/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirRealSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.FirOverridesBackwardCompatibilityHelperKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirOverrideChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParametersOwner;
import org.jetbrains.kotlin.fir.declarations.FirTypedDeclaration;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.substitution.SubstitutorsKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeCheckerContext;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.AbstractTypeCheckerContext;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J4\u0010\f\u001a\u00020\u00062\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016H\u0002J \u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\u001a2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016H\u0002J4\u0010\u001b\u001a\u0004\u0018\u00010\u0019*\u0006\u0012\u0002\b\u00030\u000e2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0002J2\u0010\u001c\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u00162\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010\u001d\u001a\u00020\u0006*\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u00192\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010 \u001a\u00020\u0006*\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u00192\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010!\u001a\u00020\u0006*\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010\"\u001a\u00020\u0006*\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u00192\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\b\u001a\u00020\tH\u0002J$\u0010#\u001a\u00020\u0006*\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\tH\u0002J$\u0010$\u001a\u00020\u0006*\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\tH\u0002J$\u0010%\u001a\u00020\u0006*\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\tH\u0002J$\u0010&\u001a\u00020\u0006*\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\tH\u0002J\"\u0010'\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016*\u00020\u00122\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J,\u0010(\u001a\u00020)*\u00020)2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkMember", "member", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableMemberDeclaration;", "typeCheckerContext", "Lorg/jetbrains/kotlin/types/AbstractTypeCheckerContext;", "firTypeScope", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "checkModality", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "overriddenSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "checkMutability", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "checkReturnType", "checkVisibility", "reportCannotChangeAccessPrivilege", "overriding", "overridden", "reportCannotWeakenAccessPrivilege", "reportNothingToOverride", "reportOverridingFinalMember", "reportReturnTypeMismatchOnFunction", "reportTypeMismatchOnProperty", "reportTypeMismatchOnVariable", "reportVarOverriddenByVal", "retrieveDirectOverriddenOf", "substituteAllTypeParameters", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "overrideDeclaration", "baseDeclaration", "checkers"})
public final class FirOverrideChecker
extends FirDeclarationChecker<FirClass<?>> {
    @NotNull
    public static final FirOverrideChecker INSTANCE = new FirOverrideChecker();

    private FirOverrideChecker() {
    }

    @Override
    public void check(@NotNull FirClass<?> declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter(declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        ConeTypeCheckerContext typeCheckerContext = SessionUtilsKt.getTypeContext(context2.getSession()).newBaseTypeCheckerContext(false, false);
        FirTypeScope firTypeScope = FirHelpersKt.unsubstitutedScope(declaration2, context2);
        for (FirDeclaration it : declaration2.getDeclarations()) {
            if (!(it instanceof FirSimpleFunction) && !(it instanceof FirProperty)) continue;
            this.checkMember((FirCallableMemberDeclaration)it, reporter2, typeCheckerContext, firTypeScope, context2);
        }
    }

    private final List<FirCallableSymbol<?>> retrieveDirectOverriddenOf(FirTypeScope $this$retrieveDirectOverriddenOf, FirCallableMemberDeclaration<?> member2) {
        List<FirCallableSymbol<?>> list2;
        FirCallableMemberDeclaration<?> firCallableMemberDeclaration = member2;
        if (firCallableMemberDeclaration instanceof FirSimpleFunction) {
            $this$retrieveDirectOverriddenOf.processFunctionsByName(((FirSimpleFunction)member2).getName(), (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)retrieveDirectOverriddenOf.1.INSTANCE));
            list2 = FirTypeScopeKt.getDirectOverriddenFunctions($this$retrieveDirectOverriddenOf, ((FirSimpleFunction)member2).getSymbol());
        } else if (firCallableMemberDeclaration instanceof FirProperty) {
            $this$retrieveDirectOverriddenOf.processPropertiesByName(((FirProperty)member2).getName(), retrieveDirectOverriddenOf.2.INSTANCE);
            list2 = FirTypeScopeKt.getDirectOverriddenProperties($this$retrieveDirectOverriddenOf, ((FirProperty)member2).getSymbol());
        } else {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"unexpected member kind ", member2));
        }
        return list2;
    }

    private final ConeKotlinType substituteAllTypeParameters(ConeKotlinType $this$substituteAllTypeParameters, FirCallableMemberDeclaration<?> overrideDeclaration, FirCallableDeclaration<?> baseDeclaration, CheckerContext context2) {
        FirTypeParametersOwner firTypeParametersOwner;
        if (overrideDeclaration.getTypeParameters().isEmpty()) {
            return $this$substituteAllTypeParameters;
        }
        FirCallableDeclaration<?> $this$safeAs$iv22 = baseDeclaration;
        boolean $i$f$safeAs = false;
        FirCallableDeclaration<?> firCallableDeclaration = $this$safeAs$iv22;
        if (!(firCallableDeclaration instanceof FirTypeParametersOwner)) {
            firCallableDeclaration = null;
        }
        if ((firTypeParametersOwner = (FirTypeParametersOwner)((Object)firCallableDeclaration)) == null) {
            return $this$substituteAllTypeParameters;
        }
        FirTypeParametersOwner parametersOwner = firTypeParametersOwner;
        boolean $this$safeAs$iv22 = false;
        Map map = new LinkedHashMap();
        int n = overrideDeclaration.getTypeParameters().size();
        int n2 = parametersOwner.getTypeParameters().size();
        boolean bl = false;
        n = 0;
        int size = Math.min(n, n2);
        if (n < size) {
            do {
                int it = n++;
                FirTypeParameterRef to = overrideDeclaration.getTypeParameters().get(it);
                FirTypeParameter from = parametersOwner.getTypeParameters().get(it);
                Map map2 = map;
                FirTypeParameterSymbol firTypeParameterSymbol = from.getSymbol();
                ConeKotlinType coneKotlinType = FirNestedClassifierScopeKt.toConeType(to);
                boolean bl2 = false;
                map2.put(firTypeParameterSymbol, coneKotlinType);
            } while (n < size);
        }
        return SubstitutorsKt.substitutorByMap(map, context2.getSession()).substituteOrSelf($this$substituteAllTypeParameters);
    }

    private final FirCallableDeclaration<?> checkModality(List<? extends FirCallableSymbol<?>> overriddenSymbols2) {
        for (FirCallableSymbol<?> overridden : overriddenSymbols2) {
            Modality modality;
            boolean isEffectivelyFinal;
            if (!(overridden.getFir() instanceof FirMemberDeclaration) || !(isEffectivelyFinal = (modality = ((FirMemberDeclaration)overridden.getFir()).getStatus().getModality()) == null || modality == Modality.FINAL)) continue;
            return (FirCallableDeclaration)overridden.getFir();
        }
        return null;
    }

    private final FirMemberDeclaration checkMutability(FirProperty $this$checkMutability, List<? extends FirCallableSymbol<?>> overriddenSymbols2) {
        FirMemberDeclaration firMemberDeclaration;
        Object v1;
        Object object;
        block7: {
            if ($this$checkMutability.isVar()) {
                return null;
            }
            object = overriddenSymbols2;
            boolean bl = false;
            Iterable iterable = object;
            boolean bl2 = false;
            for (Object t : iterable) {
                FirProperty firProperty;
                FirCallableSymbol it = (FirCallableSymbol)t;
                boolean bl3 = false;
                Object e = it.getFir();
                FirProperty firProperty2 = firProperty = e instanceof FirProperty ? (FirProperty)e : null;
                if (!(firProperty == null ? false : firProperty.isVar())) continue;
                v1 = t;
                break block7;
            }
            v1 = null;
        }
        FirCallableSymbol firCallableSymbol = v1;
        if (firCallableSymbol == null) {
            firMemberDeclaration = null;
        } else {
            object = (FirCallableDeclaration)firCallableSymbol.getFir();
            if (object == null) {
                firMemberDeclaration = null;
            } else {
                Object $this$safeAs$iv = object;
                boolean $i$f$safeAs = false;
                Object object2 = $this$safeAs$iv;
                if (!(object2 instanceof FirMemberDeclaration)) {
                    object2 = null;
                }
                firMemberDeclaration = (FirMemberDeclaration)object2;
            }
        }
        return firMemberDeclaration;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkVisibility(FirCallableMemberDeclaration<?> $this$checkVisibility, DiagnosticReporter reporter2, List<? extends FirCallableSymbol<?>> overriddenSymbols2, CheckerContext context2) {
        void $this$sortedBy$iv;
        void $this$mapNotNullTo$iv$iv22;
        Iterable $this$mapNotNull$iv = overriddenSymbols2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv22;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirCallableSymbol it = (FirCallableSymbol)element$iv$iv;
            boolean bl2 = false;
            if (!(it.getFir() instanceof FirMemberDeclaration)) {
                pair = null;
            } else {
                FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)it.getFir();
                boolean $i$f$getVisibility = false;
                pair = TuplesKt.to((Object)it, (Object)$this$visibility$iv.getStatus().getVisibility());
            }
            if (pair == null) continue;
            Pair pair2 = pair;
            boolean bl3 = false;
            boolean bl4 = false;
            Pair it$iv$iv = pair2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        boolean $this$mapNotNullTo$iv$iv22 = false;
        List visibilities = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator($this$checkVisibility){
            final /* synthetic */ FirCallableMemberDeclaration $this_checkVisibility$inlined;
            {
                this.$this_checkVisibility$inlined = firCallableMemberDeclaration;
            }

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair pair = (Pair)a;
                boolean bl2 = false;
                FirMemberDeclaration $this$visibility$iv = this.$this_checkVisibility$inlined;
                boolean $i$f$getVisibility = false;
                Integer n = Visibilities.INSTANCE.compare($this$visibility$iv.getStatus().getVisibility(), (Visibility)pair.getSecond());
                int n2 = n == null ? Integer.MIN_VALUE : n;
                pair = (Pair)b;
                Comparable comparable = Integer.valueOf(n2);
                bl2 = false;
                $this$visibility$iv = this.$this_checkVisibility$inlined;
                $i$f$getVisibility = false;
                n = Visibilities.INSTANCE.compare($this$visibility$iv.getStatus().getVisibility(), (Visibility)pair.getSecond());
                Integer n3 = n == null ? Integer.MIN_VALUE : n;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n3);
            }
        });
        for (Pair pair : visibilities) {
            FirCallableSymbol overridden = (FirCallableSymbol)pair.component1();
            Visibility overriddenVisibility = (Visibility)pair.component2();
            FirMemberDeclaration $this$visibility$iv = $this$checkVisibility;
            boolean $i$f$getVisibility = false;
            Integer compare = Visibilities.INSTANCE.compare($this$visibility$iv.getStatus().getVisibility(), overriddenVisibility);
            if (compare == null) {
                this.reportCannotChangeAccessPrivilege(reporter2, $this$checkVisibility, (FirCallableDeclaration)overridden.getFir(), context2);
                return;
            }
            if (compare >= 0) continue;
            this.reportCannotWeakenAccessPrivilege(reporter2, $this$checkVisibility, (FirCallableDeclaration)overridden.getFir(), context2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final FirMemberDeclaration checkReturnType(FirCallableMemberDeclaration<?> $this$checkReturnType, List<? extends FirCallableSymbol<?>> overriddenSymbols2, AbstractTypeCheckerContext typeCheckerContext, CheckerContext context2) {
        void $this$mapTo$iv$iv;
        ConeKotlinType overridingReturnType = FirTypeUtilsKt.getConeType($this$checkReturnType.getReturnTypeRef());
        if (overridingReturnType instanceof ConeClassErrorType) {
            return null;
        }
        Iterable $this$map$iv = overriddenSymbols2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirCallableSymbol firCallableSymbol = (FirCallableSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ConeKotlinType coneKotlinType = ConeTypesKt.upperBoundIfFlexible(FirTypeUtilsKt.getConeType(context2.getReturnTypeCalculator().tryCalculateReturnType((FirTypedDeclaration)it.getFir())));
            collection.add(coneKotlinType);
        }
        int n = 0;
        List bounds = (List)destination$iv$iv;
        int n2 = bounds.size() + -1;
        if (n <= n2) {
            do {
                boolean isReturnTypeOkForOverride;
                int it = n++;
                FirCallableDeclaration overriddenDeclaration = (FirCallableDeclaration)overriddenSymbols2.get(it).getFir();
                ConeKotlinType overriddenReturnType = this.substituteAllTypeParameters((ConeKotlinType)bounds.get(it), $this$checkReturnType, overriddenDeclaration, context2);
                boolean bl = isReturnTypeOkForOverride = overriddenDeclaration instanceof FirProperty && ((FirProperty)overriddenDeclaration).isVar() ? AbstractTypeChecker.INSTANCE.equalTypes(typeCheckerContext, overridingReturnType, overriddenReturnType) : AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, typeCheckerContext, (KotlinTypeMarker)overridingReturnType, (KotlinTypeMarker)overriddenReturnType, false, 8, null);
                if (isReturnTypeOkForOverride) continue;
                FirCallableDeclaration $this$safeAs$iv = overriddenDeclaration;
                boolean $i$f$safeAs = false;
                FirCallableDeclaration firCallableDeclaration = $this$safeAs$iv;
                if (!(firCallableDeclaration instanceof FirMemberDeclaration)) {
                    firCallableDeclaration = null;
                }
                return (FirMemberDeclaration)((Object)firCallableDeclaration);
            } while (n <= n2);
        }
        return null;
    }

    private final void checkMember(FirCallableMemberDeclaration<?> member2, DiagnosticReporter reporter2, AbstractTypeCheckerContext typeCheckerContext, FirTypeScope firTypeScope, CheckerContext context2) {
        Object it;
        boolean bl;
        boolean bl2;
        FirCallableDeclaration<?> kind;
        List<FirCallableSymbol<?>> overriddenMemberSymbols = this.retrieveDirectOverriddenOf(firTypeScope, member2);
        FirMemberDeclaration $this$isOverride$iv = member2;
        boolean $i$f$isOverride2 = false;
        if (!$this$isOverride$iv.getStatus().isOverride()) {
            FirRegularClass firRegularClass;
            if (overriddenMemberSymbols.isEmpty() || FirOverridesBackwardCompatibilityHelperKt.getOverridesBackwardCompatibilityHelper(context2.getSession()).overrideCanBeOmitted(overriddenMemberSymbols, context2)) {
                return;
            }
            FirSourceElement $i$f$isOverride2 = member2.getSource();
            FirCallableDeclaration<?> firCallableDeclaration = kind = $i$f$isOverride2 == null ? null : $i$f$isOverride2.getKind();
            if (!(kind instanceof FirRealSourceElementKind) && !(kind instanceof FirFakeSourceElementKind.PropertyFromParameter)) {
                return;
            }
            FirCallableSymbol $this$originalOrSelf$iv = (FirCallableSymbol)CollectionsKt.first(overriddenMemberSymbols);
            boolean $i$f$originalOrSelf = false;
            Object $this$originalOrSelf$iv$iv = (FirCallableDeclaration)$this$originalOrSelf$iv.getFir();
            boolean $i$f$originalOrSelf2 = false;
            FirCallableDeclaration result$iv$iv = $this$originalOrSelf$iv$iv;
            while (ClassMembersKt.isSubstitutionOrIntersectionOverride(result$iv$iv)) {
                FirCallableDeclaration firCallableDeclaration2;
                FirCallableDeclaration firCallableDeclaration3;
                FirCallableDeclaration firCallableDeclaration4;
                FirCallableDeclaration $this$originalIfFakeOverride$iv$iv$iv = result$iv$iv;
                boolean $i$f$originalIfFakeOverride = false;
                FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                boolean $i$f$getOriginalForSubstitutionOverride = false;
                FirCallableDeclaration firCallableDeclaration5 = firCallableDeclaration4 = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv) : null;
                if (firCallableDeclaration4 == null) {
                    FirCallableDeclaration $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                    boolean $i$f$getBaseForIntersectionOverride = false;
                    firCallableDeclaration3 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
                } else {
                    firCallableDeclaration3 = firCallableDeclaration2 = firCallableDeclaration4;
                }
                if (firCallableDeclaration2 == null) break;
                result$iv$iv = firCallableDeclaration2;
            }
            FirCallableSymbol firCallableSymbol = result$iv$iv.getSymbol();
            if (firCallableSymbol == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol<*>");
            }
            FirCallableSymbol overridden = firCallableSymbol;
            $this$originalOrSelf$iv$iv = ClassMembersKt.containingClass(overridden);
            FirRegularClass firRegularClass2 = firRegularClass = $this$originalOrSelf$iv$iv == null ? null : LookupTagUtilsKt.toFirRegularClass((ConeClassLikeLookupTag)$this$originalOrSelf$iv$iv, context2.getSession());
            if (firRegularClass == null) {
                return;
            }
            FirRegularClass containingClass = firRegularClass;
            DiagnosticReporterKt.reportOn$default(reporter2, member2.getSource(), FirErrors.INSTANCE.getVIRTUAL_MEMBER_HIDDEN(), member2, containingClass, context2, null, 32, null);
            return;
        }
        if (overriddenMemberSymbols.isEmpty()) {
            this.reportNothingToOverride(reporter2, member2, context2);
            return;
        }
        kind = this.checkModality(overriddenMemberSymbols);
        if (kind != null) {
            FirCallableDeclaration<?> firCallableDeclaration = kind;
            bl2 = false;
            bl = false;
            it = firCallableDeclaration;
            boolean bl3 = false;
            INSTANCE.reportOverridingFinalMember(reporter2, member2, (FirCallableDeclaration<?>)it, context2);
        }
        if (member2 instanceof FirProperty && (kind = this.checkMutability((FirProperty)member2, overriddenMemberSymbols)) != null) {
            FirCallableDeclaration<?> firCallableDeclaration = kind;
            bl2 = false;
            bl = false;
            it = firCallableDeclaration;
            boolean bl4 = false;
            INSTANCE.reportVarOverriddenByVal(reporter2, member2, (FirMemberDeclaration)it, context2);
        }
        this.checkVisibility(member2, reporter2, overriddenMemberSymbols, context2);
        FirCallableMemberDeclaration<?> firCallableMemberDeclaration = this.checkReturnType(member2, overriddenMemberSymbols, typeCheckerContext, context2);
        if (firCallableMemberDeclaration == null) {
            return;
        }
        FirCallableMemberDeclaration<?> restriction = firCallableMemberDeclaration;
        firCallableMemberDeclaration = member2;
        if (firCallableMemberDeclaration instanceof FirSimpleFunction) {
            this.reportReturnTypeMismatchOnFunction(reporter2, member2, restriction, context2);
        } else if (firCallableMemberDeclaration instanceof FirProperty) {
            if (((FirProperty)member2).isVar()) {
                this.reportTypeMismatchOnVariable(reporter2, member2, restriction, context2);
            } else {
                this.reportTypeMismatchOnProperty(reporter2, member2, restriction, context2);
            }
        }
    }

    private final void reportNothingToOverride(DiagnosticReporter $this$reportNothingToOverride, FirMemberDeclaration declaration2, CheckerContext context2) {
    }

    private final void reportOverridingFinalMember(DiagnosticReporter $this$reportOverridingFinalMember, FirMemberDeclaration overriding, FirCallableDeclaration<?> overridden, CheckerContext context2) {
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClass(overridden);
        if (coneClassLikeLookupTag != null) {
            ConeClassLikeLookupTag coneClassLikeLookupTag2 = coneClassLikeLookupTag;
            boolean bl = false;
            boolean bl2 = false;
            ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag2;
            boolean bl3 = false;
            DiagnosticReporterKt.reportOn$default($this$reportOverridingFinalMember, overriding.getSource(), FirErrors.INSTANCE.getOVERRIDING_FINAL_MEMBER(), overridden, containingClass.getName(), context2, null, 32, null);
        }
    }

    private final void reportVarOverriddenByVal(DiagnosticReporter $this$reportVarOverriddenByVal, FirMemberDeclaration overriding, FirMemberDeclaration overridden, CheckerContext context2) {
        DiagnosticReporterKt.reportOn$default($this$reportVarOverriddenByVal, overriding.getSource(), FirErrors.INSTANCE.getVAR_OVERRIDDEN_BY_VAL(), overriding, overridden, context2, null, 32, null);
    }

    private final void reportCannotWeakenAccessPrivilege(DiagnosticReporter $this$reportCannotWeakenAccessPrivilege, FirMemberDeclaration overriding, FirCallableDeclaration<?> overridden, CheckerContext context2) {
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClass(overridden);
        if (coneClassLikeLookupTag == null) {
            return;
        }
        ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag;
        FirMemberDeclaration $this$visibility$iv = overriding;
        boolean $i$f$getVisibility = false;
        DiagnosticReporterKt.reportOn$default($this$reportCannotWeakenAccessPrivilege, overriding.getSource(), FirErrors.INSTANCE.getCANNOT_WEAKEN_ACCESS_PRIVILEGE(), $this$visibility$iv.getStatus().getVisibility(), overridden, containingClass.getName(), context2, null, 64, null);
    }

    private final void reportCannotChangeAccessPrivilege(DiagnosticReporter $this$reportCannotChangeAccessPrivilege, FirMemberDeclaration overriding, FirCallableDeclaration<?> overridden, CheckerContext context2) {
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClass(overridden);
        if (coneClassLikeLookupTag == null) {
            return;
        }
        ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag;
        FirMemberDeclaration $this$visibility$iv = overriding;
        boolean $i$f$getVisibility = false;
        DiagnosticReporterKt.reportOn$default($this$reportCannotChangeAccessPrivilege, overriding.getSource(), FirErrors.INSTANCE.getCANNOT_CHANGE_ACCESS_PRIVILEGE(), $this$visibility$iv.getStatus().getVisibility(), overridden, containingClass.getName(), context2, null, 64, null);
    }

    private final void reportReturnTypeMismatchOnFunction(DiagnosticReporter $this$reportReturnTypeMismatchOnFunction, FirMemberDeclaration overriding, FirMemberDeclaration overridden, CheckerContext context2) {
        DiagnosticReporterKt.reportOn$default($this$reportReturnTypeMismatchOnFunction, overriding.getSource(), FirErrors.INSTANCE.getRETURN_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, context2, null, 32, null);
    }

    private final void reportTypeMismatchOnProperty(DiagnosticReporter $this$reportTypeMismatchOnProperty, FirMemberDeclaration overriding, FirMemberDeclaration overridden, CheckerContext context2) {
        DiagnosticReporterKt.reportOn$default($this$reportTypeMismatchOnProperty, overriding.getSource(), FirErrors.INSTANCE.getPROPERTY_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, context2, null, 32, null);
    }

    private final void reportTypeMismatchOnVariable(DiagnosticReporter $this$reportTypeMismatchOnVariable, FirMemberDeclaration overriding, FirMemberDeclaration overridden, CheckerContext context2) {
        DiagnosticReporterKt.reportOn$default($this$reportTypeMismatchOnVariable, overriding.getSource(), FirErrors.INSTANCE.getVAR_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, context2, null, 32, null);
    }
}

