/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirNameConflictsTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSymbolOwner;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirDeclarationInspector;
import org.jetbrains.kotlin.fir.analysis.checkers.FirDeclarationPresenter;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirConflictsCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirNameConflictsTracker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeSessionKey;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.ScopesKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirPackageMemberScope;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConflictsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkFile", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "inspector", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConflictsChecker$DeclarationInspector;", "checkRegularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "DeclarationInspector", "checkers"})
public final class FirConflictsChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirConflictsChecker INSTANCE = new FirConflictsChecker();

    private FirConflictsChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        DeclarationInspector inspector = new DeclarationInspector();
        FirDeclaration firDeclaration = declaration2;
        if (firDeclaration instanceof FirFile) {
            this.checkFile((FirFile)declaration2, inspector, context2);
        } else if (firDeclaration instanceof FirRegularClass) {
            this.checkRegularClass((FirRegularClass)declaration2, inspector);
        } else {
            return;
        }
        Map $this$forEach$iv = inspector.getDeclarationConflictingSymbols();
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$declaration$symbols = element$iv = iterator2.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$declaration$symbols;
            boolean bl3 = false;
            FirDeclaration declaration3 = (FirDeclaration)entry.getKey();
            Map.Entry entry2 = $dstr$declaration$symbols;
            boolean bl4 = false;
            SmartSet symbols2 = (SmartSet)entry2.getValue();
            if (symbols2.isEmpty()) continue;
            if (declaration3 instanceof FirSimpleFunction || declaration3 instanceof FirConstructor) {
                DiagnosticReporterKt.reportOn$default(reporter2, declaration3.getSource(), FirErrors.INSTANCE.getCONFLICTING_OVERLOADS(), symbols2, context2, null, 16, null);
                continue;
            }
            DiagnosticReporterKt.reportOn$default(reporter2, declaration3.getSource(), FirErrors.INSTANCE.getREDECLARATION(), symbols2, context2, null, 16, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkFile(FirFile file2, DeclarationInspector inspector, CheckerContext context2) {
        Object object;
        Object object2;
        Object answer$iv$iv;
        void id$iv;
        void this_$iv;
        ScopeSession scopeSession = context2.getSessionHolder().getScopeSession();
        FqName fqName2 = file2.getPackageFqName();
        ScopeSessionKey<FqName, FirPackageMemberScope> key$iv = ScopesKt.getPACKAGE_MEMBER();
        boolean $i$f$getOrBuild = false;
        Map $this$getOrPut$iv$iv = this_$iv.scopes();
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(id$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            boolean bl2 = false;
            answer$iv$iv = new HashMap();
            $this$getOrPut$iv$iv.put(id$iv, answer$iv$iv);
            object2 = answer$iv$iv;
        } else {
            object2 = value$iv$iv;
        }
        $this$getOrPut$iv$iv = (Map)object2;
        $i$f$getOrPut = false;
        value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            boolean bl3 = false;
            answer$iv$iv = new FirPackageMemberScope(file2.getPackageFqName(), context2.getSessionHolder().getSession());
            $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        FirPackageMemberScope packageMemberScope = (FirPackageMemberScope)object;
        for (FirDeclaration topLevelDeclaration : file2.getDeclarations()) {
            inspector.collectWithExternalConflicts(topLevelDeclaration, file2, context2.getSession(), packageMemberScope);
        }
    }

    private final void checkRegularClass(FirRegularClass declaration2, DeclarationInspector inspector) {
        for (FirDeclaration it : declaration2.getDeclarations()) {
            inspector.collect(it);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0002JH\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u001fH\u0014J\u001e\u0010!\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050#H\u0002J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050\u001e2\u0006\u0010 \u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0005H\u0014J&\u0010%\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020'J\u0018\u0010(\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0002RA\u0010\u0003\u001a2\u0012\u0004\u0012\u00020\u0005\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00060\u0004j\u0018\u0012\u0004\u0012\u00020\u0005\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConflictsChecker$DeclarationInspector;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationInspector;", "()V", "declarationConflictingSymbols", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/utils/SmartSet;", "Lorg/jetbrains/kotlin/fir/symbols/AbstractFirBasedSymbol;", "Lkotlin/collections/HashMap;", "getDeclarationConflictingSymbols", "()Ljava/util/HashMap;", "areCompatibleMainFunctions", "", "declaration1", "file1", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "declaration2", "file2", "collectExternalConflict", "", "declaration", "declarationPresentation", "", "containingFile", "conflictingSymbol", "conflictingPresentation", "conflictingFile", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "collectFunction", "", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "key", "collectLocalConflicts", "conflicting", "", "collectNonFunctionDeclaration", "collectWithExternalConflicts", "packageMemberScope", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirPackageMemberScope;", "isExpectAndActual", "checkers"})
    private static final class DeclarationInspector
    extends FirDeclarationInspector {
        @NotNull
        private final HashMap<FirDeclaration, SmartSet<AbstractFirBasedSymbol<?>>> declarationConflictingSymbols;

        public DeclarationInspector() {
            super(null, 1, null);
            boolean bl = false;
            this.declarationConflictingSymbols = new HashMap();
        }

        @NotNull
        public final HashMap<FirDeclaration, SmartSet<AbstractFirBasedSymbol<?>>> getDeclarationConflictingSymbols() {
            return this.declarationConflictingSymbols;
        }

        @Override
        @NotNull
        protected List<FirDeclaration> collectNonFunctionDeclaration(@NotNull String key, @NotNull FirDeclaration declaration2) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            List<FirDeclaration> list2 = super.collectNonFunctionDeclaration(key, declaration2);
            boolean bl = false;
            boolean bl2 = false;
            List<FirDeclaration> it = list2;
            boolean bl3 = false;
            this.collectLocalConflicts(declaration2, it);
            return list2;
        }

        @Override
        @NotNull
        protected List<FirSimpleFunction> collectFunction(@NotNull String key, @NotNull FirSimpleFunction declaration2) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            List<FirSimpleFunction> list2 = super.collectFunction(key, declaration2);
            boolean bl = false;
            boolean bl2 = false;
            List<FirSimpleFunction> it = list2;
            boolean bl3 = false;
            this.collectLocalConflicts(declaration2, it);
            return list2;
        }

        private final void collectLocalConflicts(FirDeclaration declaration2, List<? extends FirDeclaration> conflicting) {
            SmartSet localConflicts = SmartSet.Companion.create();
            for (FirDeclaration firDeclaration : conflicting) {
                Object object;
                if (!(firDeclaration instanceof FirSymbolOwner) || Intrinsics.areEqual((Object)firDeclaration, (Object)declaration2) || !(declaration2 instanceof FirSymbolOwner) || this.isExpectAndActual(declaration2, firDeclaration)) continue;
                localConflicts.add(((FirSymbolOwner)((Object)firDeclaration)).getSymbol());
                Map $this$getOrPut$iv = this.declarationConflictingSymbols;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(firDeclaration);
                if (value$iv == null) {
                    boolean bl = false;
                    SmartSet answer$iv = SmartSet.Companion.create();
                    $this$getOrPut$iv.put(firDeclaration, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((SmartSet)object).add(((FirSymbolOwner)((Object)declaration2)).getSymbol());
            }
            Map map = this.declarationConflictingSymbols;
            boolean bl = false;
            map.put(declaration2, localConflicts);
        }

        private final boolean isExpectAndActual(FirDeclaration declaration1, FirDeclaration declaration2) {
            if (!(declaration1 instanceof FirMemberDeclaration)) {
                return false;
            }
            if (!(declaration2 instanceof FirMemberDeclaration)) {
                return false;
            }
            return ((FirMemberDeclaration)declaration1).getStatus().isExpect() && ((FirMemberDeclaration)declaration2).getStatus().isActual() || ((FirMemberDeclaration)declaration1).getStatus().isActual() && ((FirMemberDeclaration)declaration2).getStatus().isExpect();
        }

        private final boolean areCompatibleMainFunctions(FirDeclaration declaration1, FirFile file1, FirDeclaration declaration2, FirFile file2) {
            if (!(declaration1 instanceof FirSimpleFunction) || !(declaration2 instanceof FirSimpleFunction)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)((FirSimpleFunction)declaration1).getName().asString(), (Object)"main") || !Intrinsics.areEqual((Object)((FirSimpleFunction)declaration2).getName().asString(), (Object)"main")) {
                return false;
            }
            return !Intrinsics.areEqual((Object)file1, (Object)file2);
        }

        private final void collectExternalConflict(FirDeclaration declaration2, String declarationPresentation, FirFile containingFile, AbstractFirBasedSymbol<?> conflictingSymbol, String conflictingPresentation, FirFile conflictingFile, FirSession session2) {
            Object object;
            FirFile actualConflictingFile;
            AbstractFirBasedSymbol<?> abstractFirBasedSymbol;
            Object actualConflictingPresentation;
            FirDeclaration firDeclaration;
            Object object2 = conflictingSymbol.getFir();
            FirDeclaration firDeclaration2 = firDeclaration = object2 instanceof FirDeclaration ? (FirDeclaration)object2 : null;
            if (firDeclaration == null) {
                return;
            }
            FirDeclaration conflicting = firDeclaration;
            if (!Intrinsics.areEqual((Object)declaration2.getModuleData(), (Object)conflicting.getModuleData())) {
                return;
            }
            object2 = conflictingPresentation;
            Object object3 = actualConflictingPresentation = object2 == null ? FirConflictsCheckerKt.access$represent(this.getPresenter(), conflicting) : object2;
            if (Intrinsics.areEqual((Object)conflicting, (Object)declaration2) || !Intrinsics.areEqual(actualConflictingPresentation, (Object)declarationPresentation)) {
                return;
            }
            FirFile firFile = conflictingFile;
            FirFile firFile2 = firFile == null ? ((abstractFirBasedSymbol = conflictingSymbol) instanceof FirClassLikeSymbol ? MainSessionComponentsKt.getFirProvider(session2).getFirClassifierContainerFileIfAny((FirClassLikeSymbol)conflictingSymbol) : (abstractFirBasedSymbol instanceof FirCallableSymbol ? MainSessionComponentsKt.getFirProvider(session2).getFirCallableContainerFile((FirCallableSymbol)conflictingSymbol) : null)) : (actualConflictingFile = firFile);
            if (Intrinsics.areEqual((Object)containingFile, (Object)actualConflictingFile)) {
                return;
            }
            if (this.areCompatibleMainFunctions(declaration2, containingFile, conflicting, actualConflictingFile)) {
                return;
            }
            if (this.isExpectAndActual(declaration2, conflicting)) {
                return;
            }
            if (!(!(conflicting instanceof FirMemberDeclaration) || conflicting instanceof FirSymbolOwner && FirVisibilityCheckerKt.getVisibilityChecker(session2).isVisible((FirMemberDeclaration)conflicting, session2, containingFile, CollectionsKt.emptyList(), null))) {
                return;
            }
            Map $this$getOrPut$iv = this.declarationConflictingSymbols;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(declaration2);
            if (value$iv == null) {
                boolean bl = false;
                SmartSet answer$iv = SmartSet.Companion.create();
                $this$getOrPut$iv.put(declaration2, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((SmartSet)object).add(conflictingSymbol);
        }

        public final void collectWithExternalConflicts(@NotNull FirDeclaration declaration2, @NotNull FirFile containingFile, @NotNull FirSession session2, @NotNull FirPackageMemberScope packageMemberScope) {
            HashMap<ClassId, Set<FirNameConflictsTracker.ClassifierWithFile>> hashMap;
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)containingFile, (String)"containingFile");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)packageMemberScope, (String)"packageMemberScope");
            this.collect(declaration2);
            Ref.ObjectRef declarationName = new Ref.ObjectRef();
            Object object = FirConflictsCheckerKt.access$represent(this.getPresenter(), declaration2);
            if (object == null) {
                return;
            }
            String declarationPresentation = object;
            object = declaration2;
            if (object instanceof FirSimpleFunction) {
                declarationName.element = ((FirSimpleFunction)declaration2).getName();
                if (!((Name)declarationName.element).isSpecial()) {
                    packageMemberScope.processFunctionsByName((Name)declarationName.element, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)new Function1<FirNamedFunctionSymbol, Unit>(this, declaration2, declarationPresentation, containingFile, session2){
                        final /* synthetic */ DeclarationInspector this$0;
                        final /* synthetic */ FirDeclaration $declaration;
                        final /* synthetic */ String $declarationPresentation;
                        final /* synthetic */ FirFile $containingFile;
                        final /* synthetic */ FirSession $session;
                        {
                            this.this$0 = $receiver;
                            this.$declaration = $declaration;
                            this.$declarationPresentation = $declarationPresentation;
                            this.$containingFile = $containingFile;
                            this.$session = $session;
                            super(1);
                        }

                        public final void invoke(@NotNull FirNamedFunctionSymbol it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            DeclarationInspector.access$collectExternalConflict(this.this$0, this.$declaration, this.$declarationPresentation, this.$containingFile, it, null, null, this.$session);
                        }
                    }));
                    packageMemberScope.processClassifiersByNameWithSubstitution((Name)declarationName.element, (Function2)new Function2<FirClassifierSymbol<?>, ConeSubstitutor, Unit>(this, declaration2, declarationPresentation, containingFile, session2){
                        final /* synthetic */ DeclarationInspector this$0;
                        final /* synthetic */ FirDeclaration $declaration;
                        final /* synthetic */ String $declarationPresentation;
                        final /* synthetic */ FirFile $containingFile;
                        final /* synthetic */ FirSession $session;
                        {
                            this.this$0 = $receiver;
                            this.$declaration = $declaration;
                            this.$declarationPresentation = $declarationPresentation;
                            this.$containingFile = $containingFile;
                            this.$session = $session;
                            super(2);
                        }

                        public final void invoke(@NotNull FirClassifierSymbol<?> symbol2, @NotNull ConeSubstitutor $noName_1) {
                            Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
                            Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
                            Object object = symbol2.getFir();
                            FirRegularClass classWithSameName = object instanceof FirRegularClass ? (FirRegularClass)object : null;
                            object = classWithSameName;
                            if (object != null) {
                                FirConflictsCheckerKt.access$onConstructors((FirDeclaration)object, (Function1)new Function1<FirConstructor, Unit>(this.this$0, this.$declaration, this.$declarationPresentation, this.$containingFile, classWithSameName, this.$session){
                                    final /* synthetic */ DeclarationInspector this$0;
                                    final /* synthetic */ FirDeclaration $declaration;
                                    final /* synthetic */ String $declarationPresentation;
                                    final /* synthetic */ FirFile $containingFile;
                                    final /* synthetic */ FirRegularClass $classWithSameName;
                                    final /* synthetic */ FirSession $session;
                                    {
                                        this.this$0 = $receiver;
                                        this.$declaration = $declaration;
                                        this.$declarationPresentation = $declarationPresentation;
                                        this.$containingFile = $containingFile;
                                        this.$classWithSameName = $classWithSameName;
                                        this.$session = $session;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull FirConstructor constructor2) {
                                        Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
                                        DeclarationInspector.access$collectExternalConflict(this.this$0, this.$declaration, this.$declarationPresentation, this.$containingFile, constructor2.getSymbol(), DeclarationInspector.access$getPresenter(this.this$0).represent(constructor2, this.$classWithSameName), null, this.$session);
                                    }
                                });
                            }
                        }
                    });
                }
            } else if (object instanceof FirVariable) {
                declarationName.element = ((FirVariable)declaration2).getName();
                if (!((Name)declarationName.element).isSpecial()) {
                    packageMemberScope.processPropertiesByName((Name)declarationName.element, (Function1)new Function1<FirVariableSymbol<?>, Unit>(this, declaration2, declarationPresentation, containingFile, session2){
                        final /* synthetic */ DeclarationInspector this$0;
                        final /* synthetic */ FirDeclaration $declaration;
                        final /* synthetic */ String $declarationPresentation;
                        final /* synthetic */ FirFile $containingFile;
                        final /* synthetic */ FirSession $session;
                        {
                            this.this$0 = $receiver;
                            this.$declaration = $declaration;
                            this.$declarationPresentation = $declarationPresentation;
                            this.$containingFile = $containingFile;
                            this.$session = $session;
                            super(1);
                        }

                        public final void invoke(@NotNull FirVariableSymbol<?> it) {
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            DeclarationInspector.access$collectExternalConflict(this.this$0, this.$declaration, this.$declarationPresentation, this.$containingFile, it, null, null, this.$session);
                        }
                    });
                }
            } else if (object instanceof FirRegularClass) {
                declarationName.element = ((FirRegularClass)declaration2).getName();
                if (!((Name)declarationName.element).isSpecial()) {
                    packageMemberScope.processClassifiersByNameWithSubstitution((Name)declarationName.element, (Function2)new Function2<FirClassifierSymbol<?>, ConeSubstitutor, Unit>(this, declaration2, declarationPresentation, containingFile, session2){
                        final /* synthetic */ DeclarationInspector this$0;
                        final /* synthetic */ FirDeclaration $declaration;
                        final /* synthetic */ String $declarationPresentation;
                        final /* synthetic */ FirFile $containingFile;
                        final /* synthetic */ FirSession $session;
                        {
                            this.this$0 = $receiver;
                            this.$declaration = $declaration;
                            this.$declarationPresentation = $declarationPresentation;
                            this.$containingFile = $containingFile;
                            this.$session = $session;
                            super(2);
                        }

                        public final void invoke(@NotNull FirClassifierSymbol<?> symbol2, @NotNull ConeSubstitutor $noName_1) {
                            Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
                            Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
                            DeclarationInspector.access$collectExternalConflict(this.this$0, this.$declaration, this.$declarationPresentation, this.$containingFile, symbol2, null, null, this.$session);
                        }
                    });
                    FirConflictsCheckerKt.access$onConstructors(declaration2, (Function1)new Function1<FirConstructor, Unit>(packageMemberScope, (Ref.ObjectRef<Name>)declarationName, this, declaration2, containingFile, session2){
                        final /* synthetic */ FirPackageMemberScope $packageMemberScope;
                        final /* synthetic */ Ref.ObjectRef<Name> $declarationName;
                        final /* synthetic */ DeclarationInspector this$0;
                        final /* synthetic */ FirDeclaration $declaration;
                        final /* synthetic */ FirFile $containingFile;
                        final /* synthetic */ FirSession $session;
                        {
                            this.$packageMemberScope = $packageMemberScope;
                            this.$declarationName = $declarationName;
                            this.this$0 = $receiver;
                            this.$declaration = $declaration;
                            this.$containingFile = $containingFile;
                            this.$session = $session;
                            super(1);
                        }

                        public final void invoke(@NotNull FirConstructor constructor2) {
                            Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
                            Object object = this.$declarationName.element;
                            Intrinsics.checkNotNull((Object)object);
                            this.$packageMemberScope.processFunctionsByName((Name)object, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)new Function1<FirNamedFunctionSymbol, Unit>(this.this$0, constructor2, this.$declaration, this.$containingFile, this.$session){
                                final /* synthetic */ DeclarationInspector this$0;
                                final /* synthetic */ FirConstructor $constructor;
                                final /* synthetic */ FirDeclaration $declaration;
                                final /* synthetic */ FirFile $containingFile;
                                final /* synthetic */ FirSession $session;
                                {
                                    this.this$0 = $receiver;
                                    this.$constructor = $constructor;
                                    this.$declaration = $declaration;
                                    this.$containingFile = $containingFile;
                                    this.$session = $session;
                                    super(1);
                                }

                                public final void invoke(@NotNull FirNamedFunctionSymbol it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    DeclarationInspector.access$collectExternalConflict(this.this$0, this.$constructor, DeclarationInspector.access$getPresenter(this.this$0).represent(this.$constructor, (FirRegularClass)this.$declaration), this.$containingFile, it, null, null, this.$session);
                                }
                            }));
                        }
                    });
                    hashMap = FirNameConflictsTrackerComponentKt.getNameConflictsTracker(session2);
                    if (hashMap != null) {
                        Set<FirNameConflictsTracker.ClassifierWithFile> set;
                        HashMap<ClassId, Set<FirNameConflictsTracker.ClassifierWithFile>> hashMap2 = hashMap;
                        boolean bl = false;
                        boolean bl2 = false;
                        HashMap<ClassId, Set<FirNameConflictsTracker.ClassifierWithFile>> it = hashMap2;
                        boolean bl3 = false;
                        FirNameConflictsTracker firNameConflictsTracker = it instanceof FirNameConflictsTracker ? (FirNameConflictsTracker)((Object)it) : null;
                        if (firNameConflictsTracker != null && (set = (hashMap2 = firNameConflictsTracker.getRedeclaredClassifiers()).get(((FirRegularClass)declaration2).getSymbol().getClassId())) != null) {
                            Iterable $this$forEach$iv = set;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                FirNameConflictsTracker.ClassifierWithFile it2 = (FirNameConflictsTracker.ClassifierWithFile)element$iv;
                                boolean bl4 = false;
                                this.collectExternalConflict(declaration2, declarationPresentation, containingFile, (AbstractFirBasedSymbol)it2.getClassifier(), null, it2.getFile(), session2);
                            }
                        }
                    }
                }
            } else if (object instanceof FirTypeAlias) {
                declarationName.element = ((FirTypeAlias)declaration2).getName();
                if (!((Name)declarationName.element).isSpecial()) {
                    packageMemberScope.processClassifiersByNameWithSubstitution((Name)declarationName.element, (Function2)new Function2<FirClassifierSymbol<?>, ConeSubstitutor, Unit>(this, declaration2, declarationPresentation, containingFile, session2){
                        final /* synthetic */ DeclarationInspector this$0;
                        final /* synthetic */ FirDeclaration $declaration;
                        final /* synthetic */ String $declarationPresentation;
                        final /* synthetic */ FirFile $containingFile;
                        final /* synthetic */ FirSession $session;
                        {
                            this.this$0 = $receiver;
                            this.$declaration = $declaration;
                            this.$declarationPresentation = $declarationPresentation;
                            this.$containingFile = $containingFile;
                            this.$session = $session;
                            super(2);
                        }

                        public final void invoke(@NotNull FirClassifierSymbol<?> symbol2, @NotNull ConeSubstitutor $noName_1) {
                            Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
                            Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
                            DeclarationInspector.access$collectExternalConflict(this.this$0, this.$declaration, this.$declarationPresentation, this.$containingFile, symbol2, null, null, this.$session);
                        }
                    });
                    hashMap = FirNameConflictsTrackerComponentKt.getNameConflictsTracker(session2);
                    if (hashMap != null) {
                        Set<FirNameConflictsTracker.ClassifierWithFile> set;
                        HashMap<ClassId, Set<FirNameConflictsTracker.ClassifierWithFile>> hashMap3 = hashMap;
                        boolean bl = false;
                        boolean $this$forEach$iv = false;
                        HashMap<ClassId, Set<FirNameConflictsTracker.ClassifierWithFile>> it = hashMap3;
                        boolean bl5 = false;
                        FirNameConflictsTracker firNameConflictsTracker = it instanceof FirNameConflictsTracker ? (FirNameConflictsTracker)((Object)it) : null;
                        if (firNameConflictsTracker != null && (set = (hashMap3 = firNameConflictsTracker.getRedeclaredClassifiers()).get(((FirTypeAlias)declaration2).getSymbol().getClassId())) != null) {
                            Iterable $this$forEach$iv2 = set;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv2) {
                                FirNameConflictsTracker.ClassifierWithFile it3 = (FirNameConflictsTracker.ClassifierWithFile)element$iv;
                                boolean bl6 = false;
                                this.collectExternalConflict(declaration2, declarationPresentation, containingFile, (AbstractFirBasedSymbol)it3.getClassifier(), null, it3.getFile(), session2);
                            }
                        }
                    }
                }
            }
            if (declarationName.element != null && (object = FirLookupTrackerComponentKt.getLookupTracker(session2)) != null) {
                Name name2 = (Name)declarationName.element;
                hashMap = containingFile.getPackageFqName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"containingFile.packageFqName.asString()");
                ((FirLookupTrackerComponent)object).recordLookup(name2, (String)((Object)hashMap), declaration2.getSource(), containingFile.getSource());
            }
        }

        public static final /* synthetic */ void access$collectExternalConflict(DeclarationInspector $this, FirDeclaration declaration2, String declarationPresentation, FirFile containingFile, AbstractFirBasedSymbol conflictingSymbol, String conflictingPresentation, FirFile conflictingFile, FirSession session2) {
            $this.collectExternalConflict(declaration2, declarationPresentation, containingFile, conflictingSymbol, conflictingPresentation, conflictingFile, session2);
        }

        public static final /* synthetic */ FirDeclarationPresenter access$getPresenter(DeclarationInspector $this) {
            return $this.getPresenter();
        }
    }
}

