/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins.jvm;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PlatformToKotlinClassMapper;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J1\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0016\u0010\f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\rH\u0082\bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u0004J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J)\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u001d2\u0006\u0010\u001e\u001a\u00020\u0004H\u0016J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u001d2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/builtins/jvm/JavaToKotlinClassMapper;", "Lorg/jetbrains/kotlin/builtins/PlatformToKotlinClassMapper;", "()V", "convertMutableToReadOnly", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "mutable", "convertReadOnlyToMutable", "readOnly", "convertToOppositeMutability", "descriptor", "mutabilityKindName", "", "oppositeNameExtractor", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "Lorg/jetbrains/kotlin/name/FqName;", "isMutable", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "isReadOnly", "mapJavaToKotlin", "fqName", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "functionTypeArity", "", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Ljava/lang/Integer;)Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "mapPlatformClass", "", "classDescriptor", "descriptors.jvm"})
public final class JavaToKotlinClassMapper
implements PlatformToKotlinClassMapper {
    @NotNull
    public static final JavaToKotlinClassMapper INSTANCE = new JavaToKotlinClassMapper();

    private JavaToKotlinClassMapper() {
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> mapPlatformClass(@NotNull ClassDescriptor classDescriptor) {
        Collection<ClassDescriptor> collection;
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
        Object object = DescriptorUtils.getFqName(classDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getFqName(classDescriptor)");
        FqNameUnsafe className2 = object;
        if (className2.isSafe()) {
            object = className2.toSafe();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"className.toSafe()");
            collection = this.mapPlatformClass((FqName)object, DescriptorUtilsKt.getBuiltIns(classDescriptor));
        } else {
            collection = SetsKt.emptySet();
        }
        return collection;
    }

    @NotNull
    public final Collection<ClassDescriptor> mapPlatformClass(@NotNull FqName fqName2, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        ClassDescriptor classDescriptor = JavaToKotlinClassMapper.mapJavaToKotlin$default(this, fqName2, builtIns, null, 4, null);
        if (classDescriptor == null) {
            return SetsKt.emptySet();
        }
        ClassDescriptor kotlinAnalog = classDescriptor;
        Object[] objectArray = JavaToKotlinClassMap.INSTANCE.readOnlyToMutable(DescriptorUtilsKt.getFqNameUnsafe(kotlinAnalog));
        if (objectArray == null) {
            return SetsKt.setOf((Object)kotlinAnalog);
        }
        Object[] kotlinMutableAnalogFqName = objectArray;
        objectArray = new ClassDescriptor[2];
        objectArray[0] = kotlinAnalog;
        ClassDescriptor classDescriptor2 = builtIns.getBuiltInClassByFqName((FqName)kotlinMutableAnalogFqName);
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor2, (String)"builtIns.getBuiltInClass\u2026otlinMutableAnalogFqName)");
        objectArray[1] = classDescriptor2;
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Nullable
    public final ClassDescriptor mapJavaToKotlin(@NotNull FqName fqName2, @NotNull KotlinBuiltIns builtIns, @Nullable Integer functionTypeArity) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        ClassId kotlinClassId = functionTypeArity != null && Intrinsics.areEqual((Object)fqName2, (Object)JavaToKotlinClassMap.INSTANCE.getFUNCTION_N_FQ_NAME()) ? StandardNames.getFunctionClassId(functionTypeArity) : JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(fqName2);
        return kotlinClassId != null ? builtIns.getBuiltInClassByFqName(kotlinClassId.asSingleFqName()) : null;
    }

    public static /* synthetic */ ClassDescriptor mapJavaToKotlin$default(JavaToKotlinClassMapper javaToKotlinClassMapper, FqName fqName2, KotlinBuiltIns kotlinBuiltIns, Integer n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        return javaToKotlinClassMapper.mapJavaToKotlin(fqName2, kotlinBuiltIns, n);
    }

    public final boolean isMutable(@NotNull ClassDescriptor mutable) {
        Intrinsics.checkNotNullParameter((Object)mutable, (String)"mutable");
        return JavaToKotlinClassMap.INSTANCE.isMutable(DescriptorUtils.getFqName(mutable));
    }

    public final boolean isMutable(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(type2);
        return classDescriptor != null && this.isMutable(classDescriptor);
    }

    public final boolean isReadOnly(@NotNull ClassDescriptor readOnly) {
        Intrinsics.checkNotNullParameter((Object)readOnly, (String)"readOnly");
        return JavaToKotlinClassMap.INSTANCE.isReadOnly(DescriptorUtils.getFqName(readOnly));
    }

    public final boolean isReadOnly(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(type2);
        return classDescriptor != null && this.isReadOnly(classDescriptor);
    }

    @NotNull
    public final ClassDescriptor convertMutableToReadOnly(@NotNull ClassDescriptor mutable) {
        Intrinsics.checkNotNullParameter((Object)mutable, (String)"mutable");
        JavaToKotlinClassMapper javaToKotlinClassMapper = this;
        String mutabilityKindName$iv = "mutable";
        boolean $i$f$convertToOppositeMutability = false;
        FqNameUnsafe it = DescriptorUtils.getFqName(mutable);
        boolean bl = false;
        Object object = JavaToKotlinClassMap.INSTANCE.mutableToReadOnly(it);
        if (object == null) {
            throw new IllegalArgumentException("Given class " + mutable + " is not a " + mutabilityKindName$iv + " collection");
        }
        FqName oppositeClassFqName$iv = object;
        object = DescriptorUtilsKt.getBuiltIns(mutable).getBuiltInClassByFqName(oppositeClassFqName$iv);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.builtIns.getB\u2026Name(oppositeClassFqName)");
        return object;
    }

    @NotNull
    public final ClassDescriptor convertReadOnlyToMutable(@NotNull ClassDescriptor readOnly) {
        Intrinsics.checkNotNullParameter((Object)readOnly, (String)"readOnly");
        JavaToKotlinClassMapper javaToKotlinClassMapper = this;
        String mutabilityKindName$iv = "read-only";
        boolean $i$f$convertToOppositeMutability = false;
        FqNameUnsafe it = DescriptorUtils.getFqName(readOnly);
        boolean bl = false;
        Object object = JavaToKotlinClassMap.INSTANCE.readOnlyToMutable(it);
        if (object == null) {
            throw new IllegalArgumentException("Given class " + readOnly + " is not a " + mutabilityKindName$iv + " collection");
        }
        FqName oppositeClassFqName$iv = object;
        object = DescriptorUtilsKt.getBuiltIns(readOnly).getBuiltInClassByFqName(oppositeClassFqName$iv);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.builtIns.getB\u2026Name(oppositeClassFqName)");
        return object;
    }

    private final ClassDescriptor convertToOppositeMutability(ClassDescriptor descriptor2, String mutabilityKindName, Function1<? super FqNameUnsafe, FqName> oppositeNameExtractor) {
        boolean $i$f$convertToOppositeMutability = false;
        Object object = (FqName)oppositeNameExtractor.invoke((Object)DescriptorUtils.getFqName(descriptor2));
        if (object == null) {
            throw new IllegalArgumentException("Given class " + descriptor2 + " is not a " + mutabilityKindName + " collection");
        }
        FqName oppositeClassFqName = object;
        object = DescriptorUtilsKt.getBuiltIns(descriptor2).getBuiltInClassByFqName(oppositeClassFqName);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.builtIns.getB\u2026Name(oppositeClassFqName)");
        return object;
    }
}

