/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirPhaseManager;
import org.jetbrains.kotlin.fir.resolve.transformers.FirPhaseManagerKt;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0016\u0010\u0007\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\b\u001a\u00020\u0001*\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\b\u001a\u00020\u0001*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000b"}, d2={"ensureResolved", "", "Lorg/jetbrains/kotlin/fir/symbols/AbstractFirBasedSymbol;", "requiredPhase", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "useSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "ensureResolvedForCalls", "ensureResolvedTypeDeclaration", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "resolve"})
public final class PhaseUtilsKt {
    public static final void ensureResolved(@NotNull AbstractFirBasedSymbol<?> $this$ensureResolved, @NotNull FirResolvePhase requiredPhase, @NotNull FirSession useSiteSession) {
        Intrinsics.checkNotNullParameter($this$ensureResolved, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)requiredPhase), (String)"requiredPhase");
        Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
        FirDeclaration fir = (FirDeclaration)$this$ensureResolved.getFir();
        FirResolvePhase availablePhase = fir.getResolvePhase();
        if (availablePhase.compareTo((Enum)requiredPhase) >= 0) {
            return;
        }
        FirPhaseManager firPhaseManager = FirPhaseManagerKt.getPhaseManager(fir.getSession());
        if (firPhaseManager == null) {
            String string2 = "phaseManager should be defined when working with FIR in phased mode";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        FirPhaseManager resolver2 = firPhaseManager;
        resolver2.ensureResolved($this$ensureResolved, requiredPhase);
    }

    public static final void ensureResolvedForCalls(@NotNull AbstractFirBasedSymbol<?> $this$ensureResolvedForCalls, @NotNull FirSession useSiteSession) {
        Intrinsics.checkNotNullParameter($this$ensureResolvedForCalls, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
        FirDeclaration fir = (FirDeclaration)$this$ensureResolvedForCalls.getFir();
        if (fir.getResolvePhase().compareTo((Enum)FirResolvePhase.Companion.getDECLARATIONS()) >= 0) {
            return;
        }
        FirResolvePhase requiredPhase = FirResolvePhase.Companion.getDECLARATIONS();
        PhaseUtilsKt.ensureResolved($this$ensureResolvedForCalls, requiredPhase, useSiteSession);
    }

    public static final void ensureResolvedTypeDeclaration(@NotNull ConeKotlinType $this$ensureResolvedTypeDeclaration, @NotNull FirSession useSiteSession) {
        Intrinsics.checkNotNullParameter((Object)$this$ensureResolvedTypeDeclaration, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
        if (!($this$ensureResolvedTypeDeclaration instanceof ConeClassLikeType)) {
            return;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol(((ConeClassLikeType)$this$ensureResolvedTypeDeclaration).getLookupTag(), useSiteSession);
        if (firClassLikeSymbol != null) {
            PhaseUtilsKt.ensureResolved((AbstractFirBasedSymbol)firClassLikeSymbol, FirResolvePhase.Companion.getDECLARATIONS(), useSiteSession);
        }
        firClassLikeSymbol = LookupTagUtilsKt.toSymbol(TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$ensureResolvedTypeDeclaration, useSiteSession, null, 2, null).getLookupTag(), useSiteSession);
        if (firClassLikeSymbol != null) {
            PhaseUtilsKt.ensureResolved((AbstractFirBasedSymbol)firClassLikeSymbol, FirResolvePhase.Companion.getDECLARATIONS(), useSiteSession);
        }
    }

    public static final void ensureResolvedTypeDeclaration(@NotNull FirTypeRef $this$ensureResolvedTypeDeclaration, @NotNull FirSession useSiteSession) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$ensureResolvedTypeDeclaration, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
        FirTypeRef $this$coneTypeSafe$iv = $this$ensureResolvedTypeDeclaration;
        boolean $i$f$coneTypeSafe = false;
        boolean bl = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType2 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
        if (!(coneKotlinType2 instanceof ConeKotlinType)) {
            coneKotlinType2 = null;
        }
        if ((coneKotlinType = coneKotlinType2) != null) {
            PhaseUtilsKt.ensureResolvedTypeDeclaration(coneKotlinType, useSiteSession);
        }
    }
}

