/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.codeInsight.CommentUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.kdoc.psi.api.KDocElement;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.parsing.KotlinExpressionParsing;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContainerNodeForControlStructureBody;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtDoubleColonExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLabelReferenceExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStatementExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.StatementFilterKt;

public class KtPsiUtil {
    private KtPsiUtil() {
    }

    public static <D> void visitChildren(@NotNull KtElement element, @NotNull KtVisitor<Void, D> visitor2, D data) {
        if (element == null) {
            KtPsiUtil.$$$reportNull$$$0(0);
        }
        if (visitor2 == null) {
            KtPsiUtil.$$$reportNull$$$0(1);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof KtElement)) continue;
            ((KtElement)child).accept(visitor2, data);
        }
    }

    @NotNull
    public static KtExpression safeDeparenthesize(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            KtPsiUtil.$$$reportNull$$$0(2);
        }
        return KtPsiUtil.safeDeparenthesize(expression2, false);
    }

    @NotNull
    public static KtExpression safeDeparenthesize(@NotNull KtExpression expression2, boolean keepAnnotations) {
        KtExpression deparenthesized;
        if (expression2 == null) {
            KtPsiUtil.$$$reportNull$$$0(3);
        }
        KtExpression ktExpression = (deparenthesized = KtPsiUtil.deparenthesize(expression2, keepAnnotations)) != null ? deparenthesized : expression2;
        if (ktExpression == null) {
            KtPsiUtil.$$$reportNull$$$0(4);
        }
        return ktExpression;
    }

    @Nullable
    public static KtExpression deparenthesize(@Nullable KtExpression expression2) {
        return KtPsiUtil.deparenthesize(expression2, false);
    }

    @Nullable
    public static KtExpression deparenthesize(@Nullable KtExpression expression2, boolean keepAnnotations) {
        KtExpression baseExpression;
        while ((baseExpression = KtPsiUtil.deparenthesizeOnce(expression2, keepAnnotations)) != expression2) {
            expression2 = baseExpression;
        }
        return baseExpression;
    }

    @Nullable
    public static KtExpression deparenthesizeOnce(@Nullable KtExpression expression2) {
        return KtPsiUtil.deparenthesizeOnce(expression2, false);
    }

    @Nullable
    public static KtExpression deparenthesizeOnce(@Nullable KtExpression expression2, boolean keepAnnotations) {
        if (expression2 instanceof KtAnnotatedExpression && !keepAnnotations) {
            return ((KtAnnotatedExpression)expression2).getBaseExpression();
        }
        if (expression2 instanceof KtLabeledExpression) {
            return ((KtLabeledExpression)expression2).getBaseExpression();
        }
        if (expression2 instanceof KtExpressionWrapper) {
            return ((KtExpressionWrapper)((Object)expression2)).getBaseExpression();
        }
        if (expression2 instanceof KtParenthesizedExpression) {
            return ((KtParenthesizedExpression)expression2).getExpression();
        }
        return expression2;
    }

    @NotNull
    public static Name safeName(@Nullable String name2) {
        Name name3 = name2 == null ? SpecialNames.NO_NAME_PROVIDED : Name.identifier(name2);
        if (name3 == null) {
            KtPsiUtil.$$$reportNull$$$0(5);
        }
        return name3;
    }

    @NotNull
    public static Set<KtElement> findRootExpressions(@NotNull Collection<KtElement> unreachableElements) {
        if (unreachableElements == null) {
            KtPsiUtil.$$$reportNull$$$0(6);
        }
        HashSet<KtElement> rootElements = new HashSet<KtElement>();
        final HashSet shadowedElements = new HashSet();
        KtVisitorVoid shadowAllChildren = new KtVisitorVoid(){

            @Override
            public void visitKtElement(@NotNull KtElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (shadowedElements.add(element)) {
                    element.acceptChildren(this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/KtPsiUtil$1", "visitKtElement"));
            }
        };
        for (KtElement element : unreachableElements) {
            if (shadowedElements.contains(element)) continue;
            element.acceptChildren(shadowAllChildren);
            rootElements.removeAll(shadowedElements);
            rootElements.add(element);
        }
        HashSet<KtElement> hashSet = rootElements;
        if (hashSet == null) {
            KtPsiUtil.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    @NotNull
    public static String unquoteIdentifier(@NotNull String quoted) {
        if (quoted == null) {
            KtPsiUtil.$$$reportNull$$$0(8);
        }
        if (quoted.indexOf(96) < 0) {
            String string2 = quoted;
            if (string2 == null) {
                KtPsiUtil.$$$reportNull$$$0(9);
            }
            return string2;
        }
        if (quoted.startsWith("`") && quoted.endsWith("`") && quoted.length() >= 2) {
            String string3 = quoted.substring(1, quoted.length() - 1);
            if (string3 == null) {
                KtPsiUtil.$$$reportNull$$$0(10);
            }
            return string3;
        }
        String string4 = quoted;
        if (string4 == null) {
            KtPsiUtil.$$$reportNull$$$0(11);
        }
        return string4;
    }

    @NotNull
    public static String unquoteIdentifierOrFieldReference(@NotNull String quoted) {
        if (quoted == null) {
            KtPsiUtil.$$$reportNull$$$0(12);
        }
        if (quoted.indexOf(96) < 0) {
            String string2 = quoted;
            if (string2 == null) {
                KtPsiUtil.$$$reportNull$$$0(13);
            }
            return string2;
        }
        if (quoted.startsWith("$")) {
            String string3 = "$" + KtPsiUtil.unquoteIdentifier(quoted.substring(1));
            if (string3 == null) {
                KtPsiUtil.$$$reportNull$$$0(14);
            }
            return string3;
        }
        return KtPsiUtil.unquoteIdentifier(quoted);
    }

    public static boolean isDeprecated(@NotNull KtModifierListOwner owner) {
        KtModifierList modifierList2;
        if (owner == null) {
            KtPsiUtil.$$$reportNull$$$0(15);
        }
        if ((modifierList2 = owner.getModifierList()) != null) {
            List<KtAnnotationEntry> annotationEntries = modifierList2.getAnnotationEntries();
            for (KtAnnotationEntry annotation2 : annotationEntries) {
                Name shortName = annotation2.getShortName();
                if (!StandardNames.FqNames.deprecated.shortName().equals(shortName)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static <T extends PsiElement> T getDirectParentOfTypeForBlock(@NotNull KtBlockExpression block, @NotNull Class<T> aClass) {
        KtFunctionLiteral functionLiteral;
        KtIfExpression ifExpression;
        PsiElement parent2;
        if (block == null) {
            KtPsiUtil.$$$reportNull$$$0(16);
        }
        if (aClass == null) {
            KtPsiUtil.$$$reportNull$$$0(17);
        }
        if ((parent2 = PsiTreeUtil.getParentOfType((PsiElement)block, aClass)) instanceof KtIfExpression && ((ifExpression = (KtIfExpression)parent2).getElse() == block || ifExpression.getThen() == block)) {
            return (T)parent2;
        }
        if (parent2 instanceof KtWhenExpression) {
            KtWhenExpression whenExpression = (KtWhenExpression)parent2;
            for (KtWhenEntry whenEntry : whenExpression.getEntries()) {
                if (whenEntry.getExpression() != block) continue;
                return (T)parent2;
            }
        }
        if (parent2 instanceof KtFunctionLiteral && (functionLiteral = (KtFunctionLiteral)parent2).getBodyExpression() == block) {
            return (T)parent2;
        }
        if (parent2 instanceof KtTryExpression) {
            KtTryExpression tryExpression = (KtTryExpression)parent2;
            if (tryExpression.getTryBlock() == block) {
                return (T)parent2;
            }
            for (KtCatchClause clause : tryExpression.getCatchClauses()) {
                if (clause.getCatchBody() != block) continue;
                return (T)parent2;
            }
        }
        return null;
    }

    @Nullable
    public static KtSimpleNameExpression getLastReference(@NotNull KtExpression importedReference) {
        KtElement selector;
        if (importedReference == null) {
            KtPsiUtil.$$$reportNull$$$0(18);
        }
        return (selector = KtPsiUtilKt.getQualifiedElementSelector(importedReference)) instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)selector : null;
    }

    public static boolean isSelectorInQualified(@NotNull KtSimpleNameExpression nameExpression) {
        KtElement qualifiedElement;
        if (nameExpression == null) {
            KtPsiUtil.$$$reportNull$$$0(19);
        }
        return (qualifiedElement = KtPsiUtilKt.getQualifiedElement(nameExpression)) instanceof KtQualifiedExpression || qualifiedElement instanceof KtUserType && ((KtUserType)qualifiedElement).getQualifier() != null;
    }

    public static boolean isLHSOfDot(@NotNull KtExpression expression2) {
        PsiElement parent2;
        if (expression2 == null) {
            KtPsiUtil.$$$reportNull$$$0(20);
        }
        if (!((parent2 = expression2.getParent()) instanceof KtQualifiedExpression)) {
            return false;
        }
        KtQualifiedExpression qualifiedParent = (KtQualifiedExpression)parent2;
        return qualifiedParent.getReceiverExpression() == expression2 || KtPsiUtil.isLHSOfDot(qualifiedParent);
    }

    public static boolean isScriptDeclaration(@NotNull KtDeclaration namedDeclaration) {
        if (namedDeclaration == null) {
            KtPsiUtil.$$$reportNull$$$0(21);
        }
        return KtPsiUtil.getScript(namedDeclaration) != null;
    }

    @Nullable
    public static KtScript getScript(@NotNull KtDeclaration namedDeclaration) {
        PsiElement parent2;
        if (namedDeclaration == null) {
            KtPsiUtil.$$$reportNull$$$0(22);
        }
        if ((parent2 = namedDeclaration.getParent()) != null && parent2.getParent() instanceof KtScript) {
            return (KtScript)parent2.getParent();
        }
        return null;
    }

    public static boolean isRemovableVariableDeclaration(@NotNull KtDeclaration declaration2) {
        if (declaration2 == null) {
            KtPsiUtil.$$$reportNull$$$0(23);
        }
        if (!(declaration2 instanceof KtVariableDeclaration)) {
            return false;
        }
        if (declaration2 instanceof KtProperty) {
            return true;
        }
        assert (declaration2 instanceof KtDestructuringDeclarationEntry);
        return true;
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _ -> null")
    public static PsiElement getTopmostParentOfTypes(@Nullable PsiElement element, Class<? extends PsiElement> ... parentTypes) {
        PsiElement next;
        if (parentTypes == null) {
            KtPsiUtil.$$$reportNull$$$0(24);
        }
        if (element instanceof PsiFile) {
            return null;
        }
        PsiElement answer = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])parentTypes);
        if (answer instanceof PsiFile) {
            return answer;
        }
        while ((next = PsiTreeUtil.getParentOfType((PsiElement)answer, (Class[])parentTypes)) != null) {
            answer = next;
        }
        return answer;
    }

    public static boolean isNullConstant(@NotNull KtExpression expression2) {
        KtExpression deparenthesized;
        if (expression2 == null) {
            KtPsiUtil.$$$reportNull$$$0(25);
        }
        return (deparenthesized = KtPsiUtil.deparenthesize(expression2)) instanceof KtConstantExpression && deparenthesized.getNode().getElementType() == KtNodeTypes.NULL;
    }

    public static boolean isTrueConstant(@Nullable KtExpression condition) {
        return KtPsiUtil.isBooleanConstant(condition) && condition.getNode().findChildByType((IElementType)KtTokens.TRUE_KEYWORD) != null;
    }

    public static boolean isFalseConstant(@Nullable KtExpression condition) {
        return KtPsiUtil.isBooleanConstant(condition) && condition.getNode().findChildByType((IElementType)KtTokens.FALSE_KEYWORD) != null;
    }

    public static boolean isBooleanConstant(@Nullable KtExpression condition) {
        return condition != null && condition.getNode().getElementType() == KtNodeTypes.BOOLEAN_CONSTANT;
    }

    public static boolean isAbstract(@NotNull KtDeclarationWithBody declaration2) {
        if (declaration2 == null) {
            KtPsiUtil.$$$reportNull$$$0(26);
        }
        return declaration2.getBodyExpression() == null;
    }

    @Nullable
    public static KtExpression getExpressionOrLastStatementInBlock(@Nullable KtExpression expression2) {
        if (expression2 instanceof KtBlockExpression) {
            return KtPsiUtil.getLastStatementInABlock((KtBlockExpression)expression2);
        }
        return expression2;
    }

    @Nullable
    public static KtExpression getLastStatementInABlock(@Nullable KtBlockExpression blockExpression) {
        if (blockExpression == null) {
            return null;
        }
        List<KtExpression> statements2 = blockExpression.getStatements();
        return statements2.isEmpty() ? null : statements2.get(statements2.size() - 1);
    }

    public static boolean isTrait(@NotNull KtClassOrObject classOrObject) {
        if (classOrObject == null) {
            KtPsiUtil.$$$reportNull$$$0(27);
        }
        return classOrObject instanceof KtClass && ((KtClass)classOrObject).isInterface();
    }

    @Nullable
    public static KtClassOrObject getOutermostClassOrObject(@NotNull KtClassOrObject classOrObject) {
        if (classOrObject == null) {
            KtPsiUtil.$$$reportNull$$$0(28);
        }
        KtClassOrObject current2 = classOrObject;
        while (true) {
            PsiElement parent2 = current2.getParent();
            assert (parent2 != null) : "Class with no parent: " + current2.getText();
            if (parent2 instanceof PsiFile) {
                return current2;
            }
            if (!(parent2 instanceof KtClassBody)) {
                return current2;
            }
            current2 = (KtClassOrObject)parent2.getParent();
        }
    }

    @Nullable
    public static KtClassOrObject getClassIfParameterIsProperty(@NotNull KtParameter jetParameter) {
        PsiElement grandParent;
        if (jetParameter == null) {
            KtPsiUtil.$$$reportNull$$$0(29);
        }
        if (jetParameter.hasValOrVar() && (grandParent = jetParameter.getParent().getParent()) instanceof KtPrimaryConstructor) {
            return ((KtPrimaryConstructor)grandParent).getContainingClassOrObject();
        }
        return null;
    }

    @Nullable
    private static IElementType getOperation(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            KtPsiUtil.$$$reportNull$$$0(30);
        }
        if (expression2 instanceof KtQualifiedExpression) {
            return ((KtQualifiedExpression)expression2).getOperationSign();
        }
        if (expression2 instanceof KtOperationExpression) {
            return ((KtOperationExpression)expression2).getOperationReference().getReferencedNameElementType();
        }
        return null;
    }

    private static int getPriority(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            KtPsiUtil.$$$reportNull$$$0(31);
        }
        int maxPriority = KotlinExpressionParsing.Precedence.values().length + 1;
        if (expression2 instanceof KtPostfixExpression || expression2 instanceof KtQualifiedExpression || expression2 instanceof KtCallExpression || expression2 instanceof KtArrayAccessExpression || expression2 instanceof KtDoubleColonExpression) {
            return maxPriority - 1;
        }
        if (expression2 instanceof KtPrefixExpression || expression2 instanceof KtLabeledExpression) {
            return maxPriority - 2;
        }
        if (expression2 instanceof KtIfExpression) {
            return KotlinExpressionParsing.Precedence.ASSIGNMENT.ordinal();
        }
        if (expression2 instanceof KtSuperExpression) {
            return maxPriority;
        }
        if (expression2 instanceof KtDeclaration || expression2 instanceof KtStatementExpression) {
            return 0;
        }
        IElementType operation = KtPsiUtil.getOperation(expression2);
        for (KotlinExpressionParsing.Precedence precedence : KotlinExpressionParsing.Precedence.values()) {
            if (precedence == KotlinExpressionParsing.Precedence.PREFIX || precedence == KotlinExpressionParsing.Precedence.POSTFIX || !precedence.getOperations().contains(operation)) continue;
            return maxPriority - precedence.ordinal() - 1;
        }
        return maxPriority;
    }

    public static boolean areParenthesesUseless(@NotNull KtParenthesizedExpression expression2) {
        KtExpression innerExpression;
        if (expression2 == null) {
            KtPsiUtil.$$$reportNull$$$0(32);
        }
        if ((innerExpression = expression2.getExpression()) == null) {
            return true;
        }
        PsiElement parent2 = expression2.getParent();
        if (!(parent2 instanceof KtExpression)) {
            return true;
        }
        return !KtPsiUtil.areParenthesesNecessary(innerExpression, expression2, (KtExpression)parent2);
    }

    public static boolean areParenthesesNecessary(@NotNull KtExpression innerExpression, @NotNull KtExpression currentInner, @NotNull KtElement parentElement) {
        int parentPriority;
        int innerPriority;
        PsiElement prevSibling;
        if (innerExpression == null) {
            KtPsiUtil.$$$reportNull$$$0(33);
        }
        if (currentInner == null) {
            KtPsiUtil.$$$reportNull$$$0(34);
        }
        if (parentElement == null) {
            KtPsiUtil.$$$reportNull$$$0(35);
        }
        if (parentElement instanceof KtParenthesizedExpression || innerExpression instanceof KtParenthesizedExpression) {
            return false;
        }
        if (parentElement instanceof KtPackageDirective) {
            return false;
        }
        if (parentElement instanceof KtWhenExpression || innerExpression instanceof KtWhenExpression) {
            return false;
        }
        if (parentElement instanceof KtCollectionLiteralExpression) {
            return false;
        }
        if (innerExpression instanceof KtIfExpression) {
            if (parentElement instanceof KtQualifiedExpression) {
                return true;
            }
            KtElement current2 = parentElement;
            while (!(current2 instanceof KtBlockExpression || current2 instanceof KtDeclaration || current2 instanceof KtStatementExpression || current2 instanceof KtFile)) {
                if (current2.getTextRange().getEndOffset() != currentInner.getTextRange().getEndOffset()) {
                    return !(current2 instanceof KtParenthesizedExpression) && !(current2 instanceof KtValueArgumentList);
                }
                current2 = current2.getParent();
            }
        }
        if (innerExpression instanceof KtLambdaExpression && (prevSibling = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)currentInner)) != null && prevSibling.getText().endsWith(KtTokens.RPAR.getValue())) {
            return true;
        }
        if (parentElement instanceof KtCallExpression && currentInner == ((KtCallExpression)parentElement).getCalleeExpression()) {
            KtExpression selector;
            KtCallExpression parentCall = (KtCallExpression)parentElement;
            KtExpression targetInnerExpression = innerExpression;
            if (targetInnerExpression instanceof KtDotQualifiedExpression && (selector = ((KtDotQualifiedExpression)targetInnerExpression).getSelectorExpression()) != null) {
                targetInnerExpression = selector;
            }
            if (targetInnerExpression instanceof KtSimpleNameExpression) {
                return false;
            }
            if (KtPsiUtilKt.getQualifiedExpressionForSelector(parentElement) != null) {
                return true;
            }
            if (targetInnerExpression instanceof KtCallExpression && parentCall.getValueArgumentList() == null) {
                return true;
            }
            return !(targetInnerExpression instanceof KtThisExpression) && !(targetInnerExpression instanceof KtArrayAccessExpression) && !(targetInnerExpression instanceof KtConstantExpression) && !(targetInnerExpression instanceof KtStringTemplateExpression) && !(targetInnerExpression instanceof KtCallExpression);
        }
        if (parentElement instanceof KtValueArgument) {
            KtExpression nextExpression;
            KtValueArgument nextArg = (KtValueArgument)PsiTreeUtil.getNextSiblingOfType((PsiElement)parentElement, KtValueArgument.class);
            KtExpression ktExpression = nextExpression = nextArg != null ? nextArg.getArgumentExpression() : null;
            if (innerExpression instanceof KtBinaryExpression && ((KtBinaryExpression)innerExpression).getOperationToken() == KtTokens.LT && nextExpression instanceof KtBinaryExpression && ((KtBinaryExpression)nextExpression).getOperationToken() == KtTokens.GT) {
                return true;
            }
        }
        if (!(parentElement instanceof KtExpression)) {
            return false;
        }
        IElementType innerOperation = KtPsiUtil.getOperation(innerExpression);
        IElementType parentOperation = KtPsiUtil.getOperation((KtExpression)parentElement);
        if (parentElement instanceof KtReturnExpression && (innerExpression instanceof KtLabeledExpression || innerExpression instanceof KtAnnotatedExpression)) {
            return true;
        }
        if (innerExpression instanceof KtBinaryExpressionWithTypeRHS && parentOperation == KtTokens.LT) {
            return true;
        }
        if (parentElement instanceof KtLabeledExpression) {
            return false;
        }
        if (parentElement instanceof KtBinaryExpression && parentOperation == KtTokens.ELVIS && !(innerExpression instanceof KtBinaryExpression) && currentInner == ((KtBinaryExpression)parentElement).getRight()) {
            return false;
        }
        if (parentElement instanceof KtBinaryExpression && parentOperation == KtTokens.EQ && innerExpression instanceof KtNamedFunction && currentInner == ((KtBinaryExpression)parentElement).getRight()) {
            return false;
        }
        if (innerExpression instanceof KtBinaryExpression) {
            KtBinaryExpression innerBinary;
            if (parentElement instanceof KtBinaryExpression && (innerBinary = (KtBinaryExpression)innerExpression).getRight() instanceof KtReturnExpression) {
                return true;
            }
            if (innerOperation != KtTokens.ELVIS && KtPsiUtil.isKeepBinaryExpressionParenthesized((KtBinaryExpression)innerExpression)) {
                return true;
            }
        }
        if ((innerPriority = KtPsiUtil.getPriority(innerExpression)) == (parentPriority = KtPsiUtil.getPriority((KtExpression)parentElement))) {
            if (parentElement instanceof KtBinaryExpression) {
                if (innerOperation == KtTokens.ANDAND || innerOperation == KtTokens.OROR) {
                    return false;
                }
                return ((KtBinaryExpression)parentElement).getRight() == currentInner;
            }
            if (parentElement instanceof KtPrefixExpression && innerExpression instanceof KtPrefixExpression) {
                if (parentOperation == KtTokens.PLUS) {
                    return innerOperation == KtTokens.PLUS || innerOperation == KtTokens.PLUSPLUS;
                }
                if (parentOperation == KtTokens.MINUS) {
                    return innerOperation == KtTokens.MINUS || innerOperation == KtTokens.MINUSMINUS;
                }
            }
            return false;
        }
        return innerPriority < parentPriority;
    }

    private static boolean isKeepBinaryExpressionParenthesized(KtBinaryExpression expression2) {
        for (PsiElement expr = expression2.getFirstChild(); expr != null; expr = expr.getNextSibling()) {
            if (expr instanceof PsiWhiteSpace && expr.textContains('\n')) {
                return true;
            }
            if (expr instanceof KtOperationReferenceExpression) break;
        }
        return expression2.getRight() instanceof KtBinaryExpression && KtPsiUtil.isKeepBinaryExpressionParenthesized((KtBinaryExpression)expression2.getRight()) || expression2.getLeft() instanceof KtBinaryExpression && KtPsiUtil.isKeepBinaryExpressionParenthesized((KtBinaryExpression)expression2.getLeft());
    }

    public static boolean isAssignment(@NotNull PsiElement element) {
        if (element == null) {
            KtPsiUtil.$$$reportNull$$$0(36);
        }
        return element instanceof KtBinaryExpression && KtTokens.ALL_ASSIGNMENTS.contains(((KtBinaryExpression)element).getOperationToken());
    }

    public static boolean isOrdinaryAssignment(@NotNull PsiElement element) {
        if (element == null) {
            KtPsiUtil.$$$reportNull$$$0(37);
        }
        return element instanceof KtBinaryExpression && ((KtBinaryExpression)element).getOperationToken().equals((Object)KtTokens.EQ);
    }

    public static boolean isSafeCast(@NotNull KtBinaryExpressionWithTypeRHS expression2) {
        if (expression2 == null) {
            KtPsiUtil.$$$reportNull$$$0(38);
        }
        return expression2.getOperationReference().getReferencedNameElementType() == KtTokens.AS_SAFE;
    }

    public static boolean isUnsafeCast(@NotNull KtBinaryExpressionWithTypeRHS expression2) {
        if (expression2 == null) {
            KtPsiUtil.$$$reportNull$$$0(39);
        }
        return expression2.getOperationReference().getReferencedNameElementType() == KtTokens.AS_KEYWORD;
    }

    public static boolean checkVariableDeclarationInBlock(@NotNull KtBlockExpression block, @NotNull String varName) {
        if (block == null) {
            KtPsiUtil.$$$reportNull$$$0(40);
        }
        if (varName == null) {
            KtPsiUtil.$$$reportNull$$$0(41);
        }
        for (KtExpression element : block.getStatements()) {
            if (!(element instanceof KtVariableDeclaration) || !((KtVariableDeclaration)element).getNameAsSafeName().asString().equals(varName)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkWhenExpressionHasSingleElse(@NotNull KtWhenExpression whenExpression) {
        if (whenExpression == null) {
            KtPsiUtil.$$$reportNull$$$0(42);
        }
        int elseCount = 0;
        for (KtWhenEntry entry : whenExpression.getEntries()) {
            if (!entry.isElse()) continue;
            ++elseCount;
        }
        return elseCount == 1;
    }

    @Nullable
    public static PsiElement skipTrailingWhitespacesAndComments(@Nullable PsiElement element) {
        return PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
    }

    @Nullable
    public static PsiElement prevLeafIgnoringWhitespaceAndComments(@NotNull PsiElement element) {
        if (element == null) {
            KtPsiUtil.$$$reportNull$$$0(43);
        }
        PsiElement prev = PsiTreeUtil.prevLeaf((PsiElement)element, (boolean)true);
        while (prev != null && KtTokens.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(prev.getNode().getElementType())) {
            prev = PsiTreeUtil.prevLeaf((PsiElement)prev, (boolean)true);
        }
        return prev;
    }

    @Nullable
    public static PsiElement getPreviousWord(@NotNull PsiElement element, @NotNull String word) {
        PsiElement prev;
        if (element == null) {
            KtPsiUtil.$$$reportNull$$$0(44);
        }
        if (word == null) {
            KtPsiUtil.$$$reportNull$$$0(45);
        }
        if ((prev = KtPsiUtil.prevLeafIgnoringWhitespaceAndComments(element)) != null && prev.getNode().getElementType() == KtTokens.IDENTIFIER && word.equals(prev.getText())) {
            return prev;
        }
        return null;
    }

    @NotNull
    public static String getText(@Nullable PsiElement element) {
        return element != null ? element.getText() : "";
    }

    @Nullable
    public static String getNullableText(@Nullable PsiElement element) {
        return element != null ? element.getText() : null;
    }

    public static boolean isInComment(PsiElement element) {
        return CommentUtilCore.isComment((PsiElement)element) || element instanceof KDocElement;
    }

    @Nullable
    public static PsiElement getOutermostParent(@NotNull PsiElement element, @NotNull PsiElement upperBound, boolean strict) {
        PsiElement parent2;
        if (element == null) {
            KtPsiUtil.$$$reportNull$$$0(46);
        }
        if (upperBound == null) {
            KtPsiUtil.$$$reportNull$$$0(47);
        }
        PsiElement psiElement = parent2 = strict ? element.getParent() : element;
        while (parent2 != null && parent2.getParent() != upperBound) {
            parent2 = parent2.getParent();
        }
        return parent2;
    }

    @SafeVarargs
    public static <T extends PsiElement> T getLastChildByType(@NotNull PsiElement root2, Class<? extends T> ... elementTypes) {
        if (root2 == null) {
            KtPsiUtil.$$$reportNull$$$0(48);
        }
        if (elementTypes == null) {
            KtPsiUtil.$$$reportNull$$$0(49);
        }
        PsiElement[] children2 = root2.getChildren();
        for (int i = children2.length - 1; i >= 0; --i) {
            if (!PsiTreeUtil.instanceOf((Object)children2[i], (Class[])elementTypes)) continue;
            return (T)children2[i];
        }
        return null;
    }

    @Nullable
    public static KtElement getOutermostDescendantElement(@Nullable PsiElement root2, boolean first, final @NotNull Predicate<KtElement> predicate) {
        if (predicate == null) {
            KtPsiUtil.$$$reportNull$$$0(50);
        }
        if (!(root2 instanceof KtElement)) {
            return null;
        }
        final ArrayList results = Lists.newArrayList();
        root2.accept((PsiElementVisitor)new KtVisitorVoid(){

            @Override
            public void visitKtElement(@NotNull KtElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (predicate.test(element)) {
                    results.add(element);
                } else {
                    element.acceptChildren(this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/KtPsiUtil$2", "visitKtElement"));
            }
        });
        if (results.isEmpty()) {
            return null;
        }
        return first ? (KtElement)results.get(0) : (KtElement)results.get(results.size() - 1);
    }

    @Nullable
    public static PsiElement findChildByType(@NotNull PsiElement element, @NotNull IElementType type2) {
        ASTNode node;
        if (element == null) {
            KtPsiUtil.$$$reportNull$$$0(51);
        }
        if (type2 == null) {
            KtPsiUtil.$$$reportNull$$$0(52);
        }
        return (node = element.getNode().findChildByType(type2)) == null ? null : node.getPsi();
    }

    @Nullable
    public static PsiElement skipSiblingsBackwardByPredicate(@Nullable PsiElement element, Predicate<PsiElement> elementsToSkip) {
        if (element == null) {
            return null;
        }
        for (PsiElement e = element.getPrevSibling(); e != null; e = e.getPrevSibling()) {
            if (elementsToSkip.test(e)) continue;
            return e;
        }
        return null;
    }

    public static PsiElement ascendIfPropertyAccessor(PsiElement element) {
        if (element instanceof KtPropertyAccessor) {
            return element.getParent();
        }
        return element;
    }

    @Nullable
    @Contract(value="_, !null -> !null")
    public static KtModifierList replaceModifierList(@NotNull KtModifierListOwner owner, @Nullable KtModifierList modifierList2) {
        if (owner == null) {
            KtPsiUtil.$$$reportNull$$$0(53);
        }
        KtModifierList oldModifierList = owner.getModifierList();
        if (modifierList2 == null) {
            if (oldModifierList != null) {
                oldModifierList.delete();
            }
            return null;
        }
        if (oldModifierList == null) {
            PsiElement firstChild = owner.getFirstChild();
            return (KtModifierList)owner.addBefore((PsiElement)modifierList2, firstChild);
        }
        return (KtModifierList)oldModifierList.replace((PsiElement)modifierList2);
    }

    @Nullable
    public static String getPackageName(@NotNull KtElement element) {
        KtFile file2;
        KtPackageDirective header;
        if (element == null) {
            KtPsiUtil.$$$reportNull$$$0(54);
        }
        return (header = (KtPackageDirective)PsiTreeUtil.findChildOfType((PsiElement)(file2 = element.getContainingKtFile()), KtPackageDirective.class)) != null ? header.getQualifiedName() : null;
    }

    @Nullable
    public static KtElement getEnclosingElementForLocalDeclaration(@NotNull KtDeclaration declaration2) {
        if (declaration2 == null) {
            KtPsiUtil.$$$reportNull$$$0(55);
        }
        return KtPsiUtil.getEnclosingElementForLocalDeclaration(declaration2, true);
    }

    private static boolean isMemberOfObjectExpression(@NotNull KtCallableDeclaration propertyOrFunction) {
        PsiElement parent2;
        if (propertyOrFunction == null) {
            KtPsiUtil.$$$reportNull$$$0(56);
        }
        if (!((parent2 = PsiTreeUtil.getStubOrPsiParent((PsiElement)propertyOrFunction)) instanceof KtClassBody)) {
            return false;
        }
        PsiElement grandparent = PsiTreeUtil.getStubOrPsiParent((PsiElement)parent2);
        if (!(grandparent instanceof KtObjectDeclaration)) {
            return false;
        }
        return PsiTreeUtil.getStubOrPsiParent((PsiElement)grandparent) instanceof KtObjectLiteralExpression;
    }

    private static boolean isNonLocalCallable(@Nullable KtDeclaration declaration2) {
        if (declaration2 instanceof KtProperty) {
            return !((KtProperty)declaration2).isLocal();
        }
        if (declaration2 instanceof KtFunction) {
            return !((KtFunction)declaration2).isLocal();
        }
        return false;
    }

    @Nullable
    public static KtElement getEnclosingElementForLocalDeclaration(@NotNull KtDeclaration declaration2, boolean skipParameters) {
        if (declaration2 == null) {
            KtPsiUtil.$$$reportNull$$$0(57);
        }
        if (declaration2 instanceof KtTypeParameter && skipParameters) {
            declaration2 = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)declaration2, KtNamedDeclaration.class);
        } else if (declaration2 instanceof KtParameter) {
            KtFunctionType functionType = (KtFunctionType)PsiTreeUtil.getParentOfType((PsiElement)declaration2, KtFunctionType.class);
            if (functionType != null) {
                return functionType;
            }
            PsiElement parent2 = declaration2.getParent();
            if (((KtParameter)declaration2).hasValOrVar() && parent2 != null && parent2.getParent() instanceof KtPrimaryConstructor) {
                return KtPsiUtil.getEnclosingElementForLocalDeclaration(((KtPrimaryConstructor)parent2.getParent()).getContainingClassOrObject(), skipParameters);
            }
            if (skipParameters && parent2 != null && !(parent2 instanceof KtForExpression) && parent2.getParent() instanceof KtNamedFunction) {
                declaration2 = (KtNamedFunction)parent2.getParent();
            }
        }
        if (declaration2 instanceof PsiFile) {
            return declaration2;
        }
        PsiElement current2 = PsiTreeUtil.getStubOrPsiParent((PsiElement)declaration2);
        boolean isNonLocalCallable = KtPsiUtil.isNonLocalCallable(declaration2);
        while (current2 != null) {
            PsiElement grandParent;
            PsiElement parent3 = PsiTreeUtil.getStubOrPsiParent((PsiElement)current2);
            if (parent3 instanceof KtScript) {
                return null;
            }
            if (current2 instanceof KtAnonymousInitializer) {
                return ((KtAnonymousInitializer)current2).getBody();
            }
            if (current2 instanceof KtProperty || current2 instanceof KtFunction) {
                if (parent3 instanceof KtFile) {
                    return (KtElement)current2;
                }
                if (parent3 instanceof KtClassBody && !KtPsiUtil.isMemberOfObjectExpression((KtCallableDeclaration)current2)) {
                    return (KtElement)parent3;
                }
                if (parent3 instanceof KtBlockExpression && (grandParent = parent3.getParent()) instanceof KtScript) {
                    return (KtElement)parent3;
                }
            }
            if (current2 instanceof KtParameter) {
                return (KtElement)current2;
            }
            if (current2 instanceof KtValueArgument && !isNonLocalCallable) {
                return (KtElement)current2;
            }
            if (!(!(current2 instanceof KtBlockExpression) || isNonLocalCallable && current2.getParent() instanceof KtFunctionLiteral)) {
                return (KtElement)current2;
            }
            if ((current2 instanceof KtDelegatedSuperTypeEntry || current2 instanceof KtSuperTypeCallEntry) && (grandParent = current2.getParent().getParent()) instanceof KtClassOrObject && !(grandParent.getParent() instanceof KtObjectLiteralExpression)) {
                return (KtElement)grandParent;
            }
            current2 = parent3;
        }
        return null;
    }

    public static boolean isLocal(@NotNull KtDeclaration declaration2) {
        if (declaration2 == null) {
            KtPsiUtil.$$$reportNull$$$0(58);
        }
        return KtPsiUtil.getEnclosingElementForLocalDeclaration(declaration2) != null;
    }

    @Nullable
    public static KtToken getOperationToken(@NotNull KtOperationExpression expression2) {
        if (expression2 == null) {
            KtPsiUtil.$$$reportNull$$$0(59);
        }
        KtSimpleNameExpression operationExpression = expression2.getOperationReference();
        IElementType elementType = operationExpression.getReferencedNameElementType();
        assert (elementType == null || elementType instanceof KtToken) : "JetOperationExpression should have operation token of type KtToken: " + expression2;
        return (KtToken)elementType;
    }

    public static boolean isLabelIdentifierExpression(PsiElement element) {
        return element instanceof KtLabelReferenceExpression;
    }

    @Nullable
    public static KtExpression getParentCallIfPresent(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            KtPsiUtil.$$$reportNull$$$0(60);
        }
        PsiElement parent2 = expression2.getParent();
        while (parent2 != null) {
            if (parent2 instanceof KtBinaryExpression || parent2 instanceof KtUnaryExpression || parent2 instanceof KtLabeledExpression || parent2 instanceof KtDotQualifiedExpression || parent2 instanceof KtCallExpression || parent2 instanceof KtArrayAccessExpression || parent2 instanceof KtDestructuringDeclaration) {
                if (parent2 instanceof KtLabeledExpression) {
                    parent2 = parent2.getParent();
                    continue;
                }
                return (KtExpression)parent2;
            }
            if (parent2 instanceof KtParenthesizedExpression || parent2 instanceof KtBinaryExpressionWithTypeRHS) {
                parent2 = parent2.getParent();
                continue;
            }
            if (parent2 instanceof KtValueArgument || parent2 instanceof KtValueArgumentList) {
                parent2 = parent2.getParent();
                continue;
            }
            if (parent2 instanceof KtLambdaExpression || parent2 instanceof KtAnnotatedExpression) {
                parent2 = parent2.getParent();
                continue;
            }
            return null;
        }
        return null;
    }

    public static boolean isLabeledFunctionLiteral(@NotNull KtFunctionLiteral functionLiteral) {
        if (functionLiteral == null) {
            KtPsiUtil.$$$reportNull$$$0(61);
        }
        return functionLiteral.getParent().getParent() instanceof KtLabeledExpression;
    }

    @Nullable
    public static KtExpression getLastElementDeparenthesized(@Nullable KtExpression expression2, @NotNull StatementFilter statementFilter) {
        KtBlockExpression blockExpression;
        KtExpression lastStatementInABlock;
        KtExpression deparenthesizedExpression;
        if (statementFilter == null) {
            KtPsiUtil.$$$reportNull$$$0(62);
        }
        if ((deparenthesizedExpression = KtPsiUtil.deparenthesize(expression2)) instanceof KtBlockExpression && (lastStatementInABlock = StatementFilterKt.getLastStatementInABlock(statementFilter, blockExpression = (KtBlockExpression)deparenthesizedExpression)) != null) {
            return KtPsiUtil.getLastElementDeparenthesized(lastStatementInABlock, statementFilter);
        }
        return deparenthesizedExpression;
    }

    public static boolean isStatementContainer(@Nullable PsiElement container2) {
        return container2 instanceof KtBlockExpression || container2 instanceof KtContainerNodeForControlStructureBody || container2 instanceof KtWhenEntry;
    }

    public static boolean isStatement(@NotNull PsiElement element) {
        if (element == null) {
            KtPsiUtil.$$$reportNull$$$0(63);
        }
        return KtPsiUtil.isStatementContainer(element.getParent());
    }

    public static boolean isInOrNotInOperation(@NotNull KtBinaryExpression binaryExpression) {
        if (binaryExpression == null) {
            KtPsiUtil.$$$reportNull$$$0(64);
        }
        return KtPsiUtil.isInOperation(binaryExpression) || KtPsiUtil.isNotInOperation(binaryExpression);
    }

    public static boolean isNotInOperation(@NotNull KtBinaryExpression binaryExpression) {
        if (binaryExpression == null) {
            KtPsiUtil.$$$reportNull$$$0(65);
        }
        return binaryExpression.getOperationToken() == KtTokens.NOT_IN;
    }

    private static boolean isInOperation(@NotNull KtBinaryExpression binaryExpression) {
        if (binaryExpression == null) {
            KtPsiUtil.$$$reportNull$$$0(66);
        }
        return binaryExpression.getOperationToken() == KtTokens.IN_KEYWORD;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 3: 
            case 20: 
            case 25: 
            case 30: 
            case 31: 
            case 32: 
            case 38: 
            case 39: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/psi/KtPsiUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unreachableElements";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quoted";
                break;
            }
            case 15: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 16: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedReference";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameExpression";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedDeclaration";
                break;
            }
            case 23: 
            case 26: 
            case 55: 
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentTypes";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classOrObject";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetParameter";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerExpression";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentInner";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varName";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whenExpression";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upperBound";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementTypes";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyOrFunction";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionLiteral";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementFilter";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/psi/KtPsiUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "safeDeparenthesize";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "safeName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findRootExpressions";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteIdentifier";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteIdentifierOrFieldReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitChildren";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "safeDeparenthesize";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findRootExpressions";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "unquoteIdentifier";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "unquoteIdentifierOrFieldReference";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isDeprecated";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDirectParentOfTypeForBlock";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLastReference";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isSelectorInQualified";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isLHSOfDot";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isScriptDeclaration";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getScript";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isRemovableVariableDeclaration";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostParentOfTypes";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isNullConstant";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isAbstract";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isTrait";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getOutermostClassOrObject";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getClassIfParameterIsProperty";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getOperation";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getPriority";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "areParenthesesUseless";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "areParenthesesNecessary";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isAssignment";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isOrdinaryAssignment";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isSafeCast";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isUnsafeCast";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "checkVariableDeclarationInBlock";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "checkWhenExpressionHasSingleElse";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "prevLeafIgnoringWhitespaceAndComments";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getPreviousWord";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getOutermostParent";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getLastChildByType";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getOutermostDescendantElement";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "findChildByType";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "replaceModifierList";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 55: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getEnclosingElementForLocalDeclaration";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isMemberOfObjectExpression";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isLocal";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getOperationToken";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getParentCallIfPresent";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "isLabeledFunctionLiteral";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getLastElementDeparenthesized";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isStatement";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "isInOrNotInOperation";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "isNotInOperation";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isInOperation";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface KtExpressionWrapper {
        public KtExpression getBaseExpression();
    }
}

