/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

public class KtPackageDirective
extends KtModifierListOwnerStub<KotlinPlaceHolderStub<KtPackageDirective>> {
    private String qualifiedNameCache;

    public KtPackageDirective(@NotNull ASTNode node) {
        if (node == null) {
            KtPackageDirective.$$$reportNull$$$0(0);
        }
        super(node);
        this.qualifiedNameCache = null;
    }

    public KtPackageDirective(@NotNull KotlinPlaceHolderStub<KtPackageDirective> stub) {
        if (stub == null) {
            KtPackageDirective.$$$reportNull$$$0(1);
        }
        super(stub, KtStubElementTypes.PACKAGE_DIRECTIVE);
        this.qualifiedNameCache = null;
    }

    @Nullable
    public KtExpression getPackageNameExpression() {
        return KtStubbedPsiUtil.getStubOrPsiChild(this, KtStubElementTypes.INSIDE_DIRECTIVE_EXPRESSIONS, KtExpression.ARRAY_FACTORY);
    }

    @NotNull
    public List<KtSimpleNameExpression> getPackageNames() {
        KtExpression nameExpression = this.getPackageNameExpression();
        if (nameExpression == null) {
            List<KtSimpleNameExpression> list2 = Collections.emptyList();
            if (list2 == null) {
                KtPackageDirective.$$$reportNull$$$0(2);
            }
            return list2;
        }
        ArrayList<KtSimpleNameExpression> packageNames = new ArrayList<KtSimpleNameExpression>();
        while (nameExpression instanceof KtQualifiedExpression) {
            KtQualifiedExpression qualifiedExpression = (KtQualifiedExpression)nameExpression;
            KtExpression selector = qualifiedExpression.getSelectorExpression();
            if (selector instanceof KtSimpleNameExpression) {
                packageNames.add((KtSimpleNameExpression)selector);
            }
            nameExpression = qualifiedExpression.getReceiverExpression();
        }
        if (nameExpression instanceof KtSimpleNameExpression) {
            packageNames.add((KtSimpleNameExpression)nameExpression);
        }
        Collections.reverse(packageNames);
        ArrayList<KtSimpleNameExpression> arrayList = packageNames;
        if (arrayList == null) {
            KtPackageDirective.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Nullable
    public KtSimpleNameExpression getLastReferenceExpression() {
        KtExpression nameExpression = this.getPackageNameExpression();
        if (nameExpression == null) {
            return null;
        }
        return (KtSimpleNameExpression)KtPsiUtilKt.getQualifiedElementSelector(nameExpression);
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        KtSimpleNameExpression lastPart = this.getLastReferenceExpression();
        return lastPart != null ? lastPart.getIdentifier() : null;
    }

    @NotNull
    public String getName() {
        PsiElement nameIdentifier = this.getNameIdentifier();
        String string2 = nameIdentifier == null ? "" : nameIdentifier.getText();
        if (string2 == null) {
            KtPackageDirective.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @NotNull
    public Name getNameAsName() {
        PsiElement nameIdentifier = this.getNameIdentifier();
        Name name2 = nameIdentifier == null ? SpecialNames.ROOT_PACKAGE : Name.identifier(nameIdentifier.getText());
        if (name2 == null) {
            KtPackageDirective.$$$reportNull$$$0(5);
        }
        return name2;
    }

    public boolean isRoot() {
        return this.getName().length() == 0;
    }

    @NotNull
    public FqName getFqName() {
        String qualifiedName = this.getQualifiedName();
        return qualifiedName.isEmpty() ? FqName.ROOT : new FqName(qualifiedName);
    }

    @NotNull
    public FqName getFqName(KtSimpleNameExpression nameExpression) {
        return new FqName(this.getQualifiedNameOf(nameExpression));
    }

    public void setFqName(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            KtPackageDirective.$$$reportNull$$$0(6);
        }
        if (fqName2.isRoot()) {
            if (!this.getFqName().isRoot()) {
                this.replace(new KtPsiFactory(this.getProject()).createFile("").getPackageDirective());
            }
            return;
        }
        KtPsiFactory psiFactory = new KtPsiFactory(this.getProject());
        KtExpression newExpression = psiFactory.createExpression(fqName2.asString());
        KtExpression currentExpression = this.getPackageNameExpression();
        if (currentExpression != null) {
            currentExpression.replace((PsiElement)newExpression);
            return;
        }
        PsiElement keyword = this.getPackageKeyword();
        if (keyword != null) {
            this.addAfter((PsiElement)newExpression, keyword);
            this.addAfter(psiFactory.createWhiteSpace(), keyword);
            return;
        }
        this.replace(psiFactory.createPackageDirective(fqName2));
    }

    @NotNull
    public String getQualifiedName() {
        if (this.qualifiedNameCache == null) {
            this.qualifiedNameCache = this.getQualifiedNameOf(null);
        }
        String string2 = this.qualifiedNameCache;
        if (string2 == null) {
            KtPackageDirective.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @NotNull
    private String getQualifiedNameOf(@Nullable KtSimpleNameExpression nameExpression) {
        StringBuilder builder2 = new StringBuilder();
        for (KtSimpleNameExpression e : this.getPackageNames()) {
            if (builder2.length() > 0) {
                builder2.append(".");
            }
            builder2.append(e.getReferencedName());
            if (e != nameExpression) continue;
            break;
        }
        String string2 = builder2.toString();
        if (string2 == null) {
            KtPackageDirective.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @Nullable
    public PsiElement getPackageKeyword() {
        return this.findChildByType(KtTokens.PACKAGE_KEYWORD);
    }

    public void subtreeChanged() {
        this.qualifiedNameCache = null;
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            KtPackageDirective.$$$reportNull$$$0(9);
        }
        return visitor2.visitPackageDirective(this, data);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/psi/KtPackageDirective";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/psi/KtPackageDirective";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageNames";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameAsName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedNameOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setFqName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

