/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.overrides;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrOverridableMember;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.overrides.DeepCopyIrTreeWithSymbolsForFakeOverrides;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContextKt;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\t\u001a\n\u0010\n\u001a\u00020\b*\u00020\u000b\u001a\n\u0010\f\u001a\u00020\b*\u00020\r\u00a8\u0006\u000e"}, d2={"buildFakeOverrideMember", "Lorg/jetbrains/kotlin/ir/declarations/IrOverridableMember;", "superType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "member", "clazz", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "isOverridableFunction", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "isOverridableMemberOrAccessor", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "isOverridableProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "ir.tree"})
public final class IrOverridingUtilKt {
    @NotNull
    public static final IrOverridableMember buildFakeOverrideMember(@NotNull IrType superType, @NotNull IrOverridableMember member2, @NotNull IrClass clazz) {
        Intrinsics.checkNotNullParameter((Object)superType, (String)"superType");
        Intrinsics.checkNotNullParameter((Object)member2, (String)"member");
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        boolean bl = superType instanceof IrSimpleType;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl42 = false;
            String string2 = "superType is " + superType + ", expected IrSimpleType";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        IrClassifierSymbol classifier2 = ((IrSimpleType)superType).getClassifier();
        bl2 = classifier2 instanceof IrClassSymbol;
        bl3 = false;
        boolean bl42 = false;
        if (!bl2) {
            boolean bl5 = false;
            String bl42 = Intrinsics.stringPlus((String)"superType classifier is not IrClassSymbol: ", (Object)classifier2);
            throw (Throwable)new IllegalArgumentException(bl42.toString());
        }
        List<IrTypeParameter> typeParameters2 = IrTypeSystemContextKt.extractTypeParameters((IrDeclarationParent)((Object)((IrClassSymbol)classifier2).getOwner()));
        List<IrTypeArgument> superArguments = ((IrSimpleType)superType).getArguments();
        bl42 = typeParameters2.size() == superArguments.size();
        int bl5 = 0;
        if (_Assertions.ENABLED && !bl42) {
            boolean $i$a$-assert-IrOverridingUtilKt$buildFakeOverrideMember$42 = false;
            String $i$a$-assert-IrOverridingUtilKt$buildFakeOverrideMember$42 = "typeParameters = " + typeParameters2 + " size != typeArguments = " + superArguments + " size ";
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-IrOverridingUtilKt$buildFakeOverrideMember$42));
        }
        bl5 = 0;
        Map substitutionMap = new LinkedHashMap();
        bl5 = 0;
        int $i$a$-assert-IrOverridingUtilKt$buildFakeOverrideMember$42 = typeParameters2.size() + -1;
        if (bl5 <= $i$a$-assert-IrOverridingUtilKt$buildFakeOverrideMember$42) {
            do {
                int i = bl5++;
                IrTypeParameter tp = typeParameters2.get(i);
                IrTypeArgument ta = superArguments.get(i);
                boolean bl6 = ta instanceof IrTypeProjection;
                boolean bl7 = false;
                boolean bl8 = false;
                if (!bl6) {
                    boolean bl9 = false;
                    String string3 = "Unexpected super type argument: " + ta + " @ " + i;
                    throw (Throwable)new IllegalArgumentException(string3.toString());
                }
                bl6 = ((IrTypeProjection)ta).getVariance() == Variance.INVARIANT;
                bl7 = false;
                if (_Assertions.ENABLED && !bl6) {
                    boolean bl10 = false;
                    String string4 = "Unexpected variance in super type argument: " + (Object)((Object)((IrTypeProjection)ta).getVariance()) + " @" + i;
                    throw (Throwable)((Object)new AssertionError((Object)string4));
                }
                Map map = substitutionMap;
                IrTypeParameterSymbol irTypeParameterSymbol = tp.getSymbol();
                IrType irType = ((IrTypeProjection)ta).getType();
                boolean bl11 = false;
                map.put(irTypeParameterSymbol, irType);
            } while (bl5 <= $i$a$-assert-IrOverridingUtilKt$buildFakeOverrideMember$42);
        }
        DeepCopyIrTreeWithSymbolsForFakeOverrides copier2 = new DeepCopyIrTreeWithSymbolsForFakeOverrides(substitutionMap);
        IrOverridableMember deepCopyFakeOverride = (IrOverridableMember)copier2.copy(member2, clazz);
        deepCopyFakeOverride.setParent(clazz);
        return deepCopyFakeOverride;
    }

    public static final boolean isOverridableFunction(@NotNull IrSimpleFunction $this$isOverridableFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isOverridableFunction, (String)"<this>");
        return !Intrinsics.areEqual((Object)$this$isOverridableFunction.getVisibility(), (Object)DescriptorVisibilities.PRIVATE) && $this$isOverridableFunction.getDispatchReceiverParameter() != null;
    }

    public static final boolean isOverridableProperty(@NotNull IrProperty $this$isOverridableProperty) {
        IrSimpleFunction irSimpleFunction;
        Intrinsics.checkNotNullParameter((Object)$this$isOverridableProperty, (String)"<this>");
        return !Intrinsics.areEqual((Object)$this$isOverridableProperty.getVisibility(), (Object)DescriptorVisibilities.PRIVATE) && (((irSimpleFunction = $this$isOverridableProperty.getGetter()) == null ? null : irSimpleFunction.getDispatchReceiverParameter()) != null || ((irSimpleFunction = $this$isOverridableProperty.getSetter()) == null ? null : irSimpleFunction.getDispatchReceiverParameter()) != null);
    }

    public static final boolean isOverridableMemberOrAccessor(@NotNull IrDeclaration $this$isOverridableMemberOrAccessor) {
        Intrinsics.checkNotNullParameter((Object)$this$isOverridableMemberOrAccessor, (String)"<this>");
        IrDeclaration irDeclaration2 = $this$isOverridableMemberOrAccessor;
        return irDeclaration2 instanceof IrSimpleFunction ? IrOverridingUtilKt.isOverridableFunction((IrSimpleFunction)$this$isOverridableMemberOrAccessor) : (irDeclaration2 instanceof IrProperty ? IrOverridingUtilKt.isOverridableProperty((IrProperty)$this$isOverridableMemberOrAccessor) : false);
    }
}

