/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.js.dce;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLITool;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.K2JSDceArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.js.dce.K2JSDce;
import org.jetbrains.kotlin.cli.js.dce.K2JSDce$WhenMappings;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.js.dce.Context;
import org.jetbrains.kotlin.js.dce.DCELogLevel;
import org.jetbrains.kotlin.js.dce.DeadCodeElimination;
import org.jetbrains.kotlin.js.dce.DeadCodeEliminationResult;
import org.jetbrains.kotlin.js.dce.DeadCodeEliminationStatus;
import org.jetbrains.kotlin.js.dce.InputFile;
import org.jetbrains.kotlin.js.dce.InputResource;
import org.jetbrains.kotlin.js.dce.PrintTreeKt;
import org.jetbrains.kotlin.js.dce.UtilKt;
import org.jetbrains.kotlin.js.inline.util.RelativePathCalculator;
import org.jetbrains.kotlin.js.parser.sourcemaps.JSONKt;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonArray;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNode;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonObject;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonString;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonSyntaxException;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0019\u001a\u00020\u0002H\u0016J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0002H\u0014J\b\u0010\u001f\u001a\u00020\nH\u0016J\u0010\u0010 \u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0018\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH\u0002J&\u0010#\u001a\u00020\u001b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010$\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\f\u0010%\u001a\u00020\n*\u00020\nH\u0002\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/cli/js/dce/K2JSDce;", "Lorg/jetbrains/kotlin/cli/common/CLITool;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSDceArguments;", "()V", "collectInputFiles", "", "Lorg/jetbrains/kotlin/js/dce/InputFile;", "baseDir", "Ljava/io/File;", "fileName", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "collectInputFilesFromDirectory", "path", "collectInputFilesFromZip", "copyFiles", "", "files", "overwriteOnlyOlderFiles", "", "copyResource", "resource", "Lorg/jetbrains/kotlin/js/dce/InputResource;", "targetFile", "createArguments", "execImpl", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "services", "Lorg/jetbrains/kotlin/config/Services;", "arguments", "executableScriptFileName", "getModuleNameFromPath", "mapSourcePaths", "inputFile", "performDce", "singleInputFile", "metaJs", "Companion", "cli-js"})
public final class K2JSDce
extends CLITool<K2JSDceArguments> {
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public K2JSDceArguments createArguments() {
        return new K2JSDceArguments();
    }

    @Override
    @NotNull
    protected ExitCode execImpl(@NotNull MessageCollector messageCollector2, @NotNull Services services, @NotNull K2JSDceArguments arguments2) {
        ExitCode exitCode2;
        Iterator $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)messageCollector2, (String)"messageCollector");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        String string2 = arguments2.getOutputDirectory();
        if (string2 == null) {
            string2 = "min";
        }
        File baseDir = new File(string2);
        Iterable $this$flatMap$iv = arguments2.getFreeArgs();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            String arg = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.collectInputFiles(baseDir, arg, messageCollector2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List files2 = (List)destination$iv$iv;
        if (messageCollector2.hasErrors()) {
            return ExitCode.COMPILATION_ERROR;
        }
        if (files2.isEmpty() && !arguments2.getVersion()) {
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "no source files", null, 4, null);
            return ExitCode.COMPILATION_ERROR;
        }
        $i$f$flatMap = false;
        Map existingFiles = new LinkedHashMap();
        for (InputFile file2 : files2) {
            InputFile inputFile = (InputFile)existingFiles.get(file2.getOutputPath());
            if (inputFile != null) {
                InputFile inputFile2 = inputFile;
                boolean bl = false;
                boolean bl2 = false;
                InputFile it = inputFile2;
                boolean bl3 = false;
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "duplicate target file will be created for '" + file2.getResource().getName() + "' and '" + it.getResource().getName() + '\'', null, 4, null);
                return ExitCode.COMPILATION_ERROR;
            }
            existingFiles.put(file2.getOutputPath(), file2);
            if (!new File(file2.getOutputPath()).isDirectory()) continue;
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "cannot open output file '" + file2.getOutputPath() + "': it is a directory", null, 4, null);
            return ExitCode.COMPILATION_ERROR;
        }
        if (!arguments2.getDevMode()) {
            exitCode2 = this.performDce(files2, arguments2, messageCollector2);
        } else {
            String string3 = arguments2.getDevModeOverwritingStrategy();
            if (string3 == null) {
                string3 = System.getProperty("kotlin.js.dce.devmode.overwriting.strategy", "older");
            }
            String devModeOverwritingStrategy = string3;
            boolean overwriteOnlyOlderFiles = Intrinsics.areEqual((Object)devModeOverwritingStrategy, (Object)"older");
            this.copyFiles(files2, overwriteOnlyOlderFiles);
            exitCode2 = ExitCode.OK;
        }
        return exitCode2;
    }

    /*
     * WARNING - void declaration
     */
    private final ExitCode performDce(List<InputFile> files2, K2JSDceArguments arguments2, MessageCollector messageCollector2) {
        void $this$filterTo$iv;
        Function2 logConsumer2;
        Set includedDeclarations;
        DeadCodeEliminationResult dceResult;
        Object[] $this$orEmpty$iv = arguments2.getDeclarationsToKeep();
        boolean $i$f$orEmpty = false;
        Object[] objectArray = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            objectArray = new String[]{};
        }
        if ((dceResult = DeadCodeElimination.Companion.run((Collection<InputFile>)files2, includedDeclarations = ArraysKt.toSet((Object[])objectArray), (Function2<? super DCELogLevel, ? super String, Unit>)(logConsumer2 = (Function2)new Function2<DCELogLevel, String, Unit>(messageCollector2){
            final /* synthetic */ MessageCollector $messageCollector;

            public final void invoke(@NotNull DCELogLevel level, @NotNull String message2) {
                CompilerMessageSeverity compilerMessageSeverity;
                Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                switch (K2JSDce$WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                    case 1: {
                        compilerMessageSeverity = CompilerMessageSeverity.ERROR;
                        break;
                    }
                    case 2: {
                        compilerMessageSeverity = CompilerMessageSeverity.WARNING;
                        break;
                    }
                    case 3: {
                        compilerMessageSeverity = CompilerMessageSeverity.LOGGING;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                CompilerMessageSeverity severity = compilerMessageSeverity;
                MessageCollector.DefaultImpls.report$default(this.$messageCollector, severity, message2, null, 4, null);
            }
            {
                this.$messageCollector = messageCollector2;
                super(2);
            }
        }))).getStatus() == DeadCodeEliminationStatus.FAILED) {
            return ExitCode.COMPILATION_ERROR;
        }
        Iterable iterable = dceResult.getReachableNodes();
        boolean bl = false;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            Context.Node it = (Context.Node)element$iv;
            boolean bl2 = false;
            if (!it.getReachable()) continue;
            destination$iv.add(element$iv);
        }
        Set nodes = (Set)destination$iv;
        CompilerMessageSeverity reachabilitySeverity = arguments2.getPrintReachabilityInfo() ? CompilerMessageSeverity.INFO : CompilerMessageSeverity.LOGGING;
        MessageCollector.DefaultImpls.report$default(messageCollector2, reachabilitySeverity, "", null, 4, null);
        for (Context.Node node : UtilKt.extractRoots(nodes)) {
            PrintTreeKt.printTree(node, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(messageCollector2, reachabilitySeverity){
                final /* synthetic */ MessageCollector $messageCollector;
                final /* synthetic */ CompilerMessageSeverity $reachabilitySeverity;

                public final void invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    MessageCollector.DefaultImpls.report$default(this.$messageCollector, this.$reachabilitySeverity, it, null, 4, null);
                }
                {
                    this.$messageCollector = messageCollector2;
                    this.$reachabilitySeverity = compilerMessageSeverity;
                    super(1);
                }
            }), false, true);
        }
        return ExitCode.OK;
    }

    private final void copyFiles(List<InputFile> files2, boolean overwriteOnlyOlderFiles) {
        for (InputFile file2 : files2) {
            InputResource inputResource;
            this.copyResource(file2.getResource(), new File(file2.getOutputPath()), overwriteOnlyOlderFiles);
            if (file2.getSourceMapResource() == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            InputResource sourceMap2 = inputResource;
            boolean bl3 = false;
            File sourceMapTarget = new File(file2.getOutputPath() + ".map");
            File inputFile = new File(sourceMap2.getName());
            if (inputFile.exists() && this.mapSourcePaths(inputFile, sourceMapTarget)) continue;
            this.copyResource(sourceMap2, sourceMapTarget, overwriteOnlyOlderFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void copyResource(InputResource resource, File targetFile, boolean overwriteOnlyOlderFiles) {
        if (overwriteOnlyOlderFiles && targetFile.exists() && ((Number)resource.getLastModified().invoke()).longValue() < targetFile.lastModified()) {
            return;
        }
        targetFile.getParentFile().mkdirs();
        Closeable closeable = (Closeable)resource.getReader().invoke();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            long l;
            InputStream input = (InputStream)closeable;
            boolean bl3 = false;
            Closeable closeable2 = new FileOutputStream(targetFile);
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                FileOutputStream output = (FileOutputStream)closeable2;
                boolean bl6 = false;
                l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final boolean mapSourcePaths(File inputFile, File targetFile) {
        Collection<JsonString> collection;
        String it;
        Iterable $this$mapTo$iv$iv;
        Object object;
        Object object2;
        void $this$mapTo$iv$iv2;
        JsonNode jsonNode;
        Object object3;
        JsonNode jsonNode2;
        try {
            jsonNode2 = JSONKt.parseJson(inputFile);
        }
        catch (JsonSyntaxException e) {
            return false;
        }
        JsonNode json = jsonNode2;
        JsonNode jsonNode3 = json;
        if (!(jsonNode3 instanceof JsonObject)) {
            jsonNode3 = null;
        }
        if (!(((object3 = (JsonObject)jsonNode3) != null && (object3 = ((JsonObject)object3).getProperties()) != null ? (JsonNode)object3.get("sources") : (jsonNode = null)) instanceof JsonArray)) {
            jsonNode = null;
        }
        JsonArray jsonArray = (JsonArray)jsonNode;
        if (jsonArray == null) {
            return false;
        }
        JsonArray sourcesArray = jsonArray;
        Iterable $this$map$iv = sourcesArray.getElements();
        boolean $i$f$map = false;
        Object object4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Object object5;
            void it2;
            Iterator iterator2 = (JsonNode)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            Object v4 = it2;
            if (!(v4 instanceof JsonString)) {
                v4 = null;
            }
            if ((object5 = (JsonString)v4) == null || (object5 = ((JsonString)object5).getValue()) == null) {
                return false;
            }
            object = object5;
            object2.add(object);
        }
        List sources = (List)destination$iv$iv;
        File file2 = targetFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"targetFile.parentFile");
        RelativePathCalculator pathCalculator = new RelativePathCalculator(file2);
        Iterable $this$map$iv2 = sources;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2 = (String)item$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl = false;
            String result2 = pathCalculator.calculateRelativePathTo(new File(inputFile.getParentFile(), it));
            object = result2 != null ? (new File(targetFile.getParentFile(), result2).exists() ? result2 : it) : it;
            object2.add(object);
        }
        List mappedSources = (List)destination$iv$iv2;
        if (Intrinsics.areEqual((Object)mappedSources, (Object)sources)) {
            return false;
        }
        $this$map$iv2 = mappedSources;
        object = "sources";
        object2 = ((JsonObject)json).getProperties();
        $i$f$map2 = false;
        $this$mapTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            JsonString jsonString = new JsonString(it);
            collection.add(jsonString);
        }
        collection = (List)destination$iv$iv2;
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        JsonString[] jsonStringArray = thisCollection$iv.toArray(new JsonString[0]);
        if (jsonStringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        JsonNode[] jsonNodeArray = jsonStringArray;
        JsonNode[] jsonNodeArray2 = Arrays.copyOf(jsonNodeArray, jsonNodeArray.length);
        object2.put(object, new JsonArray(jsonNodeArray2));
        targetFile.getParentFile().mkdirs();
        object4 = new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), "UTF-8");
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            OutputStreamWriter it3 = (OutputStreamWriter)object4;
            boolean bl3 = false;
            it3.write(json.toString());
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object4, (Throwable)throwable);
        }
        return true;
    }

    private final List<InputFile> collectInputFiles(File baseDir, String fileName, MessageCollector messageCollector2) {
        List list2;
        File file2 = new File(fileName);
        if (file2.isDirectory()) {
            list2 = this.collectInputFilesFromDirectory(baseDir, fileName);
        } else if (file2.isFile()) {
            if (StringsKt.endsWith$default((String)fileName, (String)".js", (boolean)false, (int)2, null)) {
                list2 = CollectionsKt.listOf((Object)this.singleInputFile(baseDir, fileName));
            } else if (StringsKt.endsWith$default((String)fileName, (String)".zip", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)".jar", (boolean)false, (int)2, null)) {
                list2 = this.collectInputFilesFromZip(baseDir, fileName);
            } else {
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.WARNING, "invalid file name '" + file2.getAbsolutePath() + "'; must end either with '.js', '.zip' or '.jar'", null, 4, null);
                list2 = CollectionsKt.emptyList();
            }
        } else {
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "source file or directory not found: " + fileName, null, 4, null);
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final InputFile singleInputFile(File baseDir, String path2) {
        InputResource inputResource;
        String moduleName = this.getModuleNameFromPath(path2);
        String pathToSourceMapCandidate = path2 + ".map";
        String pathToSourceMap = new File(pathToSourceMapCandidate).exists() ? pathToSourceMapCandidate : null;
        InputResource inputResource2 = InputResource.Companion.file(path2);
        String string2 = pathToSourceMap;
        if (string2 != null) {
            void it;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String string4 = string3;
            InputResource inputResource3 = inputResource2;
            boolean bl3 = false;
            InputResource inputResource4 = InputResource.Companion.file((String)it);
            inputResource2 = inputResource3;
            inputResource = inputResource4;
        } else {
            inputResource = null;
        }
        String string5 = new File(baseDir, moduleName + ".js").getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"File(baseDir, \"$moduleName.js\").absolutePath");
        String string6 = moduleName;
        String string7 = string5;
        InputResource inputResource5 = inputResource;
        InputResource inputResource6 = inputResource2;
        return new InputFile(inputResource6, inputResource5, string7, string6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<InputFile> collectInputFilesFromZip(File baseDir, String path2) {
        List list2;
        Closeable closeable = new ZipFile(path2);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ZipFile zipFile2 = (ZipFile)closeable;
            boolean bl3 = false;
            Enumeration<? extends ZipEntry> enumeration = zipFile2.entries();
            boolean bl4 = false;
            list2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.distinctBy((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), (Function1)collectInputFilesFromZip.1.1.INSTANCE), (Function1)collectInputFilesFromZip.1.2.INSTANCE), (Function1)((Function1)new Function1<ZipEntry, Boolean>(zipFile2, this, path2, baseDir){
                final /* synthetic */ ZipFile $zipFile;
                final /* synthetic */ K2JSDce this$0;
                final /* synthetic */ String $path$inlined;
                final /* synthetic */ File $baseDir$inlined;
                {
                    this.$zipFile = zipFile2;
                    this.this$0 = k2JSDce;
                    this.$path$inlined = string2;
                    this.$baseDir$inlined = file2;
                    super(1);
                }

                public final boolean invoke(ZipEntry it) {
                    ZipEntry zipEntry = it;
                    Intrinsics.checkNotNullExpressionValue((Object)zipEntry, (String)"it");
                    String string2 = zipEntry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
                    return this.$zipFile.getEntry(K2JSDce.access$metaJs(this.this$0, string2)) != null;
                }
            })), (Function1)collectInputFilesFromZip.1.4.INSTANCE), (Function1)((Function1)new Function1<ZipEntry, InputFile>(zipFile2, this, path2, baseDir){
                final /* synthetic */ ZipFile $zipFile;
                final /* synthetic */ K2JSDce this$0;
                final /* synthetic */ String $path$inlined;
                final /* synthetic */ File $baseDir$inlined;
                {
                    this.$zipFile = zipFile2;
                    this.this$0 = k2JSDce;
                    this.$path$inlined = string2;
                    this.$baseDir$inlined = file2;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final InputFile invoke(ZipEntry entry) {
                    InputResource inputResource;
                    ZipEntry zipEntry = entry;
                    Intrinsics.checkNotNullExpressionValue((Object)zipEntry, (String)"entry");
                    String string2 = zipEntry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.name");
                    String moduleName = K2JSDce.access$getModuleNameFromPath(this.this$0, string2);
                    String pathToSourceMapCandidate = entry.getName() + ".map";
                    String pathToSourceMap = this.$zipFile.getEntry(pathToSourceMapCandidate) != null ? pathToSourceMapCandidate : null;
                    String string3 = entry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"entry.name");
                    InputResource inputResource2 = InputResource.Companion.zipFile(this.$path$inlined, string3);
                    String string4 = pathToSourceMap;
                    if (string4 != null) {
                        void it;
                        String string5 = string4;
                        boolean bl = false;
                        boolean bl2 = false;
                        String string6 = string5;
                        InputResource inputResource3 = inputResource2;
                        boolean bl3 = false;
                        InputResource inputResource4 = InputResource.Companion.zipFile(this.$path$inlined, (String)it);
                        inputResource2 = inputResource3;
                        inputResource = inputResource4;
                    } else {
                        inputResource = null;
                    }
                    String string7 = new File(this.$baseDir$inlined, moduleName + ".js").getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"File(baseDir, \"$moduleName.js\").absolutePath");
                    String string8 = moduleName;
                    String string9 = string7;
                    InputResource inputResource5 = inputResource;
                    InputResource inputResource6 = inputResource2;
                    return new InputFile(inputResource6, inputResource5, string9, string8);
                }
            })));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list2;
    }

    private final List<InputFile> collectInputFilesFromDirectory(File baseDir, String path2) {
        Sequence sequence2 = (Sequence)FilesKt.walkTopDown((File)new File(path2));
        boolean bl = false;
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)sequence2, (Function1)collectInputFilesFromDirectory.1.INSTANCE), (Function1)collectInputFilesFromDirectory.2.INSTANCE), (Function1)((Function1)new Function1<File, Boolean>(this){
            final /* synthetic */ K2JSDce this$0;

            public final boolean invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string2 = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.path");
                return new File(K2JSDce.access$metaJs(this.this$0, string2)).exists();
            }
            {
                this.this$0 = k2JSDce;
                super(1);
            }
        })), (Function1)((Function1)new Function1<File, InputFile>(this, baseDir){
            final /* synthetic */ K2JSDce this$0;
            final /* synthetic */ File $baseDir;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final InputFile invoke(@NotNull File entry) {
                InputResource inputResource;
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                String string2 = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.name");
                String moduleName = K2JSDce.access$getModuleNameFromPath(this.this$0, string2);
                String pathToSourceMapCandidate = entry.getPath() + ".map";
                String pathToSourceMap = new File(pathToSourceMapCandidate).exists() ? pathToSourceMapCandidate : null;
                String string3 = entry.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"entry.path");
                InputResource inputResource2 = InputResource.Companion.file(string3);
                String string4 = pathToSourceMap;
                if (string4 != null) {
                    void it;
                    String string5 = string4;
                    boolean bl = false;
                    boolean bl2 = false;
                    String string6 = string5;
                    InputResource inputResource3 = inputResource2;
                    boolean bl3 = false;
                    InputResource inputResource4 = InputResource.Companion.file((String)it);
                    inputResource2 = inputResource3;
                    inputResource = inputResource4;
                } else {
                    inputResource = null;
                }
                String string7 = new File(this.$baseDir, moduleName + ".js").getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"File(baseDir, \"$moduleName.js\").absolutePath");
                String string8 = moduleName;
                String string9 = string7;
                InputResource inputResource5 = inputResource;
                InputResource inputResource6 = inputResource2;
                return new InputFile(inputResource6, inputResource5, string9, string8);
            }
            {
                this.this$0 = k2JSDce;
                this.$baseDir = file2;
                super(1);
            }
        })));
    }

    private final String metaJs(String $this$metaJs) {
        return StringsKt.removeSuffix((String)$this$metaJs, (CharSequence)".js") + ".meta.js";
    }

    private final String getModuleNameFromPath(String path2) {
        int dotIndex = StringsKt.lastIndexOf$default((CharSequence)path2, (char)'.', (int)0, (boolean)false, (int)6, null);
        int n = StringsKt.lastIndexOf$default((CharSequence)path2, (char)'/', (int)0, (boolean)false, (int)6, null);
        int n2 = StringsKt.lastIndexOf$default((CharSequence)path2, (char)'\\', (int)0, (boolean)false, (int)6, null);
        int n3 = 0;
        int slashIndex = Math.max(n, n2);
        String string2 = path2;
        n2 = slashIndex + 1;
        n3 = dotIndex < 0 ? path2.length() : dotIndex;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n2, n3);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string4;
    }

    @Override
    @NotNull
    public String executableScriptFileName() {
        return "kotlin-dce-js";
    }

    public static final /* synthetic */ String access$metaJs(K2JSDce $this, String $this$access_u24metaJs) {
        return $this.metaJs($this$access_u24metaJs);
    }

    public static final /* synthetic */ String access$getModuleNameFromPath(K2JSDce $this, String path2) {
        return $this.getModuleNameFromPath(path2);
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/cli/js/dce/K2JSDce$Companion;", "", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "cli-js"})
    public static final class Companion {
        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            CLITool.Companion.doMain(new K2JSDce(), args);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

