/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.LowerKt;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrElementBuilder;
import org.jetbrains.kotlin.ir.builders.IrElementBuilderKt;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrPropertyBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.impl.IrConstructorImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrFunctionImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrValueParameterImpl;
import org.jetbrains.kotlin.ir.descriptors.WrappedReceiverParameterDescriptor;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOriginImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallWithIndexedArgumentsBase;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrInstanceInitializerCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnTargetSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrValueParameterSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0003\u0010\u0011\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "nothingType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "stringType", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "CallableReferenceBuilder", "Companion", "ReferenceTransformer", "backend.js"})
public final class CallableReferenceLowering
implements BodyLoweringPass {
    private final IrType nothingType;
    private final IrType stringType;
    private final CommonBackendContext context;
    @NotNull
    private static final Name THIS_NAME;
    @NotNull
    private static final Name BOUND_RECEIVER_NAME;
    public static final Companion Companion;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        LowerKt.runOnFilePostfix$default(this, irFile, true, false, 4, null);
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        IrDeclarationParent irDeclarationParent;
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        IrDeclaration irDeclaration2 = container;
        if (!(irDeclaration2 instanceof IrDeclarationParent)) {
            irDeclaration2 = null;
        }
        if ((irDeclarationParent = (IrDeclarationParent)((Object)irDeclaration2)) == null) {
            irDeclarationParent = container.getParent();
        }
        IrDeclarationParent realContainer = irDeclarationParent;
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new ReferenceTransformer(realContainer));
    }

    public CallableReferenceLowering(@NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.nothingType = this.context.getIrBuiltIns().getNothingType();
        this.stringType = this.context.getIrBuiltIns().getStringType();
    }

    static {
        Companion = new Companion(null);
        Name name2 = Name.special("<this>");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"Name.special(\"<this>\")");
        THIS_NAME = name2;
        Name name3 = Name.identifier("$boundThis");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"Name.identifier(\"\\$boundThis\")");
        BOUND_RECEIVER_NAME = name3;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J$\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u000eH\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$ReferenceTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;)V", "buildFunctionReference", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "buildLambdaReference", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "visitBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "body", "visitFunctionExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "visitFunctionReference", "backend.js"})
    private final class ReferenceTransformer
    extends IrElementTransformerVoid {
        private final IrDeclarationParent container;

        @Override
        @NotNull
        public IrBody visitBody(@NotNull IrBody body2) {
            Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
            return body2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public IrExpression visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
            void clazz;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            IrSimpleFunction function2 = expression2.getFunction();
            Object object = this.buildLambdaReference(function2, expression2);
            IrClass irClass2 = (IrClass)object.component1();
            IrConstructor ctor = (IrConstructor)object.component2();
            clazz.setParent(this.container);
            object = expression2;
            boolean bl = false;
            boolean bl2 = false;
            Object $this$run = object;
            boolean bl3 = false;
            int vpCount = function2.isSuspend() ? 1 : 0;
            IrConstructorCallImpl irConstructorCallImpl = new IrConstructorCallImpl($this$run.getStartOffset(), $this$run.getEndOffset(), $this$run.getType(), (IrConstructorSymbol)ctor.getSymbol(), 0, 0, vpCount, Companion.CALLABLE_REFERENCE_CREATE.INSTANCE);
            boolean bl4 = false;
            boolean bl5 = false;
            IrConstructorCallImpl $this$apply = irConstructorCallImpl;
            boolean bl6 = false;
            if (function2.isSuspend()) {
                $this$apply.putValueArgument(0, IrConstImpl.Companion.constNull($this$apply.getStartOffset(), $this$apply.getEndOffset(), CallableReferenceLowering.this.context.getIrBuiltIns().getNothingNType()));
            }
            IrConstructorCallImpl ctorCall = irConstructorCallImpl;
            return new IrCompositeImpl($this$run.getStartOffset(), $this$run.getEndOffset(), $this$run.getType(), $this$run.getOrigin(), CollectionsKt.listOf((Object[])new IrElement[]{(IrElement)clazz, ctorCall}));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
            void clazz;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            Object object = this.buildFunctionReference(expression2);
            IrClass irClass2 = (IrClass)object.component1();
            IrConstructor ctor = (IrConstructor)object.component2();
            clazz.setParent(this.container);
            object = expression2;
            boolean bl = false;
            boolean bl2 = false;
            Object $this$run = object;
            boolean bl3 = false;
            IrFunctionReference irFunctionReference = expression2;
            boolean bl4 = false;
            boolean bl5 = false;
            IrFunctionReference $this$run2 = irFunctionReference;
            boolean bl6 = false;
            IrExpression irExpression = $this$run2.getDispatchReceiver();
            if (irExpression == null) {
                irExpression = $this$run2.getExtensionReceiver();
            }
            IrExpression boundReceiver = irExpression;
            int vpCount = boundReceiver != null ? 1 : 0;
            IrConstructorCallImpl irConstructorCallImpl = new IrConstructorCallImpl($this$run.getStartOffset(), $this$run.getEndOffset(), $this$run.getType(), (IrConstructorSymbol)ctor.getSymbol(), 0, 0, vpCount, Companion.CALLABLE_REFERENCE_CREATE.INSTANCE);
            boolean bl7 = false;
            boolean bl8 = false;
            IrConstructorCallImpl $this$apply = irConstructorCallImpl;
            boolean bl9 = false;
            IrExpression irExpression2 = boundReceiver;
            if (irExpression2 != null) {
                IrExpression irExpression3 = irExpression2;
                boolean bl10 = false;
                boolean bl11 = false;
                IrExpression it = irExpression3;
                boolean bl12 = false;
                $this$apply.putValueArgument(0, it);
            }
            IrConstructorCallImpl ctorCall = irConstructorCallImpl;
            return new IrCompositeImpl($this$run.getStartOffset(), $this$run.getEndOffset(), $this$run.getType(), $this$run.getOrigin(), CollectionsKt.listOf((Object[])new IrElement[]{(IrElement)clazz, ctorCall}));
        }

        private final Pair<IrClass, IrConstructor> buildFunctionReference(IrFunctionReference expression2) {
            return new CallableReferenceBuilder(((IrFunctionSymbol)expression2.getSymbol()).getOwner(), expression2, false).build();
        }

        private final Pair<IrClass, IrConstructor> buildLambdaReference(IrSimpleFunction function2, IrFunctionExpression expression2) {
            return new CallableReferenceBuilder(function2, expression2, true).build();
        }

        public ReferenceTransformer(IrDeclarationParent container) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            this.container = container;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00130\u0012J\b\u0010\u0014\u001a\u00020\u0010H\u0002J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\f\u0010\u001f\u001a\u00020 *\u00020\u0018H\u0002J\f\u0010!\u001a\u00020\"*\u00020\u0010H\u0002J\f\u0010#\u001a\u00020\u001a*\u00020\u0018H\u0002J\f\u0010$\u001a\u00020\u001a*\u00020\u0018H\u0002J\f\u0010%\u001a\u00020\u001a*\u00020\u0010H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$CallableReferenceBuilder;", "", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "isLambda", "", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;Z)V", "boundReceiverField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "isKReference", "isSuspendLambda", "superClass", "Lorg/jetbrains/kotlin/ir/types/IrType;", "superFunctionInterface", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "build", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "buildReferenceClass", "createConstructor", "clazz", "createInvokeMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "createNameProperty", "", "getValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "d", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "buildInvoke", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "createDispatchReceiver", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "createFunctionReferenceInvokeMethod", "createLambdaInvokeMethod", "createReceiverField", "backend.js"})
    private final class CallableReferenceBuilder {
        private final boolean isSuspendLambda;
        private final IrType superClass;
        private IrField boundReceiverField;
        private final IrClass superFunctionInterface;
        private final boolean isKReference;
        private final IrFunction function;
        private final IrExpression reference;
        private final boolean isLambda;

        private final IrClass buildReferenceClass() {
            boolean $i$f$buildClass = false;
            IrClassBuilder irClassBuilder = new IrClassBuilder();
            boolean bl = false;
            boolean bl2 = false;
            IrClassBuilder $this$run$iv = irClassBuilder;
            boolean bl3 = false;
            IrClassBuilder $this$buildClass = $this$run$iv;
            boolean bl4 = false;
            IrElementBuilderKt.setSourceRange($this$buildClass, this.reference);
            Visibility visibility = Visibilities.LOCAL;
            Intrinsics.checkNotNullExpressionValue((Object)visibility, (String)"Visibilities.LOCAL");
            $this$buildClass.setVisibility(visibility);
            $this$buildClass.setOrigin(this.isKReference || !this.isLambda ? (IrDeclarationOriginImpl)Companion.FUNCTION_REFERENCE_IMPL.INSTANCE : (IrDeclarationOriginImpl)Companion.LAMBDA_IMPL.INSTANCE);
            Name name2 = SpecialNames.NO_NAME_PROVIDED;
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"SpecialNames.NO_NAME_PROVIDED");
            $this$buildClass.setName(name2);
            IrClass irClass2 = DeclarationBuildersKt.buildClass($this$run$iv);
            boolean bl5 = false;
            bl = false;
            IrClass $this$apply = irClass2;
            boolean bl6 = false;
            $this$apply.setSuperTypes(CollectionsKt.listOf((Object[])new IrType[]{this.superClass, this.reference.getType()}));
            org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor($this$apply);
            this.createReceiverField($this$apply);
            return irClass2;
        }

        private final void createReceiverField(IrClass $this$createReceiverField) {
            IrExpression boundReceiver;
            IrFunctionReference funRef;
            if (this.isLambda) {
                return;
            }
            IrExpression irExpression = this.reference;
            if (irExpression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionReference");
            }
            IrFunctionReference irFunctionReference = funRef = (IrFunctionReference)irExpression;
            boolean bl = false;
            boolean bl2 = false;
            IrFunctionReference $this$run = irFunctionReference;
            boolean bl3 = false;
            IrExpression irExpression2 = $this$run.getDispatchReceiver();
            if (irExpression2 == null) {
                irExpression2 = boundReceiver = $this$run.getExtensionReceiver();
            }
            if (boundReceiver != null) {
                this.boundReceiverField = DeclarationBuildersKt.addField$default($this$createReceiverField, Companion.getBOUND_RECEIVER_NAME(), boundReceiver.getType(), null, 4, null);
            }
        }

        private final IrValueParameter createDispatchReceiver(IrClass $this$createDispatchReceiver) {
            WrappedReceiverParameterDescriptor vpDescriptor = new WrappedReceiverParameterDescriptor(null, null, 3, null);
            IrValueParameterSymbolImpl vpSymbol = new IrValueParameterSymbolImpl(vpDescriptor);
            IrValueParameterImpl declaration2 = new IrValueParameterImpl($this$createDispatchReceiver.getStartOffset(), $this$createDispatchReceiver.getEndOffset(), $this$createDispatchReceiver.getOrigin(), vpSymbol, Companion.getTHIS_NAME(), -1, IrUtilsKt.getDefaultType($this$createDispatchReceiver), null, false, false);
            vpDescriptor.bind((IrDeclaration)declaration2);
            return declaration2;
        }

        /*
         * WARNING - void declaration
         */
        private final IrConstructor createConstructor(IrClass clazz) {
            void $this$irBlockBody;
            void startOffset$iv;
            void $this$irBlockBody$iv;
            Unit unit;
            Object $this$run$iv;
            IrValueParameter irValueParameter;
            boolean bl;
            Object $this$addValueParameter3;
            boolean $i$f$addValueParameter;
            IrClass $this$addConstructor$iv = clazz;
            boolean $i$f$addConstructor = false;
            boolean $i$f$buildConstructor = false;
            IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
            boolean bl2 = false;
            boolean bl3 = false;
            IrFunctionBuilder $this$run$iv$iv = irFunctionBuilder;
            boolean bl4 = false;
            IrFunctionBuilder $this$buildConstructor$iv = $this$run$iv$iv;
            boolean bl5 = false;
            IrFunctionBuilder $this$addConstructor = $this$buildConstructor$iv;
            boolean bl6 = false;
            $this$addConstructor.setOrigin(Companion.GENERATED_MEMBER_IN_CALLABLE_REFERENCE.INSTANCE);
            $this$addConstructor.setReturnType(IrUtilsKt.getDefaultType(clazz));
            $this$addConstructor.setPrimary(true);
            $this$buildConstructor$iv.setReturnType(IrUtilsKt.getDefaultType($this$addConstructor$iv));
            IrConstructorImpl irConstructorImpl = DeclarationBuildersKt.buildConstructor($this$run$iv$iv);
            boolean bl7 = false;
            bl2 = false;
            IrConstructorImpl constructor$iv = irConstructorImpl;
            boolean bl8 = false;
            $this$addConstructor$iv.getDeclarations().add(constructor$iv);
            constructor$iv.setParent($this$addConstructor$iv);
            IrConstructorImpl irConstructorImpl2 = irConstructorImpl;
            boolean bl9 = false;
            boolean bl10 = false;
            IrConstructorImpl $this$apply = irConstructorImpl2;
            boolean bl11 = false;
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(this.superClass);
            Intrinsics.checkNotNull((Object)irClassSymbol);
            Iterable $this$single$iv = ((IrClass)irClassSymbol.getOwner()).getDeclarations();
            boolean $i$f$single2 = false;
            Object single$iv2 = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrDeclaration it = (IrDeclaration)element$iv;
                boolean bl12 = false;
                if (!(it instanceof IrConstructor && ((IrConstructor)it).isPrimary())) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv2 = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Object v1 = single$iv2;
            if (v1 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrConstructor");
            }
            IrConstructor superConstructor = v1;
            IrField irField = this.boundReceiverField;
            if (irField != null) {
                IrField $i$f$single2 = irField;
                boolean single$iv2 = false;
                found$iv = false;
                IrField it = $i$f$single2;
                boolean bl13 = false;
                IrFunction $this$addValueParameter$iv2 = $this$apply;
                $i$f$addValueParameter = false;
                IrValueParameterBuilder irValueParameterBuilder = new IrValueParameterBuilder();
                boolean bl14 = false;
                boolean bl15 = false;
                IrValueParameterBuilder $this$run$iv2 = irValueParameterBuilder;
                boolean bl16 = false;
                $this$addValueParameter3 = $this$run$iv2;
                boolean bl17 = false;
                ((IrDeclarationBuilder)$this$addValueParameter3).setName(Companion.getBOUND_RECEIVER_NAME());
                ((IrValueParameterBuilder)$this$addValueParameter3).setType(it.getType());
                ((IrValueParameterBuilder)$this$addValueParameter3).setIndex(0);
                if ($this$run$iv2.getIndex() == -1) {
                    $this$run$iv2.setIndex($this$addValueParameter$iv2.getValueParameters().size());
                }
                IrValueParameter irValueParameter2 = DeclarationBuildersKt.build($this$run$iv2);
                boolean bl18 = false;
                bl = false;
                IrValueParameter valueParameter$iv = irValueParameter2;
                boolean bl19 = false;
                IrFunction irFunction = $this$addValueParameter$iv2;
                irFunction.setValueParameters(CollectionsKt.plus((Collection)irFunction.getValueParameters(), (Object)valueParameter$iv));
                valueParameter$iv.setParent($this$addValueParameter$iv2);
                irValueParameter = irValueParameter2;
            } else {
                irValueParameter = null;
            }
            IrValueParameter boundReceiverParameter = irValueParameter;
            IrValueParameter continuation2 = null;
            if (this.isSuspendLambda) {
                IrValueParameter superContinuation = (IrValueParameter)CollectionsKt.single(superConstructor.getValueParameters());
                IrFunction $this$addValueParameter$iv = $this$apply;
                boolean $i$f$addValueParameter2 = false;
                IrValueParameterBuilder bl13 = new IrValueParameterBuilder();
                boolean $this$addValueParameter$iv2 = false;
                $i$f$addValueParameter = false;
                $this$run$iv = bl13;
                boolean bl20 = false;
                IrValueParameterBuilder $this$addValueParameter2 = $this$run$iv;
                boolean bl21 = false;
                $this$addValueParameter2.setName(superContinuation.getName());
                $this$addValueParameter2.setType(superContinuation.getType());
                $this$addValueParameter2.setIndex(boundReceiverParameter == null ? 0 : 1);
                unit = Unit.INSTANCE;
                if (((IrValueParameterBuilder)$this$run$iv).getIndex() == -1) {
                    ((IrValueParameterBuilder)$this$run$iv).setIndex($this$addValueParameter$iv.getValueParameters().size());
                }
                IrValueParameter irValueParameter3 = DeclarationBuildersKt.build((IrValueParameterBuilder)$this$run$iv);
                boolean $this$addValueParameter3 = false;
                boolean bl22 = false;
                IrValueParameter valueParameter$iv = irValueParameter3;
                boolean bl23 = false;
                IrFunction irFunction = $this$addValueParameter$iv;
                irFunction.setValueParameters(CollectionsKt.plus((Collection)irFunction.getValueParameters(), (Object)valueParameter$iv));
                valueParameter$iv.setParent($this$addValueParameter$iv);
                continuation2 = irValueParameter3;
            }
            IrBuilderWithScope superContinuation = LowerUtilsKt.createIrBuilder$default(CallableReferenceLowering.this.context, $this$apply.getSymbol(), 0, 0, 6, null);
            int $this$addValueParameter$iv = $this$apply.getStartOffset();
            int endOffset$iv = $this$apply.getEndOffset();
            boolean $i$f$irBlockBody = false;
            IrBlockBodyBuilder this_$iv$iv = new IrBlockBodyBuilder($this$irBlockBody$iv.getContext(), $this$irBlockBody$iv.getScope(), (int)startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            $this$run$iv = this_$iv$iv;
            IrConstructorImpl irConstructorImpl3 = $this$apply;
            boolean bl24 = false;
            IrStatement irStatement = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$irBlockBody, superConstructor);
            boolean bl25 = false;
            boolean bl26 = false;
            $this$addValueParameter3 = irStatement;
            void var22_54 = $this$irBlockBody;
            boolean bl27 = false;
            IrValueParameter irValueParameter4 = continuation2;
            if (irValueParameter4 != null) {
                void $this$apply2;
                IrValueParameter irValueParameter5 = irValueParameter4;
                bl = false;
                boolean bl28 = false;
                IrValueParameter it = irValueParameter5;
                boolean bl29 = false;
                $this$apply2.putValueArgument(0, this.getValue(it));
            }
            Unit unit2 = Unit.INSTANCE;
            var22_54.unaryPlus(irStatement);
            IrValueParameter irValueParameter6 = boundReceiverParameter;
            if (irValueParameter6 != null) {
                irStatement = irValueParameter6;
                bl25 = false;
                bl26 = false;
                IrStatement it = irStatement;
                boolean bl30 = false;
                IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$irBlockBody;
                IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$irBlockBody;
                IrValueParameter irValueParameter7 = clazz.getThisReceiver();
                Intrinsics.checkNotNull((Object)irValueParameter7);
                IrExpression irExpression = ExpressionHelpersKt.irGet(irBuilderWithScope2, irValueParameter7);
                IrField irField2 = this.boundReceiverField;
                Intrinsics.checkNotNull((Object)irField2);
                $this$irBlockBody.unaryPlus(ExpressionHelpersKt.irSetField(irBuilderWithScope, irExpression, irField2, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$irBlockBody, (IrValueDeclaration)it)));
            }
            $this$irBlockBody.unaryPlus(new IrInstanceInitializerCallImpl($this$irBlockBody.getStartOffset(), $this$irBlockBody.getEndOffset(), (IrClassSymbol)clazz.getSymbol(), $this$irBlockBody.getContext().getIrBuiltIns().getUnitType()));
            unit = Unit.INSTANCE;
            irConstructorImpl3.setBody(this_$iv$iv.doBuild());
            return irConstructorImpl2;
        }

        /*
         * WARNING - void declaration
         */
        private final IrSimpleFunction createInvokeMethod(IrClass clazz) {
            void it;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = this.superFunctionInterface.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List superMethods = (List)destination$iv$iv;
            Iterable $this$single$iv = superMethods;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv322 = false;
            for (Object element$iv : $this$single$iv) {
                IrSimpleFunction it2 = (IrSimpleFunction)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it2.getName().asString(), (Object)"invoke")) continue;
                if (found$iv322) {
                    throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv322 = true;
            }
            if (!found$iv322) {
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            IrSimpleFunction superMethod = single$iv;
            IrDeclarationContainer $this$addFunction$iv = clazz;
            boolean $i$f$addFunction = false;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder found$iv322 = new IrFunctionBuilder();
            boolean bl = false;
            boolean element$iv = false;
            IrFunctionBuilder $this$run$iv$iv = found$iv322;
            boolean bl2 = false;
            Object $this$addFunction = $this$run$iv$iv;
            boolean bl3 = false;
            IrElementBuilderKt.setSourceRange((IrElementBuilder)$this$addFunction, this.isLambda ? (IrStatement)this.function : (IrStatement)this.reference);
            ((IrDeclarationBuilder)$this$addFunction).setName(superMethod.getName());
            ((IrFunctionBuilder)$this$addFunction).setReturnType(this.function.getReturnType());
            ((IrFunctionBuilder)$this$addFunction).setSuspend(superMethod.isSuspend());
            ((IrFunctionBuilder)$this$addFunction).setOperator(superMethod.isOperator());
            IrFunctionImpl irFunctionImpl = DeclarationBuildersKt.buildFun$default($this$run$iv$iv, null, 1, null);
            boolean found$iv322 = false;
            bl = false;
            IrFunctionImpl function$iv = irFunctionImpl;
            boolean bl4 = false;
            $this$addFunction$iv.getDeclarations().add(function$iv);
            function$iv.setParent($this$addFunction$iv);
            IrFunctionImpl irFunctionImpl2 = irFunctionImpl;
            boolean bl5 = false;
            boolean bl6 = false;
            IrFunctionImpl $this$apply = irFunctionImpl2;
            boolean bl7 = false;
            $this$apply.setOverriddenSymbols(CollectionsKt.listOf((Object)superMethod.getSymbol()));
            IrValueParameter irValueParameter = this.createDispatchReceiver(clazz);
            boolean bl8 = false;
            boolean bl9 = false;
            $this$addFunction = irValueParameter;
            IrFunctionImpl irFunctionImpl3 = $this$apply;
            boolean bl10 = false;
            it.setParent($this$apply);
            Unit unit = Unit.INSTANCE;
            irFunctionImpl3.setDispatchReceiverParameter(irValueParameter);
            if (this.isLambda) {
                this.createLambdaInvokeMethod($this$apply);
            } else {
                this.createFunctionReferenceInvokeMethod($this$apply);
            }
            return irFunctionImpl2;
        }

        /*
         * WARNING - void declaration
         */
        private final void createLambdaInvokeMethod(IrSimpleFunction $this$createLambdaInvokeMethod) {
            void $this$associateTo$iv$iv;
            $this$createLambdaInvokeMethod.setAnnotations(this.function.getAnnotations());
            Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)IrUtilsKt.getExplicitParameters(this.function));
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                void index2;
                Map map2 = destination$iv$iv;
                IndexedValue $dstr$index$param = (IndexedValue)element$iv$iv;
                boolean bl = false;
                int n = $dstr$index$param.component1();
                IrValueParameter param = (IrValueParameter)$dstr$index$param.component2();
                Pair pair = TuplesKt.to((Object)param, (Object)org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(param, $this$createLambdaInvokeMethod, null, (int)index2, 0, 0, null, null, null, null, null, false, false, 4090, null));
                boolean bl2 = false;
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map valueParameterMap = destination$iv$iv;
            $this$createLambdaInvokeMethod.setValueParameters(CollectionsKt.toList((Iterable)valueParameterMap.values()));
            $this$createLambdaInvokeMethod.setBody(IrInlineUtilsKt.moveBodyTo(this.function, $this$createLambdaInvokeMethod, valueParameterMap));
        }

        @NotNull
        public final IrGetValue getValue(@NotNull IrValueDeclaration d) {
            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
            return new IrGetValueImpl(-1, -1, d.getType(), d.getSymbol(), Companion.CALLABLE_REFERENCE_INVOKE.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        private final IrFunctionAccessExpression buildInvoke(IrSimpleFunction $this$buildInvoke) {
            IrFunctionReference funRef;
            IrFunction callee = this.function;
            IrExpression irExpression = this.reference;
            boolean bl = false;
            boolean bl2 = false;
            IrExpression $this$run322 = irExpression;
            boolean bl3 = false;
            IrMemberAccessExpression irCall = callee instanceof IrConstructor ? (IrMemberAccessExpression)new IrConstructorCallImpl($this$run322.getStartOffset(), $this$run322.getEndOffset(), (IrType)IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(callee)), (IrConstructorSymbol)((IrConstructor)callee).getSymbol(), callee.getTypeParameters().size(), 0, callee.getValueParameters().size(), Companion.CALLABLE_REFERENCE_INVOKE.INSTANCE) : (IrMemberAccessExpression)new IrCallImpl($this$run322.getStartOffset(), $this$run322.getEndOffset(), callee.getReturnType(), callee.getSymbol(), callee.getTypeParameters().size(), callee.getValueParameters().size(), Companion.CALLABLE_REFERENCE_INVOKE.INSTANCE, null, 128, null);
            IrExpression irExpression2 = this.reference;
            if (irExpression2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionReference");
            }
            IrFunctionReference irFunctionReference = funRef = (IrFunctionReference)irExpression2;
            boolean $this$run322 = false;
            bl3 = false;
            IrFunctionReference $this$run22 = irFunctionReference;
            boolean bl4 = false;
            IrExpression irExpression3 = $this$run22.getDispatchReceiver();
            if (irExpression3 == null) {
                irExpression3 = $this$run22.getExtensionReceiver();
            }
            boolean boundReceiver = irExpression3 != null;
            IrFunction $this$run322 = callee;
            bl3 = false;
            int $this$run22 = 0;
            IrFunction $this$run42 = $this$run322;
            boolean bl5 = false;
            IrValueParameter irValueParameter = $this$run42.getDispatchReceiverParameter();
            if (irValueParameter == null) {
                irValueParameter = $this$run42.getExtensionReceiverParameter();
            }
            boolean hasReceiver = irValueParameter != null;
            ((IrCallWithIndexedArgumentsBase)irCall).setDispatchReceiver(funRef.getDispatchReceiver());
            ((IrCallWithIndexedArgumentsBase)irCall).setExtensionReceiver(funRef.getExtensionReceiver());
            int i = 0;
            List<IrValueParameter> valueParameters2 = $this$buildInvoke.getValueParameters();
            $this$run22 = 0;
            int $this$run42 = funRef.getTypeArgumentsCount();
            while ($this$run22 < $this$run42) {
                void ti;
                ((IrCallWithIndexedArgumentsBase)irCall).putTypeArgument((int)ti, funRef.getTypeArgument((int)ti));
                ++ti;
            }
            if (hasReceiver) {
                if (!boundReceiver) {
                    if (callee.getDispatchReceiverParameter() != null) {
                        ((IrCallWithIndexedArgumentsBase)irCall).setDispatchReceiver(this.getValue(valueParameters2.get(i++)));
                    }
                    if (callee.getExtensionReceiverParameter() != null) {
                        ((IrCallWithIndexedArgumentsBase)irCall).setExtensionReceiver(this.getValue(valueParameters2.get(i++)));
                    }
                } else {
                    IrField boundReceiverField = this.boundReceiverField;
                    if (boundReceiverField != null) {
                        IrValueParameter irValueParameter2 = $this$buildInvoke.getDispatchReceiverParameter();
                        Intrinsics.checkNotNull((Object)irValueParameter2);
                        IrGetValue thisValue = this.getValue(irValueParameter2);
                        IrGetFieldImpl value2 = new IrGetFieldImpl(-1, -1, (IrFieldSymbol)boundReceiverField.getSymbol(), boundReceiverField.getType(), thisValue, Companion.CALLABLE_REFERENCE_INVOKE.INSTANCE, null, 64, null);
                        if (funRef.getDispatchReceiver() != null) {
                            ((IrCallWithIndexedArgumentsBase)irCall).setDispatchReceiver(value2);
                        }
                        if (funRef.getExtensionReceiver() != null) {
                            ((IrCallWithIndexedArgumentsBase)irCall).setExtensionReceiver(value2);
                        }
                    }
                    if (callee.getDispatchReceiverParameter() != null && funRef.getDispatchReceiver() == null) {
                        ((IrCallWithIndexedArgumentsBase)irCall).setDispatchReceiver(this.getValue(valueParameters2.get(i++)));
                    }
                    if (callee.getExtensionReceiverParameter() != null && funRef.getExtensionReceiver() == null) {
                        ((IrCallWithIndexedArgumentsBase)irCall).setExtensionReceiver(this.getValue(valueParameters2.get(i++)));
                    }
                }
            }
            int j = 0;
            while (i < valueParameters2.size()) {
                ((IrCallWithIndexedArgumentsBase)irCall).putValueArgument(j++, this.getValue(valueParameters2.get(i++)));
            }
            return (IrFunctionAccessExpression)irCall;
        }

        /*
         * WARNING - void declaration
         */
        private final void createFunctionReferenceInvokeMethod(IrSimpleFunction $this$createFunctionReferenceInvokeMethod) {
            void $this$run;
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            Object object;
            Object object2;
            void $this$mapTo$iv$iv;
            IrType irType = this.reference.getType();
            if (irType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            }
            Iterable $this$map$iv = ((IrSimpleType)irType).getArguments();
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl = false;
                void v1 = it;
                if (v1 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrTypeProjection");
                }
                object = ((IrTypeProjection)v1).getType();
                object2.add(object);
            }
            List parameterTypes = (List)destination$iv$iv;
            List argumentTypes2 = CollectionsKt.dropLast((List)parameterTypes, (int)1);
            Iterable $i$f$map22 = argumentTypes2;
            object2 = $this$createFunctionReferenceInvokeMethod;
            boolean $i$f$mapIndexed = false;
            destination$iv$iv = $this$mapIndexed$iv;
            Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void t;
                void i;
                int n = index$iv$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrType irType2 = (IrType)item$iv$iv;
                int n2 = n;
                object = destination$iv$iv2;
                boolean bl2 = false;
                boolean $i$f$buildValueParameter = false;
                IrValueParameterBuilder irValueParameterBuilder = new IrValueParameterBuilder();
                boolean bl3 = false;
                boolean bl4 = false;
                IrValueParameterBuilder $this$run$iv = irValueParameterBuilder;
                boolean bl5 = false;
                IrValueParameterBuilder $this$buildValueParameter = $this$run$iv;
                boolean bl6 = false;
                Name name2 = Name.identifier("" + 'p' + (int)i);
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"Name.identifier(\"p$i\")");
                $this$buildValueParameter.setName(name2);
                $this$buildValueParameter.setType((IrType)t);
                $this$buildValueParameter.setIndex((int)i);
                IrValueParameter irValueParameter = DeclarationBuildersKt.build($this$run$iv);
                boolean bl7 = false;
                bl3 = false;
                IrValueParameter it = irValueParameter;
                boolean bl8 = false;
                it.setParent($this$createFunctionReferenceInvokeMethod);
                IrValueParameter irValueParameter2 = irValueParameter;
                object.add(irValueParameter2);
            }
            object = (List)destination$iv$iv2;
            object2.setValueParameters((List<? extends IrValueParameter>)object);
            IrExpression irExpression = this.reference;
            boolean bl = false;
            boolean bl9 = false;
            destination$iv$iv2 = irExpression;
            int n = this.reference.getEndOffset();
            int n3 = this.reference.getStartOffset();
            object2 = $this$createFunctionReferenceInvokeMethod;
            boolean bl10 = false;
            IrReturnImpl irReturnImpl = new IrReturnImpl($this$run.getStartOffset(), $this$run.getEndOffset(), CallableReferenceLowering.this.nothingType, $this$createFunctionReferenceInvokeMethod.getSymbol(), this.buildInvoke($this$createFunctionReferenceInvokeMethod));
            List list2 = CollectionsKt.listOf((Object)irReturnImpl);
            int n4 = n;
            int n5 = n3;
            object2.setBody(new IrBlockBodyImpl(n5, n4, list2));
        }

        /*
         * WARNING - void declaration
         */
        private final void createNameProperty(IrClass clazz) {
            void it;
            void $this$buildValueParameter;
            IrSimpleFunction getter2;
            IrProperty nameProperty;
            Object element$iv$iv322;
            void $this$filterIsInstanceTo$iv$iv2;
            if (!this.isKReference) {
                return;
            }
            Iterable $this$filterIsInstance$iv = this.superFunctionInterface.getDeclarations();
            boolean $i$f$filterIsInstance2 = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv322 : $this$filterIsInstanceTo$iv$iv2) {
                if (!(element$iv$iv322 instanceof IrProperty)) continue;
                destination$iv$iv.add(element$iv$iv322);
            }
            IrProperty superProperty = (IrProperty)CollectionsKt.single((List)((List)destination$iv$iv));
            IrSimpleFunction irSimpleFunction = superProperty.getGetter();
            if (irSimpleFunction == null) {
                String $i$f$filterIsInstance2 = "Expected getter for KFunction.name property";
                boolean $this$filterIsInstanceTo$iv$iv2 = false;
                throw (Throwable)new IllegalStateException($i$f$filterIsInstance2.toString());
            }
            IrSimpleFunction supperGetter = irSimpleFunction;
            IrDeclarationContainer $this$addProperty$iv = clazz;
            PropertyDescriptor originalDescriptor$iv = null;
            boolean $i$f$addProperty = false;
            boolean $i$f$buildProperty = false;
            element$iv$iv322 = new IrPropertyBuilder();
            boolean bl = false;
            boolean bl2 = false;
            Object $this$run$iv$iv = element$iv$iv322;
            boolean bl3 = false;
            Object $this$addProperty = $this$run$iv$iv;
            boolean bl4 = false;
            ((IrDeclarationBuilder)$this$addProperty).setVisibility(superProperty.getVisibility());
            ((IrDeclarationBuilder)$this$addProperty).setName(superProperty.getName());
            ((IrDeclarationBuilder)$this$addProperty).setOrigin(Companion.GENERATED_MEMBER_IN_CALLABLE_REFERENCE.INSTANCE);
            Object object = DeclarationBuildersKt.buildProperty((IrPropertyBuilder)$this$run$iv$iv, originalDescriptor$iv);
            boolean element$iv$iv322 = false;
            bl = false;
            IrProperty property$iv = object;
            boolean bl5 = false;
            $this$addProperty$iv.getDeclarations().add(property$iv);
            property$iv.setParent($this$addProperty$iv);
            IrProperty $this$addGetter$iv = nameProperty = object;
            boolean $i$f$addGetter = false;
            object = new IrFunctionBuilder();
            element$iv$iv322 = false;
            bl = false;
            Object $this$run$iv = object;
            boolean $i$a$-run-DeclarationBuildersKt$addGetter$2$iv22 = false;
            Name name2 = Name.special("<get-" + $this$addGetter$iv.getName() + '>');
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"Name.special(\"<get-${this@addGetter.name}>\")");
            ((IrDeclarationBuilder)$this$run$iv).setName(name2);
            Object $this$addGetter = $this$run$iv;
            boolean bl6 = false;
            ((IrFunctionBuilder)$this$addGetter).setReturnType(CallableReferenceLowering.this.stringType);
            IrFunctionImpl irFunctionImpl = DeclarationBuildersKt.buildFun$default((IrFunctionBuilder)$this$run$iv, null, 1, null);
            boolean bl7 = false;
            boolean bl8 = false;
            IrFunctionImpl getter$iv = irFunctionImpl;
            boolean bl9 = false;
            $this$addGetter$iv.setGetter(getter$iv);
            getter$iv.setCorrespondingPropertySymbol($this$addGetter$iv.getSymbol());
            getter$iv.setParent($this$addGetter$iv.getParent());
            IrSimpleFunction irSimpleFunction2 = getter2 = (IrSimpleFunction)irFunctionImpl;
            irSimpleFunction2.setOverriddenSymbols(CollectionsKt.plus((Collection)irSimpleFunction2.getOverriddenSymbols(), (Object)supperGetter.getSymbol()));
            boolean $i$f$buildValueParameter = false;
            IrValueParameterBuilder irValueParameterBuilder = new IrValueParameterBuilder();
            boolean bl10 = false;
            element$iv$iv322 = false;
            IrValueParameterBuilder $this$run$iv2 = irValueParameterBuilder;
            boolean bl11 = false;
            IrValueParameterBuilder $i$a$-run-DeclarationBuildersKt$addGetter$2$iv22 = $this$run$iv2;
            IrSimpleFunction irSimpleFunction3 = getter2;
            boolean bl12 = false;
            $this$buildValueParameter.setName(Companion.getTHIS_NAME());
            $this$buildValueParameter.setType(IrUtilsKt.getDefaultType(clazz));
            Unit unit = Unit.INSTANCE;
            IrValueParameter irValueParameter = DeclarationBuildersKt.build($this$run$iv2);
            boolean bl13 = false;
            bl10 = false;
            IrValueParameter element$iv$iv322 = irValueParameter;
            boolean bl14 = false;
            it.setParent(getter2);
            unit = Unit.INSTANCE;
            irSimpleFunction3.setDispatchReceiverParameter(irValueParameter);
            IrType irType = CallableReferenceLowering.this.nothingType;
            IrReturnTargetSymbol irReturnTargetSymbol = getter2.getSymbol();
            IrType irType2 = CallableReferenceLowering.this.stringType;
            String string2 = this.function.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"function.name.asString()");
            getter2.setBody(new IrBlockBodyImpl(-1, -1, CollectionsKt.listOf((Object)new IrReturnImpl(-1, -1, irType, irReturnTargetSymbol, IrConstImpl.Companion.string(-1, -1, irType2, string2)))));
            CallableReferenceLowering.this.context.getMapping().getReflectedNameAccessor().set((IrClass)((IrDeclaration)clazz), getter2);
        }

        @NotNull
        public final Pair<IrClass, IrConstructor> build() {
            IrClass clazz = this.buildReferenceClass();
            IrConstructor ctor = this.createConstructor(clazz);
            IrSimpleFunction invoke2 = this.createInvokeMethod(clazz);
            this.createNameProperty(clazz);
            return new Pair((Object)clazz, (Object)ctor);
        }

        public CallableReferenceBuilder(@NotNull IrFunction function2, IrExpression reference, boolean isLambda) {
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            this.function = function2;
            this.reference = reference;
            this.isLambda = isLambda;
            this.isSuspendLambda = this.isLambda && AdditionalIrUtilsKt.isSuspend(this.function);
            this.superClass = this.isSuspendLambda ? (IrType)IrUtilsKt.getDefaultType((IrClass)CallableReferenceLowering.this.context.getIr().getSymbols().getCoroutineImpl().getOwner()) : CallableReferenceLowering.this.context.getIrBuiltIns().getAnyType();
            Object object = IrTypesKt.getClassOrNull(this.reference.getType());
            if (object == null || (object = (IrClass)object.getOwner()) == null) {
                String string2 = "Expected functional type";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            this.superFunctionInterface = object;
            this.isKReference = this.superFunctionInterface.getName().getIdentifier().charAt(0) == 'K';
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0005\t\n\u000b\f\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$Companion;", "", "()V", "BOUND_RECEIVER_NAME", "Lorg/jetbrains/kotlin/name/Name;", "getBOUND_RECEIVER_NAME", "()Lorg/jetbrains/kotlin/name/Name;", "THIS_NAME", "getTHIS_NAME", "CALLABLE_REFERENCE_CREATE", "CALLABLE_REFERENCE_INVOKE", "FUNCTION_REFERENCE_IMPL", "GENERATED_MEMBER_IN_CALLABLE_REFERENCE", "LAMBDA_IMPL", "backend.js"})
    public static final class Companion {
        @NotNull
        public final Name getTHIS_NAME() {
            return THIS_NAME;
        }

        @NotNull
        public final Name getBOUND_RECEIVER_NAME() {
            return BOUND_RECEIVER_NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$Companion$LAMBDA_IMPL;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "()V", "backend.js"})
        public static final class LAMBDA_IMPL
        extends IrDeclarationOriginImpl {
            public static final LAMBDA_IMPL INSTANCE;

            private LAMBDA_IMPL() {
                super("LAMBDA_IMPL", false, 2, null);
            }

            static {
                LAMBDA_IMPL lAMBDA_IMPL;
                INSTANCE = lAMBDA_IMPL = new LAMBDA_IMPL();
            }
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$Companion$FUNCTION_REFERENCE_IMPL;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "()V", "backend.js"})
        public static final class FUNCTION_REFERENCE_IMPL
        extends IrDeclarationOriginImpl {
            public static final FUNCTION_REFERENCE_IMPL INSTANCE;

            private FUNCTION_REFERENCE_IMPL() {
                super("FUNCTION_REFERENCE_IMPL", false, 2, null);
            }

            static {
                FUNCTION_REFERENCE_IMPL fUNCTION_REFERENCE_IMPL;
                INSTANCE = fUNCTION_REFERENCE_IMPL = new FUNCTION_REFERENCE_IMPL();
            }
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$Companion$GENERATED_MEMBER_IN_CALLABLE_REFERENCE;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "()V", "backend.js"})
        public static final class GENERATED_MEMBER_IN_CALLABLE_REFERENCE
        extends IrDeclarationOriginImpl {
            public static final GENERATED_MEMBER_IN_CALLABLE_REFERENCE INSTANCE;

            private GENERATED_MEMBER_IN_CALLABLE_REFERENCE() {
                super("GENERATED_MEMBER_IN_CALLABLE_REFERENCE", false, 2, null);
            }

            static {
                GENERATED_MEMBER_IN_CALLABLE_REFERENCE gENERATED_MEMBER_IN_CALLABLE_REFERENCE;
                INSTANCE = gENERATED_MEMBER_IN_CALLABLE_REFERENCE = new GENERATED_MEMBER_IN_CALLABLE_REFERENCE();
            }
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$Companion$CALLABLE_REFERENCE_CREATE;", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOriginImpl;", "()V", "backend.js"})
        public static final class CALLABLE_REFERENCE_CREATE
        extends IrStatementOriginImpl {
            public static final CALLABLE_REFERENCE_CREATE INSTANCE;

            private CALLABLE_REFERENCE_CREATE() {
                super("CALLABLE_REFERENCE_CREATE");
            }

            static {
                CALLABLE_REFERENCE_CREATE cALLABLE_REFERENCE_CREATE;
                INSTANCE = cALLABLE_REFERENCE_CREATE = new CALLABLE_REFERENCE_CREATE();
            }
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$Companion$CALLABLE_REFERENCE_INVOKE;", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOriginImpl;", "()V", "backend.js"})
        public static final class CALLABLE_REFERENCE_INVOKE
        extends IrStatementOriginImpl {
            public static final CALLABLE_REFERENCE_INVOKE INSTANCE;

            private CALLABLE_REFERENCE_INVOKE() {
                super("CALLABLE_REFERENCE_INVOKE");
            }

            static {
                CALLABLE_REFERENCE_INVOKE cALLABLE_REFERENCE_INVOKE;
                INSTANCE = cALLABLE_REFERENCE_INVOKE = new CALLABLE_REFERENCE_INVOKE();
            }
        }
    }
}

