/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.DefaultNamesKt;
import org.jetbrains.kotlin.fir.declarations.FirNamedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0016\u0010\u0012\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0012\u0004\u0012\u00020\u00100\u0013H\u0016J(\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0016\u0010\u0012\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u00100\u0013H\u0016J(\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0016\u0010\u0012\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0017\u0012\u0004\u0012\u00020\u00100\u0013H\u0016J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR!\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirLocalScope;", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "()V", "classes", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "getClasses", "()Ljava/util/Map;", "functions", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "getFunctions", "properties", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "getProperties", "processClassifiersByName", "Lorg/jetbrains/kotlin/fir/scopes/ProcessorAction;", "name", "processor", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "processFunctionsByName", "processPropertiesByName", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "storeBackingField", "", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "storeDeclaration", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirNamedDeclaration;", "resolve"})
public final class FirLocalScope
extends FirScope {
    @NotNull
    private final Map<Name, FirVariableSymbol<?>> properties;
    @NotNull
    private final Map<Name, FirFunctionSymbol<?>> functions;
    @NotNull
    private final Map<Name, FirRegularClassSymbol> classes;

    @NotNull
    public final Map<Name, FirVariableSymbol<?>> getProperties() {
        return this.properties;
    }

    @NotNull
    public final Map<Name, FirFunctionSymbol<?>> getFunctions() {
        return this.functions;
    }

    @NotNull
    public final Map<Name, FirRegularClassSymbol> getClasses() {
        return this.classes;
    }

    public final void storeDeclaration(@NotNull FirNamedDeclaration declaration2) {
        block2: {
            FirNamedDeclaration firNamedDeclaration;
            block3: {
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                    firNamedDeclaration = declaration2;
                    if (!(firNamedDeclaration instanceof FirVariable)) break block1;
                    this.properties.put(declaration2.getName(), ((FirVariable)declaration2).getSymbol());
                    break block2;
                }
                if (!(firNamedDeclaration instanceof FirSimpleFunction)) break block3;
                FirFunctionSymbol<FirSimpleFunction> firFunctionSymbol = ((FirSimpleFunction)declaration2).getSymbol();
                if (firFunctionSymbol == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol");
                }
                this.functions.put(declaration2.getName(), (FirNamedFunctionSymbol)firFunctionSymbol);
                break block2;
            }
            if (!(firNamedDeclaration instanceof FirRegularClass)) break block2;
            this.classes.put(declaration2.getName(), ((FirRegularClass)declaration2).getSymbol());
        }
    }

    public final void storeBackingField(@NotNull FirProperty property) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        this.properties.put(DefaultNamesKt.getNAME_FOR_BACKING_FIELD(), property.getBackingFieldSymbol());
    }

    @Override
    @NotNull
    public ProcessorAction processFunctionsByName(@NotNull Name name2, @NotNull Function1<? super FirFunctionSymbol<?>, ? extends ProcessorAction> processor2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        FirFunctionSymbol<?> function2 = this.functions.get(name2);
        if (function2 != null) {
            return (ProcessorAction)((Object)processor2.invoke(function2));
        }
        return ProcessorAction.NONE;
    }

    @Override
    @NotNull
    public ProcessorAction processPropertiesByName(@NotNull Name name2, @NotNull Function1<? super FirCallableSymbol<?>, ? extends ProcessorAction> processor2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        FirVariableSymbol<?> property = this.properties.get(name2);
        if (property != null) {
            return (ProcessorAction)((Object)processor2.invoke(property));
        }
        return ProcessorAction.NONE;
    }

    @Override
    @NotNull
    public ProcessorAction processClassifiersByName(@NotNull Name name2, @NotNull Function1<? super FirClassifierSymbol<?>, ? extends ProcessorAction> processor2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        FirRegularClassSymbol klass2 = this.classes.get(name2);
        if (klass2 != null) {
            return (ProcessorAction)((Object)processor2.invoke((Object)klass2));
        }
        return ProcessorAction.NONE;
    }

    public FirLocalScope() {
        Map map2;
        FirLocalScope firLocalScope = this;
        boolean bl = false;
        firLocalScope.properties = map2 = (Map)new LinkedHashMap();
        firLocalScope = this;
        bl = false;
        firLocalScope.functions = map2 = (Map)new LinkedHashMap();
        firLocalScope = this;
        bl = false;
        firLocalScope.classes = map2 = (Map)new LinkedHashMap();
    }
}

