/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.NotFoundClasses;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.impl.IrClassReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetEnumValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import org.jetbrains.kotlin.ir.util.TypeTranslator;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.UByteValue;
import org.jetbrains.kotlin.resolve.constants.UIntValue;
import org.jetbrains.kotlin.resolve.constants.ULongValue;
import org.jetbrains.kotlin.resolve.constants.UShortValue;
import org.jetbrains.kotlin.resolve.source.PsiSourceElement;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J2\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J.\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\f\u0010\u001b\u001a\u00020\u0019*\u00020\u0019H\u0002J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/ir/util/ConstantValueGenerator;", "", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;)V", "typeTranslator", "Lorg/jetbrains/kotlin/ir/util/TypeTranslator;", "getTypeTranslator", "()Lorg/jetbrains/kotlin/ir/util/TypeTranslator;", "setTypeTranslator", "(Lorg/jetbrains/kotlin/ir/util/TypeTranslator;)V", "generateAnnotationConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "annotationDescriptor", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "generateConstantOrAnnotationValueAsExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "startOffset", "", "endOffset", "constantValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "varargElementType", "Lorg/jetbrains/kotlin/types/KotlinType;", "generateConstantValueAsExpression", "getArrayElementType", "toIrType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "ir.tree"})
public final class ConstantValueGenerator {
    @NotNull
    public TypeTranslator typeTranslator;
    private final ModuleDescriptor moduleDescriptor;
    private final ReferenceSymbolTable symbolTable;

    @NotNull
    public final TypeTranslator getTypeTranslator() {
        TypeTranslator typeTranslator = this.typeTranslator;
        if (typeTranslator == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"typeTranslator");
        }
        return typeTranslator;
    }

    public final void setTypeTranslator(@NotNull TypeTranslator typeTranslator) {
        Intrinsics.checkParameterIsNotNull((Object)typeTranslator, (String)"<set-?>");
        this.typeTranslator = typeTranslator;
    }

    private final IrType toIrType(@NotNull KotlinType $this$toIrType) {
        TypeTranslator typeTranslator = this.typeTranslator;
        if (typeTranslator == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"typeTranslator");
        }
        return typeTranslator.translateType($this$toIrType);
    }

    @NotNull
    public final IrExpression generateConstantValueAsExpression(int startOffset, int endOffset, @NotNull ConstantValue<?> constantValue, @Nullable KotlinType varargElementType) {
        Intrinsics.checkParameterIsNotNull(constantValue, (String)"constantValue");
        IrExpression irExpression = this.generateConstantOrAnnotationValueAsExpression(startOffset, endOffset, constantValue, varargElementType);
        if (irExpression == null) {
            Intrinsics.throwNpe();
        }
        return irExpression;
    }

    public static /* synthetic */ IrExpression generateConstantValueAsExpression$default(ConstantValueGenerator constantValueGenerator, int n, int n2, ConstantValue constantValue, KotlinType kotlinType, int n3, Object object) {
        if ((n3 & 8) != 0) {
            kotlinType = null;
        }
        return constantValueGenerator.generateConstantValueAsExpression(n, n2, constantValue, kotlinType);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateConstantOrAnnotationValueAsExpression(int startOffset, int endOffset, ConstantValue<?> constantValue, KotlinType varargElementType) {
        IrExpression irExpression;
        KotlinType constantKtType = constantValue.getType(this.moduleDescriptor);
        IrType constantType = this.toIrType(constantKtType);
        ConstantValue<?> constantValue2 = constantValue;
        if (constantValue2 instanceof StringValue) {
            irExpression = IrConstImpl.Companion.string(startOffset, endOffset, constantType, (String)((StringValue)constantValue).getValue());
        } else if (constantValue2 instanceof IntValue) {
            irExpression = IrConstImpl.Companion.int(startOffset, endOffset, constantType, ((Number)((IntValue)constantValue).getValue()).intValue());
        } else if (constantValue2 instanceof UIntValue) {
            irExpression = IrConstImpl.Companion.int(startOffset, endOffset, constantType, ((Number)((UIntValue)constantValue).getValue()).intValue());
        } else if (constantValue2 instanceof NullValue) {
            irExpression = IrConstImpl.Companion.constNull(startOffset, endOffset, constantType);
        } else if (constantValue2 instanceof BooleanValue) {
            irExpression = IrConstImpl.Companion.boolean(startOffset, endOffset, constantType, (Boolean)((BooleanValue)constantValue).getValue());
        } else if (constantValue2 instanceof LongValue) {
            irExpression = IrConstImpl.Companion.long(startOffset, endOffset, constantType, ((Number)((LongValue)constantValue).getValue()).longValue());
        } else if (constantValue2 instanceof ULongValue) {
            irExpression = IrConstImpl.Companion.long(startOffset, endOffset, constantType, ((Number)((ULongValue)constantValue).getValue()).longValue());
        } else if (constantValue2 instanceof DoubleValue) {
            irExpression = IrConstImpl.Companion.double(startOffset, endOffset, constantType, ((Number)((DoubleValue)constantValue).getValue()).doubleValue());
        } else if (constantValue2 instanceof FloatValue) {
            irExpression = IrConstImpl.Companion.float(startOffset, endOffset, constantType, ((Number)((FloatValue)constantValue).getValue()).floatValue());
        } else if (constantValue2 instanceof CharValue) {
            irExpression = IrConstImpl.Companion.char(startOffset, endOffset, constantType, ((Character)((CharValue)constantValue).getValue()).charValue());
        } else if (constantValue2 instanceof ByteValue) {
            irExpression = IrConstImpl.Companion.byte(startOffset, endOffset, constantType, ((Number)((ByteValue)constantValue).getValue()).byteValue());
        } else if (constantValue2 instanceof UByteValue) {
            irExpression = IrConstImpl.Companion.byte(startOffset, endOffset, constantType, ((Number)((UByteValue)constantValue).getValue()).byteValue());
        } else if (constantValue2 instanceof ShortValue) {
            irExpression = IrConstImpl.Companion.short(startOffset, endOffset, constantType, ((Number)((ShortValue)constantValue).getValue()).shortValue());
        } else if (constantValue2 instanceof UShortValue) {
            irExpression = IrConstImpl.Companion.short(startOffset, endOffset, constantType, ((Number)((UShortValue)constantValue).getValue()).shortValue());
        } else if (constantValue2 instanceof ArrayValue) {
            Collection<IrExpression> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            KotlinType kotlinType = varargElementType;
            if (kotlinType == null) {
                kotlinType = this.getArrayElementType(constantKtType);
            }
            KotlinType arrayElementType = kotlinType;
            Iterable iterable = (Iterable)((ArrayValue)constantValue).getValue();
            IrType irType = this.toIrType(arrayElementType);
            IrType irType2 = constantType;
            int n = endOffset;
            int n2 = startOffset;
            boolean $i$f$map = false;
            void var11_20 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ConstantValue constantValue3 = (ConstantValue)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                IrExpression irExpression2 = this.generateConstantValueAsExpression(startOffset, endOffset, (ConstantValue<?>)it, null);
                collection.add(irExpression2);
            }
            Collection<IrExpression> collection2 = collection = (List)destination$iv$iv;
            IrType irType3 = irType;
            IrType irType4 = irType2;
            int n3 = n;
            int n4 = n2;
            irExpression = new IrVarargImpl(n4, n3, irType4, irType3, (List<? extends IrVarargElement>)collection2);
        } else if (constantValue2 instanceof EnumValue) {
            ClassifierDescriptor classifierDescriptor = constantKtType.getMemberScope().getContributedClassifier(((EnumValue)constantValue).getEnumEntryName(), NoLookupLocation.FROM_BACKEND);
            if (classifierDescriptor == null) {
                throw (Throwable)((Object)new AssertionError((Object)("No such enum entry " + ((EnumValue)constantValue).getEnumEntryName() + " in " + constantType)));
            }
            ClassifierDescriptor enumEntryDescriptor = classifierDescriptor;
            if (!(enumEntryDescriptor instanceof ClassDescriptor)) {
                throw (Throwable)((Object)new AssertionError((Object)("Enum entry " + enumEntryDescriptor + " should be a ClassDescriptor")));
            }
            irExpression = new IrGetEnumValueImpl(startOffset, endOffset, constantType, this.symbolTable.referenceEnumEntry((ClassDescriptor)enumEntryDescriptor));
        } else if (constantValue2 instanceof AnnotationValue) {
            irExpression = this.generateAnnotationConstructorCall((AnnotationDescriptor)((AnnotationValue)constantValue).getValue());
        } else if (constantValue2 instanceof KClassValue) {
            IrClassReferenceImpl irClassReferenceImpl;
            KotlinType classifierKtType = ((KClassValue)constantValue).getArgumentType(this.moduleDescriptor);
            if (KotlinTypeKt.isError(classifierKtType)) {
                irClassReferenceImpl = null;
            } else {
                ClassifierDescriptor classifierDescriptor = classifierKtType.getConstructor().getDeclarationDescriptor();
                if (classifierDescriptor == null) {
                    throw (Throwable)((Object)new AssertionError((Object)("Unexpected KClassValue: " + classifierKtType)));
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)classifierDescriptor, (String)"classifierKtType.constru\u2026alue: $classifierKtType\")");
                ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
                IrType irType = this.toIrType(constantValue.getType(this.moduleDescriptor));
                SimpleType simpleType2 = classifierDescriptor2.getDefaultType();
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"classifierDescriptor.defaultType");
                irClassReferenceImpl = new IrClassReferenceImpl(startOffset, endOffset, irType, IrTypesKt.getClassifierOrFail(this.toIrType(simpleType2)), this.toIrType(classifierKtType));
            }
            irExpression = irClassReferenceImpl;
        } else {
            String string2 = "Unexpected constant value: " + constantValue.getClass().getSimpleName() + ' ' + constantValue;
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
        }
        return irExpression;
    }

    static /* synthetic */ IrExpression generateConstantOrAnnotationValueAsExpression$default(ConstantValueGenerator constantValueGenerator, int n, int n2, ConstantValue constantValue, KotlinType kotlinType, int n3, Object object) {
        if ((n3 & 8) != 0) {
            kotlinType = null;
        }
        return constantValueGenerator.generateConstantOrAnnotationValueAsExpression(n, n2, constantValue, kotlinType);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final IrConstructorCall generateAnnotationConstructorCall(@NotNull AnnotationDescriptor annotationDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)annotationDescriptor, (String)"annotationDescriptor");
        annotationType = annotationDescriptor.getType();
        annotationClassDescriptor = annotationType.getConstructor().getDeclarationDescriptor();
        if (!(annotationClassDescriptor instanceof ClassDescriptor)) {
            return null;
        }
        if (annotationClassDescriptor instanceof NotFoundClasses.MockClassDescriptor) {
            return null;
        }
        var4_4 = DescriptorUtils.isAnnotationClass(annotationClassDescriptor);
        var5_6 = false;
        if (_Assertions.ENABLED && !var4_4) {
            $i$a$-assert-ConstantValueGenerator$generateAnnotationConstructorCall$1 = false;
            $i$a$-assert-ConstantValueGenerator$generateAnnotationConstructorCall$1 = "Annotation class expected: " + annotationClassDescriptor;
            throw (Throwable)new AssertionError((Object)$i$a$-assert-ConstantValueGenerator$generateAnnotationConstructorCall$1);
        }
        v0 = ((ClassDescriptor)annotationClassDescriptor).getUnsubstitutedPrimaryConstructor();
        if (v0 == null) {
            v1 = ((ClassDescriptor)annotationClassDescriptor).getConstructors();
            Intrinsics.checkExpressionValueIsNotNull(v1, (String)"annotationClassDescriptor.constructors");
            v0 = (ClassConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)v1);
        }
        if (v0 == null) {
            throw (Throwable)new AssertionError((Object)("No constructor for annotation class " + annotationClassDescriptor));
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"annotationClassDescripto\u2026notationClassDescriptor\")");
        primaryConstructorDescriptor = v0;
        primaryConstructorSymbol = this.symbolTable.referenceConstructor(primaryConstructorDescriptor);
        $this$safeAs$iv = annotationDescriptor.getSource();
        $i$f$safeAs = false;
        v2 = $this$safeAs$iv;
        if (!(v2 instanceof PsiSourceElement)) {
            v2 = null;
        }
        v3 = (PsiSourceElement)v2;
        psi /* !! */  = v3 != null ? v3.getPsi() : null;
        v4 /* !! */  = psi /* !! */ ;
        if (v4 /* !! */  == null) ** GOTO lbl-1000
        $i$f$safeAs = v4 /* !! */ ;
        var9_16 = false;
        var10_19 = false;
        it = $i$f$safeAs;
        $i$a$-takeUnless-ConstantValueGenerator$generateAnnotationConstructorCall$startOffset$1 = false;
        v5 = it.getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it.containingFile");
        v6 = v5.getFileType();
        Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"it.containingFile.fileType");
        v4 /* !! */  = v6.isBinary() == false ? $i$f$safeAs : null;
        if (v4 /* !! */  != null) {
            v7 = PsiUtilsKt.getStartOffset(v4 /* !! */ );
        } else lbl-1000:
        // 2 sources

        {
            v7 = startOffset = -1;
        }
        if ((v8 /* !! */  = psi /* !! */ ) == null) ** GOTO lbl-1000
        var9_17 = v8 /* !! */ ;
        var10_19 = false;
        var11_22 = false;
        it = var9_17;
        $i$a$-takeUnless-ConstantValueGenerator$generateAnnotationConstructorCall$endOffset$1 = false;
        v9 = it.getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"it.containingFile");
        v10 = v9.getFileType();
        Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"it.containingFile.fileType");
        v8 /* !! */  = v10.isBinary() == false ? var9_17 : null;
        if (v8 /* !! */  != null) {
            v11 = PsiUtilsKt.getEndOffset(v8 /* !! */ );
        } else lbl-1000:
        // 2 sources

        {
            v11 = -1;
        }
        endOffset = v11;
        irCall = IrConstructorCallImpl.Companion.fromSymbolDescriptor$default(IrConstructorCallImpl.Companion, startOffset, endOffset, this.toIrType(annotationType), primaryConstructorSymbol, null, 16, null);
        for (ValueParameterDescriptor valueParameter : primaryConstructorDescriptor.getValueParameters()) {
            argumentIndex = valueParameter.getIndex();
            v12 = annotationDescriptor.getAllValueArguments();
            v13 = valueParameter;
            Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"valueParameter");
            if (v12.get(v13.getName()) == null) {
                continue;
            }
            irArgument = this.generateConstantOrAnnotationValueAsExpression(-1, -1, argumentValue, valueParameter.getVarargElementType());
            if (irArgument == null) continue;
            irCall.putValueArgument(argumentIndex, irArgument);
        }
        return irCall;
    }

    private final KotlinType getArrayElementType(@NotNull KotlinType $this$getArrayElementType) {
        KotlinType kotlinType = TypeUtilsKt.getBuiltIns($this$getArrayElementType).getArrayElementType($this$getArrayElementType);
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"builtIns.getArrayElementType(this)");
        return kotlinType;
    }

    public ConstantValueGenerator(@NotNull ModuleDescriptor moduleDescriptor, @NotNull ReferenceSymbolTable symbolTable) {
        Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)symbolTable, (String)"symbolTable");
        this.moduleDescriptor = moduleDescriptor;
        this.symbolTable = symbolTable;
    }
}

