/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.impl.FirImportImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirResolvedImportImpl;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.ConstructorProcessingKt;
import org.jetbrains.kotlin.fir.resolve.calls.ExpressionReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.SessionBasedTowerLevel;
import org.jetbrains.kotlin.fir.resolve.calls.TowerScopeLevel;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.scopes.impl.FirExplicitSimpleImportingScope;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JD\u0010\u0007\u001a\u00020\b\"\f\b\u0000\u0010\t*\u0006\u0012\u0002\b\u00030\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\t0\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/QualifiedReceiverTowerLevel;", "Lorg/jetbrains/kotlin/fir/resolve/calls/SessionBasedTowerLevel;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "bodyResolveComponents", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;)V", "processElementsByName", "Lorg/jetbrains/kotlin/fir/scopes/ProcessorAction;", "T", "Lorg/jetbrains/kotlin/fir/symbols/AbstractFirBasedSymbol;", "token", "Lorg/jetbrains/kotlin/fir/resolve/calls/TowerScopeLevel$Token;", "name", "Lorg/jetbrains/kotlin/name/Name;", "explicitReceiver", "Lorg/jetbrains/kotlin/fir/resolve/calls/ExpressionReceiverValue;", "processor", "Lorg/jetbrains/kotlin/fir/resolve/calls/TowerScopeLevel$TowerScopeLevelProcessor;", "resolve"})
public final class QualifiedReceiverTowerLevel
extends SessionBasedTowerLevel {
    private final BodyResolveComponents bodyResolveComponents;

    @Override
    @NotNull
    public <T extends AbstractFirBasedSymbol<?>> ProcessorAction processElementsByName(@NotNull TowerScopeLevel.Token<? extends T> token, @NotNull Name name2, @Nullable ExpressionReceiverValue explicitReceiver, @NotNull TowerScopeLevel.TowerScopeLevelProcessor<T> processor2) {
        ProcessorAction processorAction;
        FirScope firScope;
        Intrinsics.checkParameterIsNotNull(token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        ExpressionReceiverValue expressionReceiverValue = explicitReceiver;
        FirExpression firExpression2 = expressionReceiverValue != null ? expressionReceiverValue.getExplicitReceiverExpression() : null;
        if (firExpression2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier");
        }
        FirResolvedQualifier qualifiedReceiver = (FirResolvedQualifier)firExpression2;
        ClassId classId = qualifiedReceiver.getClassId();
        if (Intrinsics.areEqual(token, (Object)TowerScopeLevel.Token.Objects.INSTANCE) || classId == null) {
            firScope = new FirExplicitSimpleImportingScope(CollectionsKt.listOf((Object)new FirResolvedImportImpl(new FirImportImpl(null, FqName.topLevel(name2), false, null), qualifiedReceiver.getPackageFqName(), qualifiedReceiver.getRelativeClassFqName())), this.getSession(), this.bodyResolveComponents.getScopeSession());
        } else {
            firScope = ResolveUtilsKt.getFirSymbolProvider(this.getSession()).getClassUseSiteMemberScope(classId, this.getSession(), this.bodyResolveComponents.getScopeSession());
            if (firScope == null) {
                return ProcessorAction.NEXT;
            }
        }
        FirScope scope2 = firScope;
        Function1 processorForCallables2 = new Function1<FirCallableSymbol<?>, ProcessorAction>(processor2){
            final /* synthetic */ TowerScopeLevel.TowerScopeLevelProcessor $processor;

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final ProcessorAction invoke(@NotNull FirCallableSymbol<?> it) {
                ProcessorAction processorAction;
                block4: {
                    block3: {
                        FirCallableDeclaration fir;
                        block2: {
                            Intrinsics.checkParameterIsNotNull(it, (String)"it");
                            fir = (FirCallableDeclaration)it.getFir();
                            if (!(fir instanceof FirCallableMemberDeclaration)) break block2;
                            FirMemberDeclaration $this$isStatic$iv = (FirMemberDeclaration)((Object)fir);
                            boolean $i$f$isStatic = false;
                            if ($this$isStatic$iv.getStatus().isStatic()) break block3;
                        }
                        if (it.getCallableId().getClassId() == null) break block3;
                        if (!(fir instanceof FirConstructor)) break block4;
                        FirMemberDeclaration $this$isInner$iv = (FirMemberDeclaration)((Object)fir);
                        boolean $i$f$isInner = false;
                        if ($this$isInner$iv.getStatus().isInner()) break block4;
                    }
                    processorAction = this.$processor.consumeCandidate((AbstractFirBasedSymbol)it, null, null);
                    return processorAction;
                }
                processorAction = ProcessorAction.NEXT;
                return processorAction;
            }
            {
                this.$processor = towerScopeLevelProcessor;
                super(1);
            }
        };
        TowerScopeLevel.Token<? extends T> token2 = token;
        if (Intrinsics.areEqual(token2, (Object)TowerScopeLevel.Token.Objects.INSTANCE)) {
            processorAction = scope2.processClassifiersByName(name2, (Function1)new Function1<FirClassifierSymbol<?>, ProcessorAction>(processor2){
                final /* synthetic */ TowerScopeLevel.TowerScopeLevelProcessor $processor;

                @NotNull
                public final ProcessorAction invoke(@NotNull FirClassifierSymbol<?> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    return this.$processor.consumeCandidate((AbstractFirBasedSymbol)it, null, null);
                }
                {
                    this.$processor = towerScopeLevelProcessor;
                    super(1);
                }
            });
        } else if (Intrinsics.areEqual(token2, (Object)TowerScopeLevel.Token.Functions.INSTANCE)) {
            processorAction = ConstructorProcessingKt.processFunctionsAndConstructorsByName(scope2, name2, this.getSession(), this.bodyResolveComponents, processorForCallables2);
        } else if (Intrinsics.areEqual(token2, (Object)TowerScopeLevel.Token.Properties.INSTANCE)) {
            processorAction = scope2.processPropertiesByName(name2, processorForCallables2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return processorAction;
    }

    public QualifiedReceiverTowerLevel(@NotNull FirSession session, @NotNull BodyResolveComponents bodyResolveComponents) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)bodyResolveComponents, (String)"bodyResolveComponents");
        super(session);
        this.bodyResolveComponents = bodyResolveComponents;
    }
}

