/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.resolve.AdditionalAnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.checkers.ExperimentalMarkerDeclarationAnnotationChecker$checkMarkerTargets$1;
import org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0010\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J*\u0010\u0011\u001a\u00020\t2\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\fH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalMarkerDeclarationAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/AdditionalAnnotationChecker;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)V", "WRONG_TARGETS_FOR_MARKER", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "checkEntries", "", "entries", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "actualTargets", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "checkMarkerTargets", "checkUseExperimentalUsage", "annotationClasses", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "entry", "frontend"})
public final class ExperimentalMarkerDeclarationAnnotationChecker
implements AdditionalAnnotationChecker {
    private final Set<KotlinTarget> WRONG_TARGETS_FOR_MARKER;
    private final ModuleDescriptor module;

    @Override
    public void checkEntries(@NotNull List<? extends KtAnnotationEntry> entries2, @NotNull List<? extends KotlinTarget> actualTargets, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(entries2, (String)"entries");
        Intrinsics.checkParameterIsNotNull(actualTargets, (String)"actualTargets");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        boolean isAnnotatedWithExperimental = false;
        for (KtAnnotationEntry ktAnnotationEntry : entries2) {
            FqName fqName2;
            AnnotationDescriptor annotation2;
            AnnotationDescriptor annotationDescriptor = annotation2 = (AnnotationDescriptor)trace.getBindingContext().get(BindingContext.ANNOTATION, ktAnnotationEntry);
            FqName fqName3 = fqName2 = annotationDescriptor != null ? annotationDescriptor.getFqName() : null;
            if (Intrinsics.areEqual((Object)fqName2, (Object)ExperimentalUsageChecker.Companion.getUSE_EXPERIMENTAL_FQ_NAME())) {
                ConstantValue<?> constantValue = annotation2.getAllValueArguments().get(ExperimentalUsageChecker.Companion.getUSE_EXPERIMENTAL_ANNOTATION_CLASS$frontend());
                if (!(constantValue instanceof ArrayValue)) {
                    constantValue = null;
                }
                ArrayValue arrayValue = (ArrayValue)constantValue;
                List list2 = arrayValue != null ? (List)arrayValue.getValue() : null;
                boolean bl = false;
                List list3 = list2;
                if (list3 == null) {
                    list3 = CollectionsKt.emptyList();
                }
                List annotationClasses = list3;
                this.checkUseExperimentalUsage(annotationClasses, trace, ktAnnotationEntry);
                continue;
            }
            if (!Intrinsics.areEqual((Object)fqName2, (Object)ExperimentalUsageChecker.Companion.getEXPERIMENTAL_FQ_NAME())) continue;
            isAnnotatedWithExperimental = true;
        }
        if (isAnnotatedWithExperimental) {
            this.checkMarkerTargets(entries2, trace);
        }
    }

    private final void checkUseExperimentalUsage(List<? extends ConstantValue<?>> annotationClasses, BindingTrace trace, KtAnnotationEntry entry) {
        if (annotationClasses.isEmpty()) {
            trace.report(Errors.USE_EXPERIMENTAL_WITHOUT_ARGUMENTS.on((KtAnnotationEntry)((PsiElement)entry)));
            return;
        }
        for (ConstantValue<?> annotationClass : annotationClasses) {
            ClassDescriptor classDescriptor2;
            ClassifierDescriptor classifierDescriptor;
            Object object;
            ConstantValue<?> constantValue = annotationClass;
            if (!(constantValue instanceof KClassValue)) {
                constantValue = null;
            }
            if (!(((object = (KClassValue)constantValue) != null && (object = ((KClassValue)object).getArgumentType(this.module)) != null && (object = ((KotlinType)object).getConstructor()) != null ? object.getDeclarationDescriptor() : (classifierDescriptor = null)) instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            if ((ClassDescriptor)classifierDescriptor == null) {
                continue;
            }
            ExperimentalUsageChecker.Companion companion = ExperimentalUsageChecker.Companion;
            boolean bl = false;
            boolean bl2 = false;
            ExperimentalUsageChecker.Companion $this$with = companion;
            boolean bl3 = false;
            ExperimentalUsageChecker.Experimentality experimentality = $this$with.loadExperimentalityForMarkerAnnotation$frontend(classDescriptor2);
            if (experimentality != null) continue;
            trace.report(Errors.USE_EXPERIMENTAL_ARGUMENT_IS_NOT_MARKER.on((KtAnnotationEntry)((PsiElement)entry), DescriptorUtilsKt.getFqNameSafe(classDescriptor2)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkMarkerTargets(List<? extends KtAnnotationEntry> entries2, BindingTrace trace) {
        AnnotationDescriptor descriptor2;
        Object object;
        Object element$iv;
        Object capacity$iv22;
        Object $this$firstOrNull$iv;
        block6: {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = entries2;
            boolean $i$f$associate = false;
            int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                KtAnnotationEntry entry = (KtAnnotationEntry)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)entry, trace.getBindingContext().get(BindingContext.ANNOTATION, entry));
                boolean bl2 = false;
                map2.put(pair.getFirst(), pair.getSecond());
            }
            $this$firstOrNull$iv = destination$iv$iv.entrySet();
            boolean $i$f$firstOrNull = false;
            capacity$iv22 = $this$firstOrNull$iv.iterator();
            while (capacity$iv22.hasNext()) {
                element$iv = capacity$iv22.next();
                Map.Entry $dstr$_u24__u24$descriptor = (Map.Entry)element$iv;
                boolean bl = false;
                Map.Entry entry = $dstr$_u24__u24$descriptor;
                boolean bl3 = false;
                AnnotationDescriptor descriptor3 = (AnnotationDescriptor)entry.getValue();
                if (!(descriptor3 != null && Intrinsics.areEqual((Object)descriptor3.getFqName(), (Object)KotlinBuiltIns.FQ_NAMES.target))) continue;
                object = element$iv;
                break block6;
            }
            object = null;
        }
        Map.Entry entry = (Map.Entry)object;
        if (entry == null) {
            return;
        }
        Map.Entry targetEntry = entry;
        element$iv = capacity$iv22 = targetEntry;
        boolean bl = false;
        $this$firstOrNull$iv = (KtAnnotationEntry)element$iv.getKey();
        element$iv = capacity$iv22;
        bl = false;
        AnnotationDescriptor annotationDescriptor = descriptor2 = (AnnotationDescriptor)element$iv.getValue();
        if (annotationDescriptor == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)annotationDescriptor, (String)"descriptor!!");
        Set<KotlinTarget> set = AnnotationChecker.Companion.loadAnnotationTargets(annotationDescriptor);
        if (set == null) {
            return;
        }
        Set<KotlinTarget> allowedTargets = set;
        Set wrongTargets = CollectionsKt.intersect((Iterable)allowedTargets, (Iterable)this.WRONG_TARGETS_FOR_MARKER);
        Collection collection = wrongTargets;
        boolean bl4 = false;
        if (!collection.isEmpty()) {
            void entry2;
            trace.report(Errors.EXPERIMENTAL_ANNOTATION_WITH_WRONG_TARGET.on((KtAnnotationEntry)((PsiElement)entry2), CollectionsKt.joinToString$default((Iterable)wrongTargets, null, null, null, (int)0, null, (Function1)((Function1)ExperimentalMarkerDeclarationAnnotationChecker$checkMarkerTargets$1.INSTANCE), (int)31, null)));
        }
    }

    public ExperimentalMarkerDeclarationAnnotationChecker(@NotNull ModuleDescriptor module2) {
        Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
        this.module = module2;
        this.WRONG_TARGETS_FOR_MARKER = SetsKt.setOf((Object[])new KotlinTarget[]{KotlinTarget.EXPRESSION, KotlinTarget.FILE});
    }
}

