/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtils;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.ModuleWrapperTranslation$WhenMappings;
import org.jetbrains.kotlin.ir.backend.js.utils.StableNamesCollectorKt;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsImportedModule;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectScope;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.naming.NameSuggestionKt;
import org.jetbrains.kotlin.serialization.js.ModuleKind;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J:\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015J,\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J,\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J4\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J4\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/ModuleWrapperTranslation;", "", "()V", "addModuleValidation", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "currentModuleId", "", "program", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgram;", "module", "Lorg/jetbrains/kotlin/js/backend/ast/JsImportedModule;", "makePlainInvocation", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "moduleId", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "importedModules", "", "makePlainModuleRef", "wrap", "kind", "Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "wrapAmd", "wrapCommonJs", "wrapPlain", "wrapUmd", "Namer", "backend.js"})
public final class ModuleWrapperTranslation {
    public static final ModuleWrapperTranslation INSTANCE;

    @NotNull
    public final List<JsStatement> wrap(@NotNull String moduleId, @NotNull JsExpression function2, @NotNull List<JsImportedModule> importedModules, @NotNull JsProgram program, @NotNull ModuleKind kind) {
        List<JsStatement> list2;
        Intrinsics.checkParameterIsNotNull((Object)moduleId, (String)"moduleId");
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        Intrinsics.checkParameterIsNotNull(importedModules, (String)"importedModules");
        Intrinsics.checkParameterIsNotNull((Object)program, (String)"program");
        Intrinsics.checkParameterIsNotNull((Object)((Object)kind), (String)"kind");
        switch (ModuleWrapperTranslation$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1: {
                list2 = this.wrapAmd(function2, importedModules, program);
                break;
            }
            case 2: {
                list2 = this.wrapCommonJs(function2, importedModules, program);
                break;
            }
            case 3: {
                list2 = this.wrapUmd(moduleId, function2, importedModules, program);
                break;
            }
            case 4: {
                list2 = this.wrapPlain(moduleId, function2, importedModules, program);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list2;
    }

    private final List<JsStatement> wrapUmd(String moduleId, JsExpression function2, List<JsImportedModule> importedModules, JsProgram program) {
        JsObjectScope scope = program.getScope();
        JsName jsName = scope.declareName("define");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"scope.declareName(\"define\")");
        JsName defineName = jsName;
        JsName jsName2 = scope.declareName("exports");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsName2, (String)"scope.declareName(\"exports\")");
        JsName exportsName = jsName2;
        JsBlock adapterBody = new JsBlock();
        JsFunction adapter = new JsFunction((JsScope)program.getScope(), adapterBody, "Adapter");
        JsName jsName3 = adapter.getScope().declareName("root");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsName3, (String)"adapter.scope.declareName(\"root\")");
        JsName rootName = jsName3;
        JsName jsName4 = adapter.getScope().declareName("factory");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsName4, (String)"adapter.scope.declareName(\"factory\")");
        JsName factoryName = jsName4;
        Collection collection = adapter.getParameters();
        JsParameter jsParameter = new JsParameter(rootName);
        boolean bl = false;
        collection.add(jsParameter);
        collection = adapter.getParameters();
        jsParameter = new JsParameter(factoryName);
        bl = false;
        collection.add(jsParameter);
        JsNameRef jsNameRef = defineName.makeRef();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"defineName.makeRef()");
        JsBinaryOperation amdTest = JsAstUtils.INSTANCE.and(JsAstUtils.INSTANCE.typeOfIs(jsNameRef, new JsStringLiteral("function")), new JsNameRef("amd", (JsExpression)defineName.makeRef()));
        JsNameRef jsNameRef2 = exportsName.makeRef();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef2, (String)"exportsName.makeRef()");
        JsBinaryOperation commonJsTest = JsAstUtils.INSTANCE.typeOfIs(jsNameRef2, new JsStringLiteral("object"));
        JsNameRef jsNameRef3 = factoryName.makeRef();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef3, (String)"factoryName.makeRef()");
        JsBlock amdBody = new JsBlock(this.wrapAmd(jsNameRef3, importedModules, program));
        JsNameRef jsNameRef4 = factoryName.makeRef();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef4, (String)"factoryName.makeRef()");
        JsBlock commonJsBody = new JsBlock(this.wrapCommonJs(jsNameRef4, importedModules, program));
        JsNameRef jsNameRef5 = factoryName.makeRef();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef5, (String)"factoryName.makeRef()");
        JsInvocation plainInvocation = this.makePlainInvocation(moduleId, jsNameRef5, importedModules, program);
        JsExpression lhs = Namer.INSTANCE.requiresEscaping(moduleId) ? (JsExpression)new JsArrayAccess(rootName.makeRef(), new JsStringLiteral(moduleId)) : (JsExpression)new JsNameRef(scope.declareName(moduleId), (JsExpression)rootName.makeRef());
        JsBlock plainBlock = new JsBlock();
        for (JsImportedModule jsImportedModule : importedModules) {
            Collection collection2 = plainBlock.getStatements();
            JsStatement jsStatement = this.addModuleValidation(moduleId, program, jsImportedModule);
            boolean bl2 = false;
            collection2.add(jsStatement);
        }
        Collection collection3 = plainBlock.getStatements();
        Object object = JsAstUtils.INSTANCE.assignment(lhs, plainInvocation).makeStmt();
        boolean bl3 = false;
        collection3.add(object);
        JsIf jsIf = JsAstUtils.INSTANCE.newJsIf(amdTest, amdBody, JsAstUtils.INSTANCE.newJsIf(commonJsTest, commonJsBody, plainBlock));
        object = adapterBody.getStatements();
        bl3 = false;
        object.add(jsIf);
        JsStatement jsStatement = new JsInvocation((JsExpression)adapter, new JsThisRef(), function2).makeStmt();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsStatement, (String)"JsInvocation(adapter, Js\u2026f(), function).makeStmt()");
        return CollectionsKt.listOf((Object)jsStatement);
    }

    /*
     * WARNING - void declaration
     */
    private final List<JsStatement> wrapAmd(JsExpression function2, List<JsImportedModule> importedModules, JsProgram program) {
        Collection<JsStringLiteral> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object[] objectArray;
        JsObjectScope scope = program.getScope();
        JsName jsName = scope.declareName("define");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"scope.declareName(\"define\")");
        JsName defineName = jsName;
        Iterable iterable = importedModules;
        Collection collection2 = CollectionsKt.listOf((Object)new JsStringLiteral("exports"));
        int n = 0;
        Object[] objectArray2 = objectArray = new JsExpression[2];
        boolean $i$f$map = false;
        void var9_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsImportedModule jsImportedModule = (JsImportedModule)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JsStringLiteral jsStringLiteral = new JsStringLiteral(it.getExternalName());
            collection.add(jsStringLiteral);
        }
        collection = (List)destination$iv$iv;
        List list2 = CollectionsKt.plus((Collection)collection2, (Iterable)collection);
        objectArray[n] = new JsArrayLiteral(list2);
        objectArray2[1] = function2;
        List invocationArgs = CollectionsKt.listOf((Object[])objectArray2);
        JsInvocation invocation = new JsInvocation((JsExpression)defineName.makeRef(), invocationArgs);
        JsStatement jsStatement = invocation.makeStmt();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsStatement, (String)"invocation.makeStmt()");
        return CollectionsKt.listOf((Object)jsStatement);
    }

    /*
     * WARNING - void declaration
     */
    private final List<JsStatement> wrapCommonJs(JsExpression function2, List<JsImportedModule> importedModules, JsProgram program) {
        void $this$mapTo$iv$iv;
        JsObjectScope scope = program.getScope();
        JsName jsName = scope.declareName("module");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"scope.declareName(\"module\")");
        JsName moduleName = jsName;
        JsName jsName2 = scope.declareName("require");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsName2, (String)"scope.declareName(\"require\")");
        JsName requireName = jsName2;
        Iterable $this$map$iv = importedModules;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsImportedModule jsImportedModule = (JsImportedModule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JsInvocation jsInvocation = new JsInvocation((JsExpression)requireName.makeRef(), new JsStringLiteral(it.getExternalName()));
            collection.add(jsInvocation);
        }
        List invocationArgs = (List)destination$iv$iv;
        JsInvocation invocation = new JsInvocation(function2, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)new JsNameRef("exports", (JsExpression)moduleName.makeRef())), (Iterable)invocationArgs));
        JsStatement jsStatement = invocation.makeStmt();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsStatement, (String)"invocation.makeStmt()");
        return CollectionsKt.listOf((Object)jsStatement);
    }

    private final List<JsStatement> wrapPlain(String moduleId, JsExpression function2, List<JsImportedModule> importedModules, JsProgram program) {
        JsStatement jsStatement;
        JsInvocation invocation = this.makePlainInvocation(moduleId, function2, importedModules, program);
        boolean bl = false;
        List statements = new ArrayList();
        for (JsImportedModule importedModule : importedModules) {
            Collection collection = statements;
            JsStatement jsStatement2 = this.addModuleValidation(moduleId, program, importedModule);
            boolean bl2 = false;
            collection.add(jsStatement2);
        }
        Collection collection = statements;
        if (Namer.INSTANCE.requiresEscaping(moduleId)) {
            jsStatement = JsAstUtils.INSTANCE.assignment(this.makePlainModuleRef(moduleId, program), invocation).makeStmt();
        } else {
            JsName jsName = program.getRootScope().declareName(moduleId);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"program.rootScope.declareName(moduleId)");
            jsStatement = JsAstUtils.INSTANCE.newVar(jsName, invocation);
        }
        JsStatement jsStatement3 = jsStatement;
        boolean bl3 = false;
        collection.add(jsStatement3);
        return statements;
    }

    private final JsStatement addModuleValidation(String currentModuleId, JsProgram program, JsImportedModule module2) {
        JsExpression moduleRef = this.makePlainModuleRef(module2, program);
        JsBinaryOperation moduleExistsCond = JsAstUtils.INSTANCE.typeOfIs(moduleRef, new JsStringLiteral("undefined"));
        JsStringLiteral moduleNotFoundMessage = new JsStringLiteral("Error loading module '" + currentModuleId + "'. Its dependency '" + module2.getExternalName() + "' was not found. " + "Please, check whether '" + module2.getExternalName() + "' is loaded prior to '" + currentModuleId + "'.");
        JsThrow moduleNotFoundThrow = new JsThrow(new JsNew(new JsNameRef("Error"), CollectionsKt.listOf((Object)moduleNotFoundMessage)));
        return new JsIf(moduleExistsCond, new JsBlock((JsStatement)moduleNotFoundThrow));
    }

    /*
     * WARNING - void declaration
     */
    private final JsInvocation makePlainInvocation(String moduleId, JsExpression function2, List<JsImportedModule> importedModules, JsProgram program) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = importedModules;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsImportedModule jsImportedModule = (JsImportedModule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JsExpression jsExpression = INSTANCE.makePlainModuleRef((JsImportedModule)it, program);
            collection.add(jsExpression);
        }
        List invocationArgs = (List)destination$iv$iv;
        JsExpression moduleRef = this.makePlainModuleRef(moduleId, program);
        JsBinaryOperation testModuleDefined = JsAstUtils.INSTANCE.typeOfIs(moduleRef, new JsStringLiteral("undefined"));
        JsConditional selfArg = new JsConditional(testModuleDefined, new JsObjectLiteral(false), moduleRef.deepCopy());
        return new JsInvocation(function2, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)selfArg), (Iterable)invocationArgs));
    }

    private final JsExpression makePlainModuleRef(JsImportedModule module2, JsProgram program) {
        JsExpression jsExpression = module2.getPlainReference();
        if (jsExpression == null) {
            jsExpression = this.makePlainModuleRef(module2.getExternalName(), program);
        }
        return jsExpression;
    }

    private final JsExpression makePlainModuleRef(String moduleId, JsProgram program) {
        JsExpression jsExpression;
        if (Namer.INSTANCE.requiresEscaping(moduleId)) {
            jsExpression = new JsArrayAccess(new JsThisRef(), new JsStringLiteral(moduleId));
        } else {
            JsNameRef jsNameRef = program.getScope().declareName(moduleId).makeRef();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"program.scope.declareName(moduleId).makeRef()");
            jsExpression = jsNameRef;
        }
        return jsExpression;
    }

    private ModuleWrapperTranslation() {
    }

    static {
        ModuleWrapperTranslation moduleWrapperTranslation;
        INSTANCE = moduleWrapperTranslation = new ModuleWrapperTranslation();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/ModuleWrapperTranslation$Namer;", "", "()V", "requiresEscaping", "", "name", "", "backend.js"})
    public static final class Namer {
        public static final Namer INSTANCE;

        public final boolean requiresEscaping(@NotNull String name2) {
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            return !NameSuggestionKt.isValidES5Identifier(name2) || StableNamesCollectorKt.getRESERVED_IDENTIFIERS().contains(name2);
        }

        private Namer() {
        }

        static {
            Namer namer;
            INSTANCE = namer = new Namer();
        }
    }
}

