/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.common;

import java.util.BitSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.common.BackwardAnalysisInterpreter;
import org.jetbrains.kotlin.codegen.optimization.common.BackwardAnalysisKt;
import org.jetbrains.kotlin.codegen.optimization.common.OptimizationBasicInterpreter;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.common.VariableLivenessFrame;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.IincInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0000\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a1\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0003\u001a\u00020\u00042\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\u0006H\u0002\u00a2\u0006\u0002\u0010\u000b\u001a\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a(\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0007H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"analyzeLiveness", "", "Lorg/jetbrains/kotlin/codegen/optimization/common/VariableLivenessFrame;", "node", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "analyzeVisibleByDebuggerVariables", "", "Ljava/util/BitSet;", "typeAnnotatedFrames", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;[Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;)[Ljava/util/BitSet;", "defVar", "", "frame", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "useVar", "visibleByDebuggerVariables", "isInvisibleDebuggerVariable", "", "", "backend"})
public final class VariableLivenessKt {
    @NotNull
    public static final List<VariableLivenessFrame> analyzeLiveness(@NotNull MethodNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Frame<V>[] frameArray = MethodTransformer.analyze("fake", node, new OptimizationBasicInterpreter());
        Intrinsics.checkExpressionValueIsNotNull(frameArray, (String)"MethodTransformer.analyz\u2026zationBasicInterpreter())");
        Frame<V>[] typeAnnotatedFrames = frameArray;
        BitSet[] visibleByDebuggerVariables = VariableLivenessKt.analyzeVisibleByDebuggerVariables(node, typeAnnotatedFrames);
        return BackwardAnalysisKt.analyze(node, new BackwardAnalysisInterpreter<VariableLivenessFrame>(node, visibleByDebuggerVariables){
            final /* synthetic */ MethodNode $node;
            final /* synthetic */ BitSet[] $visibleByDebuggerVariables;

            @NotNull
            public VariableLivenessFrame newFrame(int maxLocals) {
                return new VariableLivenessFrame(maxLocals);
            }

            public void def(@NotNull VariableLivenessFrame frame, @NotNull AbstractInsnNode insn) {
                Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
                Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
                VariableLivenessKt.access$defVar(frame, insn);
            }

            public void use(@NotNull VariableLivenessFrame frame, @NotNull AbstractInsnNode insn) {
                Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
                Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
                VariableLivenessKt.access$useVar(frame, insn, this.$node, this.$visibleByDebuggerVariables[this.$node.instructions.indexOf(insn)]);
            }
            {
                this.$node = $captured_local_variable$0;
                this.$visibleByDebuggerVariables = $captured_local_variable$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final BitSet[] analyzeVisibleByDebuggerVariables(MethodNode node, Frame<BasicValue>[] typeAnnotatedFrames) {
        int n;
        int n2 = node.instructions.size();
        BitSet[] bitSetArray = new BitSet[n2];
        int n3 = 0;
        while (n3 < n2) {
            BitSet bitSet;
            n = n3;
            int n4 = n3++;
            BitSet[] bitSetArray2 = bitSetArray;
            boolean bl = false;
            bitSetArray2[n4] = bitSet = new BitSet(node.maxLocals);
        }
        BitSet[] res2 = bitSetArray;
        for (LocalVariableNode local2 : node.localVariables) {
            String string = local2.name;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"local.name");
            if (VariableLivenessKt.isInvisibleDebuggerVariable(string)) continue;
            n3 = node.instructions.indexOf((AbstractInsnNode)local2.start);
            n = node.instructions.indexOf((AbstractInsnNode)local2.end);
            while (n3 < n) {
                void index2;
                Type type2 = Type.getType((String)local2.desc);
                Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"Type.getType(local.desc)");
                BasicValue basicValue = typeAnnotatedFrames[index2];
                if (basicValue != null && (basicValue = (BasicValue)basicValue.getLocal(local2.index)) != null && (basicValue = basicValue.getType()) != null) {
                    if (type2.getSort() == basicValue.getSort()) {
                        res2[index2].set(local2.index);
                    }
                }
                ++index2;
            }
        }
        return res2;
    }

    private static final void defVar(VariableLivenessFrame frame, AbstractInsnNode insn) {
        if (insn instanceof VarInsnNode && UtilKt.isStoreOperation(insn)) {
            frame.markDead(((VarInsnNode)insn).var);
        }
    }

    private static final void useVar(VariableLivenessFrame frame, AbstractInsnNode insn, MethodNode node, BitSet visibleByDebuggerVariables) {
        frame.markAllAlive(visibleByDebuggerVariables);
        if (insn instanceof VarInsnNode && UtilKt.isLoadOperation(insn)) {
            frame.markAlive(((VarInsnNode)insn).var);
        } else if (insn instanceof IincInsnNode) {
            frame.markAlive(((IincInsnNode)insn).var);
        }
    }

    private static final boolean isInvisibleDebuggerVariable(@NotNull String $this$isInvisibleDebuggerVariable) {
        return StringsKt.startsWith$default((String)$this$isInvisibleDebuggerVariable, (String)"$i$a$", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$isInvisibleDebuggerVariable, (String)"$i$f$", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)$this$isInvisibleDebuggerVariable, (Object)"$completion");
    }

    public static final /* synthetic */ void access$defVar(VariableLivenessFrame frame, AbstractInsnNode insn) {
        VariableLivenessKt.defVar(frame, insn);
    }

    public static final /* synthetic */ void access$useVar(VariableLivenessFrame frame, AbstractInsnNode insn, MethodNode node, BitSet visibleByDebuggerVariables) {
        VariableLivenessKt.useVar(frame, insn, node, visibleByDebuggerVariables);
    }
}

