/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.CodeFragmentCodegen;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.PackageCodegen;
import org.jetbrains.kotlin.codegen.PackagePartCodegen;
import org.jetbrains.kotlin.codegen.ScriptCodegen;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.PackageContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.ExpectedActualDeclarationChecker;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.lazy.descriptors.PackageDescriptorUtilKt;
import org.jetbrains.org.objectweb.asm.Type;

public class PackageCodegenImpl
implements PackageCodegen {
    private final GenerationState state;
    private final Collection<KtFile> files;
    private final PackageFragmentDescriptor packageFragment;

    public PackageCodegenImpl(@NotNull GenerationState state, @NotNull Collection<KtFile> files2, @NotNull FqName packageFqName) {
        if (state == null) {
            PackageCodegenImpl.$$$reportNull$$$0(0);
        }
        if (files2 == null) {
            PackageCodegenImpl.$$$reportNull$$$0(1);
        }
        if (packageFqName == null) {
            PackageCodegenImpl.$$$reportNull$$$0(2);
        }
        this.state = state;
        this.files = files2;
        this.packageFragment = this.getOnlyPackageFragment(packageFqName);
    }

    @Override
    public void generate(@NotNull CompilationErrorHandler errorHandler) {
        if (errorHandler == null) {
            PackageCodegenImpl.$$$reportNull$$$0(3);
        }
        for (KtFile file2 : this.files) {
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            try {
                this.generateFile(file2);
                this.state.afterIndependentPart();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                VirtualFile vFile = file2.getVirtualFile();
                errorHandler.reportException(e, vFile == null ? "no file" : vFile.getUrl());
                DiagnosticUtils.throwIfRunningOnServer(e);
                if (!ApplicationManager.getApplication().isInternal()) continue;
                e.printStackTrace();
            }
        }
    }

    public static void generateClassesAndObjectsInFile(@NotNull KtFile file2, @NotNull CodegenContext<?> context2, @NotNull GenerationState state) {
        if (file2 == null) {
            PackageCodegenImpl.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            PackageCodegenImpl.$$$reportNull$$$0(5);
        }
        if (state == null) {
            PackageCodegenImpl.$$$reportNull$$$0(6);
        }
        ArrayList<KtClassOrObject> classOrObjects = new ArrayList<KtClassOrObject>();
        for (KtDeclaration declaration2 : file2.getDeclarations()) {
            if (declaration2 instanceof KtClassOrObject) {
                ClassDescriptor descriptor2 = state.getBindingContext().get(BindingContext.CLASS, declaration2);
                if (PsiUtilsKt.hasExpectModifier(declaration2) && (descriptor2 == null || !ExpectedActualDeclarationChecker.shouldGenerateExpectClass(descriptor2))) continue;
                KtClassOrObject classOrObject = (KtClassOrObject)declaration2;
                if (!state.getGenerateDeclaredClassFilter().shouldGenerateClass(classOrObject)) continue;
                classOrObjects.add(classOrObject);
                continue;
            }
            if (!(declaration2 instanceof KtScript)) continue;
            KtScript script = (KtScript)declaration2;
            if (!state.getGenerateDeclaredClassFilter().shouldGenerateScript(script)) continue;
            ScriptCodegen.createScriptCodegen(script, state, context2).generate();
        }
        List<KtClassOrObject> sortedClasses = CodegenUtilKt.sortTopLevelClassesAndPrepareContextForSealedClasses(classOrObjects, context2, state);
        for (KtClassOrObject classOrObject : sortedClasses) {
            MemberCodegen.genClassOrObject(context2, classOrObject, state, null);
        }
    }

    private void generateFile(@NotNull KtFile file2) {
        JvmFileClassInfo fileClassInfo;
        if (file2 == null) {
            PackageCodegenImpl.$$$reportNull$$$0(7);
        }
        if ((fileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve(file2)).getWithJvmMultifileClass()) {
            return;
        }
        Type fileClassType = AsmUtil.asmTypeByFqNameWithoutInnerClasses(fileClassInfo.getFileClassFqName());
        PackageContext packagePartContext = this.state.getRootContext().intoPackagePart(this.packageFragment, fileClassType, file2);
        if (file2 instanceof KtCodeFragment) {
            if (this.state.getClassBuilderMode().generateBodies && this.state.getGenerateDeclaredClassFilter().shouldGenerateCodeFragment((KtCodeFragment)file2)) {
                CodeFragmentCodegen.createCodegen((KtCodeFragment)file2, this.state, packagePartContext).generate();
            }
        } else {
            PackageCodegenImpl.generateClassesAndObjectsInFile(file2, packagePartContext, this.state);
        }
        if (!this.state.getGenerateDeclaredClassFilter().shouldGeneratePackagePart(file2)) {
            return;
        }
        if (CodegenUtil.getMemberDeclarationsToGenerate(file2).isEmpty()) {
            return;
        }
        this.state.getFactory().getPackagePartRegistry().addPart(this.packageFragment.getFqName(), fileClassType.getInternalName(), null);
        ClassBuilder builder = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.PackagePart(file2, this.packageFragment), fileClassType, (PsiFile)file2);
        new PackagePartCodegen(builder, file2, fileClassType, packagePartContext, this.state).generate();
    }

    @Nullable
    private PackageFragmentDescriptor getOnlyPackageFragment(@NotNull FqName expectedPackageFqName) {
        if (expectedPackageFqName == null) {
            PackageCodegenImpl.$$$reportNull$$$0(8);
        }
        SmartList fragments2 = new SmartList();
        for (KtFile file2 : this.files) {
            PackageFragmentDescriptor fragment = PackageDescriptorUtilKt.findPackageFragmentForFile(this.state.getModule(), file2);
            assert (fragment != null) : "package fragment is null for " + file2 + "\n" + file2.getText();
            assert (expectedPackageFqName.equals(fragment.getFqName())) : "expected package fq name: " + expectedPackageFqName + ", actual: " + fragment.getFqName();
            if (fragments2.contains((Object)fragment)) continue;
            fragments2.add((Object)fragment);
        }
        if (fragments2.size() > 1) {
            throw new IllegalStateException("More than one package fragment, files: " + this.files + " | fragments: " + fragments2);
        }
        if (fragments2.isEmpty()) {
            return null;
        }
        return (PackageFragmentDescriptor)fragments2.get(0);
    }

    @Override
    public PackageFragmentDescriptor getPackageFragment() {
        return this.packageFragment;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageFqName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedPackageFqName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/codegen/PackageCodegenImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "generate";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "generateClassesAndObjectsInFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "generateFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getOnlyPackageFragment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

