/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/AnnotationClassTargetAndRetentionChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "psi", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "getPsi", "(Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;)Lcom/intellij/psi/PsiElement;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
public final class AnnotationClassTargetAndRetentionChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        KotlinRetention retention;
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return;
        }
        if (!(declaration instanceof KtClassOrObject)) {
            return;
        }
        if (!DescriptorUtils.isAnnotationClass(descriptor2)) {
            return;
        }
        Set<KotlinTarget> set = AnnotationChecker.Companion.applicableTargetSet((ClassDescriptor)descriptor2);
        if (set == null) {
            return;
        }
        Set<KotlinTarget> targets = set;
        KotlinRetention kotlinRetention = DescriptorUtilsKt.getAnnotationRetention(descriptor2);
        if (kotlinRetention == null) {
            kotlinRetention = retention = KotlinRetention.RUNTIME;
        }
        if (targets.contains((Object)KotlinTarget.EXPRESSION) && retention != KotlinRetention.SOURCE) {
            AnnotationDescriptor annotationDescriptor;
            Annotations annotations2 = descriptor2.getAnnotations();
            FqName fqName2 = KotlinBuiltIns.FQ_NAMES.retention;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.FQ_NAMES.retention");
            AnnotationDescriptor retentionAnnotation = annotations2.findAnnotation(fqName2);
            Annotations annotations3 = descriptor2.getAnnotations();
            FqName fqName3 = KotlinBuiltIns.FQ_NAMES.target;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"KotlinBuiltIns.FQ_NAMES.target");
            AnnotationDescriptor targetAnnotation = annotations3.findAnnotation(fqName3);
            DiagnosticFactory0<PsiElement> diagnostics2 = context.getLanguageVersionSettings().supportsFeature(LanguageFeature.RestrictRetentionForExpressionAnnotations) ? Errors.RESTRICTED_RETENTION_FOR_EXPRESSION_ANNOTATION : Errors.RESTRICTED_RETENTION_FOR_EXPRESSION_ANNOTATION_WARNING;
            BindingTrace bindingTrace = context.getTrace();
            AnnotationDescriptor annotationDescriptor2 = retentionAnnotation;
            if (annotationDescriptor2 == null || (annotationDescriptor2 = this.getPsi(annotationDescriptor2)) == null) {
                AnnotationDescriptor annotationDescriptor3 = targetAnnotation;
                annotationDescriptor2 = annotationDescriptor = annotationDescriptor3 != null ? this.getPsi(annotationDescriptor3) : null;
            }
            if (annotationDescriptor2 == null) {
                annotationDescriptor = declaration;
            }
            bindingTrace.report(diagnostics2.on((PsiElement)annotationDescriptor));
        }
    }

    private final PsiElement getPsi(@NotNull AnnotationDescriptor $this$psi) {
        return (PsiElement)DescriptorToSourceUtils.getSourceFromAnnotation($this$psi);
    }
}

