/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.metadata.jvm.deserialization;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.metadata.jvm.deserialization.UtfEncodingKt;

public class BitEncoding {
    private static final boolean FORCE_8TO7_ENCODING;
    private static final char _8TO7_MODE_MARKER = '\uffff';

    private BitEncoding() {
    }

    @NotNull
    public static String[] encodeBytes(@NotNull byte[] data) {
        if (data == null) {
            BitEncoding.$$$reportNull$$$0(0);
        }
        if (!FORCE_8TO7_ENCODING) {
            String[] stringArray = UtfEncodingKt.bytesToStrings(data);
            if (stringArray == null) {
                BitEncoding.$$$reportNull$$$0(1);
            }
            return stringArray;
        }
        byte[] bytes = BitEncoding.encode8to7(data);
        BitEncoding.addModuloByte(bytes, 1);
        String[] stringArray = BitEncoding.splitBytesToStringArray(bytes);
        if (stringArray == null) {
            BitEncoding.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    @NotNull
    private static byte[] encode8to7(@NotNull byte[] data) {
        if (data == null) {
            BitEncoding.$$$reportNull$$$0(3);
        }
        int resultLength = (data.length * 8 + 6) / 7;
        byte[] result2 = new byte[resultLength];
        int byteIndex = 0;
        int bit = 0;
        for (int i = 0; i < resultLength - 1; ++i) {
            if (bit == 0) {
                result2[i] = (byte)(data[byteIndex] & 0x7F);
                bit = 7;
                continue;
            }
            int firstPart = (data[byteIndex] & 0xFF) >>> bit;
            int newBit = bit + 7 & 7;
            int secondPart = (data[++byteIndex] & (1 << newBit) - 1) << 8 - bit;
            result2[i] = (byte)(firstPart + secondPart);
            bit = newBit;
        }
        if (resultLength > 0) {
            assert (bit != 0) : "The last chunk cannot start from the input byte since otherwise at least one bit will remain unprocessed";
            assert (byteIndex == data.length - 1) : "The last 7-bit chunk should be encoded from the last input byte: " + byteIndex + " != " + (data.length - 1);
            result2[resultLength - 1] = (byte)((data[byteIndex] & 0xFF) >>> bit);
        }
        if (result2 == null) {
            BitEncoding.$$$reportNull$$$0(4);
        }
        return result2;
    }

    private static void addModuloByte(@NotNull byte[] data, int increment) {
        if (data == null) {
            BitEncoding.$$$reportNull$$$0(5);
        }
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            data[i] = (byte)(data[i] + increment & 0x7F);
        }
    }

    @NotNull
    private static String[] splitBytesToStringArray(@NotNull byte[] data) {
        if (data == null) {
            BitEncoding.$$$reportNull$$$0(6);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        int off = 0;
        int len = 2;
        boolean encodingModeAdded = false;
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            if (len >= 65534) {
                assert (len <= 65535) : "Produced strings cannot contain more than 65535 bytes: " + len;
                String string = new String(data, off, i - off);
                if (!encodingModeAdded) {
                    encodingModeAdded = true;
                    result2.add('\uffff' + string);
                } else {
                    result2.add(string);
                }
                off = i;
                len = 0;
            }
            if (data[i] == 0) {
                len += 2;
                continue;
            }
            ++len;
        }
        if (len >= 0) {
            result2.add(new String(data, off, data.length - off));
        }
        String[] stringArray = result2.toArray(new String[result2.size()]);
        if (stringArray == null) {
            BitEncoding.$$$reportNull$$$0(7);
        }
        return stringArray;
    }

    @NotNull
    public static byte[] decodeBytes(@NotNull String[] data) {
        if (data == null) {
            BitEncoding.$$$reportNull$$$0(8);
        }
        if (data.length > 0 && !data[0].isEmpty()) {
            char possibleMarker = data[0].charAt(0);
            if (possibleMarker == '\u0000') {
                byte[] byArray = UtfEncodingKt.stringsToBytes(BitEncoding.dropMarker(data));
                if (byArray == null) {
                    BitEncoding.$$$reportNull$$$0(9);
                }
                return byArray;
            }
            if (possibleMarker == '\uffff') {
                data = BitEncoding.dropMarker(data);
            }
        }
        byte[] bytes = BitEncoding.combineStringArrayIntoBytes(data);
        BitEncoding.addModuloByte(bytes, 127);
        byte[] byArray = BitEncoding.decode7to8(bytes);
        if (byArray == null) {
            BitEncoding.$$$reportNull$$$0(10);
        }
        return byArray;
    }

    @NotNull
    private static String[] dropMarker(@NotNull String[] data) {
        if (data == null) {
            BitEncoding.$$$reportNull$$$0(11);
        }
        String[] result2 = (String[])data.clone();
        result2[0] = result2[0].substring(1);
        if (result2 == null) {
            BitEncoding.$$$reportNull$$$0(12);
        }
        return result2;
    }

    @NotNull
    private static byte[] combineStringArrayIntoBytes(@NotNull String[] data) {
        if (data == null) {
            BitEncoding.$$$reportNull$$$0(13);
        }
        int resultLength = 0;
        for (String s : data) {
            assert (s.length() <= 65535) : "String is too long: " + s.length();
            resultLength += s.length();
        }
        byte[] result2 = new byte[resultLength];
        int p = 0;
        for (String s : data) {
            int n = s.length();
            for (int i = 0; i < n; ++i) {
                result2[p++] = (byte)s.charAt(i);
            }
        }
        if (result2 == null) {
            BitEncoding.$$$reportNull$$$0(14);
        }
        return result2;
    }

    @NotNull
    private static byte[] decode7to8(@NotNull byte[] data) {
        if (data == null) {
            BitEncoding.$$$reportNull$$$0(15);
        }
        int resultLength = 7 * data.length / 8;
        byte[] result2 = new byte[resultLength];
        int byteIndex = 0;
        int bit = 0;
        for (int i = 0; i < resultLength; ++i) {
            int firstPart = (data[byteIndex] & 0xFF) >>> bit;
            int secondPart = (data[++byteIndex] & (1 << bit + 1) - 1) << 7 - bit;
            result2[i] = (byte)(firstPart + secondPart);
            if (bit == 6) {
                ++byteIndex;
                bit = 0;
                continue;
            }
            ++bit;
        }
        if (result2 == null) {
            BitEncoding.$$$reportNull$$$0(16);
        }
        return result2;
    }

    static {
        String use8to7;
        try {
            use8to7 = System.getProperty("kotlin.jvm.serialization.use8to7");
        }
        catch (SecurityException e) {
            use8to7 = null;
        }
        FORCE_8TO7_ENCODING = "true".equals(use8to7);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/metadata/jvm/deserialization/BitEncoding";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/metadata/jvm/deserialization/BitEncoding";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "encodeBytes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "encode8to7";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "splitBytesToStringArray";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "decodeBytes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "dropMarker";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "combineStringArrayIntoBytes";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "decode7to8";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "encodeBytes";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "encode8to7";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addModuloByte";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "splitBytesToStringArray";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "decodeBytes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "dropMarker";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "combineStringArrayIntoBytes";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "decode7to8";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

