/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.parsing.effects;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.CallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.EffectDeclaration;
import org.jetbrains.kotlin.contracts.description.InvocationKind;
import org.jetbrains.kotlin.contracts.description.expressions.VariableReference;
import org.jetbrains.kotlin.contracts.parsing.AbstractPsiEffectParser;
import org.jetbrains.kotlin.contracts.parsing.ContractCallContext;
import org.jetbrains.kotlin.contracts.parsing.ContractParsingDiagnosticsCollector;
import org.jetbrains.kotlin.contracts.parsing.ContractsDslNames;
import org.jetbrains.kotlin.contracts.parsing.PsiContractParserDispatcher;
import org.jetbrains.kotlin.contracts.parsing.PsiContractsUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/contracts/parsing/effects/PsiCallsEffectParser;", "Lorg/jetbrains/kotlin/contracts/parsing/AbstractPsiEffectParser;", "collector", "Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingDiagnosticsCollector;", "callContext", "Lorg/jetbrains/kotlin/contracts/parsing/ContractCallContext;", "contractParserDispatcher", "Lorg/jetbrains/kotlin/contracts/parsing/PsiContractParserDispatcher;", "(Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingDiagnosticsCollector;Lorg/jetbrains/kotlin/contracts/parsing/ContractCallContext;Lorg/jetbrains/kotlin/contracts/parsing/PsiContractParserDispatcher;)V", "tryParseEffect", "Lorg/jetbrains/kotlin/contracts/description/EffectDeclaration;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "toInvocationKind", "Lorg/jetbrains/kotlin/contracts/description/InvocationKind;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "frontend"})
public final class PsiCallsEffectParser
extends AbstractPsiEffectParser {
    @Override
    @Nullable
    public EffectDeclaration tryParseEffect(@NotNull KtExpression expression2) {
        InvocationKind kind;
        Object object;
        ResolvedValueArgument kindArgument;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, this.getCallContext().getBindingContext());
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        CallableDescriptor descriptor2 = resolvedCall3.getResultingDescriptor();
        if (!PsiContractsUtilsKt.isCallsInPlaceEffectDescriptor(descriptor2)) {
            return null;
        }
        VariableReference variableReference = this.getContractParserDispatcher().parseVariable(PsiContractsUtilsKt.firstArgumentAsExpressionOrNull(resolvedCall3));
        if (variableReference == null) {
            return null;
        }
        VariableReference lambda2 = variableReference;
        List<ResolvedValueArgument> list2 = resolvedCall3.getValueArgumentsByIndex();
        ResolvedValueArgument resolvedValueArgument = kindArgument = list2 != null ? (ResolvedValueArgument)CollectionsKt.getOrNull(list2, (int)1) : null;
        InvocationKind invocationKind = resolvedValueArgument instanceof DefaultValueArgument ? InvocationKind.UNKNOWN : (resolvedValueArgument instanceof ExpressionValueArgument ? ((object = ((ExpressionValueArgument)kindArgument).getValueArgument()) != null && (object = object.getArgumentExpression()) != null ? this.toInvocationKind((KtExpression)object, this.getCallContext().getBindingContext()) : null) : (kind = null));
        if (kind == null) {
            Object object2;
            ResolvedValueArgument resolvedValueArgument2 = kindArgument;
            if (!(resolvedValueArgument2 instanceof ExpressionValueArgument)) {
                resolvedValueArgument2 = null;
            }
            if ((object2 = (ExpressionValueArgument)resolvedValueArgument2) == null || (object2 = ((ExpressionValueArgument)object2).getValueArgument()) == null || (object2 = object2.getArgumentExpression()) == null) {
                object2 = expression2;
            }
            Object reportOn = object2;
            this.getCollector().badDescription("unrecognized InvocationKind", (KtElement)reportOn);
            return null;
        }
        return new CallsEffectDeclaration(lambda2, kind);
    }

    private final InvocationKind toInvocationKind(@NotNull KtExpression $this$toInvocationKind, BindingContext bindingContext) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($this$toInvocationKind, bindingContext);
        if (resolvedCall2 == null || (resolvedCall2 = resolvedCall2.getResultingDescriptor()) == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> descriptor2 = resolvedCall2;
        if (!PsiContractsUtilsKt.isInvocationKindEnum((DeclarationDescriptor)SequencesKt.first(DescriptorUtilsKt.getParents((DeclarationDescriptor)((Object)descriptor2))))) {
            return null;
        }
        Name name2 = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((Object)descriptor2)).shortName();
        return Intrinsics.areEqual((Object)name2, (Object)ContractsDslNames.INSTANCE.getAT_MOST_ONCE_KIND()) ? InvocationKind.AT_MOST_ONCE : (Intrinsics.areEqual((Object)name2, (Object)ContractsDslNames.INSTANCE.getEXACTLY_ONCE_KIND()) ? InvocationKind.EXACTLY_ONCE : (Intrinsics.areEqual((Object)name2, (Object)ContractsDslNames.INSTANCE.getAT_LEAST_ONCE_KIND()) ? InvocationKind.AT_LEAST_ONCE : (Intrinsics.areEqual((Object)name2, (Object)ContractsDslNames.INSTANCE.getUNKNOWN_KIND()) ? InvocationKind.UNKNOWN : null)));
    }

    public PsiCallsEffectParser(@NotNull ContractParsingDiagnosticsCollector collector2, @NotNull ContractCallContext callContext, @NotNull PsiContractParserDispatcher contractParserDispatcher) {
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        Intrinsics.checkParameterIsNotNull((Object)callContext, (String)"callContext");
        Intrinsics.checkParameterIsNotNull((Object)contractParserDispatcher, (String)"contractParserDispatcher");
        super(collector2, callContext, contractParserDispatcher);
    }
}

