/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.codegen.AccessorForCompanionObjectInstanceFieldDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForConstructorDescriptor;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.CallableReferenceUtilKt;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.FieldInfo;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.SyntheticClassDescriptorForLambda;
import org.jetbrains.kotlin.codegen.VariableAsmNameManglingUtils;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.intrinsics.HashCode;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.JavaVisibilities;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmProtoBufUtil;
import org.jetbrains.kotlin.metadata.jvm.serialization.JvmStringTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.protobuf.MessageLite;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassDescriptorResolver;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.ExpectedActualDeclarationChecker;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.InlineClassManglingRulesKt;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionInfo;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class AsmUtil {
    public static final boolean IS_BUILT_WITH_ASM6 = false;
    private static final Set<Type> STRING_BUILDER_OBJECT_APPEND_ARG_TYPES = Sets.newHashSet((Object[])new Type[]{AsmTypes.getType(String.class), AsmTypes.getType(StringBuffer.class), AsmTypes.getType(CharSequence.class)});
    private static final int NO_FLAG_LOCAL = 0;
    public static final int NO_FLAG_PACKAGE_PRIVATE = 0;
    @NotNull
    private static final Map<Visibility, Integer> visibilityToAccessFlag = ImmutableMap.builder().put((Object)Visibilities.PRIVATE, (Object)2).put((Object)Visibilities.PRIVATE_TO_THIS, (Object)2).put((Object)Visibilities.PROTECTED, (Object)4).put((Object)JavaVisibilities.PROTECTED_STATIC_VISIBILITY, (Object)4).put((Object)JavaVisibilities.PROTECTED_AND_PACKAGE, (Object)4).put((Object)Visibilities.PUBLIC, (Object)1).put((Object)Visibilities.INTERNAL, (Object)1).put((Object)Visibilities.LOCAL, (Object)0).put((Object)JavaVisibilities.PACKAGE_VISIBILITY, (Object)0).build();
    public static final String THIS = "this";
    public static final String THIS_IN_DEFAULT_IMPLS = "$this";
    public static final String LABELED_THIS_FIELD = "this_";
    public static final String LABELED_THIS_PARAMETER = "$this$";
    public static final String CAPTURED_THIS_FIELD = "this$0";
    public static final String RECEIVER_PARAMETER_NAME = "$receiver";
    public static final String CAPTURED_RECEIVER_FIELD = "receiver$0";
    public static final String BOUND_REFERENCE_RECEIVER = "receiver";
    public static final String LOCAL_FUNCTION_VARIABLE_PREFIX = "$fun$";
    private static final ImmutableMap<Integer, JvmPrimitiveType> primitiveTypeByAsmSort;
    private static final ImmutableMap<Type, Type> primitiveTypeByBoxedType;

    private AsmUtil() {
    }

    @NotNull
    public static String getCapturedFieldName(@NotNull String originalName) {
        if (originalName == null) {
            AsmUtil.$$$reportNull$$$0(0);
        }
        String string = "$" + originalName;
        if (string == null) {
            AsmUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getNameForCapturedReceiverField(@NotNull CallableDescriptor descriptor2, @NotNull BindingContext bindingContext, @NotNull LanguageVersionSettings languageVersionSettings) {
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(2);
        }
        if (bindingContext == null) {
            AsmUtil.$$$reportNull$$$0(3);
        }
        if (languageVersionSettings == null) {
            AsmUtil.$$$reportNull$$$0(4);
        }
        String string = AsmUtil.getLabeledThisNameForReceiver(descriptor2, bindingContext, languageVersionSettings, LABELED_THIS_FIELD, CAPTURED_RECEIVER_FIELD);
        if (string == null) {
            AsmUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String getNameForReceiverParameter(@NotNull CallableDescriptor descriptor2, @NotNull BindingContext bindingContext, @NotNull LanguageVersionSettings languageVersionSettings) {
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(6);
        }
        if (bindingContext == null) {
            AsmUtil.$$$reportNull$$$0(7);
        }
        if (languageVersionSettings == null) {
            AsmUtil.$$$reportNull$$$0(8);
        }
        String string = AsmUtil.getLabeledThisNameForReceiver(descriptor2, bindingContext, languageVersionSettings, LABELED_THIS_PARAMETER, RECEIVER_PARAMETER_NAME);
        if (string == null) {
            AsmUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static String getLabeledThisNameForReceiver(@NotNull CallableDescriptor descriptor2, @NotNull BindingContext bindingContext, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull String prefix, @NotNull String defaultName) {
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(10);
        }
        if (bindingContext == null) {
            AsmUtil.$$$reportNull$$$0(11);
        }
        if (languageVersionSettings == null) {
            AsmUtil.$$$reportNull$$$0(12);
        }
        if (prefix == null) {
            AsmUtil.$$$reportNull$$$0(13);
        }
        if (defaultName == null) {
            AsmUtil.$$$reportNull$$$0(14);
        }
        if (!languageVersionSettings.supportsFeature(LanguageFeature.NewCapturedReceiverFieldNamingConvention)) {
            String string = defaultName;
            if (string == null) {
                AsmUtil.$$$reportNull$$$0(15);
            }
            return string;
        }
        Name callableName = null;
        if (descriptor2 instanceof FunctionDescriptor) {
            String labelName = bindingContext.get(CodegenBinding.CALL_LABEL_FOR_LAMBDA_ARGUMENT, (FunctionDescriptor)descriptor2);
            if (labelName != null) {
                String string = AsmUtil.getLabeledThisName(labelName, prefix, defaultName);
                if (string == null) {
                    AsmUtil.$$$reportNull$$$0(16);
                }
                return string;
            }
            if (descriptor2 instanceof VariableAccessorDescriptor) {
                VariableAccessorDescriptor accessor = (VariableAccessorDescriptor)descriptor2;
                callableName = accessor.getCorrespondingVariable().getName();
            }
        }
        if (callableName == null) {
            callableName = descriptor2.getName();
        }
        if (callableName.isSpecial()) {
            String string = defaultName;
            if (string == null) {
                AsmUtil.$$$reportNull$$$0(17);
            }
            return string;
        }
        String string = AsmUtil.getLabeledThisName(callableName.asString(), prefix, defaultName);
        if (string == null) {
            AsmUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public static String getLabeledThisName(@NotNull String callableName, @NotNull String prefix, @NotNull String defaultName) {
        if (callableName == null) {
            AsmUtil.$$$reportNull$$$0(19);
        }
        if (prefix == null) {
            AsmUtil.$$$reportNull$$$0(20);
        }
        if (defaultName == null) {
            AsmUtil.$$$reportNull$$$0(21);
        }
        if (!Name.isValidIdentifier(callableName)) {
            String string = defaultName;
            if (string == null) {
                AsmUtil.$$$reportNull$$$0(22);
            }
            return string;
        }
        String string = prefix + VariableAsmNameManglingUtils.mangleNameIfNeeded(callableName);
        if (string == null) {
            AsmUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public static Type boxType(@NotNull Type type2) {
        Type boxedType;
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(24);
        }
        Type type3 = (boxedType = AsmUtil.boxPrimitiveType(type2)) != null ? boxedType : type2;
        if (type3 == null) {
            AsmUtil.$$$reportNull$$$0(25);
        }
        return type3;
    }

    @NotNull
    public static Type boxType(@NotNull Type type2, @NotNull KotlinType kotlinType2, @NotNull GenerationState state2) {
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(26);
        }
        if (kotlinType2 == null) {
            AsmUtil.$$$reportNull$$$0(27);
        }
        if (state2 == null) {
            AsmUtil.$$$reportNull$$$0(28);
        }
        if (InlineClassesUtilsKt.isInlineClassType(kotlinType2)) {
            Type type3 = state2.getTypeMapper().mapTypeAsDeclaration(kotlinType2);
            if (type3 == null) {
                AsmUtil.$$$reportNull$$$0(29);
            }
            return type3;
        }
        Type boxedPrimitiveType = AsmUtil.boxPrimitiveType(type2);
        Type type4 = boxedPrimitiveType != null ? boxedPrimitiveType : type2;
        if (type4 == null) {
            AsmUtil.$$$reportNull$$$0(30);
        }
        return type4;
    }

    @Nullable
    private static Type boxPrimitiveType(@NotNull Type type2) {
        JvmPrimitiveType jvmPrimitiveType;
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(31);
        }
        return (jvmPrimitiveType = (JvmPrimitiveType)((Object)primitiveTypeByAsmSort.get((Object)type2.getSort()))) != null ? AsmUtil.asmTypeByFqNameWithoutInnerClasses(jvmPrimitiveType.getWrapperFqName()) : null;
    }

    @NotNull
    public static Type unboxType(@NotNull Type boxedType) {
        Type primitiveType;
        if (boxedType == null) {
            AsmUtil.$$$reportNull$$$0(32);
        }
        if ((primitiveType = AsmUtil.unboxPrimitiveTypeOrNull(boxedType)) == null) {
            throw new UnsupportedOperationException("Unboxing: " + boxedType);
        }
        Type type2 = primitiveType;
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(33);
        }
        return type2;
    }

    @Nullable
    public static Type unboxPrimitiveTypeOrNull(@NotNull Type boxedType) {
        if (boxedType == null) {
            AsmUtil.$$$reportNull$$$0(34);
        }
        return (Type)primitiveTypeByBoxedType.get((Object)boxedType);
    }

    public static boolean isBoxedPrimitiveType(@NotNull Type boxedType) {
        if (boxedType == null) {
            AsmUtil.$$$reportNull$$$0(35);
        }
        return primitiveTypeByBoxedType.get((Object)boxedType) != null;
    }

    @NotNull
    public static Type unboxUnlessPrimitive(@NotNull Type boxedOrPrimitiveType) {
        if (boxedOrPrimitiveType == null) {
            AsmUtil.$$$reportNull$$$0(36);
        }
        if (AsmUtil.isPrimitive(boxedOrPrimitiveType)) {
            Type type2 = boxedOrPrimitiveType;
            if (type2 == null) {
                AsmUtil.$$$reportNull$$$0(37);
            }
            return type2;
        }
        Type type3 = AsmUtil.unboxType(boxedOrPrimitiveType);
        if (type3 == null) {
            AsmUtil.$$$reportNull$$$0(38);
        }
        return type3;
    }

    public static boolean isBoxedTypeOf(@NotNull Type boxedType, @NotNull Type unboxedType) {
        if (boxedType == null) {
            AsmUtil.$$$reportNull$$$0(39);
        }
        if (unboxedType == null) {
            AsmUtil.$$$reportNull$$$0(40);
        }
        return AsmUtil.unboxPrimitiveTypeOrNull(boxedType) == unboxedType;
    }

    public static boolean isIntPrimitive(Type type2) {
        return type2 == Type.INT_TYPE || type2 == Type.SHORT_TYPE || type2 == Type.BYTE_TYPE || type2 == Type.CHAR_TYPE;
    }

    public static boolean isIntOrLongPrimitive(Type type2) {
        return AsmUtil.isIntPrimitive(type2) || type2 == Type.LONG_TYPE;
    }

    public static boolean isPrimitive(Type type2) {
        return type2.getSort() != 10 && type2.getSort() != 9;
    }

    public static boolean isPrimitiveNumberClassDescriptor(DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return false;
        }
        return KotlinBuiltIns.isPrimitiveClass((ClassDescriptor)descriptor2) && !KotlinBuiltIns.isBoolean((ClassDescriptor)descriptor2);
    }

    @NotNull
    public static Type correctElementType(@NotNull Type type2) {
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(41);
        }
        String internalName = type2.getInternalName();
        assert (internalName.charAt(0) == '[');
        Type type3 = Type.getType((String)internalName.substring(1));
        if (type3 == null) {
            AsmUtil.$$$reportNull$$$0(42);
        }
        return type3;
    }

    @NotNull
    public static Type getArrayType(@NotNull Type componentType) {
        if (componentType == null) {
            AsmUtil.$$$reportNull$$$0(43);
        }
        Type type2 = Type.getType((String)("[" + componentType.getDescriptor()));
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(44);
        }
        return type2;
    }

    @Nullable
    public static PrimitiveType asmPrimitiveTypeToLangPrimitiveType(Type type2) {
        JvmPrimitiveType jvmPrimitiveType = (JvmPrimitiveType)((Object)primitiveTypeByAsmSort.get((Object)type2.getSort()));
        return jvmPrimitiveType != null ? jvmPrimitiveType.getPrimitiveType() : null;
    }

    @NotNull
    public static Method method(@NotNull String name2, @NotNull Type returnType2, Type ... parameterTypes) {
        if (name2 == null) {
            AsmUtil.$$$reportNull$$$0(45);
        }
        if (returnType2 == null) {
            AsmUtil.$$$reportNull$$$0(46);
        }
        if (parameterTypes == null) {
            AsmUtil.$$$reportNull$$$0(47);
        }
        Method method = new Method(name2, Type.getMethodDescriptor((Type)returnType2, (Type[])parameterTypes));
        if (method == null) {
            AsmUtil.$$$reportNull$$$0(48);
        }
        return method;
    }

    public static boolean isAbstractMethod(FunctionDescriptor functionDescriptor, OwnerKind kind) {
        return (functionDescriptor.getModality() == Modality.ABSTRACT || JvmCodegenUtil.isJvmInterface(functionDescriptor.getContainingDeclaration()) && !JvmAnnotationUtilKt.hasJvmDefaultAnnotation(functionDescriptor)) && !AsmUtil.isStaticMethod(kind, functionDescriptor);
    }

    public static boolean isStaticMethod(OwnerKind kind, CallableMemberDescriptor functionDescriptor) {
        return AsmUtil.isStaticKind(kind) || KotlinTypeMapper.isStaticAccessor(functionDescriptor) || CodegenUtilKt.isJvmStaticInObjectOrClassOrInterface(functionDescriptor);
    }

    public static boolean isStaticKind(OwnerKind kind) {
        return kind == OwnerKind.PACKAGE || kind == OwnerKind.DEFAULT_IMPLS || kind == OwnerKind.ERASED_INLINE_CLASS;
    }

    public static int getMethodAsmFlags(FunctionDescriptor functionDescriptor, OwnerKind kind, GenerationState state2) {
        return AsmUtil.getMethodAsmFlags(functionDescriptor, kind, state2.getDeprecationProvider());
    }

    public static int getMethodAsmFlags(FunctionDescriptor functionDescriptor, OwnerKind kind, DeprecationResolver deprecationResolver) {
        DeclarationDescriptor containingDeclaration;
        int flags = AsmUtil.getCommonCallableFlags(functionDescriptor, kind, deprecationResolver);
        for (AnnotationCodegen.JvmFlagAnnotation flagAnnotation : AnnotationCodegen.METHOD_FLAGS) {
            flags |= flagAnnotation.getJvmFlag(functionDescriptor.getOriginal());
        }
        if (functionDescriptor.getOriginal().isExternal()) {
            flags |= 0x100;
        }
        if (CodegenUtilKt.isJvmStaticInCompanionObject(functionDescriptor)) {
            flags &= 0xFFFFFEFF;
        }
        if (!(functionDescriptor.getModality() != Modality.FINAL || functionDescriptor instanceof ConstructorDescriptor || (containingDeclaration = functionDescriptor.getContainingDeclaration()) instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind() == ClassKind.INTERFACE)) {
            flags |= 0x10;
        }
        if (AsmUtil.isStaticMethod(kind, functionDescriptor)) {
            flags |= 8;
        }
        if (AsmUtil.isAbstractMethod(functionDescriptor, kind)) {
            flags |= 0x400;
        }
        if (KotlinTypeMapper.isAccessor(functionDescriptor) || JvmAnnotationUtilKt.hasJvmSyntheticAnnotation(functionDescriptor) || AsmUtil.isInlineClassWrapperConstructor(functionDescriptor, kind) || InlineClassDescriptorResolver.isSynthesizedBoxMethod(functionDescriptor) || InlineClassDescriptorResolver.isSynthesizedUnboxMethod(functionDescriptor)) {
            flags |= 0x1000;
        }
        return flags;
    }

    private static boolean isInlineClassWrapperConstructor(@NotNull FunctionDescriptor functionDescriptor, @Nullable OwnerKind kind) {
        if (functionDescriptor == null) {
            AsmUtil.$$$reportNull$$$0(49);
        }
        if (!(functionDescriptor instanceof ConstructorDescriptor)) {
            return false;
        }
        ClassDescriptor classDescriptor2 = ((ConstructorDescriptor)functionDescriptor).getConstructedClass();
        return classDescriptor2.isInline() && kind == OwnerKind.IMPLEMENTATION;
    }

    public static int getCommonCallableFlags(FunctionDescriptor functionDescriptor, @NotNull GenerationState state2) {
        if (state2 == null) {
            AsmUtil.$$$reportNull$$$0(50);
        }
        return AsmUtil.getCommonCallableFlags(functionDescriptor, null, state2.getDeprecationProvider());
    }

    private static int getCommonCallableFlags(FunctionDescriptor functionDescriptor, @Nullable OwnerKind kind, @NotNull DeprecationResolver deprecationResolver) {
        if (deprecationResolver == null) {
            AsmUtil.$$$reportNull$$$0(51);
        }
        int flags = AsmUtil.getVisibilityAccessFlag(functionDescriptor, kind);
        flags |= AsmUtil.getVarargsFlag(functionDescriptor);
        flags |= AsmUtil.getDeprecatedAccessFlag(functionDescriptor);
        if (deprecationResolver.isDeprecatedHidden(functionDescriptor) || functionDescriptor.isSuspend() && functionDescriptor.getVisibility().equals(Visibilities.PRIVATE)) {
            flags |= 0x1000;
        }
        return flags;
    }

    public static int getVisibilityAccessFlag(@NotNull MemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(52);
        }
        return AsmUtil.getVisibilityAccessFlag(descriptor2, null);
    }

    private static int getVisibilityAccessFlag(@NotNull MemberDescriptor descriptor2, @Nullable OwnerKind kind) {
        Integer specialCase;
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(53);
        }
        if ((specialCase = AsmUtil.specialCaseVisibility(descriptor2, kind)) != null) {
            return specialCase;
        }
        Visibility visibility = descriptor2.getVisibility();
        Integer defaultMapping = AsmUtil.getVisibilityAccessFlag(visibility);
        if (defaultMapping == null) {
            throw new IllegalStateException(visibility + " is not a valid visibility in backend for " + DescriptorRenderer.DEBUG_TEXT.render(descriptor2));
        }
        return defaultMapping;
    }

    @Nullable
    public static Integer getVisibilityAccessFlag(Visibility visibility) {
        return visibilityToAccessFlag.get(visibility);
    }

    public static int getVisibilityAccessFlagForClass(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(54);
        }
        if (descriptor2 instanceof SyntheticClassDescriptorForLambda) {
            return AsmUtil.getVisibilityAccessFlagForAnonymous(descriptor2);
        }
        if (ExpectedActualDeclarationChecker.isOptionalAnnotationClass(descriptor2)) {
            return 0;
        }
        if (descriptor2.getKind() == ClassKind.ENUM_ENTRY) {
            return 0;
        }
        if (descriptor2.getVisibility() == Visibilities.PUBLIC || descriptor2.getVisibility() == Visibilities.PROTECTED || descriptor2.getVisibility() == Visibilities.LOCAL || descriptor2.getVisibility() == Visibilities.INTERNAL) {
            return 1;
        }
        return 0;
    }

    private static int getVisibilityAccessFlagForAnonymous(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(55);
        }
        return InlineUtil.isInlineOrContainingInline(descriptor2.getContainingDeclaration()) ? 1 : 0;
    }

    public static int getSyntheticAccessFlagForLambdaClass(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(56);
        }
        return descriptor2 instanceof SyntheticClassDescriptorForLambda && ((SyntheticClassDescriptorForLambda)descriptor2).isCallableReference() ? 4096 : 0;
    }

    public static int calculateInnerClassAccessFlags(@NotNull ClassDescriptor innerClass) {
        if (innerClass == null) {
            AsmUtil.$$$reportNull$$$0(57);
        }
        int visibility = innerClass instanceof SyntheticClassDescriptorForLambda ? AsmUtil.getVisibilityAccessFlagForAnonymous(innerClass) : (innerClass.getVisibility() == Visibilities.LOCAL ? 1 : AsmUtil.getVisibilityAccessFlag(innerClass));
        return visibility | AsmUtil.getSyntheticAccessFlagForLambdaClass(innerClass) | AsmUtil.innerAccessFlagsForModalityAndKind(innerClass) | (innerClass.isInner() ? 0 : 8);
    }

    private static int innerAccessFlagsForModalityAndKind(@NotNull ClassDescriptor innerClass) {
        if (innerClass == null) {
            AsmUtil.$$$reportNull$$$0(58);
        }
        switch (innerClass.getKind()) {
            case INTERFACE: {
                return 1536;
            }
            case ENUM_CLASS: {
                return 16400;
            }
            case ANNOTATION_CLASS: {
                return 9728;
            }
        }
        Modality modality = innerClass.getModality();
        if (modality == Modality.FINAL) {
            return 16;
        }
        if (modality == Modality.ABSTRACT || modality == Modality.SEALED) {
            return 1024;
        }
        return 0;
    }

    public static int getDeprecatedAccessFlag(@NotNull MemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(59);
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            return KotlinBuiltIns.isDeprecated(descriptor2) ? 131072 : AsmUtil.getDeprecatedAccessFlag(((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty());
        }
        if (KotlinBuiltIns.isDeprecated(descriptor2)) {
            return 131072;
        }
        return 0;
    }

    private static int getVarargsFlag(FunctionDescriptor functionDescriptor) {
        if (!functionDescriptor.getValueParameters().isEmpty() && functionDescriptor.getValueParameters().get(functionDescriptor.getValueParameters().size() - 1).getVarargElementType() != null) {
            return 128;
        }
        return 0;
    }

    @Nullable
    private static Integer specialCaseVisibility(@NotNull MemberDescriptor memberDescriptor, @Nullable OwnerKind kind) {
        PropertyDescriptor property;
        if (memberDescriptor == null) {
            AsmUtil.$$$reportNull$$$0(60);
        }
        DeclarationDescriptor containingDeclaration = memberDescriptor.getContainingDeclaration();
        Visibility memberVisibility = memberDescriptor.getVisibility();
        if (JvmCodegenUtil.isNonIntrinsicPrivateCompanionObjectInInterface(memberDescriptor)) {
            return 1;
        }
        if (memberDescriptor instanceof FunctionDescriptor && AsmUtil.isInlineClassWrapperConstructor((FunctionDescriptor)memberDescriptor, kind)) {
            return 2;
        }
        if (kind != OwnerKind.ERASED_INLINE_CLASS && memberDescriptor instanceof ConstructorDescriptor && !(memberDescriptor instanceof AccessorForConstructorDescriptor) && InlineClassManglingRulesKt.shouldHideConstructorDueToInlineClassTypeValueParameters((ConstructorDescriptor)memberDescriptor)) {
            return 2;
        }
        if (InlineOnlyKt.isEffectivelyInlineOnly(memberDescriptor)) {
            return 2;
        }
        if (memberVisibility == Visibilities.LOCAL && memberDescriptor instanceof CallableMemberDescriptor) {
            return 1;
        }
        if (DescriptorUtils.isEnumEntry(memberDescriptor)) {
            return 0;
        }
        if (CodegenUtilKt.isToArrayFromCollection(memberDescriptor)) {
            return 1;
        }
        if (memberDescriptor instanceof ConstructorDescriptor && DescriptorUtils.isAnonymousObject(memberDescriptor.getContainingDeclaration())) {
            return AsmUtil.getVisibilityAccessFlagForAnonymous((ClassDescriptor)memberDescriptor.getContainingDeclaration());
        }
        if (memberDescriptor instanceof SyntheticJavaPropertyDescriptor) {
            return AsmUtil.getVisibilityAccessFlag(((SyntheticJavaPropertyDescriptor)memberDescriptor).getGetMethod());
        }
        if (memberDescriptor instanceof PropertyAccessorDescriptor && (property = ((PropertyAccessorDescriptor)memberDescriptor).getCorrespondingProperty()) instanceof SyntheticJavaPropertyDescriptor) {
            FunctionDescriptor method;
            FunctionDescriptor functionDescriptor = method = memberDescriptor == property.getGetter() ? ((SyntheticJavaPropertyDescriptor)property).getGetMethod() : ((SyntheticJavaPropertyDescriptor)property).getSetMethod();
            assert (method != null) : "No get/set method in SyntheticJavaPropertyDescriptor: " + property;
            return AsmUtil.getVisibilityAccessFlag(method);
        }
        if (memberDescriptor instanceof CallableDescriptor && memberVisibility == Visibilities.PROTECTED) {
            for (CallableDescriptor overridden : DescriptorUtils.getAllOverriddenDescriptors((CallableDescriptor)((Object)memberDescriptor))) {
                if (!JvmCodegenUtil.isJvmInterface(overridden.getContainingDeclaration())) continue;
                return 1;
            }
        }
        if (!Visibilities.isPrivate(memberVisibility)) {
            return null;
        }
        if (memberDescriptor instanceof FunctionDescriptor && ((FunctionDescriptor)memberDescriptor).isSuspend()) {
            return 0;
        }
        if (memberDescriptor instanceof AccessorForCompanionObjectInstanceFieldDescriptor) {
            return 0;
        }
        if (memberDescriptor instanceof ConstructorDescriptor && DescriptorUtils.isEnumEntry(containingDeclaration)) {
            return 0;
        }
        return null;
    }

    public static Type stringValueOfType(Type type2) {
        int sort = type2.getSort();
        return sort == 10 || sort == 9 ? AsmTypes.OBJECT_TYPE : (sort == 3 || sort == 4 ? Type.INT_TYPE : type2);
    }

    private static Type stringBuilderAppendType(Type type2) {
        switch (type2.getSort()) {
            case 10: {
                return STRING_BUILDER_OBJECT_APPEND_ARG_TYPES.contains(type2) ? type2 : AsmTypes.OBJECT_TYPE;
            }
            case 9: {
                return AsmTypes.OBJECT_TYPE;
            }
            case 3: 
            case 4: {
                return Type.INT_TYPE;
            }
        }
        return type2;
    }

    public static void genThrow(@NotNull InstructionAdapter v2, @NotNull String exception, @Nullable String message) {
        if (v2 == null) {
            AsmUtil.$$$reportNull$$$0(61);
        }
        if (exception == null) {
            AsmUtil.$$$reportNull$$$0(62);
        }
        v2.anew(Type.getObjectType((String)exception));
        v2.dup();
        if (message != null) {
            v2.aconst((Object)message);
            v2.invokespecial(exception, "<init>", "(Ljava/lang/String;)V", false);
        } else {
            v2.invokespecial(exception, "<init>", "()V", false);
        }
        v2.athrow();
    }

    public static void genClosureFields(@NotNull CalculatedClosure closure, ClassBuilder v2, KotlinTypeMapper typeMapper, @NotNull LanguageVersionSettings languageVersionSettings) {
        KotlinType captureReceiverType;
        if (closure == null) {
            AsmUtil.$$$reportNull$$$0(63);
        }
        if (languageVersionSettings == null) {
            AsmUtil.$$$reportNull$$$0(64);
        }
        ArrayList<Pair<String, Type>> allFields = new ArrayList<Pair<String, Type>>();
        ClassDescriptor captureThis = closure.getCapturedOuterClassDescriptor();
        if (captureThis != null) {
            allFields.add(Pair.create((Object)CAPTURED_THIS_FIELD, (Object)typeMapper.mapType(captureThis)));
        }
        if ((captureReceiverType = closure.getCapturedReceiverFromOuterContext()) != null && !CallableReferenceUtilKt.isForCallableReference(closure)) {
            String fieldName = closure.getCapturedReceiverFieldName(typeMapper.getBindingContext(), languageVersionSettings);
            allFields.add((Pair<String, Type>)Pair.create((Object)fieldName, (Object)typeMapper.mapType(captureReceiverType)));
        }
        allFields.addAll(closure.getRecordedFields());
        AsmUtil.genClosureFields(allFields, v2);
    }

    public static void genClosureFields(List<Pair<String, Type>> allFields, ClassBuilder builder) {
        int access = 4112;
        for (Pair<String, Type> field : allFields) {
            builder.newField(JvmDeclarationOrigin.NO_ORIGIN, access, (String)field.first, ((Type)field.second).getDescriptor(), null, null);
        }
    }

    public static int genAssignInstanceFieldFromParam(FieldInfo info, int index2, InstructionAdapter iv) {
        return AsmUtil.genAssignInstanceFieldFromParam(info, index2, iv, 0, false);
    }

    public static int genAssignInstanceFieldFromParam(FieldInfo info, int index2, InstructionAdapter iv, int ownerIndex, boolean cast) {
        assert (!info.isStatic());
        Type fieldType = info.getFieldType();
        KotlinType fieldKotlinType = info.getFieldKotlinType();
        SimpleType nullableAny = fieldKotlinType != null ? fieldKotlinType.getConstructor().getBuiltIns().getNullableAnyType() : null;
        iv.load(ownerIndex, info.getOwnerType());
        if (cast) {
            iv.load(index2, AsmTypes.OBJECT_TYPE);
            StackValue.coerce(AsmTypes.OBJECT_TYPE, nullableAny, fieldType, fieldKotlinType, iv);
        } else {
            iv.load(index2, fieldType);
        }
        iv.visitFieldInsn(181, info.getOwnerInternalName(), info.getFieldName(), fieldType.getDescriptor());
        return index2 += fieldType.getSize();
    }

    public static void genStringBuilderConstructor(InstructionAdapter v2) {
        v2.visitTypeInsn(187, "java/lang/StringBuilder");
        v2.dup();
        v2.invokespecial("java/lang/StringBuilder", "<init>", "()V", false);
    }

    public static void genInvokeAppendMethod(@NotNull InstructionAdapter v2, @NotNull Type type2, @Nullable KotlinType kotlinType2) {
        if (v2 == null) {
            AsmUtil.$$$reportNull$$$0(65);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(66);
        }
        AsmUtil.genInvokeAppendMethod(v2, type2, kotlinType2, null);
    }

    public static void genInvokeAppendMethod(@NotNull InstructionAdapter v2, @NotNull Type type2, @Nullable KotlinType kotlinType2, @Nullable KotlinTypeMapper typeMapper) {
        Type appendParameterType;
        CallableMethod specializedToString;
        if (v2 == null) {
            AsmUtil.$$$reportNull$$$0(67);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(68);
        }
        if ((specializedToString = AsmUtil.getSpecializedToStringCallableMethodOrNull(kotlinType2, typeMapper)) != null) {
            specializedToString.genInvokeInstruction(v2);
            appendParameterType = AsmTypes.JAVA_STRING_TYPE;
        } else if (kotlinType2 != null && InlineClassesUtilsKt.isInlineClassType(kotlinType2)) {
            appendParameterType = AsmTypes.OBJECT_TYPE;
            SimpleType nullableAnyType = kotlinType2.getConstructor().getBuiltIns().getNullableAnyType();
            StackValue.coerce(type2, kotlinType2, appendParameterType, nullableAnyType, v2);
        } else {
            appendParameterType = AsmUtil.stringBuilderAppendType(type2);
        }
        v2.invokevirtual("java/lang/StringBuilder", "append", "(" + appendParameterType.getDescriptor() + ")Ljava/lang/StringBuilder;", false);
    }

    public static StackValue genToString(@NotNull StackValue receiver2, @NotNull Type receiverType, @Nullable KotlinType receiverKotlinType, @Nullable KotlinTypeMapper typeMapper) {
        if (receiver2 == null) {
            AsmUtil.$$$reportNull$$$0(69);
        }
        if (receiverType == null) {
            AsmUtil.$$$reportNull$$$0(70);
        }
        return StackValue.operation(AsmTypes.JAVA_STRING_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v2 -> {
            SimpleType kotlinType2;
            Type type2;
            CallableMethod specializedToString = AsmUtil.getSpecializedToStringCallableMethodOrNull(receiverKotlinType, typeMapper);
            if (specializedToString != null) {
                receiver2.put(receiverType, receiverKotlinType, (InstructionAdapter)v2);
                specializedToString.genInvokeInstruction((InstructionAdapter)v2);
                return null;
            }
            if (receiverKotlinType != null && InlineClassesUtilsKt.isInlineClassType(receiverKotlinType)) {
                type2 = AsmTypes.OBJECT_TYPE;
                kotlinType2 = receiverKotlinType.getConstructor().getBuiltIns().getNullableAnyType();
            } else {
                type2 = AsmUtil.stringValueOfType(receiverType);
                kotlinType2 = null;
            }
            receiver2.put(type2, kotlinType2, (InstructionAdapter)v2);
            v2.invokestatic("java/lang/String", "valueOf", "(" + type2.getDescriptor() + ")Ljava/lang/String;", false);
            return null;
        }));
    }

    @Nullable
    private static CallableMethod getSpecializedToStringCallableMethodOrNull(@Nullable KotlinType receiverKotlinType, @Nullable KotlinTypeMapper typeMapper) {
        if (typeMapper == null) {
            return null;
        }
        if (receiverKotlinType == null) {
            return null;
        }
        if (!InlineClassesUtilsKt.isInlineClassType(receiverKotlinType)) {
            return null;
        }
        if (receiverKotlinType.isMarkedNullable()) {
            return null;
        }
        ClassifierDescriptor receiverTypeDescriptor = receiverKotlinType.getConstructor().getDeclarationDescriptor();
        assert (receiverTypeDescriptor instanceof ClassDescriptor && ((ClassDescriptor)receiverTypeDescriptor).isInline()) : "Inline class type expected: " + receiverKotlinType;
        ClassDescriptor receiverClassDescriptor = (ClassDescriptor)receiverTypeDescriptor;
        FunctionDescriptor toStringDescriptor = receiverClassDescriptor.getUnsubstitutedMemberScope().getContributedFunctions(Name.identifier("toString"), NoLookupLocation.FROM_BACKEND).stream().filter(f -> f.getValueParameters().size() == 0 && KotlinBuiltIns.isString(f.getReturnType()) && f.getDispatchReceiverParameter() != null && f.getExtensionReceiverParameter() == null).findFirst().orElseThrow(() -> new AssertionError((Object)("'toString' not found in member scope of " + receiverClassDescriptor)));
        return typeMapper.mapToCallableMethod(toStringDescriptor, false, OwnerKind.ERASED_INLINE_CLASS);
    }

    static void genHashCode(MethodVisitor mv, InstructionAdapter iv, Type type2, JvmTarget jvmTarget) {
        if (type2.getSort() == 9) {
            Type elementType = AsmUtil.correctElementType(type2);
            if (elementType.getSort() == 10 || elementType.getSort() == 9) {
                iv.invokestatic("java/util/Arrays", "hashCode", "([Ljava/lang/Object;)I", false);
            } else {
                iv.invokestatic("java/util/Arrays", "hashCode", "(" + type2.getDescriptor() + ")I", false);
            }
        } else if (type2.getSort() == 10) {
            iv.invokevirtual("java/lang/Object", "hashCode", "()I", false);
        } else if (type2.getSort() == 1) {
            Label end = new Label();
            iv.dup();
            iv.ifeq(end);
            iv.pop();
            iv.iconst(1);
            iv.mark(end);
        } else if (JvmTarget.JVM_1_6 == jvmTarget) {
            if (type2.getSort() == 7) {
                AsmUtil.genLongHashCode(mv, iv);
            } else if (type2.getSort() == 8) {
                iv.invokestatic("java/lang/Double", "doubleToLongBits", "(D)J", false);
                AsmUtil.genLongHashCode(mv, iv);
            } else if (type2.getSort() == 6) {
                iv.invokestatic("java/lang/Float", "floatToIntBits", "(F)I", false);
            }
        } else {
            HashCode.Companion.invokeHashCode(iv, type2);
        }
    }

    private static void genLongHashCode(MethodVisitor mv, InstructionAdapter iv) {
        iv.dup2();
        iv.iconst(32);
        iv.ushr(Type.LONG_TYPE);
        iv.xor(Type.LONG_TYPE);
        mv.visitInsn(136);
    }

    public static void genInvertBoolean(InstructionAdapter v2) {
        v2.iconst(1);
        v2.xor(Type.INT_TYPE);
    }

    @NotNull
    public static StackValue genEqualsForExpressionsOnStack(@NotNull IElementType opToken, @NotNull StackValue left, @NotNull StackValue right) {
        if (opToken == null) {
            AsmUtil.$$$reportNull$$$0(71);
        }
        if (left == null) {
            AsmUtil.$$$reportNull$$$0(72);
        }
        if (right == null) {
            AsmUtil.$$$reportNull$$$0(73);
        }
        Type leftType = left.type;
        Type rightType = right.type;
        if (AsmUtil.isPrimitive(leftType) && leftType == rightType) {
            StackValue stackValue = StackValue.cmp(opToken, leftType, left, right);
            if (stackValue == null) {
                AsmUtil.$$$reportNull$$$0(74);
            }
            return stackValue;
        }
        StackValue stackValue = StackValue.operation(Type.BOOLEAN_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v2 -> {
            left.put(AsmTypes.OBJECT_TYPE, left.kotlinType, (InstructionAdapter)v2);
            right.put(AsmTypes.OBJECT_TYPE, right.kotlinType, (InstructionAdapter)v2);
            AsmUtil.genAreEqualCall(v2);
            if (opToken == KtTokens.EXCLEQ || opToken == KtTokens.EXCLEQEQEQ) {
                AsmUtil.genInvertBoolean(v2);
            }
            return Unit.INSTANCE;
        }));
        if (stackValue == null) {
            AsmUtil.$$$reportNull$$$0(75);
        }
        return stackValue;
    }

    public static void genAreEqualCall(InstructionAdapter v2) {
        v2.invokestatic("kotlin/jvm/internal/Intrinsics", "areEqual", "(Ljava/lang/Object;Ljava/lang/Object;)Z", false);
    }

    public static void genIEEE754EqualForNullableTypesCall(InstructionAdapter v2, Type left, Type right) {
        v2.invokestatic("kotlin/jvm/internal/Intrinsics", "areEqual", "(" + left.getDescriptor() + right.getDescriptor() + ")Z", false);
    }

    public static void numConst(int value, Type type2, InstructionAdapter v2) {
        if (type2 == Type.FLOAT_TYPE) {
            v2.fconst((float)value);
        } else if (type2 == Type.DOUBLE_TYPE) {
            v2.dconst((double)value);
        } else if (type2 == Type.LONG_TYPE) {
            v2.lconst((long)value);
        } else if (type2 == Type.CHAR_TYPE || type2 == Type.BYTE_TYPE || type2 == Type.SHORT_TYPE || type2 == Type.INT_TYPE) {
            v2.iconst(value);
        } else {
            throw new IllegalArgumentException("Primitive numeric type expected, got: " + type2);
        }
    }

    public static void genIncrement(Type baseType, int myDelta, InstructionAdapter v2) {
        Type operationType = AsmUtil.numberFunctionOperandType(baseType);
        AsmUtil.numConst(myDelta, operationType, v2);
        v2.add(operationType);
        StackValue.coerce(operationType, baseType, v2);
    }

    public static void swap(InstructionAdapter v2, Type stackTop, Type afterTop) {
        if (stackTop.getSize() == 1) {
            if (afterTop.getSize() == 1) {
                v2.swap();
            } else {
                v2.dupX2();
                v2.pop();
            }
        } else {
            if (afterTop.getSize() == 1) {
                v2.dup2X1();
            } else {
                v2.dup2X2();
            }
            v2.pop2();
        }
    }

    static void genNotNullAssertionsForParameters(@NotNull InstructionAdapter v2, @NotNull GenerationState state2, @NotNull FunctionDescriptor descriptor2, @NotNull FrameMap frameMap) {
        if (v2 == null) {
            AsmUtil.$$$reportNull$$$0(76);
        }
        if (state2 == null) {
            AsmUtil.$$$reportNull$$$0(77);
        }
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(78);
        }
        if (frameMap == null) {
            AsmUtil.$$$reportNull$$$0(79);
        }
        if (state2.isParamAssertionsDisabled()) {
            return;
        }
        if (descriptor2.isSuspend()) {
            return;
        }
        if (AsmUtil.getVisibilityAccessFlag(descriptor2) == 2) {
            ReceiverParameterDescriptor receiverParameter;
            if (state2.isReceiverAssertionsDisabled()) {
                return;
            }
            if (descriptor2.isOperator() && (receiverParameter = descriptor2.getExtensionReceiverParameter()) != null) {
                String name2 = AsmUtil.getNameForReceiverParameter(descriptor2, state2.getBindingContext(), state2.getLanguageVersionSettings());
                AsmUtil.genParamAssertion(v2, state2.getTypeMapper(), frameMap, receiverParameter, name2, descriptor2);
            }
            return;
        }
        ReceiverParameterDescriptor receiverParameter = descriptor2.getExtensionReceiverParameter();
        if (receiverParameter != null) {
            String name3 = AsmUtil.getNameForReceiverParameter(descriptor2, state2.getBindingContext(), state2.getLanguageVersionSettings());
            AsmUtil.genParamAssertion(v2, state2.getTypeMapper(), frameMap, receiverParameter, name3, descriptor2);
        }
        for (ValueParameterDescriptor parameter : descriptor2.getValueParameters()) {
            AsmUtil.genParamAssertion(v2, state2.getTypeMapper(), frameMap, parameter, parameter.getName().asString(), descriptor2);
        }
    }

    private static void genParamAssertion(@NotNull InstructionAdapter v2, @NotNull KotlinTypeMapper typeMapper, @NotNull FrameMap frameMap, @NotNull ParameterDescriptor parameter, @NotNull String name2, @NotNull FunctionDescriptor containingDeclaration) {
        KotlinType type2;
        if (v2 == null) {
            AsmUtil.$$$reportNull$$$0(80);
        }
        if (typeMapper == null) {
            AsmUtil.$$$reportNull$$$0(81);
        }
        if (frameMap == null) {
            AsmUtil.$$$reportNull$$$0(82);
        }
        if (parameter == null) {
            AsmUtil.$$$reportNull$$$0(83);
        }
        if (name2 == null) {
            AsmUtil.$$$reportNull$$$0(84);
        }
        if (containingDeclaration == null) {
            AsmUtil.$$$reportNull$$$0(85);
        }
        if (TypeUtils.isNullableType(type2 = parameter.getType()) || InlineClassesUtilsKt.isNullableUnderlyingType(type2)) {
            return;
        }
        Type asmType = typeMapper.mapType(type2);
        if (asmType.getSort() == 10 || asmType.getSort() == 9) {
            StackValue value;
            if (JvmCodegenUtil.isDeclarationOfBigArityFunctionInvoke(containingDeclaration) || JvmCodegenUtil.isDeclarationOfBigArityCreateCoroutineMethod(containingDeclaration)) {
                int index2 = AsmUtil.getIndexOfParameterInVarargInvokeArray(parameter);
                value = StackValue.arrayElement(AsmTypes.OBJECT_TYPE, null, StackValue.local(1, AsmUtil.getArrayType(AsmTypes.OBJECT_TYPE)), StackValue.constant(index2));
            } else {
                int index3 = frameMap.getIndex(parameter);
                value = StackValue.local(index3, asmType);
            }
            value.put(asmType, v2);
            v2.visitLdcInsn((Object)name2);
            v2.invokestatic("kotlin/jvm/internal/Intrinsics", "checkParameterIsNotNull", "(Ljava/lang/Object;Ljava/lang/String;)V", false);
        }
    }

    @NotNull
    public static StackValue genNotNullAssertions(@NotNull GenerationState state2, final @NotNull StackValue stackValue, final @Nullable RuntimeAssertionInfo runtimeAssertionInfo) {
        if (state2 == null) {
            AsmUtil.$$$reportNull$$$0(86);
        }
        if (stackValue == null) {
            AsmUtil.$$$reportNull$$$0(87);
        }
        if (state2.isCallAssertionsDisabled()) {
            StackValue stackValue2 = stackValue;
            if (stackValue2 == null) {
                AsmUtil.$$$reportNull$$$0(88);
            }
            return stackValue2;
        }
        if (runtimeAssertionInfo == null || !runtimeAssertionInfo.getNeedNotNullAssertion()) {
            StackValue stackValue3 = stackValue;
            if (stackValue3 == null) {
                AsmUtil.$$$reportNull$$$0(89);
            }
            return stackValue3;
        }
        StackValue stackValue4 = new StackValue(stackValue.type, stackValue.kotlinType){

            @Override
            public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType2, @NotNull InstructionAdapter v2) {
                if (type2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (v2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                Type innerType = stackValue.type;
                KotlinType innerKotlinType = stackValue.kotlinType;
                stackValue.put(innerType, innerKotlinType, v2);
                if (innerType.getSort() == 10 || innerType.getSort() == 9) {
                    v2.dup();
                    v2.visitLdcInsn((Object)runtimeAssertionInfo.getMessage());
                    v2.invokestatic("kotlin/jvm/internal/Intrinsics", "checkExpressionValueIsNotNull", "(Ljava/lang/Object;Ljava/lang/String;)V", false);
                }
                StackValue.coerce(innerType, innerKotlinType, type2, kotlinType2, v2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "v";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/codegen/AsmUtil$1";
                objectArray[2] = "putSelector";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (stackValue4 == null) {
            AsmUtil.$$$reportNull$$$0(90);
        }
        return stackValue4;
    }

    private static int getIndexOfParameterInVarargInvokeArray(@NotNull ParameterDescriptor parameter) {
        if (parameter == null) {
            AsmUtil.$$$reportNull$$$0(91);
        }
        if (parameter instanceof ReceiverParameterDescriptor) {
            return 0;
        }
        DeclarationDescriptor container2 = parameter.getContainingDeclaration();
        assert (parameter instanceof ValueParameterDescriptor) : "Non-extension-receiver parameter must be a value parameter: " + parameter;
        int extensionShift = ((CallableDescriptor)container2).getExtensionReceiverParameter() == null ? 0 : 1;
        return extensionShift + ((ValueParameterDescriptor)parameter).getIndex();
    }

    public static void generateVarargInvokeArityAssert(InstructionAdapter v2, int functionArity) {
        Label start = new Label();
        v2.load(1, AsmUtil.getArrayType(AsmTypes.OBJECT_TYPE));
        v2.arraylength();
        v2.iconst(functionArity);
        v2.ificmpeq(start);
        v2.visitLdcInsn((Object)("Vararg argument must contain " + functionArity + " elements."));
        v2.invokestatic("kotlin/jvm/internal/Intrinsics", "throwIllegalArgument", "(Ljava/lang/String;)V", false);
        v2.visitLabel(start);
    }

    public static void pushDefaultValueOnStack(@NotNull Type type2, @NotNull InstructionAdapter v2) {
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(92);
        }
        if (v2 == null) {
            AsmUtil.$$$reportNull$$$0(93);
        }
        if (type2.getSort() == 10 || type2.getSort() == 9) {
            v2.aconst(null);
        } else {
            AsmUtil.pushDefaultPrimitiveValueOnStack(type2, v2);
        }
    }

    public static void pushDefaultPrimitiveValueOnStack(@NotNull Type type2, @NotNull InstructionAdapter v2) {
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(94);
        }
        if (v2 == null) {
            AsmUtil.$$$reportNull$$$0(95);
        }
        if (type2.getSort() == 6) {
            v2.fconst(0.0f);
        } else if (type2.getSort() == 8) {
            v2.dconst(0.0);
        } else if (type2.getSort() == 7) {
            v2.lconst(0L);
        } else {
            v2.iconst(0);
        }
    }

    public static boolean isInstancePropertyWithStaticBackingField(@NotNull PropertyDescriptor propertyDescriptor2) {
        if (propertyDescriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(96);
        }
        return propertyDescriptor2.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE && DescriptorUtils.isObject(propertyDescriptor2.getContainingDeclaration());
    }

    public static int getVisibilityForBackingField(@NotNull PropertyDescriptor propertyDescriptor2, boolean isDelegate) {
        boolean isExtensionProperty;
        if (propertyDescriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(97);
        }
        boolean bl = isExtensionProperty = propertyDescriptor2.getExtensionReceiverParameter() != null;
        if (isDelegate || isExtensionProperty) {
            return 2;
        }
        return propertyDescriptor2.isLateInit() || JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(propertyDescriptor2) ? AsmUtil.getVisibilityAccessFlag(AsmUtil.descriptorForVisibility(propertyDescriptor2)) : 2;
    }

    private static MemberDescriptor descriptorForVisibility(@NotNull PropertyDescriptor propertyDescriptor2) {
        if (propertyDescriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(98);
        }
        if (!propertyDescriptor2.isVar()) {
            return propertyDescriptor2;
        }
        return propertyDescriptor2.getSetter() != null ? propertyDescriptor2.getSetter() : propertyDescriptor2;
    }

    public static boolean isPropertyWithBackingFieldCopyInOuterClass(@NotNull PropertyDescriptor propertyDescriptor2) {
        if (propertyDescriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(99);
        }
        DeclarationDescriptor propertyContainer = propertyDescriptor2.getContainingDeclaration();
        return propertyDescriptor2.isConst() && DescriptorUtils.isCompanionObject(propertyContainer) && JvmCodegenUtil.isJvmInterface(propertyContainer.getContainingDeclaration()) && AsmUtil.getVisibilityForBackingField(propertyDescriptor2, false) == 1;
    }

    public static Type comparisonOperandType(Type left, Type right) {
        if (left == Type.DOUBLE_TYPE || right == Type.DOUBLE_TYPE) {
            return Type.DOUBLE_TYPE;
        }
        if (left == Type.FLOAT_TYPE || right == Type.FLOAT_TYPE) {
            return Type.FLOAT_TYPE;
        }
        if (left == Type.LONG_TYPE || right == Type.LONG_TYPE) {
            return Type.LONG_TYPE;
        }
        if (left == Type.CHAR_TYPE || right == Type.CHAR_TYPE) {
            return Type.CHAR_TYPE;
        }
        return Type.INT_TYPE;
    }

    @NotNull
    public static Type numberFunctionOperandType(@NotNull Type expectedType) {
        if (expectedType == null) {
            AsmUtil.$$$reportNull$$$0(100);
        }
        if (expectedType == Type.SHORT_TYPE || expectedType == Type.BYTE_TYPE || expectedType == Type.CHAR_TYPE) {
            Type type2 = Type.INT_TYPE;
            if (type2 == null) {
                AsmUtil.$$$reportNull$$$0(101);
            }
            return type2;
        }
        Type type3 = expectedType;
        if (type3 == null) {
            AsmUtil.$$$reportNull$$$0(102);
        }
        return type3;
    }

    public static void pop(@NotNull MethodVisitor v2, @NotNull Type type2) {
        if (v2 == null) {
            AsmUtil.$$$reportNull$$$0(103);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(104);
        }
        if (type2.getSize() == 2) {
            v2.visitInsn(88);
        } else {
            v2.visitInsn(87);
        }
    }

    public static void pop2(@NotNull MethodVisitor v2, @NotNull Type type2) {
        if (v2 == null) {
            AsmUtil.$$$reportNull$$$0(105);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(106);
        }
        if (type2.getSize() == 2) {
            v2.visitInsn(88);
            v2.visitInsn(88);
        } else {
            v2.visitInsn(88);
        }
    }

    public static void dup(@NotNull InstructionAdapter v2, @NotNull Type type2) {
        if (v2 == null) {
            AsmUtil.$$$reportNull$$$0(107);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(108);
        }
        AsmUtil.dup(v2, type2.getSize());
    }

    private static void dup(@NotNull InstructionAdapter v2, int size) {
        if (v2 == null) {
            AsmUtil.$$$reportNull$$$0(109);
        }
        if (size == 2) {
            v2.dup2();
        } else if (size == 1) {
            v2.dup();
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static void dupx(@NotNull InstructionAdapter v2, @NotNull Type type2) {
        if (v2 == null) {
            AsmUtil.$$$reportNull$$$0(110);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(111);
        }
        AsmUtil.dupx(v2, type2.getSize());
    }

    private static void dupx(@NotNull InstructionAdapter v2, int size) {
        if (v2 == null) {
            AsmUtil.$$$reportNull$$$0(112);
        }
        if (size == 2) {
            v2.dup2X2();
        } else if (size == 1) {
            v2.dupX1();
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static void dup(@NotNull InstructionAdapter v2, @NotNull Type topOfStack, @NotNull Type afterTop) {
        if (v2 == null) {
            AsmUtil.$$$reportNull$$$0(113);
        }
        if (topOfStack == null) {
            AsmUtil.$$$reportNull$$$0(114);
        }
        if (afterTop == null) {
            AsmUtil.$$$reportNull$$$0(115);
        }
        if (topOfStack.getSize() == 0 && afterTop.getSize() == 0) {
            return;
        }
        if (topOfStack.getSize() == 0) {
            AsmUtil.dup(v2, afterTop);
        } else if (afterTop.getSize() == 0) {
            AsmUtil.dup(v2, topOfStack);
        } else if (afterTop.getSize() == 1) {
            if (topOfStack.getSize() == 1) {
                AsmUtil.dup(v2, 2);
            } else {
                v2.dup2X1();
                v2.pop2();
                v2.dupX2();
                v2.dupX2();
                v2.pop();
                v2.dup2X1();
            }
        } else {
            throw new UnsupportedOperationException("Don't know how generate dup3/dup4 for: " + topOfStack + " and " + afterTop);
        }
    }

    public static void writeAnnotationData(@NotNull AnnotationVisitor av, @NotNull DescriptorSerializer serializer2, @NotNull MessageLite message) {
        if (av == null) {
            AsmUtil.$$$reportNull$$$0(116);
        }
        if (serializer2 == null) {
            AsmUtil.$$$reportNull$$$0(117);
        }
        if (message == null) {
            AsmUtil.$$$reportNull$$$0(118);
        }
        AsmUtil.writeAnnotationData(av, message, (JvmStringTable)((Object)serializer2.getStringTable()));
    }

    public static void writeAnnotationData(@NotNull AnnotationVisitor av, @NotNull MessageLite message, @NotNull JvmStringTable stringTable) {
        if (av == null) {
            AsmUtil.$$$reportNull$$$0(119);
        }
        if (message == null) {
            AsmUtil.$$$reportNull$$$0(120);
        }
        if (stringTable == null) {
            AsmUtil.$$$reportNull$$$0(121);
        }
        AsmUtil.writeAnnotationData(av, JvmProtoBufUtil.writeData(message, stringTable), ArrayUtil.toStringArray(stringTable.getStrings()));
    }

    public static void writeAnnotationData(@NotNull AnnotationVisitor av, @NotNull String[] data, @NotNull String[] strings) {
        if (av == null) {
            AsmUtil.$$$reportNull$$$0(122);
        }
        if (data == null) {
            AsmUtil.$$$reportNull$$$0(123);
        }
        if (strings == null) {
            AsmUtil.$$$reportNull$$$0(124);
        }
        AnnotationVisitor dataVisitor = av.visitArray("d1");
        for (String string : data) {
            dataVisitor.visit(null, (Object)string);
        }
        dataVisitor.visitEnd();
        AnnotationVisitor stringsVisitor = av.visitArray("d2");
        for (String string : strings) {
            stringsVisitor.visit(null, (Object)string);
        }
        stringsVisitor.visitEnd();
    }

    @NotNull
    public static Type asmTypeByFqNameWithoutInnerClasses(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            AsmUtil.$$$reportNull$$$0(125);
        }
        Type type2 = Type.getObjectType((String)AsmUtil.internalNameByFqNameWithoutInnerClasses(fqName2));
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(126);
        }
        return type2;
    }

    @NotNull
    public static Type asmTypeByClassId(@NotNull ClassId classId) {
        if (classId == null) {
            AsmUtil.$$$reportNull$$$0(127);
        }
        Type type2 = Type.getObjectType((String)classId.asString().replace('.', '$'));
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(128);
        }
        return type2;
    }

    @NotNull
    public static String internalNameByFqNameWithoutInnerClasses(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            AsmUtil.$$$reportNull$$$0(129);
        }
        String string = JvmClassName.byFqNameWithoutInnerClasses(fqName2).getInternalName();
        if (string == null) {
            AsmUtil.$$$reportNull$$$0(130);
        }
        return string;
    }

    public static void putJavaLangClassInstance(@NotNull InstructionAdapter v2, @NotNull Type type2, @Nullable KotlinType kotlinType2, @NotNull GenerationState state2) {
        if (v2 == null) {
            AsmUtil.$$$reportNull$$$0(131);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(132);
        }
        if (state2 == null) {
            AsmUtil.$$$reportNull$$$0(133);
        }
        if (kotlinType2 != null && InlineClassesUtilsKt.isInlineClassType(kotlinType2)) {
            v2.aconst((Object)AsmUtil.boxType(type2, kotlinType2, state2));
        } else if (AsmUtil.isPrimitive(type2)) {
            v2.getstatic(AsmUtil.boxType(type2).getInternalName(), "TYPE", "Ljava/lang/Class;");
        } else {
            v2.aconst((Object)type2);
        }
    }

    public static void wrapJavaClassIntoKClass(@NotNull InstructionAdapter v2) {
        if (v2 == null) {
            AsmUtil.$$$reportNull$$$0(134);
        }
        v2.invokestatic("kotlin/jvm/internal/Reflection", "getOrCreateKotlinClass", Type.getMethodDescriptor((Type)AsmTypes.K_CLASS_TYPE, (Type[])new Type[]{AsmTypes.getType(Class.class)}), false);
    }

    public static void wrapJavaClassesIntoKClasses(@NotNull InstructionAdapter v2) {
        if (v2 == null) {
            AsmUtil.$$$reportNull$$$0(135);
        }
        v2.invokestatic("kotlin/jvm/internal/Reflection", "getOrCreateKotlinClasses", Type.getMethodDescriptor((Type)AsmTypes.K_CLASS_ARRAY_TYPE, (Type[])new Type[]{AsmTypes.getType(Class[].class)}), false);
    }

    public static int getReceiverIndex(@NotNull CodegenContext context, @NotNull CallableMemberDescriptor descriptor2) {
        OwnerKind kind;
        if (context == null) {
            AsmUtil.$$$reportNull$$$0(136);
        }
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(137);
        }
        return (kind = context.getContextKind()) != OwnerKind.DEFAULT_IMPLS && AsmUtil.isStaticMethod(kind, descriptor2) ? 0 : 1;
    }

    static {
        ImmutableMap.Builder typeBySortBuilder = ImmutableMap.builder();
        ImmutableMap.Builder typeByWrapperBuilder = ImmutableMap.builder();
        for (JvmPrimitiveType primitiveType : JvmPrimitiveType.values()) {
            Type asmType = Type.getType((String)primitiveType.getDesc());
            typeBySortBuilder.put((Object)asmType.getSort(), (Object)primitiveType);
            typeByWrapperBuilder.put((Object)AsmUtil.asmTypeByFqNameWithoutInnerClasses(primitiveType.getWrapperFqName()), (Object)asmType);
        }
        primitiveTypeByAsmSort = typeBySortBuilder.build();
        primitiveTypeByBoxedType = typeByWrapperBuilder.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 33: 
            case 37: 
            case 38: 
            case 42: 
            case 44: 
            case 48: 
            case 74: 
            case 75: 
            case 88: 
            case 89: 
            case 90: 
            case 101: 
            case 102: 
            case 126: 
            case 128: 
            case 130: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 33: 
            case 37: 
            case 38: 
            case 42: 
            case 44: 
            case 48: 
            case 74: 
            case 75: 
            case 88: 
            case 89: 
            case 90: 
            case 101: 
            case 102: 
            case 126: 
            case 128: 
            case 130: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalName";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 33: 
            case 37: 
            case 38: 
            case 42: 
            case 44: 
            case 48: 
            case 74: 
            case 75: 
            case 88: 
            case 89: 
            case 90: 
            case 101: 
            case 102: 
            case 126: 
            case 128: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/AsmUtil";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 59: 
            case 78: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageVersionSettings";
                break;
            }
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableName";
                break;
            }
            case 24: 
            case 26: 
            case 31: 
            case 41: 
            case 66: 
            case 68: 
            case 92: 
            case 94: 
            case 104: 
            case 106: 
            case 108: 
            case 111: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlinType";
                break;
            }
            case 28: 
            case 50: 
            case 77: 
            case 86: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 32: 
            case 34: 
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boxedType";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boxedOrPrimitiveType";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unboxedType";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 45: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deprecationResolver";
                break;
            }
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerClass";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberDescriptor";
                break;
            }
            case 61: 
            case 65: 
            case 67: 
            case 76: 
            case 80: 
            case 93: 
            case 95: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 110: 
            case 112: 
            case 113: 
            case 131: 
            case 134: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = BOUND_REFERENCE_RECEIVER;
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverType";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opToken";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 79: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameMap";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 83: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingDeclaration";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackValue";
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topOfStack";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterTop";
                break;
            }
            case 116: 
            case 119: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "av";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 118: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringTable";
                break;
            }
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 125: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classId";
                break;
            }
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/AsmUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapturedFieldName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForCapturedReceiverField";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForReceiverParameter";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabeledThisNameForReceiver";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabeledThisName";
                break;
            }
            case 25: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "boxType";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "unboxType";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "unboxUnlessPrimitive";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "correctElementType";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayType";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "method";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "genEqualsForExpressionsOnStack";
                break;
            }
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "genNotNullAssertions";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "numberFunctionOperandType";
                break;
            }
            case 126: {
                objectArray = objectArray2;
                objectArray2[1] = "asmTypeByFqNameWithoutInnerClasses";
                break;
            }
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "asmTypeByClassId";
                break;
            }
            case 130: {
                objectArray = objectArray2;
                objectArray2[1] = "internalNameByFqNameWithoutInnerClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCapturedFieldName";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 33: 
            case 37: 
            case 38: 
            case 42: 
            case 44: 
            case 48: 
            case 74: 
            case 75: 
            case 88: 
            case 89: 
            case 90: 
            case 101: 
            case 102: 
            case 126: 
            case 128: 
            case 130: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNameForCapturedReceiverField";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNameForReceiverParameter";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLabeledThisNameForReceiver";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getLabeledThisName";
                break;
            }
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "boxType";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "boxPrimitiveType";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "unboxType";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "unboxPrimitiveTypeOrNull";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isBoxedPrimitiveType";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "unboxUnlessPrimitive";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isBoxedTypeOf";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "correctElementType";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getArrayType";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "method";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isInlineClassWrapperConstructor";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getCommonCallableFlags";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getVisibilityAccessFlag";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getVisibilityAccessFlagForClass";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getVisibilityAccessFlagForAnonymous";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getSyntheticAccessFlagForLambdaClass";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "calculateInnerClassAccessFlags";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "innerAccessFlagsForModalityAndKind";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getDeprecatedAccessFlag";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "specialCaseVisibility";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "genThrow";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "genClosureFields";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "genInvokeAppendMethod";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "genToString";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "genEqualsForExpressionsOnStack";
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "genNotNullAssertionsForParameters";
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "genParamAssertion";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "genNotNullAssertions";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getIndexOfParameterInVarargInvokeArray";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "pushDefaultValueOnStack";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "pushDefaultPrimitiveValueOnStack";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "isInstancePropertyWithStaticBackingField";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "getVisibilityForBackingField";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "descriptorForVisibility";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyWithBackingFieldCopyInOuterClass";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "numberFunctionOperandType";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "pop";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "pop2";
                break;
            }
            case 107: 
            case 108: 
            case 109: 
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "dup";
                break;
            }
            case 110: 
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "dupx";
                break;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "writeAnnotationData";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "asmTypeByFqNameWithoutInnerClasses";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "asmTypeByClassId";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "internalNameByFqNameWithoutInnerClasses";
                break;
            }
            case 131: 
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "putJavaLangClassInstance";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "wrapJavaClassIntoKClass";
                break;
            }
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "wrapJavaClassesIntoKClasses";
                break;
            }
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "getReceiverIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 33: 
            case 37: 
            case 38: 
            case 42: 
            case 44: 
            case 48: 
            case 74: 
            case 75: 
            case 88: 
            case 89: 
            case 90: 
            case 101: 
            case 102: 
            case 126: 
            case 128: 
            case 130: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

