/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.LabelNormalizationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.RedundantNopsCleanupMethodTransformerKt;
import org.jetbrains.kotlin.codegen.optimization.common.InsnSequence;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LineNumberNode;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u001e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/RedundantNopsCleanupMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "()V", "recordNopsRequiredForDebugger", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "requiredNops", "", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "recordNopsRequiredForTryCatchBlocks", "transform", "internalClassName", "", "backend"})
public final class RedundantNopsCleanupMethodTransformer
extends MethodTransformer {
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkParameterIsNotNull((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkParameterIsNotNull((Object)methodNode, (String)"methodNode");
        new LabelNormalizationMethodTransformer().transform(internalClassName, methodNode);
        HashSet requiredNops = new HashSet();
        this.recordNopsRequiredForTryCatchBlocks(methodNode, requiredNops);
        this.recordNopsRequiredForDebugger(methodNode, requiredNops);
        InsnList insnList = methodNode.instructions;
        Intrinsics.checkExpressionValueIsNotNull((Object)insnList, (String)"methodNode.instructions");
        AbstractInsnNode current = insnList.getFirst();
        while (current != null) {
            if (current.getOpcode() == 0 && !requiredNops.contains(current)) {
                AbstractInsnNode toRemove = current;
                current = current.getNext();
                methodNode.instructions.remove(toRemove);
                continue;
            }
            current = current.getNext();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void recordNopsRequiredForDebugger(MethodNode methodNode, Set<AbstractInsnNode> requiredNops) {
        void $receiver$iv$iv;
        Object $receiver$iv;
        for (AbstractInsnNode insn : methodNode.instructions) {
            AbstractInsnNode it;
            AbstractInsnNode finger$iv;
            if (!(insn instanceof LineNumberNode)) continue;
            $receiver$iv = insn;
            for (finger$iv = $receiver$iv.getNext(); finger$iv != null && !((it = finger$iv) instanceof LineNumberNode && ((LineNumberNode)it).line != ((LineNumberNode)insn).line); finger$iv = finger$iv.getNext()) {
            }
            AbstractInsnNode nextLineNumber = finger$iv;
            CollectionsKt.addIfNotNull((Collection)requiredNops, RedundantNopsCleanupMethodTransformerKt.getRequiredNopInRange(insn, nextLineNumber));
        }
        RedundantNopsCleanupMethodTransformer redundantNopsCleanupMethodTransformer = this;
        RedundantNopsCleanupMethodTransformer $receiver = redundantNopsCleanupMethodTransformer;
        Object $receiver2 = $receiver$iv = new HashSet();
        for (LocalVariableNode localVariable : methodNode.localVariables) {
            ((HashSet)$receiver2).add(localVariable.start);
            ((HashSet)$receiver2).add(localVariable.end);
        }
        Object labels2 = $receiver$iv;
        AbstractInsnNode[] abstractInsnNodeArray = methodNode.instructions.toArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNodeArray, (String)"methodNode.instructions.toArray()");
        $receiver2 = $receiver$iv = abstractInsnNodeArray;
        Collection destination$iv$iv = new ArrayList();
        for (void element$iv$iv : $receiver$iv$iv) {
            void it = element$iv$iv;
            if (!kotlin.collections.CollectionsKt.contains((Iterable)((Iterable)labels2), (Object)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        int n = 0;
        List localVariableLabels = (List)destination$iv$iv;
        int n2 = localVariableLabels.size() - 2;
        if (n <= n2) {
            while (true) {
                boolean bl;
                AbstractInsnNode end;
                AbstractInsnNode begin;
                void i;
                block8: {
                    begin = (AbstractInsnNode)localVariableLabels.get((int)i);
                    end = (AbstractInsnNode)localVariableLabels.get((int)(i + true));
                    AbstractInsnNode abstractInsnNode = begin;
                    Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode, (String)"begin");
                    Sequence $receiver$iv2 = new InsnSequence(abstractInsnNode, end);
                    for (Object element$iv : $receiver$iv2) {
                        AbstractInsnNode it = (AbstractInsnNode)element$iv;
                        if (!requiredNops.contains(it)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
                if (!bl) {
                    CollectionsKt.addIfNotNull((Collection)requiredNops, RedundantNopsCleanupMethodTransformerKt.getRequiredNopInRange(begin, end));
                }
                if (i == n2) break;
                ++i;
            }
        }
    }

    private final void recordNopsRequiredForTryCatchBlocks(MethodNode methodNode, Set<AbstractInsnNode> requiredNops) {
        for (TryCatchBlockNode tcb : methodNode.tryCatchBlocks) {
            AbstractInsnNode nop;
            AbstractInsnNode it;
            AbstractInsnNode finger$iv;
            LabelNode labelNode = tcb.start;
            Intrinsics.checkExpressionValueIsNotNull((Object)labelNode, (String)"tcb.start");
            AbstractInsnNode $receiver$iv = (AbstractInsnNode)labelNode;
            for (finger$iv = $receiver$iv.getNext(); finger$iv != null && !UtilKt.isMeaningful(it = finger$iv); finger$iv = finger$iv.getNext()) {
            }
            AbstractInsnNode abstractInsnNode = nop = finger$iv;
            if (abstractInsnNode == null) continue;
            if (abstractInsnNode.getOpcode() != 0) continue;
            requiredNops.add(nop);
        }
    }
}

