/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSdkUtil {
    @NotNull
    public static List<File> getJdkClassesRoots(@NotNull File home, boolean isJre) {
        File classesDir;
        String[] ibmJdkVmJarDirs;
        Object toolsJar;
        File[] jarDirs;
        if (SystemInfo.isMac && !home.getName().startsWith("mockJDK")) {
            File libEndorsedDir;
            File libExtDir;
            File classesDir2;
            File libDir;
            File openJdkRtJar = new File(home, "jre/lib/rt.jar");
            if (openJdkRtJar.isFile()) {
                libDir = new File(home, "lib");
                classesDir2 = openJdkRtJar.getParentFile();
                libExtDir = new File(openJdkRtJar.getParentFile(), "ext");
                libEndorsedDir = new File(libDir, "endorsed");
                jarDirs = new File[]{libEndorsedDir, libDir, classesDir2, libExtDir};
            } else {
                libDir = new File(home, "lib");
                classesDir2 = new File(home, "../Classes");
                libExtDir = new File(libDir, "ext");
                libEndorsedDir = new File(libDir, "endorsed");
                jarDirs = new File[]{libEndorsedDir, libDir, classesDir2, libExtDir};
            }
        } else if (new File(home, "lib/jrt-fs.jar").exists()) {
            jarDirs = ArrayUtil.EMPTY_FILE_ARRAY;
        } else {
            File libDir = new File(home, isJre ? "lib" : "jre/lib");
            File libExtDir = new File(libDir, "ext");
            File libEndorsedDir = new File(libDir, "endorsed");
            jarDirs = new File[]{libEndorsedDir, libDir, libExtDir};
        }
        FileFilter jarFileFilter = FileFilters.filesWithExtension((String)"jar");
        THashSet pathFilter = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
        ArrayList rootFiles = ContainerUtil.newArrayList();
        if (Registry.is((String)"project.structure.add.tools.jar.to.new.jdk") && ((File)(toolsJar = new File(home, "lib/tools.jar"))).isFile()) {
            rootFiles.add(toolsJar);
        }
        for (File jarDir : jarDirs) {
            File[] jarFiles;
            if (jarDir == null || !jarDir.isDirectory()) continue;
            for (File jarFile : jarFiles = (File[])ObjectUtils.notNull((Object)jarDir.listFiles(jarFileFilter), (Object)ArrayUtil.EMPTY_FILE_ARRAY)) {
                String canonicalPath;
                String jarFileName = jarFile.getName();
                if (jarFileName.equals("alt-rt.jar") || jarFileName.equals("alt-string.jar") || (canonicalPath = JavaSdkUtil.getCanonicalPath(jarFile)) == null || !pathFilter.add(canonicalPath)) continue;
                rootFiles.add(jarFile);
            }
        }
        for (String relativePath : ibmJdkVmJarDirs = new String[]{"bin/default", "lib/i386/default", "lib/amd64/default"}) {
            File[] vmJarDirs;
            File libDir = new File(home, isJre ? relativePath : "jre/" + relativePath);
            for (File dir : vmJarDirs = (File[])ObjectUtils.notNull((Object)libDir.listFiles(FileUtilRt.ALL_DIRECTORIES), (Object)ArrayUtil.EMPTY_FILE_ARRAY)) {
                File vmJar;
                if (!dir.getName().startsWith("jclSC") || !(vmJar = new File(dir, "vm.jar")).isFile()) continue;
                rootFiles.add(vmJar);
            }
        }
        File classesZip = new File(home, "lib/classes.zip");
        if (classesZip.isFile()) {
            rootFiles.add(classesZip);
        }
        if (rootFiles.isEmpty() && (classesDir = new File(home, "classes")).isDirectory()) {
            rootFiles.add(classesDir);
        }
        return rootFiles;
    }

    @Nullable
    private static String getCanonicalPath(File file2) {
        try {
            return file2.getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
    }
}

