/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.results;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.FlatSignatureForResolvedCallKt;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadingConflictResolver;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.tower.TowerUtilsKt;

public class ResolutionResultsHandler {
    private final OverloadingConflictResolver<MutableResolvedCall<?>> overloadingConflictResolver;

    public ResolutionResultsHandler(@NotNull KotlinBuiltIns builtIns, @NotNull TypeSpecificityComparator specificityComparator) {
        this.overloadingConflictResolver = FlatSignatureForResolvedCallKt.createOverloadingConflictResolver(builtIns, specificityComparator);
    }

    @NotNull
    public <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> computeResultAndReportErrors(@NotNull CallResolutionContext context, @NotNull TracingStrategy tracing, @NotNull Collection<MutableResolvedCall<D>> candidates2, @NotNull LanguageVersionSettings languageVersionSettings) {
        LinkedHashSet successfulCandidates = Sets.newLinkedHashSet();
        LinkedHashSet failedCandidates = Sets.newLinkedHashSet();
        LinkedHashSet incompleteCandidates = Sets.newLinkedHashSet();
        LinkedHashSet candidatesWithWrongReceiver = Sets.newLinkedHashSet();
        for (MutableResolvedCall<D> candidateCall : candidates2) {
            ResolutionStatus status2 = candidateCall.getStatus();
            assert (status2 != ResolutionStatus.UNKNOWN_STATUS) : "No resolution for " + candidateCall.getCandidateDescriptor();
            if (status2.isSuccess()) {
                successfulCandidates.add(candidateCall);
                continue;
            }
            if (status2 == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) {
                incompleteCandidates.add(candidateCall);
                continue;
            }
            if (candidateCall.getStatus() == ResolutionStatus.RECEIVER_TYPE_ERROR) {
                candidatesWithWrongReceiver.add(candidateCall);
                continue;
            }
            if (candidateCall.getStatus() == ResolutionStatus.RECEIVER_PRESENCE_ERROR) continue;
            failedCandidates.add(candidateCall);
        }
        if (!successfulCandidates.isEmpty() || !incompleteCandidates.isEmpty()) {
            return this.computeSuccessfulResult(context, tracing, successfulCandidates, incompleteCandidates, context.checkArguments, languageVersionSettings);
        }
        if (!failedCandidates.isEmpty()) {
            return this.computeFailedResult(tracing, context.trace, failedCandidates, context.checkArguments, languageVersionSettings);
        }
        if (!candidatesWithWrongReceiver.isEmpty()) {
            tracing.unresolvedReferenceWrongReceiver(context.trace, candidatesWithWrongReceiver);
            return OverloadResolutionResultsImpl.candidatesWithWrongReceiver(candidatesWithWrongReceiver);
        }
        tracing.unresolvedReference(context.trace);
        return OverloadResolutionResultsImpl.nameNotFound();
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> computeSuccessfulResult(@NotNull CallResolutionContext context, @NotNull TracingStrategy tracing, @NotNull Set<MutableResolvedCall<D>> successfulCandidates, @NotNull Set<MutableResolvedCall<D>> incompleteCandidates, @NotNull CheckArgumentTypesMode checkArgumentsMode, @NotNull LanguageVersionSettings languageVersionSettings) {
        LinkedHashSet successfulAndIncomplete = Sets.newLinkedHashSet();
        successfulAndIncomplete.addAll(successfulCandidates);
        successfulAndIncomplete.addAll(incompleteCandidates);
        OverloadResolutionResultsImpl<D> results = this.chooseAndReportMaximallySpecific(successfulAndIncomplete, true, context.isDebuggerContext, checkArgumentsMode, languageVersionSettings);
        if (results.isSingleResult()) {
            ResolvedCall resultingCall = results.getResultingCall();
            resultingCall.getTrace().moveAllMyDataTo(context.trace);
            if (resultingCall.getStatus() == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) {
                return OverloadResolutionResultsImpl.incompleteTypeInference(resultingCall);
            }
        }
        if (results.isAmbiguity()) {
            tracing.recordAmbiguity(context.trace, results.getResultingCalls());
            boolean allCandidatesIncomplete = ResolutionResultsHandler.allIncomplete(results.getResultingCalls());
            if (context.checkArguments != CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS || !CallUtilKt.hasUnresolvedArguments(context.call, context)) {
                if (allCandidatesIncomplete) {
                    tracing.cannotCompleteResolve(context.trace, results.getResultingCalls());
                } else {
                    tracing.ambiguity(context.trace, results.getResultingCalls());
                }
            }
            if (allCandidatesIncomplete) {
                return OverloadResolutionResultsImpl.incompleteTypeInference(results.getResultingCalls());
            }
        }
        return results;
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> computeFailedResult(@NotNull TracingStrategy tracing, @NotNull BindingTrace trace, @NotNull Set<MutableResolvedCall<D>> failedCandidates, @NotNull CheckArgumentTypesMode checkArgumentsMode, @NotNull LanguageVersionSettings languageVersionSettings) {
        if (failedCandidates.size() == 1) {
            return ResolutionResultsHandler.recordFailedInfo(tracing, trace, failedCandidates);
        }
        for (EnumSet<ResolutionStatus> severityLevel : ResolutionStatus.SEVERITY_LEVELS) {
            LinkedHashSet thisLevel = Sets.newLinkedHashSet();
            for (MutableResolvedCall<D> candidate2 : failedCandidates) {
                if (!severityLevel.contains((Object)candidate2.getStatus())) continue;
                thisLevel.add(candidate2);
            }
            if (thisLevel.isEmpty()) continue;
            if (severityLevel.contains((Object)ResolutionStatus.ARGUMENTS_MAPPING_ERROR)) {
                OverloadingConflictResolver<MutableResolvedCall<?>> myResolver = this.overloadingConflictResolver;
                return ResolutionResultsHandler.recordFailedInfo(tracing, trace, myResolver.filterOutEquivalentCalls(new LinkedHashSet(thisLevel)));
            }
            OverloadResolutionResultsImpl<D> results = this.chooseAndReportMaximallySpecific(thisLevel, false, false, checkArgumentsMode, languageVersionSettings);
            return ResolutionResultsHandler.recordFailedInfo(tracing, trace, results.getResultingCalls());
        }
        throw new AssertionError((Object)("Should not be reachable, cause every status must belong to some level: " + failedCandidates));
    }

    @NotNull
    private static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> recordFailedInfo(@NotNull TracingStrategy tracing, @NotNull BindingTrace trace, @NotNull Collection<MutableResolvedCall<D>> candidates2) {
        if (candidates2.size() == 1) {
            MutableResolvedCall<D> failed = candidates2.iterator().next();
            failed.getTrace().moveAllMyDataTo(trace);
            return OverloadResolutionResultsImpl.singleFailedCandidate(failed);
        }
        tracing.noneApplicable(trace, candidates2);
        tracing.recordAmbiguity(trace, candidates2);
        return OverloadResolutionResultsImpl.manyFailedCandidates(candidates2);
    }

    private static <D extends CallableDescriptor> boolean allIncomplete(@NotNull Collection<MutableResolvedCall<D>> results) {
        for (MutableResolvedCall<D> result2 : results) {
            if (result2.getStatus() == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> chooseAndReportMaximallySpecific(@NotNull Set<MutableResolvedCall<D>> candidates2, boolean discriminateGenerics, boolean isDebuggerContext, @NotNull CheckArgumentTypesMode checkArgumentsMode, @NotNull LanguageVersionSettings languageVersionSettings) {
        Set<MutableResolvedCall<D>> specificCalls;
        OverloadingConflictResolver<MutableResolvedCall<?>> myResolver = this.overloadingConflictResolver;
        Set<MutableResolvedCall<D>> refinedCandidates = candidates2;
        if (!languageVersionSettings.supportsFeature(LanguageFeature.RefinedSamAdaptersPriority)) {
            HashSet<MutableResolvedCall<D>> nonSynthesized = new HashSet<MutableResolvedCall<D>>();
            for (MutableResolvedCall<D> candidate2 : candidates2) {
                if (TowerUtilsKt.isSynthesized(candidate2.getCandidateDescriptor())) continue;
                nonSynthesized.add(candidate2);
            }
            if (!nonSynthesized.isEmpty()) {
                refinedCandidates = nonSynthesized;
            }
        }
        if ((specificCalls = myResolver.chooseMaximallySpecificCandidates(refinedCandidates, checkArgumentsMode, discriminateGenerics, isDebuggerContext)).size() == 1) {
            return OverloadResolutionResultsImpl.success(specificCalls.iterator().next());
        }
        return OverloadResolutionResultsImpl.ambiguity(specificCalls);
    }
}

