/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.patterns.DescriptorPredicate;
import org.jetbrains.kotlin.js.patterns.PatternBuilder;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;

public class InOperationTranslator
extends AbstractTranslator {
    private static final DescriptorPredicate INT_SPECIALIZATION_TEST = PatternBuilder.pattern("ranges.IntRange.contains");
    private static final DescriptorPredicate INT_RANGE_TEST = PatternBuilder.pattern("Int.rangeTo");
    private final JsExpression left;
    private final KtExpression right;
    private final KtSimpleNameExpression operation;
    private final boolean negated;

    public InOperationTranslator(@NotNull TranslationContext context, @NotNull JsExpression left, @NotNull KtExpression right, @NotNull KtSimpleNameExpression operation, boolean negated) {
        super(context);
        this.left = left;
        this.right = right;
        this.operation = operation;
        this.negated = negated;
    }

    @NotNull
    public JsExpression translate() {
        JsExpression candidate2;
        ResolvedCall<? extends FunctionDescriptor> call2 = CallUtilKt.getFunctionResolvedCallWithAssert(this.operation, this.bindingContext());
        if (INT_SPECIALIZATION_TEST.test(call2.getResultingDescriptor()) && (candidate2 = this.translateInt()) != null) {
            return candidate2;
        }
        JsExpression rightTranslated = Translation.translateAsExpression(this.right, this.context());
        return this.translateGeneral(call2, rightTranslated);
    }

    @NotNull
    private JsExpression translateGeneral(@NotNull ResolvedCall<? extends FunctionDescriptor> call2, @NotNull JsExpression rightTranslated) {
        JsExpression result2 = CallTranslator.translate(this.context(), call2, rightTranslated);
        if (this.negated) {
            result2 = JsAstUtils.not(result2);
        }
        return result2;
    }

    @Nullable
    private JsExpression translateInt() {
        ResolvedCall<? extends CallableDescriptor> rightCall = CallUtilKt.getResolvedCallWithAssert(this.right, this.bindingContext());
        if (!(rightCall.getResultingDescriptor() instanceof FunctionDescriptor)) {
            return null;
        }
        FunctionDescriptor callDescriptor = (FunctionDescriptor)rightCall.getResultingDescriptor();
        if (!INT_RANGE_TEST.test(callDescriptor)) {
            return null;
        }
        if (!(rightCall.getDispatchReceiver() instanceof ExpressionReceiver)) {
            return null;
        }
        KtExpression lower2 = ((ExpressionReceiver)rightCall.getDispatchReceiver()).getExpression();
        KtExpression upper = rightCall.getCall().getValueArguments().get(0).getArgumentExpression();
        assert (upper != null) : "Parse error occurred: " + PsiUtilsKt.getTextWithLocation((PsiElement)this.right);
        return this.translateInt(lower2, upper);
    }

    @NotNull
    private JsExpression translateInt(@NotNull KtExpression lowerExpression, @NotNull KtExpression upperExpression) {
        JsExpression lower2 = Translation.translateAsExpression(lowerExpression, this.context());
        JsExpression upper = Translation.translateAsExpression(upperExpression, this.context());
        if (!this.negated) {
            JsBinaryOperation first2 = JsAstUtils.greaterThanEq(this.left, lower2);
            JsBinaryOperation second = JsAstUtils.lessThanEq(this.left, upper);
            return JsAstUtils.and(first2, second);
        }
        JsBinaryOperation first3 = JsAstUtils.lessThan(this.left, lower2);
        JsBinaryOperation second = JsAstUtils.greaterThan(this.left, upper);
        return JsAstUtils.or(first3, second);
    }
}

