/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PropertyFetcher {
    private static final String GETPROP_COMMAND = "getprop";
    private static final Pattern GETPROP_PATTERN = Pattern.compile("^\\[([^]]+)\\]\\:\\s*\\[(.*)\\]$");
    private static final Pattern GETPROP_START_LINE_PATTERN = Pattern.compile("^\\[([^]]+)\\]\\:\\s*\\[(.*)$");
    private static final Pattern GETPROP_END_LINE_PATTERN = Pattern.compile("(.*)\\]$");
    private static final int GETPROP_TIMEOUT_SEC = 2;
    private static final int EXPECTED_PROP_COUNT = 150;
    private final Map<String, String> mProperties = Maps.newHashMapWithExpectedSize((int)150);
    private final IDevice mDevice;
    private CacheState mCacheState = CacheState.UNPOPULATED;
    private final Map<String, SettableFuture<String>> mPendingRequests = Maps.newHashMapWithExpectedSize((int)4);
    private static boolean sEnableCachingMutableProps = true;

    public PropertyFetcher(IDevice device) {
        this.mDevice = device;
    }

    public synchronized Map<String, String> getProperties() {
        return this.mProperties;
    }

    public static void enableCachingMutableProps(boolean enabled) {
        sEnableCachingMutableProps = enabled;
    }

    public synchronized ListenableFuture<String> getProperty(String name) {
        if (!this.mProperties.isEmpty() && PropertyFetcher.isImmutableProperty(name)) {
            return Futures.immediateFuture((Object)this.mProperties.get(name));
        }
        if (this.mCacheState.equals((Object)CacheState.FETCHING)) {
            return this.addPendingRequest(name);
        }
        if (this.mDevice.isOnline() && this.mCacheState.equals((Object)CacheState.UNPOPULATED) || !PropertyFetcher.isImmutableProperty(name)) {
            SettableFuture<String> result = this.addPendingRequest(name);
            this.mCacheState = CacheState.FETCHING;
            this.initiatePropertiesQuery();
            return result;
        }
        return Futures.immediateFuture((Object)this.mProperties.get(name));
    }

    private SettableFuture<String> addPendingRequest(String name) {
        SettableFuture future = this.mPendingRequests.get(name);
        if (future == null) {
            future = SettableFuture.create();
            this.mPendingRequests.put(name, (SettableFuture<String>)future);
        }
        return future;
    }

    private void initiatePropertiesQuery() {
        String threadName = String.format("query-prop-%s", this.mDevice.getSerialNumber());
        Thread propThread = new Thread(threadName){

            @Override
            public void run() {
                try {
                    GetPropReceiver propReceiver = new GetPropReceiver();
                    PropertyFetcher.this.mDevice.executeShellCommand(PropertyFetcher.GETPROP_COMMAND, propReceiver, PropertyFetcher.this.getTimeout(), TimeUnit.SECONDS);
                    PropertyFetcher.this.populateCache(propReceiver.getCollectedProperties());
                }
                catch (Throwable e) {
                    PropertyFetcher.this.handleException(e);
                }
            }
        };
        propThread.setDaemon(true);
        propThread.start();
    }

    private int getTimeout() {
        try {
            return Integer.parseInt(System.getProperty("ddmlib.getprop.timeout.sec"));
        }
        catch (NumberFormatException e) {
            return 2;
        }
    }

    private synchronized void populateCache(Map<String, String> props) {
        CacheState cacheState = this.mCacheState = props.isEmpty() ? CacheState.UNPOPULATED : CacheState.POPULATED;
        if (!props.isEmpty()) {
            if (sEnableCachingMutableProps) {
                this.mProperties.putAll(props);
            } else {
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    if (!PropertyFetcher.isImmutableProperty(entry.getKey())) continue;
                    this.mProperties.put(entry.getKey(), (String)entry.getValue());
                }
            }
        }
        for (Map.Entry<String, Object> entry : this.mPendingRequests.entrySet()) {
            if (sEnableCachingMutableProps || PropertyFetcher.isImmutableProperty(entry.getKey())) {
                ((SettableFuture)entry.getValue()).set((Object)this.mProperties.get(entry.getKey()));
                continue;
            }
            ((SettableFuture)entry.getValue()).set((Object)props.get(entry.getKey()));
        }
        this.mPendingRequests.clear();
    }

    private synchronized void handleException(Throwable e) {
        this.mCacheState = CacheState.UNPOPULATED;
        String msg = String.format("%s getting properties for device %s", e.getClass().getSimpleName(), this.mDevice.getSerialNumber());
        Log.w("PropertyFetcher", new Throwable(msg, e));
        for (Map.Entry<String, SettableFuture<String>> entry : this.mPendingRequests.entrySet()) {
            entry.getValue().setException(e);
        }
        this.mPendingRequests.clear();
    }

    @Deprecated
    public synchronized boolean arePropertiesSet() {
        return CacheState.POPULATED.equals((Object)this.mCacheState);
    }

    private static boolean isImmutableProperty(String propName) {
        return propName.startsWith("ro.") || propName.equals("qemu.sf.lcd_density");
    }

    private static enum CacheState {
        UNPOPULATED,
        FETCHING,
        POPULATED;

    }

    @VisibleForTesting
    static class GetPropReceiver
    extends MultiLineReceiver {
        private final Map<String, String> mCollectedProperties = Maps.newHashMapWithExpectedSize((int)150);
        private String[] lines = new String[0];

        GetPropReceiver() {
        }

        @Override
        public void processNewLines(String[] newLines) {
            String[] tmp = new String[this.lines.length + newLines.length];
            System.arraycopy(this.lines, 0, tmp, 0, this.lines.length);
            System.arraycopy(newLines, 0, tmp, this.lines.length, newLines.length);
            this.lines = tmp;
        }

        @Override
        public void done() {
            String multiLineLabel = null;
            Object multiLineValue = null;
            for (String line : this.lines) {
                if (multiLineLabel == null && (line.isEmpty() || line.startsWith("#"))) continue;
                Matcher m = GETPROP_PATTERN.matcher(line);
                if (m.matches()) {
                    String label = m.group(1);
                    String value = m.group(2);
                    if (!label.isEmpty()) {
                        this.mCollectedProperties.put(label, value);
                    }
                    multiLineLabel = null;
                    multiLineValue = null;
                    continue;
                }
                Matcher multiLinePattern = GETPROP_START_LINE_PATTERN.matcher(line);
                if (multiLinePattern.matches()) {
                    multiLineLabel = multiLinePattern.group(1);
                    if (multiLineLabel.isEmpty()) continue;
                    multiLineValue = multiLinePattern.group(2);
                    continue;
                }
                Matcher endPattern = GETPROP_END_LINE_PATTERN.matcher(line);
                if (multiLineLabel != null && endPattern.matches()) {
                    multiLineValue = (String)multiLineValue + "\n" + endPattern.group(1);
                    this.mCollectedProperties.put(multiLineLabel, (String)multiLineValue);
                    multiLineLabel = null;
                    multiLineValue = null;
                    continue;
                }
                if (multiLineValue == null) continue;
                multiLineValue = (String)multiLineValue + "\n" + line;
            }
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        Map<String, String> getCollectedProperties() {
            return this.mCollectedProperties;
        }
    }
}

