/*
 * Decompiled with CFR 0.152.
 */
package com.android.incfs.install;

import com.android.incfs.install.StreamingApk;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;

public class PendingBlock {
    private final Path mFilePath;
    private final Type mType;
    private final int mBlockIndex;
    private final int mBlockCount;
    private final StreamingApk mApk;
    private final int mBlockOffset;
    private final short mBlockSize;

    PendingBlock(Path filePath, Type type, int blockIndex, int blockCount, StreamingApk apk, int blockOffset, short blockSize) {
        this.mFilePath = filePath;
        this.mType = type;
        this.mBlockIndex = blockIndex;
        this.mBlockCount = blockCount;
        this.mApk = apk;
        this.mBlockOffset = blockOffset;
        this.mBlockSize = blockSize;
    }

    public PendingBlock(PendingBlock block) {
        this.mFilePath = block.mFilePath;
        this.mType = block.mType;
        this.mBlockIndex = block.mBlockIndex;
        this.mBlockCount = block.mBlockCount;
        this.mApk = block.mApk;
        this.mBlockOffset = block.mBlockOffset;
        this.mBlockSize = block.mBlockSize;
    }

    public Path getPath() {
        return this.mFilePath;
    }

    public Type getType() {
        return this.mType;
    }

    public Compression getCompression() {
        return Compression.NONE;
    }

    public int getBlockIndex() {
        return this.mBlockIndex;
    }

    public int getFileBlockCount() {
        return this.mBlockCount;
    }

    public short getBlockSize() {
        return this.mBlockSize;
    }

    public void readBlockData(ByteBuffer buffer) throws IOException {
        this.mApk.readBlockData(buffer, this.mType, this.mBlockOffset, this.mBlockSize);
    }

    public String toString() {
        return "PendingBlock{mFilePath=" + this.mFilePath + ", mType=" + this.mType + ", mBlockIndex=" + this.mBlockIndex + ", mBlockCount=" + this.mBlockCount + ", mBlockOffset=" + this.mBlockOffset + ", mBlockSize=" + this.mBlockSize + "}";
    }

    public static enum Compression {
        NONE,
        LZ4;

    }

    public static enum Type {
        APK_DATA,
        SIGNATURE_TREE;

    }
}

