/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class AdbInitOptions {
    public static final AdbInitOptions DEFAULT = AdbInitOptions.builder().build();
    public final boolean clientSupport;
    public final boolean userManagedAdbMode;
    public final int userManagedAdbPort;
    public final ImmutableMap<String, String> adbEnvVars;

    public static Builder builder() {
        return new Builder();
    }

    private AdbInitOptions(boolean clientSupport, boolean userManagedAdbMode, int userManagedAdbPort, ImmutableMap<String, String> adbEnvVars) {
        this.clientSupport = clientSupport;
        this.userManagedAdbMode = userManagedAdbMode;
        this.userManagedAdbPort = userManagedAdbPort;
        this.adbEnvVars = adbEnvVars;
    }

    public static class Builder {
        boolean clientSupport = false;
        boolean userManagedAdbMode = false;
        int userManagedAdbPort = 0;
        ImmutableMap.Builder<String, String> envVarBuilder = ImmutableMap.builder();

        public Builder setClientSupportEnabled(boolean enabled) {
            this.clientSupport = enabled;
            return this;
        }

        public Builder enableUserManagedAdbMode(int port) {
            this.userManagedAdbMode = true;
            this.userManagedAdbPort = port;
            return this;
        }

        public Builder withEnv(String key, String value) {
            this.envVarBuilder.put((Object)key, (Object)value);
            return this;
        }

        public Builder withEnv(Map<String, String> envVars) {
            this.envVarBuilder.putAll(envVars);
            return this;
        }

        public AdbInitOptions build() {
            return new AdbInitOptions(this.clientSupport, this.userManagedAdbMode, this.userManagedAdbPort, this.envVarBuilder.build());
        }
    }
}

