/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.internal.jdwp;

import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.internal.jdwp.JdwpClientManager;
import com.android.ddmlib.internal.jdwp.JdwpClientManagerFactory;
import com.android.ddmlib.internal.jdwp.JdwpClientManagerId;
import com.android.ddmlib.internal.jdwp.JdwpLoggingUtils;
import com.android.ddmlib.internal.jdwp.JdwpSocketHandler;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;

public class JdwpProxyClient
implements JdwpSocketHandler {
    private SocketChannel mClientImplSocket;
    private String mDeviceId = null;
    private int mPId = 0;
    private JdwpClientManager mConnection;
    private boolean mHandshakeComplete = false;
    private final byte[] mBuffer;
    private final JdwpClientManagerFactory mFactory;

    JdwpProxyClient(SocketChannel socket, JdwpClientManagerFactory factory, byte[] readBuffer) {
        this.mClientImplSocket = socket;
        this.mBuffer = readBuffer;
        this.mFactory = factory;
    }

    public boolean isConnected() {
        return this.mClientImplSocket != null;
    }

    @Override
    public void shutdown() throws IOException {
        if (this.mClientImplSocket != null) {
            this.mClientImplSocket.close();
            this.mClientImplSocket = null;
        }
        if (this.mConnection != null) {
            this.mConnection.removeListener(this);
            this.mConnection = null;
        }
    }

    @Override
    public void read() throws IOException, TimeoutException {
        String body;
        if (this.mClientImplSocket == null) {
            return;
        }
        ByteBuffer buffer = ByteBuffer.wrap(this.mBuffer);
        int count = this.mClientImplSocket.read(buffer);
        if (count == -1) {
            this.shutdown();
            throw new EOFException("Client Disconnected");
        }
        JdwpLoggingUtils.log("CLIENT", "READ", this.mBuffer, count);
        String data = new String(this.mBuffer, 0, count);
        String string = body = data.length() > 4 ? data.substring(4) : "";
        if (this.mDeviceId == null && body.startsWith("host:transport:")) {
            this.mDeviceId = body.substring("host:transport:".length());
            this.write("OKAY");
        } else if (this.mPId == 0 && body.startsWith("jdwp:")) {
            this.mPId = Integer.parseInt(body.substring("jdwp:".length()));
            JdwpClientManagerId key = new JdwpClientManagerId(this.mDeviceId, this.mPId);
            try {
                this.mConnection = this.mFactory.createConnection(key);
                this.mConnection.addListener(this);
                this.write("OKAY");
            }
            catch (Exception ex) {
                this.write("FAIL");
                byte[] reason = AdbHelper.formAdbRequest(ex.getMessage());
                this.write(reason, reason.length);
                this.shutdown();
            }
        } else if (this.mConnection != null) {
            this.mConnection.write(this, this.mBuffer, count);
        }
    }

    public boolean isHandshakeComplete() {
        return this.mHandshakeComplete;
    }

    public void setHandshakeComplete() {
        this.mHandshakeComplete = true;
    }

    public void write(byte[] data, int length) throws IOException, TimeoutException {
        JdwpLoggingUtils.log("CLIENT", "WRITE", this.mBuffer, length);
        AdbHelper.write(this.mClientImplSocket, data, length, DdmPreferences.getTimeOut());
    }

    private void write(String value) throws IOException, TimeoutException {
        this.write(value.getBytes(Charset.defaultCharset()), value.length());
    }
}

