/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.logcat;

import com.android.annotations.NonNull;
import com.android.ddmlib.Log;

public final class LogCatMessage {
    private final Log.LogLevel mLogLevel;
    private final String mPid;
    private final String mTid;
    private final String mAppName;
    private final String mTag;
    private final String mTime;
    private final String mMessage;

    public LogCatMessage(@NonNull Log.LogLevel logLevel, @NonNull String pid, @NonNull String tid, @NonNull String appName, @NonNull String tag, @NonNull String time, @NonNull String msg) {
        long tidValue;
        this.mLogLevel = logLevel;
        this.mPid = pid;
        this.mAppName = appName;
        this.mTag = tag;
        this.mTime = time;
        this.mMessage = msg;
        try {
            tidValue = Long.decode(tid.trim());
        }
        catch (NumberFormatException e) {
            tidValue = -1L;
        }
        this.mTid = Long.toString(tidValue);
    }

    @NonNull
    public Log.LogLevel getLogLevel() {
        return this.mLogLevel;
    }

    @NonNull
    public String getPid() {
        return this.mPid;
    }

    @NonNull
    public String getTid() {
        return this.mTid;
    }

    @NonNull
    public String getAppName() {
        return this.mAppName;
    }

    @NonNull
    public String getTag() {
        return this.mTag;
    }

    @NonNull
    public String getTime() {
        return this.mTime;
    }

    @NonNull
    public String getMessage() {
        return this.mMessage;
    }

    public String toString() {
        return this.mTime + ": " + this.mLogLevel.getPriorityLetter() + "/" + this.mTag + "(" + this.mPid + "): " + this.mMessage;
    }
}

