/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.IShellOutputReceiver;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public abstract class MultiLineReceiver
implements IShellOutputReceiver {
    private boolean mTrimLines = true;
    private String mUnfinishedLine = null;
    private final ArrayList<String> mArray = new ArrayList();

    public void setTrimLine(boolean trim) {
        this.mTrimLines = trim;
    }

    @Override
    public final void addOutput(byte[] data, int offset, int length) {
        if (!this.isCancelled()) {
            String s = null;
            try {
                s = new String(data, offset, length, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                s = new String(data, offset, length);
            }
            if (this.mUnfinishedLine != null) {
                s = this.mUnfinishedLine + s;
                this.mUnfinishedLine = null;
            }
            this.mArray.clear();
            int start = 0;
            while (true) {
                int index;
                if ((index = s.indexOf("\r\n", start)) == -1) break;
                String line = s.substring(start, index);
                if (this.mTrimLines) {
                    line = line.trim();
                }
                this.mArray.add(line);
                start = index + 2;
            }
            this.mUnfinishedLine = s.substring(start);
            if (!this.mArray.isEmpty()) {
                String[] lines = this.mArray.toArray(new String[this.mArray.size()]);
                this.processNewLines(lines);
            }
        }
    }

    @Override
    public final void flush() {
        if (this.mUnfinishedLine != null) {
            this.processNewLines(new String[]{this.mUnfinishedLine});
        }
        this.done();
    }

    public void done() {
    }

    public abstract void processNewLines(String[] var1);
}

