/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.SdkConstants;
import com.android.utils.TokenizedCommandLineKt;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\n\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0014\n\u0002\u0010 \n\u0002\b\u0006\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0006\u0010\u0019\u001a\u00020\u0007J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007H\u0007J\u000e\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0003J\u0006\u0010\"\u001a\u00020\u0007J\u0010\u0010#\u001a\u0004\u0018\u00010\u00032\u0006\u0010$\u001a\u00020\u0007J,\u0010%\u001a\u0004\u0018\u00010\u00032\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00072\b\b\u0002\u0010(\u001a\u00020\u00052\b\b\u0002\u0010)\u001a\u00020\u0005J\b\u0010*\u001a\u00020\u0003H\u0016J\u000e\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u0003J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030-J \u0010.\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u0005H\u0007J\u0010\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u0007H\u0002J\u0010\u00101\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u00102\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/android/utils/TokenizedCommandLine;", "", "commandLine", "", "raw", "", "platform", "", "indexes", "", "(Ljava/lang/String;ZI[I)V", "getCommandLine", "()Ljava/lang/String;", "generation", "getPlatform", "()I", "getRaw", "()Z", "toStringValue", "charAt", "", "i", "(I)Ljava/lang/Character;", "checkGeneration", "", "computeNormalizedCommandLineHashCode", "invalidate", "isEndOfCommand", "isEndOfToken", "isStartOfToken", "nextTokenAfter", "offset", "normalizedCommandLineEquals", "other", "normalizedCommandLineLength", "removeNth", "n", "removeTokenGroup", "token", "extra", "matchPrefix", "returnFirstExtra", "toString", "separator", "toTokenList", "", "tokenMatches", "tokenStartingAt", "start", "zeroAllocTokenizePOSIX", "zeroAllocTokenizeWindows", "common"})
public final class TokenizedCommandLine {
    @NotNull
    private final String commandLine;
    private final boolean raw;
    private final int platform;
    @NotNull
    private int[] indexes;
    private final int generation;
    @Nullable
    private String toStringValue;

    public TokenizedCommandLine(@NotNull String commandLine, boolean raw, int platform, @NotNull int[] indexes) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        Intrinsics.checkParameterIsNotNull((Object)indexes, (String)"indexes");
        this.commandLine = commandLine;
        this.raw = raw;
        this.platform = platform;
        int[] nArray = this.indexes = indexes;
        nArray[0] = nArray[0] + 1;
        this.generation = nArray[0];
        this.checkGeneration();
        if (this.platform == 2) {
            this.zeroAllocTokenizeWindows(this.raw);
        } else {
            this.zeroAllocTokenizePOSIX(this.raw);
        }
    }

    public /* synthetic */ TokenizedCommandLine(String string, boolean bl, int n, int[] nArray, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = SdkConstants.currentPlatform();
        }
        if ((n2 & 8) != 0) {
            nArray = TokenizedCommandLineKt.allocateTokenizeCommandLineBuffer(string);
        }
        this(string, bl, n, nArray);
    }

    @NotNull
    public final String getCommandLine() {
        return this.commandLine;
    }

    public final boolean getRaw() {
        return this.raw;
    }

    public final int getPlatform() {
        return this.platform;
    }

    @Nullable
    public final String removeTokenGroup(@NotNull String token, int extra, boolean matchPrefix, boolean returnFirstExtra) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        this.checkGeneration();
        this.invalidate();
        int read = 1;
        int write = 1;
        String firstExtra = null;
        do {
            int n = read >= write ? 1 : 0;
            boolean bl = false;
            boolean bl2 = false;
            if (_Assertions.ENABLED && n == 0) {
                boolean bl3 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            n = this.isStartOfToken(read);
            bl = false;
            bl2 = false;
            if (_Assertions.ENABLED && n == 0) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            n = this.isStartOfToken(write);
            bl = false;
            bl2 = false;
            if (_Assertions.ENABLED && n == 0) {
                boolean bl5 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (this.tokenMatches(token, read, matchPrefix)) {
                if (returnFirstExtra) {
                    firstExtra = matchPrefix ? this.tokenStartingAt(read + token.length()) : this.tokenStartingAt(this.nextTokenAfter(read));
                }
                for (int count = 0; count != extra + 1 && !this.isEndOfCommand(read); ++count) {
                    read = this.nextTokenAfter(read);
                }
            } else {
                if (this.isEndOfCommand(read) || this.isEndOfCommand(write)) continue;
                do {
                    n = write;
                    write = n + 1;
                    int n2 = n;
                    n = read;
                    read = n + 1;
                    this.indexes[n2] = this.indexes[n];
                } while (!this.isEndOfToken(read - 1));
            }
        } while (!this.isEndOfCommand(read));
        this.indexes[write] = Integer.MIN_VALUE;
        return firstExtra;
    }

    public static /* synthetic */ String removeTokenGroup$default(TokenizedCommandLine tokenizedCommandLine, String string, int n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        return tokenizedCommandLine.removeTokenGroup(string, n, bl, bl2);
    }

    private final String tokenStartingAt(int start) {
        this.checkGeneration();
        StringBuilder token = new StringBuilder();
        int n = start;
        int n2 = this.indexes.length;
        if (n < n2) {
            block4: while (true) {
                int read = n++;
                int offset = this.indexes[read];
                switch (offset) {
                    case -2147483648: {
                        break block4;
                    }
                    case 0x7FFFFFFF: {
                        break block4;
                    }
                    default: {
                        token.append(this.commandLine.charAt(offset));
                        if (n < n2) continue block4;
                    }
                }
                break;
            }
        }
        return ((Object)StringsKt.trim((CharSequence)token)).toString();
    }

    @Nullable
    public final String removeNth(int n) {
        this.checkGeneration();
        this.invalidate();
        StringBuilder token = new StringBuilder();
        int tokenNumber = 0;
        int write = 1;
        int n2 = 1;
        int n3 = this.indexes.length;
        if (n2 < n3) {
            block4: do {
                int read = n2++;
                if (tokenNumber != n) {
                    int n4 = write;
                    write = n4 + 1;
                    this.indexes[n4] = this.indexes[read];
                }
                int offset = this.indexes[read];
                switch (offset) {
                    case -2147483648: {
                        CharSequence charSequence = token;
                        boolean bl = false;
                        if (charSequence.length() == 0) {
                            return null;
                        }
                        return token.toString();
                    }
                    case 0x7FFFFFFF: {
                        int n5 = tokenNumber;
                        tokenNumber = n5 + 1;
                        break;
                    }
                    default: {
                        if (tokenNumber != n) continue block4;
                        token.append(this.commandLine.charAt(offset));
                    }
                }
            } while (n2 < n3);
        }
        return null;
    }

    @NotNull
    public final List<String> toTokenList() {
        this.checkGeneration();
        boolean bl = false;
        List result = new ArrayList();
        StringBuilder token = new StringBuilder();
        int i = 1;
        while (!this.isEndOfCommand(i)) {
            Character c = this.charAt(i);
            if (c == null) {
                CharSequence charSequence = token;
                boolean bl2 = false;
                if (charSequence.length() > 0) {
                    charSequence = token.toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"token.toString()");
                    result.add(charSequence);
                    token.setLength(0);
                }
            } else {
                token.append(c.charValue());
            }
            ++i;
        }
        return result;
    }

    private final TokenizedCommandLine zeroAllocTokenizeWindows(boolean raw) {
        int n;
        this.checkGeneration();
        this.invalidate();
        boolean quoting = false;
        int i = 0;
        int length = this.commandLine.length();
        Character c = null;
        int offset = 0;
        offset = 1;
        while (i < length && Character.isWhitespace(this.commandLine.charAt(i))) {
            n = i;
            i = n + 1;
        }
        block1: while (i < length) {
            c = Character.valueOf(this.commandLine.charAt(i));
            n = 34;
            if (c.charValue() == n) {
                if (raw) {
                    n = offset;
                    offset = n + 1;
                    this.indexes[n] = i;
                }
                quoting = !quoting;
                ++i;
                continue;
            }
            n = 92;
            if (c.charValue() == n) {
                boolean quote;
                int forward = i + 1;
                int slashCount = 1;
                c = StringsKt.getOrNull((CharSequence)this.commandLine, (int)forward);
                while (true) {
                    Character c2 = c;
                    char c3 = '\\';
                    if (c2 == null || c2.charValue() != c3) break;
                    ++slashCount;
                    c = StringsKt.getOrNull((CharSequence)this.commandLine, (int)(++forward));
                }
                boolean odd = slashCount % 2 == 1;
                Character c4 = c;
                int n2 = 34;
                boolean bl = quote = c4 != null && c4.charValue() == n2;
                if (!raw && quote) {
                    slashCount /= 2;
                }
                n2 = 0;
                int n3 = 0;
                n3 = 0;
                int n4 = slashCount;
                while (n3 < n4) {
                    int j = n3++;
                    boolean bl2 = false;
                    int n5 = offset;
                    offset = n5 + 1;
                    this.indexes[n5] = i + j;
                }
                if (odd && quote) {
                    n2 = offset;
                    offset = n2 + 1;
                    int n6 = n2;
                    n2 = forward;
                    forward = n2 + 1;
                    this.indexes[n6] = n2;
                }
                i = forward;
                continue;
            }
            if (!quoting) {
                n = 94;
                if (c.charValue() == n) {
                    c = StringsKt.getOrNull((CharSequence)this.commandLine, (int)(++i));
                    if (raw || c == null) {
                        n = offset;
                        offset = n + 1;
                        this.indexes[n] = i - 1;
                    }
                    Character c5 = c;
                    n = 94;
                    if (c5 != null && c5.charValue() == n) {
                        n = offset;
                        offset = n + 1;
                        int n7 = n;
                        n = i;
                        i = n + 1;
                        this.indexes[n7] = n;
                    }
                    while (true) {
                        Character c6 = c;
                        n = 13;
                        if (c6 == null || c6.charValue() != n) {
                            Character c7 = c;
                            n = 10;
                            if (c7 == null || c7.charValue() != n) continue block1;
                        }
                        c = StringsKt.getOrNull((CharSequence)this.commandLine, (int)(++i));
                    }
                }
            }
            if (!quoting && Character.isWhitespace(c.charValue())) {
                n = offset;
                offset = n + 1;
                this.indexes[n] = Integer.MAX_VALUE;
                c = StringsKt.getOrNull((CharSequence)this.commandLine, (int)(++i));
                while (c != null && Character.isWhitespace(c.charValue())) {
                    c = StringsKt.getOrNull((CharSequence)this.commandLine, (int)(++i));
                }
                continue;
            }
            n = offset;
            offset = n + 1;
            int n8 = n;
            n = i;
            i = n + 1;
            this.indexes[n8] = n;
        }
        if (!this.isEndOfToken(offset - 1)) {
            n = offset;
            offset = n + 1;
            this.indexes[n] = Integer.MAX_VALUE;
        }
        n = offset;
        offset = n + 1;
        this.indexes[n] = Integer.MIN_VALUE;
        return this;
    }

    private final TokenizedCommandLine zeroAllocTokenizePOSIX(boolean raw) {
        int n;
        this.checkGeneration();
        this.invalidate();
        boolean quoting = false;
        char quote = '\u0000';
        boolean escaping = false;
        boolean skipping = true;
        int i = 0;
        char c = '\u0000';
        int length = this.commandLine.length();
        int offset = 1;
        while (i < length) {
            n = i;
            i = n + 1;
            c = this.commandLine.charAt(n);
            if (skipping) {
                if (Character.isWhitespace(c)) continue;
                skipping = false;
            }
            if ((quoting || !Character.isWhitespace(c)) && raw) {
                n = offset;
                offset = n + 1;
                this.indexes[n] = i - 1;
            }
            if (escaping) {
                escaping = false;
                if (c == '\n' || raw) continue;
                n = offset;
                offset = n + 1;
                this.indexes[n] = i - 1;
                continue;
            }
            if (!(c != '\\' || quoting && quote != '\"')) {
                escaping = true;
                continue;
            }
            if (!(quoting || c != '\"' && c != '\'')) {
                quoting = true;
                quote = c;
                continue;
            }
            if (quoting && c == quote) {
                quoting = false;
                quote = '\u0000';
                continue;
            }
            if (!quoting && Character.isWhitespace(c)) {
                skipping = true;
                n = offset;
                offset = n + 1;
                this.indexes[n] = Integer.MAX_VALUE;
                continue;
            }
            if (raw) continue;
            n = offset;
            offset = n + 1;
            this.indexes[n] = i - 1;
        }
        if (!this.isEndOfToken(offset - 1)) {
            n = offset;
            offset = n + 1;
            this.indexes[n] = Integer.MAX_VALUE;
        }
        this.indexes[offset] = Integer.MIN_VALUE;
        return this;
    }

    @VisibleForTesting
    public final boolean tokenMatches(@NotNull String token, int offset, boolean matchPrefix) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        this.checkGeneration();
        int i = 0;
        int index = this.indexes[offset];
        while (index != Integer.MIN_VALUE) {
            boolean endOfToken;
            boolean bl = endOfToken = index == Integer.MAX_VALUE;
            if (i == token.length()) {
                return endOfToken || matchPrefix;
            }
            if (endOfToken) {
                return false;
            }
            if (token.charAt(i) != this.commandLine.charAt(index)) {
                return false;
            }
            index = this.indexes[offset + ++i];
        }
        return false;
    }

    @VisibleForTesting
    public final int nextTokenAfter(int offset) {
        this.checkGeneration();
        int result = offset;
        while (!this.isEndOfToken(result) && !this.isEndOfCommand(result)) {
            ++result;
        }
        return result + 1;
    }

    private final boolean isEndOfToken(int i) {
        return i < this.indexes.length && this.indexes[i] == Integer.MAX_VALUE;
    }

    private final boolean isEndOfCommand(int i) {
        return i >= this.indexes.length || this.indexes[i] == Integer.MIN_VALUE;
    }

    private final boolean isStartOfToken(int i) {
        return i == 1 || this.isEndOfToken(i - 1);
    }

    private final Character charAt(int i) {
        return this.isEndOfToken(i) ? null : Character.valueOf(this.commandLine.charAt(this.indexes[i]));
    }

    public final int normalizedCommandLineLength() {
        int n;
        if (this.isEndOfCommand(1)) {
            n = 0;
        } else {
            int i = 1;
            while (!this.isEndOfCommand(i + 1)) {
                ++i;
            }
            n = i - 1;
        }
        return n;
    }

    public final int computeNormalizedCommandLineHashCode() {
        this.checkGeneration();
        long hash = 1469598103934665603L;
        int i = 1;
        while (!this.isEndOfCommand(i) && !this.isEndOfCommand(i + 1)) {
            Character c = this.charAt(i);
            hash ^= (long)(c == null ? 32 : (int)c.charValue());
            hash *= 1099511628211L;
            ++i;
        }
        return (int)hash;
    }

    public final boolean normalizedCommandLineEquals(@NotNull String other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        int length1 = this.normalizedCommandLineLength();
        int length2 = other.length();
        if (length1 == 0 && length2 == 0) {
            return true;
        }
        if (length1 != length2) {
            return false;
        }
        int n = 1;
        if (n < length1) {
            do {
                int i;
                Character c;
                if (((c = this.charAt(i = n++)) == null ? (char)' ' : (char)c.charValue()) == other.charAt(i - 1)) continue;
                return false;
            } while (n < length1);
        }
        return true;
    }

    @NotNull
    public final String toString(@NotNull String separator) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)separator, (String)"separator");
        this.checkGeneration();
        int i = 1;
        if (this.isEndOfCommand(i)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (!this.isEndOfCommand(i + 1)) {
            object = this.charAt(i);
            sb.append(object == null ? separator : object);
            ++i;
        }
        object = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"sb.toString()");
        return object;
    }

    @NotNull
    public String toString() {
        if (this.toStringValue != null) {
            String string = this.toStringValue;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return string;
        }
        this.toStringValue = this.toString(" ");
        String string = this.toStringValue;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    private final void invalidate() {
        this.toStringValue = null;
    }

    private final void checkGeneration() {
        int n = this.indexes[0];
        boolean bl = false;
        if (this.generation != Math.abs(n)) {
            throw new Exception("Buffer indexes was shared with another TokenizedCommandLine after this one");
        }
    }
}

