/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.utils.TokenizedCommandLine;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0007\u00a8\u0006\t"}, d2={"Lcom/android/utils/StringHelperWindows;", "", "()V", "splitCommandLine", "", "", "commandLine", "tokenizeCommandLineToEscaped", "tokenizeCommandLineToRaw", "common"})
public final class StringHelperWindows {
    public static final StringHelperWindows INSTANCE;

    @JvmStatic
    @NotNull
    public static final List<String> splitCommandLine(@NotNull String commandLine) {
        String string;
        List list;
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"Lists.newArrayList()");
        List commands = arrayList;
        boolean quoting = false;
        boolean escapingQuotes = false;
        boolean escapingOthers = false;
        int commandStart = 0;
        int length = commandLine.length();
        int i2 = 0;
        while (i2 < length) {
            char c = commandLine.charAt(i2);
            if (c == '\"' && !escapingQuotes) {
                quoting = !quoting;
                ++i2;
                continue;
            }
            if (escapingQuotes) {
                escapingQuotes = false;
            } else if (c == '\\') {
                escapingQuotes = true;
                ++i2;
                continue;
            }
            if (escapingOthers) {
                escapingOthers = false;
                ++i2;
                continue;
            }
            if (c == '^') {
                escapingOthers = true;
                ++i2;
                continue;
            }
            if (!quoting && commandLine.charAt(i2) == '&') {
                String string2 = commandLine;
                list = commands;
                boolean bl = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(commandStart, i2), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                list.add(string);
                if (commandLine.length() <= ++i2 || commandLine.charAt(i2) == '&') {
                    // empty if block
                }
                commandStart = ++i2;
            }
            ++i2;
        }
        if (commandStart < length) {
            String string3 = commandLine;
            list = commands;
            boolean bl = false;
            String string4 = string3.substring(commandStart);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            string = string4;
            list.add(string);
        }
        return commands;
    }

    @JvmStatic
    @NotNull
    public static final List<String> tokenizeCommandLineToEscaped(@NotNull String commandLine) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        return new TokenizedCommandLine(commandLine, false, 2, null, 8, null).toTokenList();
    }

    @JvmStatic
    @NotNull
    public static final List<String> tokenizeCommandLineToRaw(@NotNull String commandLine) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        return new TokenizedCommandLine(commandLine, true, 2, null, 8, null).toTokenList();
    }

    private StringHelperWindows() {
    }

    static {
        StringHelperWindows stringHelperWindows;
        INSTANCE = stringHelperWindows = new StringHelperWindows();
    }
}

