/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.annotations.NonNull;
import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;

public class FileUtils {
    public static boolean deleteFolder(File folder) {
        if (!folder.exists()) {
            return true;
        }
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    FileUtils.deleteFolder(file);
                    continue;
                }
                file.delete();
            }
        }
        return folder.delete();
    }

    public static void copyFile(File from, File to) throws IOException {
        to = new File(to, from.getName());
        if (from.isDirectory()) {
            File[] children;
            if (!to.exists()) {
                to.mkdirs();
            }
            if ((children = from.listFiles()) != null) {
                for (File child : children) {
                    FileUtils.copyFile(child, to);
                }
            }
        } else if (from.isFile()) {
            Files.copy((File)from, (File)to);
        }
    }

    public static String relativePath(@NonNull File file, @NonNull File dir) {
        Preconditions.checkArgument((boolean)file.isFile(), (String)"%s is not a file.", (Object[])new Object[]{file.getPath()});
        Preconditions.checkArgument((boolean)dir.isDirectory(), (String)"%s is not a directory.", (Object[])new Object[]{dir.getPath()});
        return dir.toURI().relativize(file.toURI()).getPath();
    }

    public static String sha1(@NonNull File file) throws IOException {
        return Hashing.sha1().hashBytes(Files.toByteArray((File)file)).toString();
    }
}

