/*
 * Decompiled with CFR 0.152.
 */
package com.android.prefs;

import com.android.annotations.NonNull;
import java.io.File;

public final class AndroidLocation {
    public static final String FOLDER_DOT_ANDROID = ".android";
    public static final String FOLDER_AVD = "avd";
    private static String sPrefsLocation = null;

    @NonNull
    public static final String getFolder() throws AndroidLocationException {
        File f;
        if (sPrefsLocation == null) {
            String home = AndroidLocation.findValidPath(EnvVar.ANDROID_SDK_HOME, EnvVar.USER_HOME, EnvVar.HOME);
            if (home == null) {
                throw new AndroidLocationException("Unable to get the Android SDK home directory.\nMake sure the environment variable ANDROID_SDK_HOME is set up.");
            }
            sPrefsLocation = home;
            if (!sPrefsLocation.endsWith(File.separator)) {
                sPrefsLocation = sPrefsLocation + File.separator;
            }
            sPrefsLocation = sPrefsLocation + FOLDER_DOT_ANDROID + File.separator;
        }
        if (!(f = new File(sPrefsLocation)).exists()) {
            try {
                f.mkdir();
            }
            catch (SecurityException e) {
                AndroidLocationException e2 = new AndroidLocationException(String.format("Unable to create folder '%1$s'. This is the path of preference folder expected by the Android tools.", sPrefsLocation));
                e2.initCause(e);
                throw e2;
            }
        } else if (f.isFile()) {
            throw new AndroidLocationException(sPrefsLocation + " is not a directory! " + "This is the path of preference folder expected by the Android tools.");
        }
        return sPrefsLocation;
    }

    public static final void resetFolder() {
        sPrefsLocation = null;
    }

    private static String findValidPath(EnvVar ... vars) {
        for (EnvVar var : vars) {
            String path;
            if (var.mIsSysProp && (path = AndroidLocation.checkPath(System.getProperty(var.mName))) != null) {
                return path;
            }
            if (!var.mIsEnvVar || (path = AndroidLocation.checkPath(System.getenv(var.mName))) == null) continue;
            return path;
        }
        return null;
    }

    private static String checkPath(String path) {
        File f;
        if (path != null && (f = new File(path)).isDirectory()) {
            return path;
        }
        return null;
    }

    public static enum EnvVar {
        ANDROID_SDK_HOME("ANDROID_SDK_HOME", true, true),
        USER_HOME("user.home", true, false),
        HOME("HOME", false, true);

        final String mName;
        final boolean mIsSysProp;
        final boolean mIsEnvVar;

        private EnvVar(String name, boolean isSysProp, boolean isEnvVar) {
            this.mName = name;
            this.mIsSysProp = isSysProp;
            this.mIsEnvVar = isEnvVar;
        }

        public String getName() {
            return this.mName;
        }
    }

    public static final class AndroidLocationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public AndroidLocationException(String string) {
            super(string);
        }
    }
}

