/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourcePosition;
import com.android.manifmerger.Actions;
import com.android.manifmerger.AttributeModel;
import com.android.manifmerger.AttributeOperationType;
import com.android.manifmerger.MergeType;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.PlaceholderHandler;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlElement;
import com.android.manifmerger.XmlNode;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import org.w3c.dom.Attr;

public class XmlAttribute
extends XmlNode {
    private final XmlElement mOwnerElement;
    private final Attr mXml;
    private final AttributeModel mAttributeModel;

    public XmlAttribute(XmlElement ownerElement, Attr xml, AttributeModel attributeModel) {
        this.mOwnerElement = (XmlElement)Preconditions.checkNotNull((Object)ownerElement);
        this.mXml = (Attr)Preconditions.checkNotNull((Object)xml);
        this.mAttributeModel = attributeModel;
        this.checkAndExpandPlaceHolder();
    }

    public static XmlAttribute createXmlAttribute(XmlElement ownerElement, Attr attribute) {
        XmlNode.NodeName nodeName = attribute.getNamespaceURI() != null ? XmlNode.fromNSName(attribute.getNamespaceURI(), attribute.getPrefix(), attribute.getLocalName()) : XmlNode.fromXmlName(attribute.getName());
        return new XmlAttribute(ownerElement, attribute, ownerElement.getType().getAttributeModel(nodeName));
    }

    private void checkAndExpandPlaceHolder() {
        if (this.mAttributeModel != null && this.mAttributeModel.isPackageDependent()) {
            Object value = this.mXml.getValue();
            if (value == null || ((String)value).isEmpty()) {
                return;
            }
            if (!PlaceholderHandler.isPlaceHolder((String)value)) {
                String pkg = this.mOwnerElement.getDocument().getNamespace();
                if (pkg == null) {
                    throw new RuntimeException("No namespace or package specified");
                }
                if (((String)value).indexOf(46) == -1 || ((String)value).charAt(0) == '.') {
                    value = ((String)value).charAt(0) == '.' ? pkg + (String)value : pkg + "." + (String)value;
                    this.mXml.setValue((String)value);
                }
            }
        }
    }

    @Override
    public XmlNode.NodeName getName() {
        return XmlNode.unwrapName(this.mXml);
    }

    public String getValue() {
        return this.mXml.getValue();
    }

    @Override
    public XmlNode.NodeKey getId() {
        String myName = this.mXml.getNamespaceURI() == null ? this.mXml.getName() : this.mXml.getLocalName();
        return new XmlNode.NodeKey(this.mOwnerElement.getId() + "@" + myName);
    }

    @Override
    public SourcePosition getPosition() {
        try {
            return XmlDocument.getNodePosition(this);
        }
        catch (Exception e) {
            return SourcePosition.UNKNOWN;
        }
    }

    @Override
    public Attr getXml() {
        return this.mXml;
    }

    public void setValue(String value) {
        this.getOwnerElement().setAttribute(this, value);
    }

    public AttributeModel getModel() {
        return this.mAttributeModel;
    }

    XmlElement getOwnerElement() {
        return this.mOwnerElement;
    }

    void mergeInHigherPriorityElement(XmlElement higherPriorityElement, MergingReport.Builder mergingReport) {
        Optional<XmlAttribute> higherPriorityAttributeOptional = higherPriorityElement.getAttribute(this.getName());
        AttributeOperationType attributeOperationType = higherPriorityElement.getAttributeOperationType(this.getName());
        if (higherPriorityAttributeOptional.isPresent()) {
            XmlAttribute higherPriorityAttribute = higherPriorityAttributeOptional.get();
            this.handleBothAttributePresent(mergingReport, higherPriorityAttribute, attributeOperationType);
            return;
        }
        if (attributeOperationType == AttributeOperationType.REMOVE) {
            mergingReport.getActionRecorder().recordAttributeAction(this, Actions.ActionType.REJECTED, AttributeOperationType.REMOVE);
            return;
        }
        String mergedValue = this.mergeThisAndDefaultValue(mergingReport, higherPriorityElement);
        if (mergedValue == null) {
            return;
        }
        higherPriorityElement.addAttribute(this, mergedValue);
        mergingReport.getActionRecorder().recordAttributeAction(this, Actions.ActionType.ADDED, this.getOwnerElement().getAttributeOperationType(this.getName()));
    }

    private void handleBothAttributePresent(MergingReport.Builder report, XmlAttribute higherPriority, AttributeOperationType operationType) {
        if (this.isNonMergeableFromLowerPriorityNode()) {
            report.getActionRecorder().recordAttributeAction(this, Actions.ActionType.REJECTED, null);
            return;
        }
        if (this.getXml().getNamespaceURI() != null && this.getXml().getNamespaceURI().equals("http://schemas.android.com/tools")) {
            this.handleBothToolsAttributePresent(higherPriority);
            return;
        }
        if (operationType == AttributeOperationType.REPLACE) {
            report.getActionRecorder().recordAttributeAction(this, Actions.ActionType.REJECTED, AttributeOperationType.REPLACE);
            return;
        }
        if (this.mAttributeModel != null) {
            String mergedValue = this.mAttributeModel.getMergingPolicy().merge(higherPriority.getValue(), this.getValue());
            if (mergedValue != null) {
                higherPriority.setValue(mergedValue);
            } else {
                if (this.automaticallyRejected(report, higherPriority)) {
                    return;
                }
                this.addConflictingValueMessage(report, higherPriority);
            }
            return;
        }
        if (!this.getValue().equals(higherPriority.getValue())) {
            if (this.automaticallyRejected(report, higherPriority)) {
                return;
            }
            this.addConflictingValueMessage(report, higherPriority);
        }
    }

    private boolean automaticallyRejected(MergingReport.Builder report, XmlAttribute higherPriority) {
        if (this.mOwnerElement.getDocument().getModel().autoRejectConflicts()) {
            Actions.AttributeRecord attributeRecord = report.getActionRecorder().getAttributeCreationRecord(higherPriority);
            String message = String.format("Attribute %1$s value=(%2$s) from %3$s\n\tis also present at %4$s value=(%5$s).\n\tThe merger automatically chose %2$s. Verify that this is what you want and adjust if necessary.", higherPriority.getId(), higherPriority.getValue(), attributeRecord != null ? attributeRecord.getActionLocation().print(true) : "(unknown)", this.printPosition(), this.getValue());
            report.addMessage(higherPriority, attributeRecord != null ? attributeRecord.getActionLocation().getPosition() : SourcePosition.UNKNOWN, MergingReport.Record.Severity.WARNING, message);
            return true;
        }
        return false;
    }

    private void handleBothToolsAttributePresent(XmlAttribute higherPriority) {
        if (this.getName().getLocalName().equals("node")) {
            return;
        }
        Splitter splitter = Splitter.on((char)',');
        ImmutableSet.Builder targetValues = ImmutableSet.builder();
        targetValues.addAll(splitter.split((CharSequence)higherPriority.getValue()));
        targetValues.addAll(splitter.split((CharSequence)this.getValue()));
        higherPriority.setValue(Joiner.on((char)',').join((Iterable)targetValues.build()));
    }

    private String mergeThisAndDefaultValue(MergingReport.Builder mergingReport, XmlElement implicitNode) {
        if (this.isNonMergeableFromLowerPriorityNode()) {
            mergingReport.getActionRecorder().recordAttributeAction(this, Actions.ActionType.REJECTED, null);
            return null;
        }
        String mergedValue = this.getValue();
        if (this.mAttributeModel == null || this.mAttributeModel.getDefaultValue() == null || !this.mAttributeModel.getMergingPolicy().shouldMergeDefaultValues()) {
            return mergedValue;
        }
        String defaultValue = this.mAttributeModel.getDefaultValue();
        if (defaultValue.equals(mergedValue)) {
            return mergedValue;
        }
        mergedValue = this.mAttributeModel.getMergingPolicy().merge(defaultValue, mergedValue);
        if (mergedValue == null) {
            this.addIllegalImplicitOverrideMessage(mergingReport, this.mAttributeModel, implicitNode);
            return null;
        }
        if (mergedValue.equals(defaultValue)) {
            return null;
        }
        return mergedValue;
    }

    void mergeWithLowerPriorityDefaultValue(MergingReport.Builder mergingReport, XmlElement implicitNode) {
        if (this.mAttributeModel == null || this.mAttributeModel.getDefaultValue() == null || !this.mAttributeModel.getMergingPolicy().shouldMergeDefaultValues()) {
            return;
        }
        if (!this.mAttributeModel.getMergingPolicy().canMergeWithLowerPriority(implicitNode.getDocument())) {
            return;
        }
        if (this.mOwnerElement.getAttributeOperationType(this.getName()) == AttributeOperationType.REPLACE) {
            mergingReport.getActionRecorder().recordImplicitRejection(this, implicitNode);
            return;
        }
        String mergedValue = this.mAttributeModel.getMergingPolicy().merge(this.getValue(), this.mAttributeModel.getDefaultValue());
        if (mergedValue == null) {
            this.addIllegalImplicitOverrideMessage(mergingReport, this.mAttributeModel, implicitNode);
        } else {
            this.setValue(mergedValue);
            mergingReport.getActionRecorder().recordAttributeAction(this, Actions.ActionType.MERGED, null);
        }
    }

    private void addIllegalImplicitOverrideMessage(MergingReport.Builder mergingReport, AttributeModel attributeModel, XmlElement implicitNode) {
        String error = String.format("Attribute %1$s value=(%2$s) at %3$s cannot override implicit default value=(%4$s) at %5$s", this.getId(), this.getValue(), this.printPosition(), attributeModel.getDefaultValue(), implicitNode.printPosition());
        mergingReport.addMessage(this, MergingReport.Record.Severity.ERROR, error);
    }

    private void addConflictingValueMessage(MergingReport.Builder report, XmlAttribute higherPriority) {
        Actions.AttributeRecord attributeRecord = report.getActionRecorder().getAttributeCreationRecord(higherPriority);
        String error = this.getOwnerElement().getType().getMergeType() == MergeType.MERGE_CHILDREN_ONLY ? String.format("Attribute %1$s value=(%2$s) from %3$s\n\tis also present at %4$s value=(%5$s).\n\tAttributes of <%6$s> elements are not merged.", higherPriority.getId(), higherPriority.getValue(), attributeRecord != null ? attributeRecord.getActionLocation().print(true) : "(unknown)", this.printPosition(), this.getValue(), this.getOwnerElement().getName().getLocalName()) : String.format("Attribute %1$s value=(%2$s) from %3$s\n\tis also present at %4$s value=(%5$s).\n\tSuggestion: add 'tools:replace=\"%6$s\"' to <%7$s> element at %8$s to override.", higherPriority.getId(), higherPriority.getValue(), attributeRecord != null ? attributeRecord.getActionLocation().print(true) : "(unknown)", this.printPosition(), this.getValue(), this.mXml.getName(), this.getOwnerElement().getName().getLocalName(), higherPriority.getOwnerElement().printPosition());
        report.addMessage(higherPriority, attributeRecord != null ? attributeRecord.getActionLocation().getPosition() : SourcePosition.UNKNOWN, MergingReport.Record.Severity.ERROR, error);
    }

    private boolean isNonMergeableFromLowerPriorityNode() {
        if (this.mAttributeModel != null) {
            return !this.mAttributeModel.getMergingPolicy().canMergeWithLowerPriority(this.mOwnerElement.getDocument());
        }
        return false;
    }

    @Override
    public SourceFile getSourceFile() {
        return this.getOwnerElement().getSourceFile();
    }
}

