/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourcePosition;
import com.android.manifmerger.DocumentModel;
import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.XmlNode;
import com.android.utils.XmlUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Optional;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class OrphanXmlElement
extends XmlNode {
    private final Element mXml;
    private final ManifestModel.NodeTypes mType;

    public OrphanXmlElement(Element xml, DocumentModel<ManifestModel.NodeTypes> model) {
        this.mXml = (Element)Preconditions.checkNotNull((Object)xml);
        String elementName = this.mXml.getNodeName();
        this.mType = model.fromXmlSimpleName(elementName.substring(elementName.indexOf(58) + 1));
    }

    public boolean isA(ManifestModel.NodeTypes type) {
        return this.mType == type;
    }

    @Override
    public Element getXml() {
        return this.mXml;
    }

    public String getNamespaceURI() {
        return this.mXml.getNamespaceURI();
    }

    public String getTagName() {
        return this.mXml.getTagName();
    }

    public String getAttributeValue(String namespaceUri, String localName) {
        NamedNodeMap namedNodeMap = this.getXml().getAttributes();
        return Optional.ofNullable(namedNodeMap.getNamedItemNS(namespaceUri, localName)).map(Node::getNodeValue).orElse(null);
    }

    public String getAttributeInfo(String namespaceUri, String attributeName) {
        Element element = this.getXml();
        Attr attr = element.getAttributeNodeNS(namespaceUri, attributeName);
        if (attr == null) {
            return null;
        }
        return element.getTagName() + ":" + attributeName + ":" + attr.getValue();
    }

    public String lookupNamespacePrefix(String nsUri, boolean create) {
        return XmlUtils.lookupNamespacePrefix((Node)this.getXml(), (String)nsUri, (boolean)create);
    }

    public String lookupNamespacePrefix(String nsUri, String defaultPrefix, boolean create) {
        return XmlUtils.lookupNamespacePrefix((Node)this.getXml(), (String)nsUri, (String)defaultPrefix, (boolean)create);
    }

    public Attr getAttributeNode(String name) {
        return this.mXml.getAttributeNode(name);
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return this.mXml.getAttributeNodeNS(namespaceURI, localName);
    }

    @Override
    public XmlNode.NodeKey getId() {
        return new XmlNode.NodeKey((String)(Strings.isNullOrEmpty((String)this.getKey()) ? this.getName().toString() : this.getName().toString() + "#" + this.getKey()));
    }

    @Override
    public XmlNode.NodeName getName() {
        return XmlNode.unwrapName(this.mXml);
    }

    public ManifestModel.NodeTypes getType() {
        return this.mType;
    }

    public String getKey() {
        return this.mType.getNodeKeyResolver().getKey(this.mXml);
    }

    @Override
    public SourcePosition getPosition() {
        return SourcePosition.UNKNOWN;
    }

    @Override
    public SourceFile getSourceFile() {
        return SourceFile.UNKNOWN;
    }
}

