/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlElement;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/manifmerger/OverrideLibrarySelector;", "", "selectorPackageName", "", "(Ljava/lang/String;)V", "packageNamePrefix", "appliesTo", "", "element", "Lcom/android/manifmerger/XmlElement;", "Companion", "manifest-merger"})
public final class OverrideLibrarySelector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String selectorPackageName;
    @Nullable
    private final String packageNamePrefix;
    @NotNull
    public static final String WILDCARD_SUFFIX = ".*";

    public OverrideLibrarySelector(@NotNull String selectorPackageName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)selectorPackageName, (String)"selectorPackageName");
        this.selectorPackageName = selectorPackageName;
        if (StringsKt.endsWith$default((String)this.selectorPackageName, (String)WILDCARD_SUFFIX, (boolean)false, (int)2, null) && this.selectorPackageName.length() > 2) {
            String string2 = this.selectorPackageName.substring(0, this.selectorPackageName.length() - 2);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = null;
        }
        this.packageNamePrefix = string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean appliesTo(@NotNull XmlElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Optional<XmlAttribute> packageName = element.getDocument().getPackage();
        if (this.packageNamePrefix != null) {
            if (!packageName.isPresent()) return false;
            String string = packageName.get().getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"packageName.get().value");
            if (!StringsKt.startsWith$default((String)string, (String)this.packageNamePrefix, (boolean)false, (int)2, null)) return false;
            return true;
        }
        if (!packageName.isPresent()) return false;
        if (!Intrinsics.areEqual((Object)this.selectorPackageName, (Object)packageName.get().getValue())) return false;
        return true;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/manifmerger/OverrideLibrarySelector$Companion;", "", "()V", "WILDCARD_SUFFIX", "", "manifest-merger"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

