/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.logging;

import com.android.build.gradle.internal.cxx.logging.LoggingEnvironment;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.LoggingMessage;
import com.android.build.gradle.internal.cxx.logging.LoggingMessageKt;
import com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment;
import com.android.build.gradle.internal.cxx.string.StringEncoder;
import com.android.utils.ILogger;
import com.android.utils.cxx.CxxBugDiagnosticCode;
import com.android.utils.cxx.CxxDiagnosticCode;
import com.google.protobuf.GeneratedMessageV3;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment;", "Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;", "()V", "close", "", "Companion", "gradle-core"})
public abstract class ThreadLoggingEnvironment
implements LoggingEnvironment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ThreadLocal<Companion.LoggerStack> loggerStack;
    @NotNull
    private static final Companion.BottomLoggingEnvironment BOTTOM_LOGGING_ENVIRONMENT;

    public ThreadLoggingEnvironment() {
        ThreadLoggingEnvironment.Companion.push(this);
    }

    @Override
    public void close() {
        ThreadLoggingEnvironment.Companion.pop();
    }

    @JvmStatic
    @NotNull
    public static final LoggingEnvironment parentLogger() {
        return Companion.parentLogger();
    }

    static {
        ThreadLocal threadLocal = ThreadLocal.withInitial(Companion.loggerStack.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(threadLocal, (String)"withInitial(...)");
        loggerStack = threadLocal;
        BOTTOM_LOGGING_ENVIRONMENT = new Companion.BottomLoggingEnvironment();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002%&B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u001a\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014J\b\u0010\u0017\u001a\u00020\u0006H\u0007J\b\u0010\u0018\u001a\u00020\u0012H\u0002J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u001aH\u0002J\u0016\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u000fJ\u000e\u0010!\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001cJ\u000e\u0010\"\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001cJ\u0018\u0010#\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001c2\b\u0010 \u001a\u0004\u0018\u00010\u000fJ\u0006\u0010$\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion;", "", "()V", "BOTTOM_LOGGING_ENVIRONMENT", "Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion$BottomLoggingEnvironment;", "logger", "Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;", "getLogger", "()Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;", "loggerStack", "Ljava/lang/ThreadLocal;", "Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion$LoggerStack;", "getILogger", "Lcom/android/utils/ILogger;", "warningDiagnosticCode", "Lcom/android/utils/cxx/CxxDiagnosticCode;", "errorDiagnosticCode", "logStructuredMessageToCurrentLogger", "", "message", "Lkotlin/Function1;", "Lcom/android/build/gradle/internal/cxx/string/StringEncoder;", "Lcom/google/protobuf/GeneratedMessageV3;", "parentLogger", "pop", "push", "Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment;", "reportFormattedBugToCurrentLogger", "", "bugCode", "Lcom/android/utils/cxx/CxxBugDiagnosticCode;", "reportFormattedErrorToCurrentLogger", "diagnosticCode", "reportFormattedInfoToCurrentLogger", "reportFormattedLifecycleToCurrentLogger", "reportFormattedWarningToCurrentLogger", "requireExplicitLogger", "BottomLoggingEnvironment", "LoggerStack", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        private final LoggingEnvironment getLogger() {
            Object object = (LoggerStack)loggerStack.get();
            if (object == null || (object = ((LoggerStack)object).getLogger()) == null) {
                object = BOTTOM_LOGGING_ENVIRONMENT;
            }
            return object;
        }

        private final void push(ThreadLoggingEnvironment logger) {
            loggerStack.set(new LoggerStack(logger, (LoggerStack)loggerStack.get()));
        }

        private final void pop() {
            LoggerStack next;
            LoggerStack loggerStack2 = (LoggerStack)loggerStack.get();
            LoggerStack loggerStack3 = next = loggerStack2 != null ? loggerStack2.getNext() : null;
            if (next != null) {
                loggerStack.set(next);
            } else {
                loggerStack.remove();
            }
        }

        @JvmStatic
        @NotNull
        public final LoggingEnvironment parentLogger() {
            Object object = (LoggerStack)loggerStack.get();
            if (object == null || (object = ((LoggerStack)object).getNext()) == null || (object = ((LoggerStack)object).getLogger()) == null) {
                object = BOTTOM_LOGGING_ENVIRONMENT;
            }
            return object;
        }

        public final void reportFormattedBugToCurrentLogger(@NotNull String message2, @NotNull CxxBugDiagnosticCode bugCode) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Intrinsics.checkNotNullParameter((Object)bugCode, (String)"bugCode");
            this.getLogger().log(LoggingMessageKt.bugRecordOf(message2, bugCode));
        }

        public final void reportFormattedErrorToCurrentLogger(@NotNull String message2, @NotNull CxxDiagnosticCode diagnosticCode) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Intrinsics.checkNotNullParameter((Object)diagnosticCode, (String)"diagnosticCode");
            this.getLogger().log(LoggingMessageKt.errorRecordOf(message2, diagnosticCode));
        }

        public final void reportFormattedWarningToCurrentLogger(@NotNull String message2, @Nullable CxxDiagnosticCode diagnosticCode) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            this.getLogger().log(LoggingMessageKt.warnRecordOf(message2, diagnosticCode));
        }

        public final void reportFormattedLifecycleToCurrentLogger(@NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            this.getLogger().log(LoggingMessageKt.lifecycleRecordOf(message2));
        }

        public final void reportFormattedInfoToCurrentLogger(@NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            this.getLogger().log(LoggingMessageKt.infoRecordOf(message2));
        }

        public final void logStructuredMessageToCurrentLogger(@NotNull Function1<? super StringEncoder, ? extends GeneratedMessageV3> message2) {
            Intrinsics.checkNotNullParameter(message2, (String)"message");
            this.getLogger().logStructured(message2);
        }

        public final void requireExplicitLogger() {
            if (Intrinsics.areEqual((Object)this.getLogger(), (Object)BOTTOM_LOGGING_ENVIRONMENT)) {
                throw new Exception("Non-default logger is required");
            }
        }

        @NotNull
        public final ILogger getILogger(@NotNull CxxDiagnosticCode warningDiagnosticCode, @NotNull CxxDiagnosticCode errorDiagnosticCode) {
            Intrinsics.checkNotNullParameter((Object)warningDiagnosticCode, (String)"warningDiagnosticCode");
            Intrinsics.checkNotNullParameter((Object)errorDiagnosticCode, (String)"errorDiagnosticCode");
            return new ILogger(errorDiagnosticCode, warningDiagnosticCode){
                final /* synthetic */ CxxDiagnosticCode $errorDiagnosticCode;
                final /* synthetic */ CxxDiagnosticCode $warningDiagnosticCode;
                {
                    this.$errorDiagnosticCode = $errorDiagnosticCode;
                    this.$warningDiagnosticCode = $warningDiagnosticCode;
                }

                public void error(@Nullable Throwable t, @Nullable String format, Object ... args) {
                    Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                    Throwable throwable = t;
                    if (throwable != null) {
                        throw throwable;
                    }
                    LoggingEnvironment loggingEnvironment = com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment$Companion.access$getLogger(ThreadLoggingEnvironment.Companion);
                    String string = format;
                    Intrinsics.checkNotNull((Object)string);
                    loggingEnvironment.log(LoggingMessageKt.errorRecordOf(LoggingEnvironmentKt.checkedFormat(string, args), this.$errorDiagnosticCode));
                }

                public void warning(@NotNull String format, Object ... args) {
                    Intrinsics.checkNotNullParameter((Object)format, (String)"format");
                    Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                    com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment$Companion.access$getLogger(ThreadLoggingEnvironment.Companion).log(LoggingMessageKt.warnRecordOf(LoggingEnvironmentKt.checkedFormat(format, args), this.$warningDiagnosticCode));
                }

                public void info(@NotNull String format, Object ... args) {
                    Intrinsics.checkNotNullParameter((Object)format, (String)"format");
                    Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                    com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment$Companion.access$getLogger(ThreadLoggingEnvironment.Companion).log(LoggingMessageKt.infoRecordOf(LoggingEnvironmentKt.checkedFormat(format, args)));
                }

                public void verbose(@NotNull String format, Object ... args) {
                    Intrinsics.checkNotNullParameter((Object)format, (String)"format");
                    Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                    com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment$Companion.access$getLogger(ThreadLoggingEnvironment.Companion).log(LoggingMessageKt.infoRecordOf(LoggingEnvironmentKt.checkedFormat(format, args)));
                }
            };
        }

        public static final /* synthetic */ LoggingEnvironment access$getLogger(Companion $this) {
            return $this.getLogger();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion$BottomLoggingEnvironment;", "Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "close", "", "log", "message", "Lcom/android/build/gradle/internal/cxx/logging/LoggingMessage;", "gradle-core"})
        private static final class BottomLoggingEnvironment
        implements LoggingEnvironment {
            private final Logger logger = Logging.getLogger(BottomLoggingEnvironment.class);

            @Override
            public void log(@NotNull LoggingMessage message2) {
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                LoggingMessage.LoggingLevel loggingLevel = message2.getLevel();
                switch (loggingLevel == null ? -1 : WhenMappings.$EnumSwitchMapping$0[loggingLevel.ordinal()]) {
                    case 1: {
                        this.logger.error(LoggingMessageKt.text(message2));
                        break;
                    }
                    case 2: {
                        this.logger.warn(LoggingMessageKt.text(message2));
                        break;
                    }
                    case 3: {
                        this.logger.lifecycle(LoggingMessageKt.text(message2));
                        break;
                    }
                    case 4: {
                        this.logger.info(LoggingMessageKt.text(message2));
                    }
                }
            }

            @Override
            public void close() {
            }

            @Metadata(mv={1, 9, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[LoggingMessage.LoggingLevel.values().length];
                    try {
                        nArray[LoggingMessage.LoggingLevel.ERROR.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[LoggingMessage.LoggingLevel.WARN.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[LoggingMessage.LoggingLevel.LIFECYCLE.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[LoggingMessage.LoggingLevel.INFO.ordinal()] = 4;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[LoggingMessage.LoggingLevel.BUG.ordinal()] = 5;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[LoggingMessage.LoggingLevel.UNRECOGNIZED.ordinal()] = 6;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0005J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0000H\u00c6\u0003J\u001f\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0000H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion$LoggerStack;", "", "logger", "Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;", "next", "(Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion$LoggerStack;)V", "getLogger", "()Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;", "getNext", "()Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion$LoggerStack;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "gradle-core"})
        private static final class LoggerStack {
            @NotNull
            private final LoggingEnvironment logger;
            @Nullable
            private final LoggerStack next;

            public LoggerStack(@NotNull LoggingEnvironment logger, @Nullable LoggerStack next) {
                Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
                this.logger = logger;
                this.next = next;
            }

            @NotNull
            public final LoggingEnvironment getLogger() {
                return this.logger;
            }

            @Nullable
            public final LoggerStack getNext() {
                return this.next;
            }

            @NotNull
            public final LoggingEnvironment component1() {
                return this.logger;
            }

            @Nullable
            public final LoggerStack component2() {
                return this.next;
            }

            @NotNull
            public final LoggerStack copy(@NotNull LoggingEnvironment logger, @Nullable LoggerStack next) {
                Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
                return new LoggerStack(logger, next);
            }

            public static /* synthetic */ LoggerStack copy$default(LoggerStack loggerStack2, LoggingEnvironment loggingEnvironment, LoggerStack loggerStack3, int n, Object object) {
                if ((n & 1) != 0) {
                    loggingEnvironment = loggerStack2.logger;
                }
                if ((n & 2) != 0) {
                    loggerStack3 = loggerStack2.next;
                }
                return loggerStack2.copy(loggingEnvironment, loggerStack3);
            }

            @NotNull
            public String toString() {
                return "LoggerStack(logger=" + this.logger + ", next=" + this.next + ")";
            }

            public int hashCode() {
                int result2 = this.logger.hashCode();
                result2 = result2 * 31 + (this.next == null ? 0 : this.next.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LoggerStack)) {
                    return false;
                }
                LoggerStack loggerStack2 = (LoggerStack)other;
                if (!Intrinsics.areEqual((Object)this.logger, (Object)loggerStack2.logger)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.next, (Object)loggerStack2.next);
            }
        }
    }
}

