/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.core.dsl.impl.features;

import com.android.build.api.dsl.BuildType;
import com.android.build.api.dsl.ProductFlavor;
import com.android.build.gradle.internal.core.dsl.features.ShadersDslInfo;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00070\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/core/dsl/impl/features/ShadersDslInfoImpl;", "Lcom/android/build/gradle/internal/core/dsl/features/ShadersDslInfo;", "defaultConfig", "Lcom/android/build/gradle/internal/dsl/DefaultConfig;", "buildTypeObj", "Lcom/android/build/api/dsl/BuildType;", "productFlavorList", "", "Lcom/android/build/api/dsl/ProductFlavor;", "(Lcom/android/build/gradle/internal/dsl/DefaultConfig;Lcom/android/build/api/dsl/BuildType;Ljava/util/List;)V", "defaultGlslcArgs", "", "getDefaultGlslcArgs", "()Ljava/util/List;", "scopedGlslcArgs", "", "getScopedGlslcArgs", "()Ljava/util/Map;", "scopedGlslcKeys", "", "getScopedGlslcKeys", "()Ljava/util/Set;", "getKey", "fullOption", "gradle-core"})
public final class ShadersDslInfoImpl
implements ShadersDslInfo {
    @NotNull
    private final DefaultConfig defaultConfig;
    @NotNull
    private final BuildType buildTypeObj;
    @NotNull
    private final List<ProductFlavor> productFlavorList;

    public ShadersDslInfoImpl(@NotNull DefaultConfig defaultConfig, @NotNull BuildType buildTypeObj, @NotNull List<? extends ProductFlavor> productFlavorList) {
        Intrinsics.checkNotNullParameter((Object)defaultConfig, (String)"defaultConfig");
        Intrinsics.checkNotNullParameter((Object)buildTypeObj, (String)"buildTypeObj");
        Intrinsics.checkNotNullParameter(productFlavorList, (String)"productFlavorList");
        this.defaultConfig = defaultConfig;
        this.buildTypeObj = buildTypeObj;
        this.productFlavorList = productFlavorList;
    }

    @Override
    @NotNull
    public List<String> getDefaultGlslcArgs() {
        HashMap hashMap = Maps.newHashMap();
        Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMap(...)");
        Map optionMap = hashMap;
        for (String option : this.defaultConfig.getShaders().getGlslcArgs()) {
            Intrinsics.checkNotNull((Object)option);
            optionMap.put(this.getKey(option), option);
        }
        int n = this.productFlavorList.size() + -1;
        if (0 <= n) {
            do {
                int i = n--;
                for (String option : this.productFlavorList.get(i).getShaders().getGlslcArgs()) {
                    optionMap.put(this.getKey(option), option);
                }
            } while (0 <= n);
        }
        for (String option : this.buildTypeObj.getShaders().getGlslcArgs()) {
            optionMap.put(this.getKey(option), option);
        }
        ArrayList arrayList = Lists.newArrayList((Iterable)optionMap.values());
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(...)");
        return arrayList;
    }

    @Override
    @NotNull
    public Map<String, List<String>> getScopedGlslcArgs() {
        HashMap hashMap = Maps.newHashMap();
        Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMap(...)");
        Map scopedArgs = hashMap;
        Set<String> keys = this.getScopedGlslcKeys();
        for (String key : keys) {
            ImmutableList immutableList;
            HashMap hashMap2 = Maps.newHashMap();
            Intrinsics.checkNotNullExpressionValue((Object)hashMap2, (String)"newHashMap(...)");
            Map optionMap = hashMap2;
            for (String option : this.defaultConfig.getShaders().getGlslcArgs()) {
                Intrinsics.checkNotNull((Object)option);
                optionMap.put(this.getKey(option), option);
            }
            for (String option : this.defaultConfig.getShaders().getScopedGlslcArgs().get((Object)key)) {
                Intrinsics.checkNotNull((Object)option);
                optionMap.put(this.getKey(option), option);
            }
            int n = this.productFlavorList.size() + -1;
            if (0 <= n) {
                do {
                    int i = n--;
                    for (String option : this.productFlavorList.get(i).getShaders().getGlslcArgs()) {
                        optionMap.put(this.getKey(option), option);
                    }
                    for (String option : this.productFlavorList.get(i).getShaders().getScopedGlslcArgs().get((Object)key)) {
                        Intrinsics.checkNotNull((Object)option);
                        optionMap.put(this.getKey(option), option);
                    }
                } while (0 <= n);
            }
            for (String option : this.buildTypeObj.getShaders().getGlslcArgs()) {
                optionMap.put(this.getKey(option), option);
            }
            for (String option : this.buildTypeObj.getShaders().getScopedGlslcArgs().get((Object)key)) {
                Intrinsics.checkNotNull((Object)option);
                optionMap.put(this.getKey(option), option);
            }
            Map map = scopedArgs;
            Intrinsics.checkNotNullExpressionValue((Object)ImmutableList.copyOf(optionMap.values()), (String)"copyOf(...)");
            map.put(key, immutableList);
        }
        return scopedArgs;
    }

    private final Set<String> getScopedGlslcKeys() {
        HashSet hashSet = Sets.newHashSet();
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"newHashSet(...)");
        Set keys = hashSet;
        Set set = this.defaultConfig.getShaders().getScopedGlslcArgs().keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keySet(...)");
        keys.addAll(set);
        for (ProductFlavor flavor : this.productFlavorList) {
            Set set2 = flavor.getShaders().getScopedGlslcArgs().keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"keySet(...)");
            keys.addAll(set2);
        }
        Set set3 = this.buildTypeObj.getShaders().getScopedGlslcArgs().keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"keySet(...)");
        keys.addAll(set3);
        return keys;
    }

    private final String getKey(String fullOption) {
        String string;
        int pos = StringsKt.lastIndexOf$default((CharSequence)fullOption, (char)'=', (int)0, (boolean)false, (int)6, null);
        if (pos == -1) {
            string = fullOption;
        } else {
            String string2 = fullOption.substring(0, pos);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        }
        return string;
    }
}

