/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.AvdManager;
import com.android.build.gradle.internal.AvdSnapshotHandler;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.ManagedVirtualDeviceLockManager;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.testing.AdbHelper;
import com.android.builder.utils.ExceptionFunction;
import com.android.builder.utils.SynchronizedFile;
import com.android.io.IAbstractFile;
import com.android.prefs.AndroidLocationsProvider;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.PathFileWrapper;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.internal.avd.AvdCamera;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.EmulatedProperties;
import com.android.sdklib.internal.avd.GpuMode;
import com.android.sdklib.internal.avd.HardwareProperties;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.LoggerProgressIndicatorWrapper;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.sun.xml.bind.v2.util.EditDistance;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\"J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0017J5\u0010&\u001a\u0004\u0018\u00010'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00052\u0006\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b-J,\u0010.\u001a\u00020\u00032\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00052\u0006\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\u0017J\u0014\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001700H\u0002J\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020\u00170\"2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00170\"J\u0006\u00103\u001a\u00020$J\u0010\u00104\u001a\u00020$2\u0006\u0010+\u001a\u00020\u0017H\u0002J*\u00105\u001a\b\u0012\u0004\u0012\u00020\u00170\"2\u0006\u0010,\u001a\u00020\u00172\b\b\u0002\u00106\u001a\u0002072\b\b\u0002\u00108\u001a\u000207H\u0002J\u0016\u00109\u001a\u00020$2\u0006\u0010+\u001a\u00020\u00172\u0006\u0010:\u001a\u00020\u0017J\u001a\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010=\u001a\u00020>H\u0002J)\u0010?\u001a\u0002H@\"\u0004\b\u0000\u0010@2\u0006\u0010+\u001a\u00020\u00172\f\u0010A\u001a\b\u0012\u0004\u0012\u0002H@0BH\u0002\u00a2\u0006\u0002\u0010CR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\n \u0014*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/android/build/gradle/internal/AvdManager;", "", "avdFolder", "Ljava/io/File;", "versionedSdkLoader", "Lorg/gradle/api/provider/Provider;", "Lcom/android/build/gradle/internal/SdkComponentsBuildService$VersionedSdkLoader;", "sdkHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "androidLocationsProvider", "Lcom/android/prefs/AndroidLocationsProvider;", "snapshotHandler", "Lcom/android/build/gradle/internal/AvdSnapshotHandler;", "deviceLockManager", "Lcom/android/build/gradle/internal/ManagedVirtualDeviceLockManager;", "adbHelper", "Lcom/android/build/gradle/internal/testing/AdbHelper;", "(Ljava/io/File;Lorg/gradle/api/provider/Provider;Lcom/android/sdklib/repository/AndroidSdkHandler;Lcom/android/prefs/AndroidLocationsProvider;Lcom/android/build/gradle/internal/AvdSnapshotHandler;Lcom/android/build/gradle/internal/ManagedVirtualDeviceLockManager;Lcom/android/build/gradle/internal/testing/AdbHelper;)V", "avdManager", "Lcom/android/sdklib/internal/avd/AvdManager;", "kotlin.jvm.PlatformType", "defaultEmulatorPropertiesMap", "", "", "getDeviceLockManager", "()Lcom/android/build/gradle/internal/ManagedVirtualDeviceLockManager;", "deviceManager", "Lcom/android/sdklib/devices/DeviceManager;", "logger", "Lcom/android/utils/ILogger;", "sdkDirectory", "getSdkDirectory", "()Ljava/io/File;", "allAvds", "", "closeOpenEmulators", "", "idPrefix", "createAvd", "Lcom/android/sdklib/internal/avd/AvdInfo;", "imageProvider", "Lorg/gradle/api/file/Directory;", "imageHash", "deviceName", "hardwareProfile", "createAvd$gradle_core", "createOrRetrieveAvd", "defaultHardwareConfig", "", "deleteAvds", "avds", "deleteDeviceLockTrackingFile", "deleteLockFile", "getHardwareProfiles", "maxEditDistance", "", "maxSuggestions", "loadSnapshotIfNeeded", "emulatorGpuFlag", "retrieveSystemImage", "Lcom/android/sdklib/ISystemImage;", "imageLocation", "Ljava/nio/file/Path;", "runWithMultiProcessLocking", "V", "runnable", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nAvdManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvdManager.kt\ncom/android/build/gradle/internal/AvdManager\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,371:1\n603#2:372\n11065#3:373\n11400#3,3:374\n766#4:377\n857#4,2:378\n1855#4,2:380\n1855#4,2:382\n*S KotlinDebug\n*F\n+ 1 AvdManager.kt\ncom/android/build/gradle/internal/AvdManager\n*L\n191#1:372\n232#1:373\n232#1:374,3\n247#1:377\n247#1:378,2\n280#1:380,2\n307#1:382,2\n*E\n"})
public final class AvdManager {
    @NotNull
    private final File avdFolder;
    @NotNull
    private final Provider<SdkComponentsBuildService.VersionedSdkLoader> versionedSdkLoader;
    @NotNull
    private final AndroidSdkHandler sdkHandler;
    @NotNull
    private final AndroidLocationsProvider androidLocationsProvider;
    @NotNull
    private final AvdSnapshotHandler snapshotHandler;
    @NotNull
    private final ManagedVirtualDeviceLockManager deviceLockManager;
    @NotNull
    private final AdbHelper adbHelper;
    @NotNull
    private final ILogger logger;
    private final DeviceManager deviceManager;
    private final com.android.sdklib.internal.avd.AvdManager avdManager;
    @NotNull
    private final Map<String, String> defaultEmulatorPropertiesMap;

    public AvdManager(@NotNull File avdFolder, @NotNull Provider<SdkComponentsBuildService.VersionedSdkLoader> versionedSdkLoader2, @NotNull AndroidSdkHandler sdkHandler, @NotNull AndroidLocationsProvider androidLocationsProvider, @NotNull AvdSnapshotHandler snapshotHandler, @NotNull ManagedVirtualDeviceLockManager deviceLockManager, @NotNull AdbHelper adbHelper2) {
        Intrinsics.checkNotNullParameter((Object)avdFolder, (String)"avdFolder");
        Intrinsics.checkNotNullParameter(versionedSdkLoader2, (String)"versionedSdkLoader");
        Intrinsics.checkNotNullParameter((Object)sdkHandler, (String)"sdkHandler");
        Intrinsics.checkNotNullParameter((Object)androidLocationsProvider, (String)"androidLocationsProvider");
        Intrinsics.checkNotNullParameter((Object)snapshotHandler, (String)"snapshotHandler");
        Intrinsics.checkNotNullParameter((Object)deviceLockManager, (String)"deviceLockManager");
        Intrinsics.checkNotNullParameter((Object)adbHelper2, (String)"adbHelper");
        this.avdFolder = avdFolder;
        this.versionedSdkLoader = versionedSdkLoader2;
        this.sdkHandler = sdkHandler;
        this.androidLocationsProvider = androidLocationsProvider;
        this.snapshotHandler = snapshotHandler;
        this.deviceLockManager = deviceLockManager;
        this.adbHelper = adbHelper2;
        LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(AvdManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)loggerWrapper, (String)"getLogger(...)");
        this.logger = loggerWrapper;
        FileUtils.mkdirs((File)this.avdFolder);
        this.deviceManager = DeviceManager.createInstance((AndroidLocationsProvider)this.androidLocationsProvider, (Path)this.getSdkDirectory().toPath(), (ILogger)this.logger);
        this.avdManager = com.android.sdklib.internal.avd.AvdManager.createInstance((AndroidSdkHandler)this.sdkHandler, (Path)this.sdkHandler.toCompatiblePath(this.avdFolder), (DeviceManager)this.deviceManager, (ILogger)this.logger);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"hw.camera.back", (Object)AvdCamera.EMULATED.getAsParameter()), TuplesKt.to((Object)"hw.cpu.ncore", (Object)String.valueOf(EmulatedProperties.RECOMMENDED_NUMBER_OF_CORES)), TuplesKt.to((Object)"skin.path", (Object)"_no_skin"), TuplesKt.to((Object)"showDeviceFrame", (Object)"yes"), TuplesKt.to((Object)"hw.camera.front", (Object)AvdCamera.EMULATED.getAsParameter()), TuplesKt.to((Object)"hw.keyboard", (Object)"yes"), TuplesKt.to((Object)"hw.gpu.mode", (Object)GpuMode.AUTO.getGpuSetting()), TuplesKt.to((Object)"hw.initialOrientation", (Object)"Portrait"), TuplesKt.to((Object)"disk.dataPartition.size", (Object)EmulatedProperties.DEFAULT_INTERNAL_STORAGE.toString()), TuplesKt.to((Object)"runtime.network.latency", (Object)"None"), TuplesKt.to((Object)"runtime.network.speed", (Object)"Full"), TuplesKt.to((Object)"sdcard.size", (Object)EmulatedProperties.DEFAULT_SDCARD_SIZE.toString()), TuplesKt.to((Object)"fastboot.forceChosenSnapshotBoot", (Object)"no"), TuplesKt.to((Object)"fastboot.forceColdBoot", (Object)"no"), TuplesKt.to((Object)"fastboot.forceFastBoot", (Object)"yes"), TuplesKt.to((Object)"hw.gpu.enabled", (Object)"yes"), TuplesKt.to((Object)"vm.heapSize", (Object)EmulatedProperties.DEFAULT_HEAP.toString())};
        this.defaultEmulatorPropertiesMap = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final ManagedVirtualDeviceLockManager getDeviceLockManager() {
        return this.deviceLockManager;
    }

    private final File getSdkDirectory() {
        File file = ((Directory)((SdkComponentsBuildService.VersionedSdkLoader)this.versionedSdkLoader.get()).getSdkDirectoryProvider().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        return file;
    }

    @NotNull
    public final File createOrRetrieveAvd(@NotNull Provider<Directory> imageProvider, @NotNull String imageHash, @NotNull String deviceName, @NotNull String hardwareProfile) {
        Intrinsics.checkNotNullParameter(imageProvider, (String)"imageProvider");
        Intrinsics.checkNotNullParameter((Object)imageHash, (String)"imageHash");
        Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
        Intrinsics.checkNotNullParameter((Object)hardwareProfile, (String)"hardwareProfile");
        return (File)this.runWithMultiProcessLocking(deviceName, (Function0)new Function0<File>(this, deviceName, imageProvider, imageHash, hardwareProfile){
            final /* synthetic */ AvdManager this$0;
            final /* synthetic */ String $deviceName;
            final /* synthetic */ Provider<Directory> $imageProvider;
            final /* synthetic */ String $imageHash;
            final /* synthetic */ String $hardwareProfile;
            {
                this.this$0 = $receiver;
                this.$deviceName = $deviceName;
                this.$imageProvider = $imageProvider;
                this.$imageHash = $imageHash;
                this.$hardwareProfile = $hardwareProfile;
                super(0);
            }

            @NotNull
            public final File invoke() {
                AvdInfo newInfo;
                Object object;
                AvdManager avdManager2;
                AvdInfo info2;
                AvdManager.access$getAvdManager$p(this.this$0).reloadAvds();
                AvdInfo avdInfo = info2 = AvdManager.access$getAvdManager$p(this.this$0).getAvd(this.$deviceName, false);
                if (avdInfo != null) {
                    AvdInfo avdInfo2 = avdInfo;
                    avdManager2 = this.this$0;
                    String string = this.$deviceName;
                    AvdInfo it = avdInfo2;
                    boolean bl = false;
                    if (info2.getStatus() == AvdInfo.AvdStatus.OK) {
                        AvdManager.access$getLogger$p(avdManager2).info("Device: " + string + " already exists. AVD creation skipped.", new Object[0]);
                        File file = info2.getConfigFile().toFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                        return file;
                    }
                    AvdManager.access$getLogger$p(avdManager2).warning(string + " needs to be recreated because it is invalid (AvdStatus = " + info2.getStatus() + ")", new Object[0]);
                    AvdManager.access$getAvdManager$p(avdManager2).deleteAvd(info2);
                }
                Object object2 = (object = (newInfo = this.this$0.createAvd$gradle_core(this.$imageProvider, this.$imageHash, this.$deviceName, this.$hardwareProfile))) != null && (object = object.getConfigFile()) != null ? object.toFile() : (avdManager2 = null);
                if (avdManager2 == null) {
                    throw new IllegalStateException("AVD could not be created.".toString());
                }
                return avdManager2;
            }
        });
    }

    private final <V> V runWithMultiProcessLocking(String deviceName, Function0<? extends V> runnable) {
        return (V)SynchronizedFile.getInstanceWithMultiProcessLocking((File)FilesKt.resolve((File)this.avdFolder, (String)deviceName)).write(new ExceptionFunction(runnable){
            final /* synthetic */ Function0<V> $runnable;
            {
                this.$runnable = $runnable;
            }

            public final V accept(File it) {
                return (V)this.$runnable.invoke();
            }
        });
    }

    private final void deleteLockFile(String deviceName) {
        File lockFile = SynchronizedFile.getLockFile((File)FilesKt.resolve((File)this.avdFolder, (String)deviceName));
        if (lockFile.exists()) {
            lockFile.delete();
        }
    }

    @Nullable
    public final AvdInfo createAvd$gradle_core(@NotNull Provider<Directory> imageProvider, @NotNull String imageHash, @NotNull String deviceName, @NotNull String hardwareProfile) {
        Object v1;
        Iterable iterable;
        ISystemImage systemImage;
        block6: {
            Intrinsics.checkNotNullParameter(imageProvider, (String)"imageProvider");
            Intrinsics.checkNotNullParameter((Object)imageHash, (String)"imageHash");
            Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
            Intrinsics.checkNotNullParameter((Object)hardwareProfile, (String)"hardwareProfile");
            if (!imageProvider.isPresent()) {
                throw new RuntimeException("Failed to find system image for hash: " + imageHash);
            }
            Path imageLocation = this.sdkHandler.toCompatiblePath(((Directory)imageProvider.get()).getAsFile());
            Intrinsics.checkNotNull((Object)imageLocation);
            systemImage = this.retrieveSystemImage(this.sdkHandler, imageLocation);
            if (systemImage == null) {
                throw new IllegalStateException(("System image does not exist at " + imageLocation).toString());
            }
            Collection collection = this.deviceManager.getDevices((Collection)DeviceManager.ALL_DEVICES);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getDevices(...)");
            iterable = collection;
            for (Object t : iterable) {
                Device it = (Device)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getDisplayName(), (Object)hardwareProfile)) continue;
                v1 = t;
                break block6;
            }
            v1 = null;
        }
        Device device = v1;
        if (device == null) {
            Iterable iterable2;
            iterable = AvdManager.getHardwareProfiles$default(this, hardwareProfile, 0, 0, 6, null);
            if (iterable.isEmpty()) {
                boolean bl = false;
                iterable2 = AvdManager.getHardwareProfiles$default(this, "Pixel 6", 0, 0, 6, null);
            } else {
                iterable2 = iterable;
            }
            List availableDevices = (List)iterable2;
            String errMsg = StringsKt.trimIndent((String)("\n                Failed to find hardware profile for name: " + hardwareProfile + "\n                Try one of the following device profiles: " + CollectionsKt.joinToString$default((Iterable)availableDevices, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "\n                "));
            throw new IllegalStateException(errMsg.toString());
        }
        Map<String, String> hardwareConfig = this.defaultHardwareConfig();
        Map map = DeviceManager.getHardwareProperties((Device)device);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getHardwareProperties(...)");
        hardwareConfig.putAll(map);
        EmulatedProperties.restrictDefaultRamSize(hardwareConfig);
        Path deviceFolder = AvdInfo.getDefaultAvdFolder((com.android.sdklib.internal.avd.AvdManager)this.avdManager, (String)deviceName, (boolean)false);
        return this.avdManager.createAvd(deviceFolder, deviceName, systemImage, null, null, hardwareConfig, null, device.getBootProps(), device.hasPlayStore(), false, false);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getHardwareProfiles(String hardwareProfile, int maxEditDistance, int maxSuggestions) {
        void $this$sortedBy$iv;
        Collection collection = this.deviceManager.getDevices((Collection)DeviceManager.ALL_DEVICES);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getDevices(...)");
        Sequence sequence = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.distinct((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)getHardwareProfiles.1.INSTANCE), (Function1)getHardwareProfiles.2.INSTANCE)), (Function1)((Function1)new Function1<String, Pair<? extends String, ? extends Integer>>(hardwareProfile){
            final /* synthetic */ String $hardwareProfile;
            {
                this.$hardwareProfile = $hardwareProfile;
                super(1);
            }

            @NotNull
            public final Pair<String, Integer> invoke(String it) {
                return TuplesKt.to((Object)it, (Object)EditDistance.editDistance((String)this.$hardwareProfile, (String)it));
            }
        })), (Function1)((Function1)new Function1<Pair<? extends String, ? extends Integer>, Boolean>(maxEditDistance){
            final /* synthetic */ int $maxEditDistance;
            {
                this.$maxEditDistance = $maxEditDistance;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Pair<String, Integer> pair) {
                Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 0>");
                int distance = ((Number)pair.component2()).intValue();
                return distance <= this.$maxEditDistance;
            }
        }));
        boolean $i$f$sortedBy = false;
        return SequencesKt.toList((Sequence)SequencesKt.take((Sequence)SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair pair = (Pair)a;
                boolean bl = false;
                int distance = ((Number)pair.component2()).intValue();
                pair = (Pair)b;
                Comparable comparable = Integer.valueOf(distance);
                bl = false;
                distance = ((Number)pair.component2()).intValue();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(distance));
            }
        }), (Function1)getHardwareProfiles.6.INSTANCE), (int)maxSuggestions));
    }

    static /* synthetic */ List getHardwareProfiles$default(AvdManager avdManager2, String string, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 3;
        }
        if ((n3 & 4) != 0) {
            n2 = 5;
        }
        return avdManager2.getHardwareProfiles(string, n, n2);
    }

    public final void loadSnapshotIfNeeded(@NotNull String deviceName, @NotNull String emulatorGpuFlag) {
        Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
        Intrinsics.checkNotNullParameter((Object)emulatorGpuFlag, (String)"emulatorGpuFlag");
        this.runWithMultiProcessLocking(deviceName, (Function0)new Function0<Unit>(this, deviceName, emulatorGpuFlag){
            final /* synthetic */ AvdManager this$0;
            final /* synthetic */ String $deviceName;
            final /* synthetic */ String $emulatorGpuFlag;
            {
                this.this$0 = $receiver;
                this.$deviceName = $deviceName;
                this.$emulatorGpuFlag = $emulatorGpuFlag;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                if (AvdSnapshotHandler.checkSnapshotLoadable$default(AvdManager.access$getSnapshotHandler$p(this.this$0), this.$deviceName, AvdManager.access$getAvdFolder$p(this.this$0), this.$emulatorGpuFlag, AvdManager.access$getLogger$p(this.this$0), null, 16, null)) {
                    AvdManager.access$getLogger$p(this.this$0).verbose("Snapshot already exists for device " + this.$deviceName, new Object[0]);
                    return;
                }
                Closeable closeable = this.this$0.getDeviceLockManager().lock(1);
                AvdManager avdManager2 = this.this$0;
                String string = this.$deviceName;
                String string2 = this.$emulatorGpuFlag;
                Throwable throwable = null;
                try {
                    ManagedVirtualDeviceLockManager.DeviceLock it = (ManagedVirtualDeviceLockManager.DeviceLock)closeable;
                    boolean bl = false;
                    AvdSnapshotHandler avdSnapshotHandler = AvdManager.access$getSnapshotHandler$p(avdManager2);
                    File file = AvdManager.access$getAvdFolder$p(avdManager2);
                    com.android.sdklib.internal.avd.AvdManager avdManager3 = AvdManager.access$getAvdManager$p(avdManager2);
                    Intrinsics.checkNotNullExpressionValue((Object)avdManager3, (String)"access$getAvdManager$p(...)");
                    avdSnapshotHandler.generateSnapshot(string, file, string2, avdManager3, AvdManager.access$getLogger$p(avdManager2));
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                AvdManager.access$getLogger$p(this.this$0).verbose("Verified snapshot created for: " + this.$deviceName + ".", new Object[0]);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> allAvds() {
        void $this$mapTo$iv$iv;
        this.avdManager.reloadAvds();
        AvdInfo[] avdInfoArray = this.avdManager.getAllAvds();
        Intrinsics.checkNotNullExpressionValue((Object)avdInfoArray, (String)"getAllAvds(...)");
        Object[] $this$map$iv = avdInfoArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AvdInfo avdInfo = (AvdInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> deleteAvds(@NotNull List<String> avds) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(avds, (String)"avds");
        this.avdManager.reloadAvds();
        Iterable $this$filter$iv = avds;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String avdName = (String)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)this.runWithMultiProcessLocking(avdName, (Function0)new Function0<Boolean>(this, avdName){
                final /* synthetic */ AvdManager this$0;
                final /* synthetic */ String $avdName;
                {
                    this.this$0 = $receiver;
                    this.$avdName = $avdName;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    boolean isDeleted;
                    AvdInfo avdInfo = AvdManager.access$getAvdManager$p(this.this$0).getAvd(this.$avdName, false);
                    boolean bl = isDeleted = avdInfo != null ? AvdManager.access$getAvdManager$p(this.this$0).deleteAvd(avdInfo) : false;
                    if (!isDeleted) {
                        AvdManager.access$getLogger$p(this.this$0).warning("Failed to delete avd: " + this.$avdName + ".", new Object[0]);
                    } else {
                        AvdManager.access$getLogger$p(this.this$0).verbose("Deleting lock file for: " + this.$avdName, new Object[0]);
                        AvdManager.access$deleteLockFile(this.this$0, this.$avdName);
                    }
                    return isDeleted;
                }
            })).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void deleteDeviceLockTrackingFile() {
        this.deviceLockManager.deleteLockFile();
    }

    public final void closeOpenEmulators(@NotNull String idPrefix) {
        Intrinsics.checkNotNullParameter((Object)idPrefix, (String)"idPrefix");
        Iterable $this$forEach$iv = this.adbHelper.findAllDeviceSerialsWithIdPrefix(idPrefix);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String serial = (String)element$iv;
            boolean bl = false;
            this.adbHelper.killDevice(serial);
        }
    }

    private final Map<String, String> defaultHardwareConfig() {
        Provider<Directory> emulatorProvider = ((SdkComponentsBuildService.VersionedSdkLoader)this.versionedSdkLoader.get()).getEmulatorDirectoryProvider();
        if (!emulatorProvider.isPresent()) {
            throw new IllegalStateException("AVD Emulator package is not downloaded. Failed to retrieve hardware defaults for virtual device.".toString());
        }
        File emulatorLib = ((Directory)emulatorProvider.get()).getAsFile();
        File libDirectory = new File(emulatorLib, "lib");
        File hardwareDefs = new File(libDirectory, "hardware-properties.ini");
        Map map = HardwareProperties.parseHardwareDefinitions((IAbstractFile)((IAbstractFile)new PathFileWrapper(this.sdkHandler.toCompatiblePath(hardwareDefs))), (ILogger)this.logger);
        if (map == null) {
            throw new IllegalStateException("Failed to find hardware definitions for emulator.".toString());
        }
        Map hwMap = map;
        Map hwConfigMap = MapsKt.toMutableMap(this.defaultEmulatorPropertiesMap);
        Iterable $this$forEach$iv = hwMap.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            HardwareProperties.HardwareProperty it = (HardwareProperties.HardwareProperty)element$iv;
            boolean bl = false;
            String string2 = it.getDefault();
            Object object = string2;
            if (object == null || object.length() == 0) continue;
            object = hwConfigMap;
            Intrinsics.checkNotNullExpressionValue((Object)it.getName(), (String)"getName(...)");
            Intrinsics.checkNotNull((Object)string2);
            String string3 = string2;
            object.put(string, string3);
        }
        return hwConfigMap;
    }

    private final ISystemImage retrieveSystemImage(AndroidSdkHandler sdkHandler, Path imageLocation) {
        long delay = 2L;
        for (int retry = 0; retry < 5; ++retry) {
            ISystemImage systemImage = sdkHandler.getSystemImageManager((ProgressIndicator)new LoggerProgressIndicatorWrapper(this.logger)).getImageAt(imageLocation);
            if (systemImage != null) {
                return systemImage;
            }
            if (retry == 4) continue;
            this.logger.warning("Failed to to retrieve system image at: " + imageLocation + " Retrying in " + delay + " seconds", new Object[0]);
            Thread.sleep(delay * (long)1000);
            delay = Math.min(delay * 2L, 10L);
        }
        return null;
    }

    public static final /* synthetic */ com.android.sdklib.internal.avd.AvdManager access$getAvdManager$p(AvdManager $this) {
        return $this.avdManager;
    }

    public static final /* synthetic */ ILogger access$getLogger$p(AvdManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ AvdSnapshotHandler access$getSnapshotHandler$p(AvdManager $this) {
        return $this.snapshotHandler;
    }

    public static final /* synthetic */ File access$getAvdFolder$p(AvdManager $this) {
        return $this.avdFolder;
    }

    public static final /* synthetic */ void access$deleteLockFile(AvdManager $this, String deviceName) {
        $this.deleteLockFile(deviceName);
    }
}

