/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.dependencies;

import com.android.build.gradle.internal.attributes.VariantAttr;
import com.android.build.gradle.internal.ide.DependenciesImpl;
import com.android.build.gradle.internal.testFixtures.TestFixturesUtil;
import com.android.builder.model.Dependencies;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.capabilities.Capability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\f\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u0007\u001a\n\u0010\b\u001a\u00020\t*\u00020\u0007\u001a\n\u0010\n\u001a\u00020\t*\u00020\u0007\u00a8\u0006\u000b"}, d2={"clone", "Lcom/android/builder/model/Dependencies;", "dependencies", "modelLevel", "", "getVariantName", "", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "hasLibraryTestFixturesCapability", "", "hasProjectTestFixturesCapability", "gradle-core"})
@JvmName(name="LibraryUtils")
@SourceDebugExtension(value={"SMAP\nLibraryUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryUtils.kt\ncom/android/build/gradle/internal/ide/dependencies/LibraryUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1747#2,3:83\n1747#2,3:86\n*S KotlinDebug\n*F\n+ 1 LibraryUtils.kt\ncom/android/build/gradle/internal/ide/dependencies/LibraryUtils\n*L\n62#1:83,3\n76#1:86,3\n*E\n"})
public final class LibraryUtils {
    @NotNull
    public static final Dependencies clone(@NotNull Dependencies dependencies2, int modelLevel) {
        Intrinsics.checkNotNullParameter((Object)dependencies2, (String)"dependencies");
        if (modelLevel >= 4) {
            Dependencies dependencies3 = DependenciesImpl.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)dependencies3, (String)"EMPTY");
            return dependencies3;
        }
        List libraries = CollectionsKt.emptyList();
        ArrayList javaLibraries = Lists.newArrayList((Iterable)dependencies2.getJavaLibraries());
        List projects = CollectionsKt.emptyList();
        return new DependenciesImpl(libraries, javaLibraries, projects, Lists.newArrayList((Iterable)dependencies2.getRuntimeOnlyClasses()));
    }

    @Nullable
    public static final String getVariantName(@NotNull ResolvedArtifactResult $this$getVariantName) {
        Intrinsics.checkNotNullParameter((Object)$this$getVariantName, (String)"<this>");
        VariantAttr variantAttr = (VariantAttr)$this$getVariantName.getVariant().getAttributes().getAttribute(VariantAttr.ATTRIBUTE);
        return variantAttr != null ? variantAttr.getName() : null;
    }

    public static final boolean hasProjectTestFixturesCapability(@NotNull ResolvedArtifactResult $this$hasProjectTestFixturesCapability) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$hasProjectTestFixturesCapability, (String)"<this>");
            if (!($this$hasProjectTestFixturesCapability.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier)) {
                return false;
            }
            List list = $this$hasProjectTestFixturesCapability.getVariant().getCapabilities();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"variant.capabilities");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Capability it = (Capability)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    ComponentIdentifier componentIdentifier = $this$hasProjectTestFixturesCapability.getId().getComponentIdentifier();
                    Intrinsics.checkNotNull((Object)componentIdentifier, (String)"null cannot be cast to non-null type org.gradle.api.artifacts.component.ProjectComponentIdentifier");
                    String string = ((ProjectComponentIdentifier)componentIdentifier).getProjectName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id.componentIdentifier a\u2026ntIdentifier).projectName");
                    if (!TestFixturesUtil.isProjectTestFixturesCapability(it, string)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean hasLibraryTestFixturesCapability(@NotNull ResolvedArtifactResult $this$hasLibraryTestFixturesCapability) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$hasLibraryTestFixturesCapability, (String)"<this>");
            if (!($this$hasLibraryTestFixturesCapability.getId().getComponentIdentifier() instanceof ModuleComponentIdentifier)) {
                return false;
            }
            List list = $this$hasLibraryTestFixturesCapability.getVariant().getCapabilities();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"variant.capabilities");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Capability it = (Capability)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    ComponentIdentifier componentIdentifier = $this$hasLibraryTestFixturesCapability.getId().getComponentIdentifier();
                    Intrinsics.checkNotNull((Object)componentIdentifier, (String)"null cannot be cast to non-null type org.gradle.api.artifacts.component.ModuleComponentIdentifier");
                    String string = ((ModuleComponentIdentifier)componentIdentifier).getModule();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id.componentIdentifier a\u2026mponentIdentifier).module");
                    if (!TestFixturesUtil.isLibraryTestFixturesCapability(it, string)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }
}

