/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.build.api.dsl.ApkSigningConfig;
import com.android.build.gradle.internal.api.ReadOnlyBuildType;
import com.android.build.gradle.internal.api.ReadOnlyProductFlavor;
import com.android.build.gradle.internal.api.ReadOnlySigningConfig;
import com.android.builder.model.BuildType;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SigningConfig;
import com.google.common.collect.Maps;
import java.util.Map;

public class ReadOnlyObjectProvider {
    private ReadOnlyProductFlavor readOnlyDefaultConfig;
    private final Map<BuildType, BuildType> readOnlyBuildTypes = Maps.newIdentityHashMap();
    private final Map<ProductFlavor, ProductFlavor> readOnlyFlavors = Maps.newIdentityHashMap();
    private final Map<ApkSigningConfig, SigningConfig> readOnlySigningConfig = Maps.newIdentityHashMap();

    ProductFlavor getDefaultConfig(ProductFlavor defaultConfig) {
        if (this.readOnlyDefaultConfig != null) {
            if (this.readOnlyDefaultConfig.productFlavor != defaultConfig) {
                throw new IllegalStateException("Different DefaultConfigs passed to ApiObjectProvider");
            }
        } else {
            this.readOnlyDefaultConfig = new ReadOnlyProductFlavor(defaultConfig, this);
        }
        return this.readOnlyDefaultConfig;
    }

    public BuildType getBuildType(BuildType buildType) {
        BuildType readOnlyBuildType = this.readOnlyBuildTypes.get(buildType);
        if (readOnlyBuildType == null) {
            readOnlyBuildType = new ReadOnlyBuildType(buildType, this);
            this.readOnlyBuildTypes.put(buildType, readOnlyBuildType);
        }
        return readOnlyBuildType;
    }

    public ProductFlavor getProductFlavor(ProductFlavor productFlavor) {
        ProductFlavor readOnlyProductFlavor = this.readOnlyFlavors.get(productFlavor);
        if (readOnlyProductFlavor == null) {
            readOnlyProductFlavor = new ReadOnlyProductFlavor(productFlavor, this);
            this.readOnlyFlavors.put(productFlavor, readOnlyProductFlavor);
        }
        return readOnlyProductFlavor;
    }

    public SigningConfig getSigningConfig(ApkSigningConfig signingConfig2) {
        if (signingConfig2 == null) {
            return null;
        }
        SigningConfig readOnlySigningConfig = this.readOnlySigningConfig.get(signingConfig2);
        if (readOnlySigningConfig == null) {
            readOnlySigningConfig = new ReadOnlySigningConfig(signingConfig2);
            this.readOnlySigningConfig.put(signingConfig2, readOnlySigningConfig);
        }
        return readOnlySigningConfig;
    }
}

