/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.gradle.internal.ide.SourceProviderImpl;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

final class SourceProviderContainerImpl
implements SourceProviderContainer,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final SourceProvider sourceProvider;

    static SourceProviderContainer clone(SourceProviderContainer sourceProviderContainer) {
        return SourceProviderContainerImpl.create(sourceProviderContainer.getArtifactName(), sourceProviderContainer.getSourceProvider());
    }

    static List<SourceProviderContainer> cloneCollection(Collection<SourceProviderContainer> containers) {
        return containers.stream().map(SourceProviderContainerImpl::clone).collect(Collectors.toList());
    }

    static SourceProviderContainer create(String name, SourceProvider sourceProvider) {
        return new SourceProviderContainerImpl(name, new SourceProviderImpl(sourceProvider));
    }

    private SourceProviderContainerImpl(String name, SourceProvider sourceProvider) {
        this.name = name;
        this.sourceProvider = sourceProvider;
    }

    public String getArtifactName() {
        return this.name;
    }

    public SourceProvider getSourceProvider() {
        return this.sourceProvider;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceProviderContainerImpl that = (SourceProviderContainerImpl)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.sourceProvider, that.sourceProvider);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.sourceProvider);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("sourceProvider", (Object)this.sourceProvider).toString();
    }
}

