/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.core;

import com.google.common.collect.ImmutableList;
import java.util.Collection;

public enum Abi {
    ARMEABI("armeabi", "arm", "arm-linux-androideabi", "arm-linux-androideabi", false, false),
    ARMEABI_V7A("armeabi-v7a", "arm", "arm-linux-androideabi", "arm-linux-androideabi", false, true),
    ARM64_V8A("arm64-v8a", "arm64", "aarch64-linux-android", "aarch64-linux-android", true, true),
    X86("x86", "x86", "x86", "i686-linux-android", false, true),
    X86_64("x86_64", "x86_64", "x86_64", "x86_64-linux-android", true, true),
    MIPS("mips", "mips", "mipsel-linux-android", "mipsel-linux-android", false, false),
    MIPS64("mips64", "mips64", "mips64el-linux-android", "mips64el-linux-android", true, false);

    private final String name;
    final String architecture;
    private final String gccToolchainPrefix;
    private final String gccExecutablePrefix;
    private final boolean supports64Bits;
    private final boolean isDefault;
    private static ImmutableList<Abi> defaultValues;

    private Abi(String name, String architecture, String gccToolchainPrefix, String gccExecutablePrefix, boolean supports64Bits2, boolean isDefault) {
        this.name = name;
        this.architecture = architecture;
        this.gccToolchainPrefix = gccToolchainPrefix;
        this.gccExecutablePrefix = gccExecutablePrefix;
        this.supports64Bits = supports64Bits2;
        this.isDefault = isDefault;
    }

    public static Abi getByName(String name) {
        for (Abi abi : Abi.values()) {
            if (!abi.name.equals(name)) continue;
            return abi;
        }
        return null;
    }

    public String getTag() {
        return this.name;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getGccToolchainPrefix() {
        return this.gccToolchainPrefix;
    }

    public String getGccExecutablePrefix() {
        return this.gccExecutablePrefix;
    }

    public boolean supports64Bits() {
        return this.supports64Bits;
    }

    public static Collection<Abi> getDefaultValues() {
        if (defaultValues != null) {
            return defaultValues;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Abi abi : Abi.values()) {
            if (!abi.isDefault) continue;
            builder.add((Object)abi);
        }
        defaultValues = builder.build();
        return defaultValues;
    }

    static {
        defaultValues = null;
    }
}

