/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.artifact.impl.InternalScopedArtifacts;
import com.android.build.api.dsl.Device;
import com.android.build.api.dsl.DeviceGroup;
import com.android.build.api.instrumentation.manageddevice.DeviceSetupConfigureAction;
import com.android.build.api.instrumentation.manageddevice.DeviceSetupTaskAction;
import com.android.build.gradle.internal.AndroidTestTaskManager;
import com.android.build.gradle.internal.ManagedDeviceUtilsKt;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.component.AndroidTestCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.KmpComponentCreationConfig;
import com.android.build.gradle.internal.component.TestComponentCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.coverage.JacocoConfigurations;
import com.android.build.gradle.internal.coverage.JacocoReportTask;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.ManagedVirtualDevice;
import com.android.build.gradle.internal.profile.AnalyticsConfiguratorService;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.AndroidReportTask;
import com.android.build.gradle.internal.tasks.AppClasspathCheckTask;
import com.android.build.gradle.internal.tasks.CompressAssetsTask;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.tasks.JacocoTask;
import com.android.build.gradle.internal.tasks.ManagedDeviceCleanTask;
import com.android.build.gradle.internal.tasks.ManagedDeviceInstrumentationTestSetupTask;
import com.android.build.gradle.internal.tasks.ManagedDeviceSetupTask;
import com.android.build.gradle.internal.tasks.SigningConfigVersionsWriterTask;
import com.android.build.gradle.internal.tasks.SigningConfigWriterTask;
import com.android.build.gradle.internal.tasks.TestPreBuildTask;
import com.android.build.gradle.internal.tasks.TestServerTask;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.build.gradle.internal.tasks.factory.TaskFactory;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitUtils;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.test.BundleTestDataImpl;
import com.android.build.gradle.internal.test.TestDataImpl;
import com.android.build.gradle.internal.testing.ManagedDeviceRegistry;
import com.android.build.gradle.internal.testing.utp.UtpTestUtilsKt;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.testing.api.DeviceProvider;
import com.android.builder.testing.api.TestServer;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableSet;
import com.google.wireless.android.sdk.stats.GradleBuildProject;
import com.google.wireless.android.sdk.stats.ProjectApiUse;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\rH\u0002J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0012\u001a\u00020\rH\u0002J\u0006\u0010\u0013\u001a\u00020\rJ\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/AndroidTestTaskManager;", "Lcom/android/build/gradle/internal/TaskManager;", "project", "Lorg/gradle/api/Project;", "globalConfig", "Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;", "(Lorg/gradle/api/Project;Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;)V", "javaResMergingScopes", "", "Lcom/android/build/api/artifact/impl/InternalScopedArtifacts$InternalScope;", "getJavaResMergingScopes", "()Ljava/util/Set;", "createConnectedTestForVariant", "", "androidTestProperties", "Lcom/android/build/gradle/internal/component/AndroidTestCreationConfig;", "createMockableJarTask", "createTasks", "createTestDevicesTasks", "createTopLevelTasks", "createVariantPreBuildTask", "creationConfig", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nAndroidTestTaskManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidTestTaskManager.kt\ncom/android/build/gradle/internal/AndroidTestTaskManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,448:1\n800#2,11:449\n*S KotlinDebug\n*F\n+ 1 AndroidTestTaskManager.kt\ncom/android/build/gradle/internal/AndroidTestTaskManager\n*L\n332#1:449,11\n*E\n"})
public final class AndroidTestTaskManager
extends TaskManager {
    @NotNull
    private final Set<InternalScopedArtifacts.InternalScope> javaResMergingScopes;

    public AndroidTestTaskManager(@NotNull Project project2, @NotNull GlobalTaskCreationConfig globalConfig2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)globalConfig2, (String)"globalConfig");
        super(project2, globalConfig2);
        InternalScopedArtifacts.InternalScope[] internalScopeArray = new InternalScopedArtifacts.InternalScope[]{InternalScopedArtifacts.InternalScope.SUB_PROJECTS, InternalScopedArtifacts.InternalScope.EXTERNAL_LIBS};
        this.javaResMergingScopes = SetsKt.setOf((Object[])internalScopeArray);
    }

    public final void createTopLevelTasks() {
        this.createMockableJarTask();
        List reportTasks = new ArrayList();
        List<DeviceProvider> providers = this.globalConfig.getDeviceProviders();
        Object connectedAndroidTestTask = null;
        if (this.globalConfig.getProductFlavorCount() > 0) {
            connectedAndroidTestTask = this.taskFactory.register(new AndroidReportTask.CreationAction(this.globalConfig, AndroidReportTask.CreationAction.TaskKind.CONNECTED));
            String string = connectedAndroidTestTask.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"connectedAndroidTestTask.name");
            reportTasks.add(string);
        } else {
            connectedAndroidTestTask = this.taskFactory.register("connectedAndroidTest", createTopLevelTasks.1.INSTANCE);
        }
        this.taskFactory.configure("connectedCheck", (Action<? super Task>)new Action((TaskProvider<? extends Task>)connectedAndroidTestTask){
            final /* synthetic */ TaskProvider<? extends Task> $connectedAndroidTestTask;
            {
                this.$connectedAndroidTestTask = $connectedAndroidTestTask;
            }

            public final void execute(@NotNull Task check) {
                Intrinsics.checkNotNullParameter((Object)check, (String)"check");
                Object[] objectArray = new Object[]{this.$connectedAndroidTestTask.getName()};
                check.dependsOn(objectArray);
            }
        });
        Object deviceAndroidTestTask = null;
        if (providers.size() > 1 || this.globalConfig.getProductFlavorCount() > 0) {
            deviceAndroidTestTask = this.taskFactory.register(new AndroidReportTask.CreationAction(this.globalConfig, AndroidReportTask.CreationAction.TaskKind.DEVICE_PROVIDER));
            String string = deviceAndroidTestTask.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"deviceAndroidTestTask.name");
            reportTasks.add(string);
        } else {
            deviceAndroidTestTask = this.taskFactory.register("deviceAndroidTest", createTopLevelTasks.3.INSTANCE);
        }
        this.taskFactory.configure("deviceCheck", (Action<? super Task>)new Action((TaskProvider<? extends Task>)deviceAndroidTestTask){
            final /* synthetic */ TaskProvider<? extends Task> $deviceAndroidTestTask;
            {
                this.$deviceAndroidTestTask = $deviceAndroidTestTask;
            }

            public final void execute(@NotNull Task check) {
                Intrinsics.checkNotNullParameter((Object)check, (String)"check");
                Object[] objectArray = new Object[]{this.$deviceAndroidTestTask.getName()};
                check.dependsOn(objectArray);
            }
        });
        if (!((Collection)reportTasks).isEmpty() && this.project.getGradle().getStartParameter().isContinueOnFailure()) {
            this.project.getGradle().getTaskGraph().whenReady(new Action(reportTasks, this){
                final /* synthetic */ List<String> $reportTasks;
                final /* synthetic */ AndroidTestTaskManager this$0;
                {
                    this.$reportTasks = $reportTasks;
                    this.this$0 = $receiver;
                }

                public final void execute(@NotNull TaskExecutionGraph taskGraph) {
                    Intrinsics.checkNotNullParameter((Object)taskGraph, (String)"taskGraph");
                    for (String reportTask : this.$reportTasks) {
                        if (!taskGraph.hasTask(TaskManager.Companion.getTaskPath(this.this$0.project, reportTask))) continue;
                        this.this$0.taskFactory.configure(reportTask, (Action<? super Task>)createTopLevelTasks.1.INSTANCE);
                    }
                }
            });
        }
        this.createTestDevicesTasks();
    }

    public final void createTasks(@NotNull AndroidTestCreationConfig androidTestProperties) {
        Intrinsics.checkNotNullParameter((Object)androidTestProperties, (String)"androidTestProperties");
        this.createAnchorTasks(androidTestProperties);
        this.createDependencyStreams(androidTestProperties);
        this.createProcessTestManifestTask(androidTestProperties);
        this.createGenerateResValuesTask(androidTestProperties);
        this.createRenderscriptTask(androidTestProperties);
        ComponentCreationConfig componentCreationConfig = androidTestProperties;
        ImmutableSet immutableSet = ImmutableSet.of();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"of()");
        this.createMergeResourcesTask(componentCreationConfig, true, (Set)immutableSet);
        this.createShaderTask(androidTestProperties);
        this.createMergeAssetsTask(androidTestProperties);
        this.taskFactory.register(new CompressAssetsTask.CreationAction(androidTestProperties));
        this.createBuildConfigTask(androidTestProperties);
        this.createApkProcessResTask(androidTestProperties);
        this.createProcessJavaResTask(androidTestProperties);
        this.createAidlTask(androidTestProperties);
        this.createMergeJniLibFoldersTasks(androidTestProperties);
        this.createDataBindingTasksIfNecessary(androidTestProperties);
        if (!(androidTestProperties instanceof KmpComponentCreationConfig)) {
            TaskManager.Companion.setJavaCompilerTask(this.createJavacTask(androidTestProperties), androidTestProperties);
        }
        this.createPostCompilationTasks(androidTestProperties);
        this.createValidateSigningTask(androidTestProperties);
        this.taskFactory.register(new SigningConfigWriterTask.CreationAction(androidTestProperties));
        this.taskFactory.register(new SigningConfigVersionsWriterTask.CreationAction(androidTestProperties));
        this.createPackagingTask(androidTestProperties);
        this.taskFactory.configure("assembleAndroidTest", (Action<? super Task>)new Action(androidTestProperties){
            final /* synthetic */ AndroidTestCreationConfig $androidTestProperties;
            {
                this.$androidTestProperties = $androidTestProperties;
            }

            public final void execute(@NotNull Task assembleTest) {
                Intrinsics.checkNotNullParameter((Object)assembleTest, (String)"assembleTest");
                Object[] objectArray = new Object[]{this.$androidTestProperties.getTaskContainer().getAssembleTask().getName()};
                assembleTest.dependsOn(objectArray);
            }
        });
        this.createConnectedTestForVariant(androidTestProperties);
    }

    private final void createConnectedTestForVariant(AndroidTestCreationConfig androidTestProperties) {
        GradleBuildProject.Builder providerTask;
        Object object;
        List<DeviceProvider> providers;
        ProjectApiUse.Builder reportTask;
        AbstractTestDataImpl abstractTestDataImpl;
        FileCollection privacySandboxSdkApks;
        VariantCreationConfig testedVariant = androidTestProperties.getMainVariant();
        boolean isLibrary = testedVariant.getComponentType().isAar();
        FileCollection fileCollection2 = privacySandboxSdkApks = androidTestProperties.getServices().getProjectOptions().get(BooleanOption.PRIVACY_SANDBOX_SDK_SUPPORT) ? VariantDependencies.getArtifactFileCollection$default(testedVariant.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.ANDROID_PRIVACY_SANDBOX_SDK_APKS, null, 8, null) : null;
        if (testedVariant.getComponentType().isDynamicFeature()) {
            Provider<String> provider2 = androidTestProperties.getNamespace();
            Provider provider3 = androidTestProperties.getArtifacts().get((SingleArtifact)SingleArtifact.APK.INSTANCE);
            String string = this.project.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.path");
            abstractTestDataImpl = new BundleTestDataImpl(provider2, androidTestProperties, provider3, FeatureSplitUtils.getFeatureName(string), VariantDependencies.getArtifactFileCollection$default(testedVariant.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.APKS_FROM_BUNDLE, null, 8, null), privacySandboxSdkApks);
        } else {
            Object[] objectArray = new Object[]{testedVariant.getArtifacts().get((SingleArtifact)SingleArtifact.APK.INSTANCE)};
            ConfigurableFileCollection testedApkFileCollection = this.project.files(objectArray);
            abstractTestDataImpl = new TestDataImpl(androidTestProperties.getNamespace(), androidTestProperties, androidTestProperties.getArtifacts().get((SingleArtifact)SingleArtifact.APK.INSTANCE), (FileCollection)(isLibrary ? null : testedApkFileCollection), privacySandboxSdkApks);
        }
        AbstractTestDataImpl testData = abstractTestDataImpl;
        this.configureTestData(androidTestProperties, testData);
        Provider provider4 = this.taskFactory.named("connectedCheck").flatMap((Transformer)createConnectedTestForVariant.connectedCheckSerials.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider4, (String)"taskFactory.named(CONNEC\u2026erialValues\n            }");
        Provider connectedCheckSerials2 = provider4;
        TaskProvider connectedTask = this.taskFactory.register(new DeviceProviderInstrumentTestTask.CreationAction(androidTestProperties, testData, (Provider<List<String>>)connectedCheckSerials2));
        this.taskFactory.configure("connectedAndroidTest", (Action<? super Task>)new Action(connectedTask){
            final /* synthetic */ TaskProvider<DeviceProviderInstrumentTestTask> $connectedTask;
            {
                this.$connectedTask = $connectedTask;
            }

            public final void execute(@NotNull Task connectedAndroidTest) {
                Intrinsics.checkNotNullParameter((Object)connectedAndroidTest, (String)"connectedAndroidTest");
                Object[] objectArray = new Object[]{this.$connectedTask};
                connectedAndroidTest.dependsOn(objectArray);
            }
        });
        if (androidTestProperties.isAndroidTestCoverageEnabled()) {
            Configuration configuration = JacocoConfigurations.getJacocoAntTaskConfiguration(this.project, JacocoTask.Companion.getJacocoVersion(androidTestProperties));
            Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"getJacocoAntTaskConfigur\u2026n(androidTestProperties))");
            Configuration jacocoAntConfiguration = configuration;
            reportTask = this.taskFactory.register(new JacocoReportTask.CreationActionConnectedTest(androidTestProperties, jacocoAntConfiguration));
            TaskFactoryUtils.dependsOn(testedVariant.getTaskContainer().getCoverageReportTask(), reportTask);
            this.taskFactory.configure("connectedAndroidTest", (Action<? super Task>)new Action((TaskProvider<JacocoReportTask>)reportTask){
                final /* synthetic */ TaskProvider<JacocoReportTask> $reportTask;
                {
                    this.$reportTask = $reportTask;
                }

                public final void execute(@NotNull Task connectedAndroidTest) {
                    Intrinsics.checkNotNullParameter((Object)connectedAndroidTest, (String)"connectedAndroidTest");
                    Object[] objectArray = new Object[]{this.$reportTask};
                    connectedAndroidTest.dependsOn(objectArray);
                }
            });
        }
        if (!((Collection)(providers = this.globalConfig.getDeviceProviders())).isEmpty()) {
            BuildServiceRegistry buildServiceRegistry = this.project.getGradle().getSharedServices();
            Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry, (String)"project.gradle.sharedServices");
            AnalyticsConfiguratorService analyticsConfiguratorService = (AnalyticsConfiguratorService)BuildServicesKt.getBuildService(buildServiceRegistry, AnalyticsConfiguratorService.class).get();
            String string = this.project.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.path");
            object = analyticsConfiguratorService.getProjectBuilder(string);
            ProjectApiUse.Builder builder = reportTask = object != null ? object.getProjectApiUseBuilder() : null;
            if (reportTask != null) {
                reportTask.setBuilderTestApiDeviceProvider(true);
            }
        }
        for (DeviceProvider deviceProvider : providers) {
            providerTask = this.taskFactory.register(new DeviceProviderInstrumentTestTask.CreationAction(androidTestProperties, deviceProvider, testData, (Provider<List<String>>)connectedCheckSerials2));
            this.taskFactory.configure("deviceAndroidTest", (Action<? super Task>)new Action((TaskProvider<DeviceProviderInstrumentTestTask>)providerTask){
                final /* synthetic */ TaskProvider<DeviceProviderInstrumentTestTask> $providerTask;
                {
                    this.$providerTask = $providerTask;
                }

                public final void execute(@NotNull Task deviceAndroidTest) {
                    Intrinsics.checkNotNullParameter((Object)deviceAndroidTest, (String)"deviceAndroidTest");
                    Object[] objectArray = new Object[]{this.$providerTask};
                    deviceAndroidTest.dependsOn(objectArray);
                }
            });
        }
        List<TestServer> servers = this.globalConfig.getTestServers();
        if (!((Collection)servers).isEmpty()) {
            BuildServiceRegistry buildServiceRegistry = this.project.getGradle().getSharedServices();
            Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry, (String)"project.gradle.sharedServices");
            AnalyticsConfiguratorService analyticsConfiguratorService = (AnalyticsConfiguratorService)BuildServicesKt.getBuildService(buildServiceRegistry, AnalyticsConfiguratorService.class).get();
            String string = this.project.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.path");
            providerTask = analyticsConfiguratorService.getProjectBuilder(string);
            Object object2 = object = providerTask != null ? providerTask.getProjectApiUseBuilder() : null;
            if (object != null) {
                object.setBuilderTestApiTestServer(true);
            }
        }
        for (TestServer testServer : servers) {
            TaskProvider serverTask = this.taskFactory.register(new TestServerTask.TestServerTaskCreationAction(androidTestProperties, testServer));
            TaskProvider[] taskProviderArray = new TaskProvider[]{androidTestProperties.getTaskContainer().getAssembleTask()};
            TaskFactoryUtils.dependsOn(serverTask, taskProviderArray);
            this.taskFactory.configure("deviceCheck", (Action<? super Task>)new Action(serverTask){
                final /* synthetic */ TaskProvider<TestServerTask> $serverTask;
                {
                    this.$serverTask = $serverTask;
                }

                public final void execute(@NotNull Task deviceAndroidTest) {
                    Intrinsics.checkNotNullParameter((Object)deviceAndroidTest, (String)"deviceAndroidTest");
                    Object[] objectArray = new Object[]{this.$serverTask};
                    deviceAndroidTest.dependsOn(objectArray);
                }
            });
        }
        TaskManager.createTestDevicesForVariant$default(this, androidTestProperties, testData, androidTestProperties.getMainVariant().getName(), null, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void createTestDevicesTasks() {
        List list;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        if (!UtpTestUtilsKt.shouldEnableUtp(this.globalConfig.getServices().getProjectOptions(), this.globalConfig.getTestOptions()) || this.globalConfig.getTestOptions().getDevices().isEmpty()) {
            return;
        }
        List<Device> managedDevices = this.getManagedDevices();
        Iterable iterable = managedDevices;
        GlobalTaskCreationConfig globalTaskCreationConfig = this.globalConfig;
        String string = "cleanManagedDevices";
        TaskFactory taskFactory = this.taskFactory;
        boolean $i$f$filterIsInstance = false;
        void var5_8 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ManagedVirtualDevice)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = list = (List)destination$iv$iv;
        GlobalTaskCreationConfig globalTaskCreationConfig2 = globalTaskCreationConfig;
        String string2 = string;
        TaskProvider cleanTask = taskFactory.register(new ManagedDeviceCleanTask.CreationAction(string2, globalTaskCreationConfig2, list2));
        TaskProvider<Task> allDevices2 = this.taskFactory.register("allDevicesCheck", createTestDevicesTasks.allDevices.1.INSTANCE);
        for (Device device : managedDevices) {
            String[] stringArray;
            Object object;
            ManagedDeviceRegistry.Registration<?> registration = this.globalConfig.getManagedDeviceRegistry().get(device.getClass());
            if (device instanceof ManagedVirtualDevice) {
                object = this.taskFactory.register(new ManagedDeviceInstrumentationTestSetupTask.CreationAction(ManagedDeviceUtilsKt.setupTaskName(device), (ManagedVirtualDevice)device, this.globalConfig));
            } else if (registration != null) {
                if (registration.getHasSetupActions()) {
                    stringArray = new String[]{"managedDeviceSetupResults", device.getName()};
                    Provider provider2 = this.project.getLayout().getBuildDirectory().dir(FileUtils.join((String[])stringArray));
                    Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"project.layout.buildDire\u2026                        )");
                    Class<DeviceSetupConfigureAction<?, ?>> clazz = registration.getSetupConfigAction();
                    Intrinsics.checkNotNull(clazz);
                    Class<DeviceSetupTaskAction<?>> clazz2 = registration.getSetupTaskAction();
                    Intrinsics.checkNotNull(clazz2);
                    object = this.taskFactory.register((TaskCreationAction)new ManagedDeviceSetupTask.CreationAction<Device>((Provider<Directory>)provider2, clazz, clazz2, device, this.globalConfig));
                } else {
                    object = this.taskFactory.register(ManagedDeviceUtilsKt.setupTaskName(device));
                }
            } else {
                object = this.taskFactory.register(ManagedDeviceUtilsKt.setupTaskName(device));
            }
            TaskProvider<Task> setupTask = object;
            setupTask.configure(new Action(cleanTask){
                final /* synthetic */ TaskProvider<ManagedDeviceCleanTask> $cleanTask;
                {
                    this.$cleanTask = $cleanTask;
                }

                public final void execute(Task it) {
                    Object[] objectArray = new Object[]{this.$cleanTask};
                    it.mustRunAfter(objectArray);
                }
            });
            TaskProvider<Task> deviceAllVariantsTask2 = this.taskFactory.register(ManagedDeviceUtilsKt.managedDeviceAllVariantsTaskName(device), (Action<? super Task>)new Action(device){
                final /* synthetic */ Device $device;
                {
                    this.$device = $device;
                }

                public final void execute(@NotNull Task deviceVariantTask) {
                    Intrinsics.checkNotNullParameter((Object)deviceVariantTask, (String)"deviceVariantTask");
                    deviceVariantTask.setDescription("Runs all device checks on the managed device " + this.$device.getName() + ".");
                    deviceVariantTask.setGroup("verification");
                }
            });
            stringArray = new TaskProvider[]{deviceAllVariantsTask2};
            TaskFactoryUtils.dependsOn(allDevices2, stringArray);
        }
        for (DeviceGroup group : this.getDeviceGroups()) {
            this.taskFactory.register(ManagedDeviceUtilsKt.managedDeviceGroupAllVariantsTaskName(group), (Action<? super Task>)new Action(group){
                final /* synthetic */ DeviceGroup $group;
                {
                    this.$group = $group;
                }

                public final void execute(@NotNull Task deviceGroupTask) {
                    Intrinsics.checkNotNullParameter((Object)deviceGroupTask, (String)"deviceGroupTask");
                    deviceGroupTask.setDescription("Runs all device checks on all devices defined in group " + this.$group.getName() + ".");
                    deviceGroupTask.setGroup("verification");
                }
            });
        }
    }

    private final void createMockableJarTask() {
        Object[] objectArray = new Object[]{new Callable(this){
            final /* synthetic */ AndroidTestTaskManager this$0;
            {
                this.this$0 = $receiver;
            }

            @Nullable
            public final File call() {
                return (File)this.this$0.globalConfig.getVersionedSdkLoader().flatMap((Transformer)createMockableJarTask.1.INSTANCE).getOrNull();
            }
        }};
        this.project.getDependencies().add("androidApis", (Object)this.project.files(objectArray));
        this.taskFactory.register("createMockableJar", (Action<? super Task>)new Action(this){
            final /* synthetic */ AndroidTestTaskManager this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(@NotNull Task task) {
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                Object[] objectArray = new Object[]{this.this$0.globalConfig.getMockableJarArtifact()};
                task.dependsOn(objectArray);
            }
        });
    }

    @Override
    @NotNull
    protected Set<InternalScopedArtifacts.InternalScope> getJavaResMergingScopes() {
        return this.javaResMergingScopes;
    }

    @Override
    protected void createVariantPreBuildTask(@NotNull ComponentCreationConfig creationConfig) {
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        if (creationConfig instanceof AndroidTestCreationConfig && ((AndroidTestCreationConfig)creationConfig).getMainVariant().getComponentType().isApk() && !((AndroidTestCreationConfig)creationConfig).getMainVariant().getComponentType().isForTesting()) {
            boolean useDependencyConstraints = creationConfig.getServices().getProjectOptions().get(BooleanOption.USE_DEPENDENCY_CONSTRAINTS);
            TaskProvider testPreBuildTask = this.taskFactory.register(new TestPreBuildTask.CreationAction((TestComponentCreationConfig)creationConfig));
            if (useDependencyConstraints) {
                testPreBuildTask.configure((Action)createVariantPreBuildTask.1.INSTANCE);
            } else {
                TaskProvider classpathCheck = this.taskFactory.register(new AppClasspathCheckTask.CreationAction(creationConfig));
                TaskProvider[] taskProviderArray = new TaskProvider[]{classpathCheck};
                TaskFactoryUtils.dependsOn(testPreBuildTask, taskProviderArray);
            }
            return;
        }
        super.createVariantPreBuildTask(creationConfig);
    }
}

