/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import android.databinding.tool.LayoutXmlProcessor;
import android.databinding.tool.util.RelativizableFile;
import android.databinding.tool.writer.JavaFileWriter;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.gradle.internal.DependencyResourcesComputer;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.aapt.WorkerExecutorResourceCompilationService;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.databinding.MergingFileLookup;
import com.android.build.gradle.internal.errors.MessageReceiverImpl;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.res.namespaced.NamespaceRemover;
import com.android.build.gradle.internal.scope.BuildFeatureValues;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.services.Aapt2Input;
import com.android.build.gradle.internal.services.Aapt2ThreadPoolBuildService;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.Blocks;
import com.android.build.gradle.internal.tasks.NewIncrementalTask;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.internal.variant.VariantPathHelper;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.SyncOptions;
import com.android.build.gradle.tasks.IncrementalChangesUtils;
import com.android.build.gradle.tasks.ResourceException;
import com.android.build.gradle.tasks.SourceSetInputs;
import com.android.builder.model.VectorDrawablesOptions;
import com.android.builder.png.VectorDrawableRenderer;
import com.android.ide.common.blame.MergingLog;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.resources.CopyToOutputDirectoryResourceCompilationService;
import com.android.ide.common.resources.FileValidity;
import com.android.ide.common.resources.GeneratedResourceSet;
import com.android.ide.common.resources.MergeConsumer;
import com.android.ide.common.resources.MergedResourceWriter;
import com.android.ide.common.resources.MergedResourceWriterRequest;
import com.android.ide.common.resources.MergingException;
import com.android.ide.common.resources.NoOpResourcePreprocessor;
import com.android.ide.common.resources.RelativeResourceUtils;
import com.android.ide.common.resources.ResourceCompilationService;
import com.android.ide.common.resources.ResourceMerger;
import com.android.ide.common.resources.ResourcePreprocessor;
import com.android.ide.common.resources.ResourceSet;
import com.android.ide.common.resources.SingleFileProcessor;
import com.android.ide.common.vectordrawable.ResourcesNotSupportedException;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.resources.Density;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import kotlin.jvm.functions.Function1;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.FileChange;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;
import org.slf4j.Logger;

@CacheableTask
public abstract class MergeResources
extends NewIncrementalTask {
    private boolean processResources;
    private boolean crunchPng;
    private List<ResourceSet> processedInputs;
    private final FileValidity<ResourceSet> fileValidity = new FileValidity();
    private boolean disableVectorDrawables;
    private boolean vectorSupportLibraryIsUsed;
    private Collection<String> generatedDensities;
    private File mergedNotCompiledResourcesOutputDirectory;
    private boolean precompileDependenciesResources;
    private ImmutableSet<Flag> flags;
    DependencyResourcesComputer resourcesComputer;
    private SyncOptions.ErrorFormatMode errorFormatMode;

    @OutputDirectory
    @Optional
    public abstract DirectoryProperty getGeneratedPngsOutputDir();

    @Input
    public abstract Property<Boolean> getDataBindingEnabled();

    @Input
    public abstract Property<Boolean> getViewBindingEnabled();

    @Input
    @Optional
    public abstract Property<String> getNamespace();

    @Input
    @Optional
    public abstract Property<Boolean> getUseAndroidX();

    @Nested
    public abstract SourceSetInputs getSourceSetInputs();

    @Input
    public abstract SetProperty<String> getResourceDirsOutsideRootProjectDir();

    @Input
    public abstract Property<Boolean> getRelativePathsEnabled();

    @Input
    public abstract Property<Boolean> getPseudoLocalesEnabled();

    @Internal
    public abstract Property<Aapt2ThreadPoolBuildService> getAapt2ThreadPoolBuildService();

    @Nested
    public abstract Aapt2Input getAapt2();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Incremental
    public abstract ConfigurableFileCollection getRawLocalResourcesNoProcessRes();

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @Incremental
    public abstract ConfigurableFileCollection getRawLocalResourcesProcessRes();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Incremental
    public abstract ConfigurableFileCollection getLibrarySourceSets();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getGeneratedResDir();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getExtraGeneratedResDir();

    private static ResourceCompilationService getResourceProcessor(MergeResources mergeResourcesTask, ImmutableSet<Flag> flags, boolean processResources2, Aapt2Input aapt2Input) {
        if (flags.contains((Object)Flag.REMOVE_RESOURCE_NAMESPACES)) {
            return NamespaceRemover.INSTANCE;
        }
        if (!processResources2) {
            return CopyToOutputDirectoryResourceCompilationService.INSTANCE;
        }
        return new WorkerExecutorResourceCompilationService(mergeResourcesTask.getProjectName(), mergeResourcesTask.getPath(), mergeResourcesTask.getWorkerExecutor(), (Provider<AnalyticsService>)mergeResourcesTask.getAnalyticsService(), aapt2Input);
    }

    @Internal
    public WorkerExecutorFacade getAaptWorkerFacade() {
        return Workers.INSTANCE.withGradleWorkers(this.getProjectName(), this.getPath(), this.getWorkerExecutor(), (Provider<AnalyticsService>)this.getAnalyticsService());
    }

    @OutputDirectory
    @Optional
    public abstract DirectoryProperty getDataBindingLayoutInfoOutFolder();

    @Internal
    public abstract Property<String> getAaptEnv();

    @Internal
    public abstract DirectoryProperty getProjectRootDir();

    protected void doFullTaskAction() throws IOException, JAXBException {
        ResourcePreprocessor preprocessor = this.getPreprocessor();
        File incrementalFolder = ((Directory)this.getIncrementalFolder().get()).getAsFile();
        File destinationDir = ((Directory)this.getOutputDir().get()).getAsFile();
        FileUtils.cleanOutputDir((File)destinationDir);
        if (this.getDataBindingLayoutInfoOutFolder().isPresent()) {
            FileUtils.deleteDirectoryContents((File)((Directory)this.getDataBindingLayoutInfoOutFolder().get()).getAsFile());
        }
        List<ResourceSet> resourceSets = this.getConfiguredResourceSets(preprocessor, (String)this.getAaptEnv().getOrNull());
        ResourceMerger merger = new ResourceMerger(((Integer)this.getMinSdk().get()).intValue());
        MergingLog mergingLog2 = null;
        if (this.getBlameLogOutputFolder().isPresent()) {
            File blameLogFolder = ((Directory)this.getBlameLogOutputFolder().get()).getAsFile();
            FileUtils.cleanOutputDir((File)blameLogFolder);
            mergingLog2 = new MergingLog(blameLogFolder);
        }
        try (WorkerExecutorFacade workerExecutorFacade = this.getAaptWorkerFacade();
             ResourceCompilationService resourceCompiler = MergeResources.getResourceProcessor(this, this.flags, this.processResources, this.getAapt2());){
            SingleFileProcessor dataBindingLayoutProcessor = this.maybeCreateLayoutProcessor();
            Blocks.recordSpan(this.getPath(), GradleBuildProfileSpan.ExecutionType.TASK_EXECUTION_PHASE_1, (AnalyticsService)this.getAnalyticsService().get(), () -> {
                for (ResourceSet resourceSet : resourceSets) {
                    resourceSet.loadFromFiles((ILogger)new LoggerWrapper(this.getLogger()));
                    merger.addDataSet(resourceSet);
                }
            });
            File publicFile = this.getPublicFile().isPresent() ? ((RegularFile)this.getPublicFile().get()).getAsFile() : null;
            Map<String, String> sourceSetPaths = this.getRelativeSourceSetMap(resourceSets, destinationDir, incrementalFolder);
            MergedResourceWriter writer = new MergedResourceWriter(new MergedResourceWriterRequest(workerExecutorFacade, destinationDir, publicFile, mergingLog2, preprocessor, resourceCompiler, incrementalFolder, dataBindingLayoutProcessor, this.mergedNotCompiledResourcesOutputDirectory, ((Boolean)this.getPseudoLocalesEnabled().get()).booleanValue(), this.getCrunchPng(), sourceSetPaths));
            Blocks.recordSpan(this.getPath(), GradleBuildProfileSpan.ExecutionType.TASK_EXECUTION_PHASE_2, (AnalyticsService)this.getAnalyticsService().get(), () -> merger.mergeData((MergeConsumer)writer, false));
            Blocks.recordSpan(this.getPath(), GradleBuildProfileSpan.ExecutionType.TASK_EXECUTION_PHASE_3, (AnalyticsService)this.getAnalyticsService().get(), () -> {
                if (dataBindingLayoutProcessor != null) {
                    dataBindingLayoutProcessor.end();
                }
            });
            Blocks.recordSpan(this.getPath(), GradleBuildProfileSpan.ExecutionType.TASK_EXECUTION_PHASE_4, (AnalyticsService)this.getAnalyticsService().get(), () -> merger.writeBlobTo(incrementalFolder, (MergeConsumer)writer, false));
        }
        catch (Exception e) {
            MergingException.findAndReportMergingException((Exception)e, (MessageReceiver)new MessageReceiverImpl(this.errorFormatMode, (Logger)this.getLogger()));
            try {
                throw e;
            }
            catch (MergingException mergingException) {
                merger.cleanBlob(incrementalFolder);
                throw new ResourceException(mergingException.getMessage(), mergingException);
            }
        }
        finally {
            this.cleanup();
        }
    }

    private boolean isFilteredOutLibraryResource(File changedFile) {
        ConfigurableFileCollection localLibraryResources = this.getLibrarySourceSets();
        File parentFile = changedFile.getParentFile();
        if (parentFile.getName().startsWith("values")) {
            return false;
        }
        for (File resDir : localLibraryResources.getFiles()) {
            if (!parentFile.getAbsolutePath().startsWith(resDir.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doTaskAction(InputChanges changedInputs) {
        if (!changedInputs.isIncremental()) {
            try {
                this.getLogger().info("[MergeResources] Inputs are non-incremental full task action.");
                this.doFullTaskAction();
            }
            catch (IOException | JAXBException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        ResourcePreprocessor preprocessor = this.getPreprocessor();
        File incrementalFolder = ((Directory)this.getIncrementalFolder().get()).getAsFile();
        ConfigurableFileCollection rawLocalResources = this.processResources ? this.getRawLocalResourcesProcessRes() : this.getRawLocalResourcesNoProcessRes();
        Iterable rawResourceChanges = changedInputs.getFileChanges((FileCollection)rawLocalResources);
        Iterable libraryResourceChanges = changedInputs.getFileChanges((FileCollection)this.getLibrarySourceSets());
        if (!rawResourceChanges.iterator().hasNext() && !libraryResourceChanges.iterator().hasNext()) {
            return;
        }
        ResourceMerger merger = new ResourceMerger(((Integer)this.getMinSdk().get()).intValue());
        try {
            if (!merger.loadFromBlob(incrementalFolder, true, (String)this.getAaptEnv().getOrNull())) {
                this.getLogger().info("[MergeResources] Blob cannot be loaded causing a full task action.");
                this.doFullTaskAction();
                return;
            }
            for (Object resourceSet : merger.getDataSets()) {
                resourceSet.setPreprocessor(preprocessor);
            }
            List<ResourceSet> resourceSets = this.getConfiguredResourceSets(preprocessor, (String)this.getAaptEnv().getOrNull());
            if (!merger.checkValidUpdate(resourceSets)) {
                this.getLogger().info("Changed Resource sets: full task run!");
                this.doFullTaskAction();
                return;
            }
            for (FileChange entry : rawResourceChanges) {
                if (this.precompileDependenciesResources && this.isFilteredOutLibraryResource(entry.getFile()) || this.tryUpdateResourceSetsWithChangedFile(merger, entry)) continue;
                this.doFullTaskAction();
                return;
            }
            for (FileChange entry : libraryResourceChanges) {
                if (this.precompileDependenciesResources && this.isFilteredOutLibraryResource(entry.getFile()) || this.tryUpdateResourceSetsWithChangedFile(merger, entry)) continue;
                this.doFullTaskAction();
                return;
            }
            MergingLog mergingLog2 = this.getBlameLogOutputFolder().isPresent() ? new MergingLog(((Directory)this.getBlameLogOutputFolder().get()).getAsFile()) : null;
            try (WorkerExecutorFacade workerExecutorFacade = this.getAaptWorkerFacade();
                 ResourceCompilationService resourceCompiler = MergeResources.getResourceProcessor(this, this.flags, this.processResources, this.getAapt2());){
                SingleFileProcessor dataBindingLayoutProcessor = this.maybeCreateLayoutProcessor();
                File publicFile = this.getPublicFile().isPresent() ? ((RegularFile)this.getPublicFile().get()).getAsFile() : null;
                File destinationDir = ((Directory)this.getOutputDir().get()).getAsFile();
                Map<String, String> sourceSetPaths = this.getRelativeSourceSetMap(resourceSets, destinationDir, incrementalFolder);
                MergedResourceWriter writer = new MergedResourceWriter(new MergedResourceWriterRequest(workerExecutorFacade, destinationDir, publicFile, mergingLog2, preprocessor, resourceCompiler, incrementalFolder, dataBindingLayoutProcessor, this.mergedNotCompiledResourcesOutputDirectory, ((Boolean)this.getPseudoLocalesEnabled().get()).booleanValue(), this.getCrunchPng(), sourceSetPaths));
                merger.mergeData((MergeConsumer)writer, false);
                if (dataBindingLayoutProcessor != null) {
                    dataBindingLayoutProcessor.end();
                }
                merger.writeBlobTo(incrementalFolder, (MergeConsumer)writer, false);
            }
        }
        catch (Exception e) {
            MergingException.findAndReportMergingException((Exception)e, (MessageReceiver)new MessageReceiverImpl(this.errorFormatMode, (Logger)this.getLogger()));
            try {
                throw e;
            }
            catch (MergingException mergingException) {
                merger.cleanBlob(incrementalFolder);
                throw new ResourceException(mergingException.getMessage(), mergingException);
            }
            catch (IOException | JAXBException runTimeException) {
                throw new RuntimeException(runTimeException);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            this.cleanup();
        }
    }

    private boolean tryUpdateResourceSetsWithChangedFile(ResourceMerger merger, FileChange entry) throws MergingException {
        File changedFile = entry.getFile();
        merger.findDataSetContaining(changedFile, this.fileValidity);
        if (this.fileValidity.getStatus() == FileValidity.FileStatus.UNKNOWN_FILE) {
            this.getLogger().info("[MergeResources] " + changedFile.getAbsolutePath() + " has an unknown file status, requiring full task run.");
            return false;
        }
        if (this.fileValidity.getStatus() == FileValidity.FileStatus.VALID_FILE && !((ResourceSet)this.fileValidity.getDataSet()).updateWith(this.fileValidity.getSourceFile(), changedFile, IncrementalChangesUtils.toSerializable(entry.getChangeType()), (ILogger)new LoggerWrapper(this.getLogger()))) {
            this.getLogger().info(String.format("[MergeResources] Failed to process %s event! Requires full task run", entry.getChangeType()));
            return false;
        }
        return true;
    }

    private Map<String, String> getRelativeSourceSetMap(List<ResourceSet> resourceSets, File destinationDir, File incrementalFolder) {
        if (!((Boolean)this.getRelativePathsEnabled().get()).booleanValue()) {
            return Collections.emptyMap();
        }
        ArrayList sourceSets = Lists.newArrayList();
        for (ResourceSet sourceSet : resourceSets) {
            sourceSets.addAll(sourceSet.getSourceFiles());
        }
        if (this.getGeneratedPngsOutputDir().isPresent()) {
            sourceSets.add(((Directory)this.getGeneratedPngsOutputDir().get()).getAsFile());
        }
        sourceSets.add(destinationDir);
        sourceSets.add(FileUtils.join((File)incrementalFolder, (String[])new String[]{"merged.dir"}));
        sourceSets.add(FileUtils.join((File)incrementalFolder, (String[])new String[]{"stripped.dir"}));
        return RelativeResourceUtils.getIdentifiedSourceSetMap((List)sourceSets, (String)((String)this.getNamespace().get()), (String)this.getProjectName());
    }

    private SingleFileProcessor maybeCreateLayoutProcessor() {
        if (!((Boolean)this.getDataBindingEnabled().get()).booleanValue() && !((Boolean)this.getViewBindingEnabled().get()).booleanValue()) {
            return null;
        }
        LayoutXmlProcessor.OriginalFileLookup fileLookup = this.getBlameLogOutputFolder().isPresent() ? new MergingFileLookup(((Directory)this.getBlameLogOutputFolder().get()).getAsFile()) : file -> null;
        final LayoutXmlProcessor processor = new LayoutXmlProcessor((String)this.getNamespace().get(), new JavaFileWriter(){

            public void writeToFile(String canonicalName, String contents) {
                throw new UnsupportedOperationException("Not supported in this mode");
            }

            public void deleteFile(String canonicalName) {
                throw new UnsupportedOperationException("Not supported in this mode");
            }
        }, fileLookup, ((Boolean)this.getUseAndroidX().get()).booleanValue());
        return new SingleFileProcessor(){

            private LayoutXmlProcessor getProcessor() {
                return processor;
            }

            public boolean processSingleFile(File inputFile, File outputFile, Boolean inputFileIsFromDependency) throws Exception {
                RelativizableFile normalizedInputFile;
                if (inputFileIsFromDependency == Boolean.TRUE) {
                    return false;
                }
                File rootProjectDir = (File)MergeResources.this.getProjectRootDir().getAsFile().get();
                if (FileUtils.isFileInDirectory((File)inputFile, (File)rootProjectDir)) {
                    Preconditions.checkState((!this.resourceIsInResourceDirs(inputFile, (Set)MergeResources.this.getResourceDirsOutsideRootProjectDir().get()) ? 1 : 0) != 0, (Object)(inputFile.getAbsolutePath() + " should not be annotated as @Input"));
                    normalizedInputFile = RelativizableFile.fromAbsoluteFile((File)inputFile.getCanonicalFile(), (File)rootProjectDir);
                    Preconditions.checkState((normalizedInputFile.getRelativeFile() != null ? 1 : 0) != 0);
                } else {
                    Preconditions.checkState((boolean)this.resourceIsInResourceDirs(inputFile, (Set)MergeResources.this.getResourceDirsOutsideRootProjectDir().get()), (Object)(inputFile.getAbsolutePath() + " is not annotated as @Input"));
                    normalizedInputFile = RelativizableFile.fromAbsoluteFile((File)inputFile.getCanonicalFile(), null);
                    Preconditions.checkState((normalizedInputFile.getRelativeFile() == null ? 1 : 0) != 0);
                }
                return this.getProcessor().processSingleFile(normalizedInputFile, outputFile, ((Boolean)MergeResources.this.getViewBindingEnabled().get()).booleanValue(), ((Boolean)MergeResources.this.getDataBindingEnabled().get()).booleanValue());
            }

            private boolean resourceIsInResourceDirs(File resFile, Set<String> resDirs) {
                return resDirs.stream().anyMatch(resDir -> FileUtils.isFileInDirectory((File)resFile, (File)new File((String)resDir)));
            }

            public void processRemovedFile(File file) {
                this.getProcessor().processRemovedFile(file);
            }

            public void processFileWithNoDataBinding(File file) {
                this.getProcessor().processFileWithNoDataBinding(file);
            }

            public void end() throws JAXBException {
                this.getProcessor().writeLayoutInfoFiles(((Directory)MergeResources.this.getDataBindingLayoutInfoOutFolder().get()).getAsFile());
            }
        };
    }

    private ResourcePreprocessor getPreprocessor() {
        if (this.disableVectorDrawables) {
            return NoOpResourcePreprocessor.INSTANCE;
        }
        Collection densities = this.getGeneratedDensities().stream().map(Density::getEnum).collect(Collectors.toList());
        return new MergeResourcesVectorDrawableRenderer((Integer)this.getMinSdk().get(), this.vectorSupportLibraryIsUsed, ((Directory)this.getGeneratedPngsOutputDir().get()).getAsFile(), densities, LoggerWrapper.supplierFor(MergeResources.class));
    }

    private List<ResourceSet> getConfiguredResourceSets(ResourcePreprocessor preprocessor, String aaptEnv) {
        if (this.processedInputs == null) {
            this.processedInputs = this.resourcesComputer.compute(this.precompileDependenciesResources, aaptEnv);
            ArrayList<GeneratedResourceSet> generatedSets = new ArrayList<GeneratedResourceSet>(this.processedInputs.size());
            for (ResourceSet resourceSet : this.processedInputs) {
                resourceSet.setPreprocessor(preprocessor);
                GeneratedResourceSet generatedSet = new GeneratedResourceSet(resourceSet, aaptEnv);
                resourceSet.setGeneratedSet((ResourceSet)generatedSet);
                generatedSets.add(generatedSet);
            }
            for (int i2 = 0; i2 < generatedSets.size(); ++i2) {
                this.processedInputs.add(2 * i2, (ResourceSet)generatedSets.get(i2));
            }
        }
        return this.processedInputs;
    }

    private void cleanup() {
        this.fileValidity.clear();
        this.processedInputs = null;
    }

    @OutputDirectory
    public abstract DirectoryProperty getOutputDir();

    @Input
    public boolean getCrunchPng() {
        return this.crunchPng;
    }

    @Input
    public boolean getProcessResources() {
        return this.processResources;
    }

    @Optional
    @OutputFile
    public abstract RegularFileProperty getPublicFile();

    @Input
    public boolean isValidateEnabled() {
        return this.resourcesComputer.getValidateEnabled();
    }

    @OutputDirectory
    @Optional
    public abstract DirectoryProperty getBlameLogOutputFolder();

    @Input
    public Collection<String> getGeneratedDensities() {
        return this.generatedDensities;
    }

    @Input
    public abstract Property<Integer> getMinSdk();

    @Input
    public boolean isVectorSupportLibraryUsed() {
        return this.vectorSupportLibraryIsUsed;
    }

    @OutputDirectory
    @Optional
    public abstract DirectoryProperty getMergedNotCompiledResourcesOutputDirectory();

    @Input
    public String getFlags() {
        return this.flags.stream().map(Enum::name).sorted().collect(Collectors.joining(","));
    }

    @OutputDirectory
    @Optional
    public abstract DirectoryProperty getIncrementalFolder();

    public static enum Flag {
        REMOVE_RESOURCE_NAMESPACES,
        PROCESS_VECTOR_DRAWABLES;

    }

    public static class CreationAction
    extends VariantTaskCreationAction<MergeResources, ComponentCreationConfig> {
        private final TaskManager.MergeType mergeType;
        private final File mergedNotCompiledOutputDirectory;
        private final boolean includeDependencies;
        private final boolean processResources;
        private final boolean processVectorDrawables;
        private final ImmutableSet<Flag> flags;
        private final boolean isLibrary;

        public CreationAction(ComponentCreationConfig creationConfig, TaskManager.MergeType mergeType, File mergedNotCompiledOutputDirectory, boolean includeDependencies, boolean processResources2, ImmutableSet<Flag> flags, boolean isLibrary) {
            super(creationConfig);
            this.mergeType = mergeType;
            this.mergedNotCompiledOutputDirectory = mergedNotCompiledOutputDirectory;
            this.includeDependencies = includeDependencies;
            this.processResources = processResources2;
            this.processVectorDrawables = flags.contains((Object)Flag.PROCESS_VECTOR_DRAWABLES);
            this.flags = flags;
            this.isLibrary = isLibrary;
        }

        @Override
        public String getName() {
            return this.computeTaskName(this.mergeType.name().toLowerCase(Locale.ENGLISH), "Resources");
        }

        @Override
        public Class<MergeResources> getType() {
            return MergeResources.class;
        }

        @Override
        public void handleProvider(TaskProvider<MergeResources> taskProvider) {
            super.handleProvider(taskProvider);
            this.creationConfig.getTaskContainer().setMergeResourcesTask(taskProvider);
            ArtifactsImpl artifacts2 = this.creationConfig.getArtifacts();
            artifacts2.setInitialProvider(taskProvider, MergeResources::getOutputDir).on(this.mergeType.getOutputType());
            if (this.mergedNotCompiledOutputDirectory != null) {
                artifacts2.setInitialProvider(taskProvider, MergeResources::getMergedNotCompiledResourcesOutputDirectory).atLocation(this.mergedNotCompiledOutputDirectory.getPath()).on(InternalArtifactType.MERGED_NOT_COMPILED_RES.INSTANCE);
            }
            artifacts2.setInitialProvider(taskProvider, MergeResources::getDataBindingLayoutInfoOutFolder).withName("out").on(this.mergeType == TaskManager.MergeType.MERGE ? InternalArtifactType.DATA_BINDING_LAYOUT_INFO_TYPE_MERGE.INSTANCE : InternalArtifactType.DATA_BINDING_LAYOUT_INFO_TYPE_PACKAGE.INSTANCE);
            if (this.includeDependencies) {
                artifacts2.setInitialProvider(taskProvider, MergeResources::getBlameLogOutputFolder).withName("out").on(InternalArtifactType.MERGED_RES_BLAME_FOLDER.INSTANCE);
            }
            VariantPathHelper paths = this.creationConfig.getPaths();
            artifacts2.setInitialProvider(taskProvider, MergeResources::getGeneratedPngsOutputDir).atLocation((Function1<MergeResources, Provider<Directory>>)((Function1)mergeResources -> paths.getGeneratedPngsOutputDir()));
        }

        @Override
        public void configure(MergeResources task) {
            super.configure(task);
            VariantScope variantScope = this.creationConfig.getVariantScope();
            VariantPathHelper paths = this.creationConfig.getPaths();
            HasConfigurableValuesKt.setDisallowChanges(task.getNamespace(), this.creationConfig.getNamespace());
            task.getMinSdk().set(task.getProject().provider(() -> this.creationConfig.getMinSdkVersion().getApiLevel()));
            task.getMinSdk().disallowChanges();
            task.getIncrementalFolder().set(paths.getIncrementalDir(this.getName()));
            task.processResources = this.processResources;
            task.crunchPng = variantScope.isCrunchPngs();
            VectorDrawablesOptions vectorDrawablesOptions = this.creationConfig.getVariantDslInfo().getVectorDrawables();
            task.generatedDensities = vectorDrawablesOptions.getGeneratedDensities();
            if (task.generatedDensities == null) {
                task.generatedDensities = Collections.emptySet();
            }
            task.disableVectorDrawables = !this.processVectorDrawables || task.generatedDensities.isEmpty();
            task.vectorSupportLibraryIsUsed = Boolean.TRUE.equals(vectorDrawablesOptions.getUseSupportLibrary());
            task.resourcesComputer = new DependencyResourcesComputer();
            if (!task.disableVectorDrawables) {
                task.getGeneratedPngsOutputDir().set(paths.getGeneratedPngsOutputDir());
            }
            ArtifactCollection libraryArtifacts = this.includeDependencies ? this.creationConfig.getVariantDependencies().getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.ANDROID_RES) : null;
            ConfigurableFileCollection microApk = this.creationConfig.getServices().fileCollection(this.creationConfig.getArtifacts().get(InternalArtifactType.MICRO_APK_RES.INSTANCE));
            task.getSourceSetInputs().initialise(this.creationConfig, task, this.includeDependencies);
            if (this.includeDependencies) {
                task.getLibrarySourceSets().setFrom((Iterable)task.getSourceSetInputs().getLibrarySourceSets());
            }
            task.getGeneratedResDir().setFrom(new Object[]{task.getSourceSetInputs().getGeneratedResDir()});
            task.getExtraGeneratedResDir().setFrom((Iterable)task.getSourceSetInputs().getExtraGeneratedResDir());
            task.resourcesComputer.initFromVariantScope(this.creationConfig, task.getSourceSetInputs(), (FileCollection)microApk, libraryArtifacts);
            BuildFeatureValues features = this.creationConfig.getBuildFeatures();
            boolean isDataBindingEnabled = features.getDataBinding();
            boolean isViewBindingEnabled = features.getViewBinding();
            HasConfigurableValuesKt.setDisallowChanges(task.getDataBindingEnabled(), isDataBindingEnabled);
            HasConfigurableValuesKt.setDisallowChanges(task.getViewBindingEnabled(), isViewBindingEnabled);
            if (isDataBindingEnabled || isViewBindingEnabled) {
                HasConfigurableValuesKt.setDisallowChanges(task.getUseAndroidX(), this.creationConfig.getServices().getProjectOptions().get(BooleanOption.USE_ANDROID_X));
            }
            task.mergedNotCompiledResourcesOutputDirectory = this.mergedNotCompiledOutputDirectory;
            task.getPseudoLocalesEnabled().set(this.creationConfig.getPseudoLocalesEnabled());
            task.getPseudoLocalesEnabled().disallowChanges();
            task.flags = this.flags;
            task.errorFormatMode = SyncOptions.getErrorFormatMode(this.creationConfig.getServices().getProjectOptions());
            task.precompileDependenciesResources = this.mergeType.equals((Object)TaskManager.MergeType.MERGE) && !this.isLibrary && this.creationConfig.isPrecompileDependenciesResourcesEnabled();
            task.getResourceDirsOutsideRootProjectDir().set(task.getProject().provider(() -> CreationAction.getResourcesDirsOutsideRoot(task, isDataBindingEnabled, isViewBindingEnabled)));
            task.getResourceDirsOutsideRootProjectDir().disallowChanges();
            task.dependsOn(new Object[]{this.creationConfig.getTaskContainer().getResourceGenTask()});
            if (this.processResources) {
                task.getRawLocalResourcesProcessRes().setFrom((Iterable)task.getSourceSetInputs().getResourceSourceSets());
            } else {
                task.getRawLocalResourcesNoProcessRes().setFrom((Iterable)task.getSourceSetInputs().getResourceSourceSets());
            }
            task.getRawLocalResourcesProcessRes().disallowChanges();
            task.getRawLocalResourcesNoProcessRes().disallowChanges();
            HasConfigurableValuesKt.setDisallowChanges(task.getAapt2ThreadPoolBuildService(), BuildServicesKt.getBuildService(this.creationConfig.getServices().getBuildServiceRegistry(), Aapt2ThreadPoolBuildService.class));
            this.creationConfig.getServices().initializeAapt2Input(task.getAapt2());
            task.getAaptEnv().set(this.creationConfig.getServices().getGradleEnvironmentProvider().getEnvVariable("ANDROID_AAPT_IGNORE"));
            task.getProjectRootDir().set(task.getProject().getRootDir());
            task.getRelativePathsEnabled().set((Object)this.creationConfig.getServices().getProjectOptions().get(BooleanOption.ENABLE_SOURCE_SET_PATHS_MAP));
        }

        private static Set<String> getResourcesDirsOutsideRoot(MergeResources task, boolean isDataBindingEnabled, boolean isViewBindingEnabled) throws IOException {
            HashSet<String> resourceDirsOutsideRootProjectDir = new HashSet<String>();
            if (!isDataBindingEnabled && !isViewBindingEnabled) {
                return resourceDirsOutsideRootProjectDir;
            }
            File rootProjectDir = task.getProject().getRootDir();
            ConfigurableFileCollection resourceSourceSets = task.processResources ? task.getRawLocalResourcesProcessRes() : task.getRawLocalResourcesNoProcessRes();
            for (File resDir : resourceSourceSets.getFiles()) {
                if (FileUtils.isFileInDirectory((File)resDir, (File)rootProjectDir)) continue;
                resourceDirsOutsideRootProjectDir.add(resDir.getCanonicalPath());
            }
            return resourceDirsOutsideRootProjectDir;
        }
    }

    private static class MergeResourcesVectorDrawableRenderer
    extends VectorDrawableRenderer {
        public MergeResourcesVectorDrawableRenderer(int minSdk, boolean supportLibraryIsUsed, File outputDir, Collection<Density> densities, Supplier<ILogger> loggerSupplier) {
            super(minSdk, supportLibraryIsUsed, outputDir, densities, loggerSupplier);
        }

        public void generateFile(File toBeGenerated, File original) throws IOException {
            try {
                super.generateFile(toBeGenerated, original);
            }
            catch (ResourcesNotSupportedException e) {
                throw new GradleException(String.format("Can't process attribute %1$s=\"%2$s\": references to other resources are not supported by build-time PNG generation.\n%3$s\nSee http://developer.android.com/tools/help/vector-asset-studio.html for details.", e.getName(), e.getValue(), this.getPreprocessingReasonDescription(original)));
            }
        }
    }
}

