/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.gradle.internal.ide.DependencyFailureHandler;
import com.android.build.gradle.internal.lint.CustomLintCheckUtils;
import com.android.builder.errors.IssueReporter;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"getLocalCustomLintChecks", "Lorg/gradle/api/file/FileCollection;", "lintChecks", "Lorg/gradle/api/artifacts/Configuration;", "Lorg/gradle/api/artifacts/ArtifactCollection;", "lenientMode", "", "getLocalCustomLintChecksForModel", "Lcom/google/common/collect/ImmutableList;", "Ljava/io/File;", "project", "Lorg/gradle/api/Project;", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "gradle-core"})
@JvmName(name="CustomLintCheckUtils")
public final class CustomLintCheckUtils {
    @NotNull
    public static final ImmutableList<File> getLocalCustomLintChecksForModel(@NotNull Project project2, @NotNull IssueReporter issueReporter2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)issueReporter2, (String)"issueReporter");
        Configuration lintChecks = project2.getConfigurations().getByName("lintChecks");
        Intrinsics.checkNotNullExpressionValue((Object)lintChecks, (String)"lintChecks");
        ArtifactCollection artifactCollection = CustomLintCheckUtils.getLocalCustomLintChecks(lintChecks, true);
        Collection failures = artifactCollection.getFailures();
        if (!failures.isEmpty()) {
            DependencyFailureHandler failureHandler = new DependencyFailureHandler();
            String string = project2.getPath() + '/' + lintChecks.getName();
            Intrinsics.checkNotNullExpressionValue((Object)failures, (String)"failures");
            failureHandler.addErrors(string, failures);
            failureHandler.registerIssues(issueReporter2);
        }
        ImmutableList immutableList = ImmutableList.copyOf((Collection)artifactCollection.getArtifactFiles().getFiles());
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(artifactCollection.artifactFiles.files)");
        return immutableList;
    }

    @NotNull
    public static final FileCollection getLocalCustomLintChecks(@NotNull Configuration lintChecks) {
        Intrinsics.checkNotNullParameter((Object)lintChecks, (String)"lintChecks");
        FileCollection fileCollection2 = CustomLintCheckUtils.getLocalCustomLintChecks(lintChecks, false).getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"getLocalCustomLintChecks(lintChecks, lenientMode = false).artifactFiles");
        return fileCollection2;
    }

    private static final ArtifactCollection getLocalCustomLintChecks(Configuration lintChecks, boolean lenientMode) {
        ArtifactCollection artifactCollection = lintChecks.getIncoming().artifactView((Action)new Action<ArtifactView.ViewConfiguration>(lenientMode){
            final /* synthetic */ boolean $lenientMode;
            {
                this.$lenientMode = $lenientMode;
            }

            public final void execute(@NotNull ArtifactView.ViewConfiguration config2) {
                Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
                config2.attributes((Action)getLocalCustomLintChecks.1.INSTANCE);
                config2.lenient(this.$lenientMode);
            }
        }).getArtifacts();
        Intrinsics.checkNotNullExpressionValue((Object)artifactCollection, (String)"lenientMode: Boolean): ArtifactCollection {\n    return lintChecks.incoming.artifactView { config: ViewConfiguration ->\n        config.attributes { attributes: AttributeContainer ->\n            // Query for JAR instead of PROCESSED_JAR as lint.jar doesn't need processing\n            attributes.attribute(\n                AndroidArtifacts.ARTIFACT_TYPE,\n                AndroidArtifacts.ArtifactType.JAR.type\n            )\n        }\n        config.lenient(lenientMode)\n    }.artifacts");
        return artifactCollection;
    }
}

