/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test.report;

import com.android.build.gradle.internal.test.report.AllTestResults;
import com.android.build.gradle.internal.test.report.ClassTestResults;
import com.android.build.gradle.internal.test.report.CompositeTestResults;
import com.android.build.gradle.internal.test.report.TestResult;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

class PackageTestResults
extends CompositeTestResults {
    private static final String DEFAULT_PACKAGE = "default-package";
    private final String name;
    private final Map<String, ClassTestResults> classes = new TreeMap<String, ClassTestResults>();

    public PackageTestResults(String name2, AllTestResults model) {
        super(model);
        this.name = name2.isEmpty() ? DEFAULT_PACKAGE : name2;
    }

    @Override
    public String getTitle() {
        return this.name.equals(DEFAULT_PACKAGE) ? "Default package" : String.format("Package %s", this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Collection<ClassTestResults> getClasses() {
        return this.classes.values();
    }

    public TestResult addTest(String className, String testName, long duration, String device, String project, String flavor) {
        ClassTestResults classResults = this.addClass(className);
        TestResult testResult = this.addTest(classResults.addTest(testName, duration, device, project, flavor));
        this.addDevice(device, testResult);
        this.addVariant(project, flavor, testResult);
        return testResult;
    }

    public ClassTestResults addClass(String className) {
        ClassTestResults classResults = this.classes.get(className);
        if (classResults == null) {
            classResults = new ClassTestResults(className, this);
            this.classes.put(className, classResults);
        }
        return classResults;
    }
}

