/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.SdkParsingUtilsKt;
import com.android.repository.api.LocalPackage;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.OptionalLibrary;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\b\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\u0010\fR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/PlatformComponents;", "", "targetPlatformVersion", "Lcom/android/sdklib/AndroidVersion;", "aidlFramework", "Ljava/io/File;", "androidJar", "targetBootClasspath", "", "additionalLibraries", "Lcom/android/sdklib/OptionalLibrary;", "optionalLibraries", "(Lcom/android/sdklib/AndroidVersion;Ljava/io/File;Ljava/io/File;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getAdditionalLibraries$gradle_core", "()Ljava/util/List;", "getAidlFramework$gradle_core", "()Ljava/io/File;", "getAndroidJar$gradle_core", "getOptionalLibraries$gradle_core", "getTargetBootClasspath$gradle_core", "getTargetPlatformVersion$gradle_core", "()Lcom/android/sdklib/AndroidVersion;", "Companion", "gradle-core"})
final class PlatformComponents {
    @NotNull
    private final AndroidVersion targetPlatformVersion;
    @NotNull
    private final File aidlFramework;
    @NotNull
    private final File androidJar;
    @NotNull
    private final List<File> targetBootClasspath;
    @NotNull
    private final List<OptionalLibrary> additionalLibraries;
    @NotNull
    private final List<OptionalLibrary> optionalLibraries;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final AndroidVersion getTargetPlatformVersion$gradle_core() {
        return this.targetPlatformVersion;
    }

    @NotNull
    public final File getAidlFramework$gradle_core() {
        return this.aidlFramework;
    }

    @NotNull
    public final File getAndroidJar$gradle_core() {
        return this.androidJar;
    }

    @NotNull
    public final List<File> getTargetBootClasspath$gradle_core() {
        return this.targetBootClasspath;
    }

    @NotNull
    public final List<OptionalLibrary> getAdditionalLibraries$gradle_core() {
        return this.additionalLibraries;
    }

    @NotNull
    public final List<OptionalLibrary> getOptionalLibraries$gradle_core() {
        return this.optionalLibraries;
    }

    public PlatformComponents(@NotNull AndroidVersion targetPlatformVersion, @NotNull File aidlFramework, @NotNull File androidJar, @NotNull List<? extends File> targetBootClasspath, @NotNull List<? extends OptionalLibrary> additionalLibraries, @NotNull List<? extends OptionalLibrary> optionalLibraries) {
        Intrinsics.checkParameterIsNotNull((Object)targetPlatformVersion, (String)"targetPlatformVersion");
        Intrinsics.checkParameterIsNotNull((Object)aidlFramework, (String)"aidlFramework");
        Intrinsics.checkParameterIsNotNull((Object)androidJar, (String)"androidJar");
        Intrinsics.checkParameterIsNotNull(targetBootClasspath, (String)"targetBootClasspath");
        Intrinsics.checkParameterIsNotNull(additionalLibraries, (String)"additionalLibraries");
        Intrinsics.checkParameterIsNotNull(optionalLibraries, (String)"optionalLibraries");
        this.targetPlatformVersion = targetPlatformVersion;
        this.aidlFramework = aidlFramework;
        this.androidJar = androidJar;
        this.targetBootClasspath = targetBootClasspath;
        this.additionalLibraries = additionalLibraries;
        this.optionalLibraries = optionalLibraries;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/PlatformComponents$Companion;", "", "()V", "build", "Lcom/android/build/gradle/internal/PlatformComponents;", "sdkDirectory", "Ljava/io/File;", "targetHash", "", "build$gradle_core", "gradle-core"})
    public static final class Companion {
        @Nullable
        public final PlatformComponents build$gradle_core(@NotNull File sdkDirectory2, @NotNull String targetHash) {
            String platformId;
            Intrinsics.checkParameterIsNotNull((Object)sdkDirectory2, (String)"sdkDirectory");
            Intrinsics.checkParameterIsNotNull((Object)targetHash, (String)"targetHash");
            if (!AndroidTargetHash.isPlatform((String)targetHash)) {
                return null;
            }
            AndroidVersion androidVersion = AndroidTargetHash.getVersionFromHash((String)targetHash);
            if (androidVersion == null) {
                return null;
            }
            AndroidVersion platformVersion = androidVersion;
            String string = platformId = DetailsTypes.getPlatformPath((AndroidVersion)platformVersion);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"platformId");
            File platformBase = FilesKt.resolve((File)sdkDirectory2, (String)StringsKt.replace$default((String)string, (char)';', (char)'/', (boolean)false, (int)4, null));
            File platformXml = FilesKt.resolve((File)platformBase, (String)"package.xml");
            LocalPackage platformPackage = SdkParsingUtilsKt.parsePackage(platformXml);
            if (platformPackage == null || !platformId.equals(platformPackage.getPath())) {
                return null;
            }
            File file = FilesKt.resolve((File)platformBase, (String)"framework.aidl");
            File file2 = FilesKt.resolve((File)platformBase, (String)"android.jar");
            ImmutableList immutableList = ImmutableList.of((Object)FilesKt.resolve((File)platformBase, (String)"android.jar"));
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of(platfor\u2026ts.FN_FRAMEWORK_LIBRARY))");
            return new PlatformComponents(platformVersion, file, file2, (List)immutableList, SdkParsingUtilsKt.parseAdditionalLibraries(platformPackage), SdkParsingUtilsKt.parseOptionalLibraries(platformPackage));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

