/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.external.cmake;

import com.android.SdkConstants;
import com.android.build.gradle.external.cmake.server.CodeModel;
import com.android.build.gradle.external.cmake.server.Configuration;
import com.android.build.gradle.external.cmake.server.FileGroup;
import com.android.build.gradle.external.cmake.server.Project;
import com.android.build.gradle.external.cmake.server.Target;
import com.android.build.gradle.internal.cxx.json.NativeToolchainValue;
import com.android.build.gradle.internal.cxx.json.PlainFileGsonTypeAdaptor;
import com.android.repository.Revision;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CmakeUtils {
    private static final String CMAKE_VERSION_LINE_PREFIX = "cmake version ";

    public static Revision getVersion(File cmakeInstallPath) throws IOException {
        String versionString = CmakeUtils.getVersionString(cmakeInstallPath);
        return Revision.parseRevision((String)CmakeUtils.keepWhileNumbersAndDots(versionString));
    }

    public static String keepWhileNumbersAndDots(String versionString) {
        String stripped = "";
        for (char c : versionString.toCharArray()) {
            if ((c < '0' || c > '9') && c != '.') break;
            stripped = stripped + c;
        }
        return stripped;
    }

    public static Revision getVersion(String cmakeVersionString) {
        return Revision.parseRevision((String)cmakeVersionString);
    }

    public static List<String> getBuildCommand(File cmakeExecutable, File outputFolder, String targetName) {
        return ImmutableList.of((Object)CmakeUtils.getNinjaExecutable(cmakeExecutable), (Object)"-C", (Object)outputFolder.getAbsolutePath(), (Object)targetName);
    }

    public static List<String> getCleanCommand(File cmakeExecutable, File outputFolder) {
        return ImmutableList.of((Object)CmakeUtils.getNinjaExecutable(cmakeExecutable), (Object)"-C", (Object)outputFolder.getAbsolutePath(), (Object)"clean");
    }

    public static List<String> getBuildTargetsCommand(File cmakeExecutable, File outputFolder, List<String> buildCommandArgs) {
        return ImmutableList.builder().add((Object)CmakeUtils.getNinjaExecutable(cmakeExecutable)).addAll(buildCommandArgs).add((Object)"-C").add((Object)outputFolder.getAbsolutePath()).add((Object)"{LIST_OF_TARGETS_TO_BUILD}").build();
    }

    public static Set<String> getCppExtensionSet(CodeModel codeModel) {
        return CmakeUtils.getLangExtensions(codeModel, "CXX");
    }

    public static Set<String> getCExtensionSet(CodeModel codeModel) {
        return CmakeUtils.getLangExtensions(codeModel, "C");
    }

    public static int getToolchainHash(NativeToolchainValue toolchainValue) {
        StringBuilder toolchainString = new StringBuilder();
        if (toolchainValue.cppCompilerExecutable != null) {
            toolchainString = toolchainString.append(toolchainValue.cppCompilerExecutable.getAbsolutePath()).append(" ");
        }
        if (toolchainValue.cCompilerExecutable != null) {
            toolchainString = toolchainString.append(toolchainValue.cCompilerExecutable.getAbsolutePath());
        }
        return toolchainString.toString().hashCode();
    }

    public static <ContentType> String getObjectToString(ContentType content2) {
        Gson gson2 = new GsonBuilder().registerTypeAdapter(File.class, (Object)new PlainFileGsonTypeAdaptor()).disableHtmlEscaping().setPrettyPrinting().create();
        return gson2.toJson(content2);
    }

    private static String getVersionString(File cmakeInstallPath) throws IOException {
        String versionOutput = CmakeUtils.getCmakeVersionLinePrefix(cmakeInstallPath);
        if (!versionOutput.startsWith(CMAKE_VERSION_LINE_PREFIX)) {
            throw new RuntimeException("Did not recognize stdout line as a cmake version: " + versionOutput);
        }
        return versionOutput.substring(CMAKE_VERSION_LINE_PREFIX.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCmakeVersionLinePrefix(File cmakeInstallPath) throws IOException {
        File cmakeExecutable = new File(cmakeInstallPath, "cmake");
        ProcessBuilder processBuilder = new ProcessBuilder(cmakeExecutable.getAbsolutePath(), "--version");
        processBuilder.redirectErrorStream();
        Process process2 = processBuilder.start();
        BufferedReader bufferedReader = null;
        try (InputStreamReader inputStreamReader = null;){
            String string;
            block8: {
                inputStreamReader = new InputStreamReader(process2.getInputStream());
                try {
                    bufferedReader = new BufferedReader(inputStreamReader);
                    string = bufferedReader.readLine();
                    if (bufferedReader == null) break block8;
                }
                catch (Throwable throwable) {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    throw throwable;
                }
                bufferedReader.close();
            }
            return string;
        }
    }

    private static Set<String> getLangExtensions(CodeModel codeModel, String language) {
        HashSet<String> languageSet = new HashSet<String>();
        if (codeModel.configurations == null) {
            return languageSet;
        }
        for (Configuration configuration2 : codeModel.configurations) {
            if (configuration2.projects == null) continue;
            for (Project project : configuration2.projects) {
                if (project.targets == null) continue;
                for (Target target : project.targets) {
                    if (target.fileGroups == null) continue;
                    for (FileGroup fileGroup : target.fileGroups) {
                        if (fileGroup.sources == null || fileGroup.language == null || !fileGroup.language.equals(language)) continue;
                        for (String source : fileGroup.sources) {
                            String extension = source.substring(source.lastIndexOf(46) + 1).trim();
                            languageSet.add(extension);
                        }
                    }
                }
            }
        }
        return languageSet;
    }

    @VisibleForTesting
    static String getNinjaExecutable(File cmakeExecutable) {
        File possibleNinja;
        File cmakeBinFolder = cmakeExecutable.getParentFile();
        File file = possibleNinja = CmakeUtils.isWindows() ? new File(cmakeBinFolder, "ninja.exe") : new File(cmakeBinFolder, "ninja");
        if (possibleNinja.isFile()) {
            return possibleNinja.getPath();
        }
        return CmakeUtils.isWindows() ? "ninja.exe" : "ninja";
    }

    static boolean isWindows() {
        return SdkConstants.CURRENT_PLATFORM == 2;
    }
}

